/******************************************************************************
	INCLUDE:	DMGLOBAL.I
	WRITTEN BY:	Robert Fenske, Jr. (rfenske@swri.edu)
				Southwest Research Institute
				Electromagnetics Division
				6220 Culebra
				San Antonio, Texas 78238-5166
	CREATED:	Mar. 1994
	DESCRIPTION:	This include file contains all the necessary constant,
			macro, syntax, and type definitions as well as all
			external and global variables needed for the various
			DOOM-related utility programs.

			DOOM is a trademark of id Software, Inc.
******************************************************************************/
#if !defined(DM_Globals)

#if defined(sun) && !defined(BSWAP)		/* Suns need bytes swapped */
#define BSWAP		1
#endif

/*===========================================================================*/

#undef PI
#define PI		(double)3.14159265358979323846	/* ubiquitous PI */
#define TWOPI		(double)6.28318530717958647693
#define bams_to_deg	(double)0.00549316406250000000	/* angle conv consts */
#define deg_to_bams   (double)182.04444444444444444444
#define bams_to_rad	(double)0.00009587379924285258
#define rad_to_bams (double)10430.37835047045272494957
#define deg_to_rad	(double)0.01745329251994329577
#define rad_to_deg     (double)57.29577951308232087680
#define BAMS180		((bams)0x8000)		/* BAMS: (-)180 degrees */
#define BAMS090		((bams)0x4000)		/* BAMS: 90 degrees */

#define FALSE		0
#define TRUE		(!FALSE)

#define MAINS		0
#define THINGS		1
#define LINES		2
#define SIDES		3
#define VERTS		4
#define SEGS		5
#define SSECTS		6
#define NODES		7
#define SECTS		8
#define REJECTS		9
#define BLKMAPS		10
#define ALL		11

/*===========================================================================*/

#define abs(a)		((a) < 0 ? -(a) : (a))
#define min(a,b)	((a) < (b) ? (a) : (b))
#define max(a,b)	((a) < (b) ? (b) : (a))
#define numbytes(v)	((unsigned)sizeof(v))
#define numelm(a)	(sizeof a / sizeof a[0])
#define sgn(a)		((0<(a))-((a)<0))
#if defined(BSWAP)
#define bswapw(v)	((unsigned short)((((v)>>8)&0xFF) | ((v)<<8)))
#define bswapl(v)	((unsigned long)((((v)>>24)&0x000000FFL) | \
			                 (((v)>> 8)&0x0000FF00L) | \
			                 (((v)<< 8)&0x00FF0000L) | \
			                 ( (v)<<24)))
#else
#define bswapw(v)	(v)
#define bswapl(v)	(v)
#endif

#if defined(__TURBOC__)
#define blockmem(t,n)	(t huge*)farcalloc((unsigned)(n),sizeof(t))
#define blockfree(b)	((b)!=NULL?farfree((char huge*)(b)):0)
#else
#define blockmem(t,n)	(t *)calloc((unsigned)(n),sizeof(t))
#define blockfree(b)	((b)!=NULL?free((char *)(b)):0)
#endif

#define Things		((DOOM_THING *)WInfo.data[WInfo.lvlndx+THINGS])
#define Lines		((DOOM_LINE *)WInfo.data[WInfo.lvlndx+LINES])
#define Sides		((DOOM_SIDE *)WInfo.data[WInfo.lvlndx+SIDES])
#define Verts		((DOOM_VERT *)WInfo.data[WInfo.lvlndx+VERTS])
#define Segs		((DOOM_SEGS *)WInfo.data[WInfo.lvlndx+SEGS])
#define Ssecs		((DOOM_SSECTOR *)WInfo.data[WInfo.lvlndx+SSECTS])
#define Nodes		((DOOM_NODE *)WInfo.data[WInfo.lvlndx+NODES])
#define Sects		((DOOM_SECTOR *)WInfo.data[WInfo.lvlndx+SECTS])
#define Rejects		((DOOM_REJECT *)WInfo.data[WInfo.lvlndx+REJECTS])
#define Blockmaps	((DOOM_BLOCKMAP *)WInfo.data[WInfo.lvlndx+BLKMAPS])

#define NThings		WInfo.count[WInfo.lvlndx+THINGS]
#define NLines		WInfo.count[WInfo.lvlndx+LINES]
#define NSides		WInfo.count[WInfo.lvlndx+SIDES]
#define NVerts		WInfo.count[WInfo.lvlndx+VERTS]
#define NSegs		WInfo.count[WInfo.lvlndx+SEGS]
#define NSsecs		WInfo.count[WInfo.lvlndx+SSECTS]
#define NNodes		WInfo.count[WInfo.lvlndx+NODES]
#define NSects		WInfo.count[WInfo.lvlndx+SECTS]
#define NRejects	WInfo.count[WInfo.lvlndx+REJECTS]
#define NBlockmaps	WInfo.count[WInfo.lvlndx+BLKMAPS]

/*===========================================================================*/

#define bcase		break;case		/* for a more reasonabble */
#define bdefault	break;default		/* switch statement       */
#define global					/* global declarations */
#define forward		extern			/* forward references */
#define local		static			/* local declarations */
#define otherwise	break;default		/* alternate default case */
#define repeat		do
#define until(expr)	while (!(expr))		/* for do ... until loops */

/*===========================================================================*/

typedef unsigned short	ushort;
typedef unsigned int	boolean;		/* integer used as boolean */
typedef short		word;			/* 16-bit word */
typedef word		bams;			/* 16-bit bams */

/*===========================================================================*/

typedef struct DOOM_THING {			/* thing information */
	short x, y;
	short angle;
	short flag;
	short item;
} DOOM_THING;

typedef struct DOOM_LINE {			/* line information */
	short fndx, tndx;
	short flag, action_flag;
	short sect_tag;
	short rsidndx, lsidndx;
} DOOM_LINE;

typedef struct DOOM_SIDE {			/* side information */
	short image_xoff, image_yoff;
	char lowwall[8], highwall[8], fullwall[8];
	short sectndx;
} DOOM_SIDE;

typedef struct DOOM_VERT {			/* vertex information */
	short x, y;
} DOOM_VERT;

typedef struct DOOM_SEGS {			/* segment information */
	short fndx, tndx;
	bams angle;
	short lndx;
	short sndx;
	short loffset;
} DOOM_SEGS;

typedef struct DOOM_SSECTOR {			/* subsector information */
	short count;
	short sndx;
} DOOM_SSECTOR;

typedef struct DOOM_NODE {			/* node information */
	short x, y;
	short xdel, ydel;
	short rymax, rymin, rxmin, rxmax;
	short lymax, lymin, lxmin, lxmax;
	short nndx[2];
} DOOM_NODE;

typedef struct DOOM_SECTOR {			/* sector information */
	short floor_ht, ceil_ht;
	char floor_desc[8], ceil_desc[8];
	short light_lvl;
	short property;
	short line_tag;
} DOOM_SECTOR;

typedef unsigned char	DOOM_REJECT;		/* reject information */

typedef short		DOOM_BLOCKMAP;		/* block map information */

typedef struct WAD_HEAD {			/* WAD file header */
	char ident[4];
	long count;
	long offset;
} WAD_HEAD;

typedef struct DIR_ENTRY {			/* WAD file directory entry */
	long offset;
	long nbytes;
	char name[8];
} DIR_ENTRY;

typedef struct WAD_INFO {			/* WAD file information */
	WAD_HEAD head;					/* file header */
	DIR_ENTRY *origdir,				/* orig directory */
	          *dir;					/* resources dirctry */
	char **data;					/* resources data */
	boolean *changed;				/* rsrce changed flg */
	int *count;					/* resources size */
	int lvlndx;					/* where a level is */
	int ep, mp;					/* cur episode/map */
	double ver;					/* patch version */
} WAD_INFO;

/*===========================================================================*/

extern WAD_INFO WInfo;				/* WAD file information */

#define DM_Globals	1			/* now have defined these */
#endif
