' DEHACK - Doom Exe HACK
' by Matt Fell (matt.burnett@acebbs.com)
' written 3/4/94, last revised 6/13/94
'
' DEHACK 2 - The THING TABLE
'
' These crude programs extract information from the DOOM.EXE or DOOM.WAD
' files and store it into a TXT file, suitable for perusing or printing.
' If you want to print the results, you might have to reformat it. Please
' don't waste reams of paper. Thanks.
' All of these only work on the 1.2 registered doom.exe, because I use
' simple byte offset numbers, not search strings.
'
' IMPORTANT: If you don't like typing pathnames, modify the next section,
' un-comment it, and remove or comment-out the input section.

' infile$ = "c:\doom\doom.exe"
' outfile$ = "c:\-\doom\12\dehack2.txt"

CLS
PRINT "Enter the full pathname to your DOOM.EXE file, then the full pathname"
PRINT "to where you want the textfile to be (in an already existing directory)"
PRINT "e.g. 'c:\doom\doom.exe' and 'c:\doom\txt\dehack2.txt'"
PRINT "Note: modify the program with built-in pathnames, and skip this!"
PRINT
INPUT infile$
INPUT outfile$

OPEN infile$ FOR BINARY AS 1
OPEN outfile$ FOR OUTPUT AS 2

PRINT #2, "The 'Thing Table' contained in DOOM.EXE version 1.2 2-17-94"
PRINT #2, "List-making program was written by Matt Fell (matt.burnett@acebbs.com)"
PRINT #2, "=========================================================================="
PRINT #2, "The columns are: (all 4-byte 'long' integers)"
PRINT #2, "  1. Thing number. 3001 is an imp, 5 is a blue key, etc. Some of them are"
PRINT #2, "     -1, e.g. the very first entry (players), the fireballs, ... "
PRINT #2, "  2. First frame number of the thing's frame sequence, for 'regular' items."
PRINT #2, "     For monsters, it's the first frame of the standing-in-place sequence."
PRINT #2, "  3. Toughness/hit points."
PRINT #2, "  4. 'moving' first frame #, monsters/player only"
PRINT #2, "  5. 'see player' sound # for monsters, or 'first' sound for projectiles."
PRINT #2, "     Note the sounds are 1-61, not 0-60. 0 indicates no sound. And the #s"
PRINT #2, "     do NOT directly reference the sound resources in the wad file. There"
PRINT #2, "     is another table in doom.exe, the SOUND TABLE, in which each sound #"
PRINT #2, "     is assigned a name, like 'pistol' or 'shotgn'."
PRINT #2, "  6. Always 8, except for player. What does it do?"
PRINT #2, "  7. 'attack' sound #, monsters only."
PRINT #2, "  8. 'injury' first frame #, monsters/player only."
PRINT #2, "  9. ???. monsters/player only."
PRINT #2, "  10. 'pain' sound #, monsters/player only."
PRINT #2, "  11. 'close attack' frame #, monsters/player."
PRINT #2, "  12. 'distance attack' frame #, monsters/player."
PRINT #2, "  13. 'death' frame # for monsters, 'explode' frame # for projectiles."
PRINT #2, "  14. 'explosive death' frame #, only PLAY, POSS, SPOS, TROO are this weak."
PRINT #2, "  15. 'death' sound # for monsters, 'explode' sound # for projectiles. "
PRINT #2, "  16. Speed of movement. Projectiles' speeds are * 65536 (or split this"
PRINT #2, "      into two 2-byte integers."
PRINT #2, "  17. Horizontal size * 65536"
PRINT #2, "  18. Height * 65536"
PRINT #2, "  19. Point value? Not implemented."
PRINT #2, "  20. Missle damage. Also, SKUL has a 3 here, I presume it turns into a"
PRINT #2, "      projectile when attacking."
PRINT #2, "  21. 'act' sound #, monsters."
PRINT #2, "  22. Attributes, controlled by bits. Bit set = condition true. bit0 ="
PRINT #2, "      1/0, bit8 = 256/0, bit16 = 65536/0, ..."
PRINT #2, ""
PRINT #2, "   bit0     a gettable thing"
PRINT #2, "   bit1     an obstacle to players and monsters (but not projectiles)"
PRINT #2, "   bit2     can be hurt (note barrels have this set)"
PRINT #2, "   bit3     ? teleport destination is only one with it set"
PRINT #2, "   bit4     'automatics' like PUFF, TFOG, BLUD, projectiles"
PRINT #2, "   bit5-7   unused?"
PRINT #2, "   bit8     hung from ceiling"
PRINT #2, "   bit9     floating monsters and not-on-ground things"
PRINT #2, "   bit10    projectiles and player"
PRINT #2, "   bit11    ? player only"
PRINT #2, "   bit12-13 unused?"
PRINT #2, "   bit14    floating monsters"
PRINT #2, "   bit15    unused?"
PRINT #2, "   bit16    projectiles"
PRINT #2, "   bit17    unused?"
PRINT #2, "   bit18    'Inviso' like Spectres!"
PRINT #2, "   bit19    ? barrel only"
PRINT #2, "   bit20-21 unused?"
PRINT #2, "   bit22    Monster: counts towards KILL % at end-of-level screen"
PRINT #2, "   bit23    Artifact: counts towards ITEM %"
PRINT #2, "   bit24    unused?"
PRINT #2, "   bit25    the 6 keys and the player"
PRINT #2, "   bit26-31 unused?"
PRINT #2, "=========================================================================="

table& = 570313         ' this should be 512709 for 0.99,
                        ' 569109 for 1.1(dosextender 1.95),
                        ' ______ for 1.1 (dosextender 1.94)
                        ' 570313 for 1.2
                        ' 666666 for 1.666

FOR i& = 0 TO 101
FOR j% = 0 TO 21
        GET #1, table& + i& * 88 + j% * 4, num&
               
        SELECT CASE j%
        CASE 21
                PRINT #2, USING "##########"; num&;
        CASE 16 TO 17
                PRINT #2, USING "####"; num& / 65536;
        CASE 15
                IF num& > 65535 THEN PRINT #2, USING "####"; num& / 65536;
                IF num& < 65536 THEN PRINT #2, USING "####"; num&;
        CASE ELSE
                PRINT #2, USING "####"; num&;
        END SELECT
        PRINT #2, " ";
NEXT j%
PRINT #2, " "
NEXT i&

