// Structures for DoomEd
// Copyright  1994 by Geoff Allan

struct WadDirectoryEntry {
    long Offset;                // start in WAD
    long Length;                // length
    char Title[9];              // name (in file, is 8 bytes)
};

struct WadThingsFile {          // 10 bytes
    int  x;                     // location x
    int  y;                     // location y
    int  face;                  // direction it faces (degrees)
    int  item;                  // the item type number
    int  lev;                   // level(s) (bit specific)
                                // bit 0 = lev 1
                                // bit 1 = lev 2&3
                                // bit 2 = lev 4
                                // bit 3 = deaf: must see you
                                // bit 4 = multiplayer mode only
};

struct WadLineDefsFile {        // 14 bytes
    int  from;                  // vertex from
    int  to;                    // vertex to
    int  solidity;              // bit 0 indicates walk-thru
    int  special;               // 1=door, 48=animated, 
    int  plat;                  // attached to sector - platform trigger
    int  sidedef1;              // side texturing
    int  sidedef2;              // optional side texturing (or -1)
};

struct WadSideDefsFile {        // 30 bytes
    int  x;                     // offset for texture start point
    int  y;                     // offset for texture start point
    char t1[8];                 // texture above a lower adjacent ceiling
    char t2[8];                 // texture below a higher adjacent floor
    char t3[8];                 // texture for the main wall area
    int  sector;                // which sector this is a part of
};

struct WadVertexFile {          // 4 bytes
    int  x;                     // location x
    int  y;                     // location y
};

struct WadSegsFile {            // 12 bytes
    int  vertex1;               // vertex from
    int  vertex2;               // vertex to
    int  angle;                 // angle:     0 = east,  16384 = north,
                                //       -32768 = west, -16384 = south
    int  linedef;               // linedef
    int  normal;                // BOOL - TRUE means vertex1 to vertex2
                                //       FALSE means vertex2 to vertex1
    int  distance;              // distance from end of linedef
};

struct WadSSectorsFile {        // 4 bytes
    int  num;                   // # of segs in sector
    int  segs;                  // segs record number to start
};

struct WadNodesFile {           // 28 bytes
    int  x;                     // location
    int  y;                     // likewise
    int  dx;                    // offset to end of nodeline
    int  dy;
    int  maxy1;                 // rectangular area 1
    int  miny1;
    int  minx1;
    int  maxx1;
    int  maxy2;                 // rectangular area 2
    int  miny2;
    int  minx2;
    int  maxx2;
    int  ssector1;              // if bit 15 set, these are ssectors
    int  ssector2;              // (must be &'d with 0x7fff)
                                // otherwise they are nodes
};

struct WadSectorsFile {         // 26 bytes
    int  floorZ;                // Z axis location of floor
    int  ceilZ;                 // Y axis location of floor
    char Floor[8];              // name of floor tile
    char Ceil[8];               // name of ceiling tile
    int  light;                 // brightness of area (0-255)
    int  flash;                 // light flashing info
    int  plat;                  // platform number (elevators)
};

struct WadBlockMapFile {        // used for fast-math display routines.
                                // Each block is 0x80 square
    int  x;                     // origin (bottom left corner)
    int  y;
    int  xblocks;               // #: X direction (columns)
    int  yblocks;               // #: Y direction (rows)
};

struct WadSoundHeader {
    int  id;                    // must be 3
    int  rate;                  // sampling rate must be 11025
    long size;                  // number of bytes
};

// not in WAD file, just for DoomEd:

struct dThing {                 // descriptions of things
    int  num;                   // the item number
    char image[9];              // the WAD image
    char desc[40];              // a nice description
};

struct TextureInfo {
    char name[9];               // name of texture
    long offset;                // where in WAD is data
    int  v1;
    int  v2;
    int  x;
    int  y;
    int  v5;
    int  v6;
    int  num;
};

struct TextureItem {
    int  x;
    int  y;
    int  pname;
    int  v4;
    int  v5;
};

struct PNameInfo {
    char name[9];
    int  num;
};

struct WavSoundHeader {         // brute force, dammit!
    FOURCC riff;                // (multimedia extensions
    long size;                  //  way is too complex...)
    FOURCC wave;
    FOURCC fmt;
    long  offset;
    WAVEFORMAT wf;
    int  u1;
    FOURCC data;
    long datasize;
};

struct QueueEntry {
    BOOL Active;                // will action be performed?
    int Action;                 // Q_ADD, Q_EXTRACT, Q_DELETE, Q_REPLACE
    int dirnum;                 // Which WAD object number
    long Size;                  // how many bytes in buffer
    unsigned char _huge *dbuf;  // allocated using GlobalAlloc
    HGLOBAL hglobal;            // this will be freed on QueueFlush
    char dosfile[144];          // DOS filename (reference only)
};

struct Plats {
    int  PlatNum;               // platform number for Doom
    char PlatName[16];          // symbolic name
    char PlatDesc[256];         // description for editing
};

// What follows is for the ID BSP builder

typedef struct {
    int      floorheight, ceilingheight;
    char     floorflat[9], ceilingflat[9];
    int      lightlevel;
    int      special, tag;  
} sectordef_t;

typedef struct {
    int     firstrow;  
    int     firstcollumn;
    char    toptexture[9];
    char    bottomtexture[9];
    char    midtexture[9];
    sectordef_t  sectordef;   // on the viewer's side
    int     sector;           // only used when saving doom map
} worldside_t;

typedef struct {
    POINT    p1, p2;
    int      special, tag;
    int      flags;  
    worldside_t  side[2];
} worldline_t;

