/* File Name DGRAB.C.                             Todd A. Moore              
   ============================================================
   A game first designed by Tim Moore. Programmed in C Language 
   and compiled using the PCC compiler in 1994 by Todd Moore.
   This represents my first actual attempt at a useful C program.
   (Did I actually say "USEFUL"?)
   As I start this program, I have Been programming in C for
   one week.                                                   
    STARTED:  04/17/94   
   FINISHED:  05/08/94

*/
   
/* Preprocessor Directives.                                                */

#include <stdio.h>

#define UP     30
#define DOWN   31
#define LEFT   29
#define RIGHT  28
#define RETURN 13

#define ROWS 24
#define COLS 80


/* Pseudocode:
	      The title screen will come up and Ask the player if they 
	      require Instructions for game play.  If you do, it will 
	      display a Screen with the instructions as well as show the keys
	      to use to manipulate your gamepiece.  After the instruction 
	      routine will be called to draw the correct playfield for
	      the current level. Pellets will then be randomly placed on
	      the playfield.  The user then will be given a countdown to
	      indicate that the game is about to begin. When the game
	      begins, the player will use the cursor "arrow" keys to
	      manipulate a gamepiece around he playfield and eat the
	      pellets, while avoiding the obsicals in the playfield 
	      including the users own "tail".  When the gamepiece does hit
	      an obstical, a explosion will occur at the point of the
	      impact, and the player will see the countdown sequence again.
	      When the player has expired all 3 lives, the game will be over 
	      At this point, the user will be given the opportunity to quit, 
	      or play again.                    
*/
	  
/* global variables                                                        */

int lives;
int level;
int levelflag;
long int score;
int diamonds;
int optionflag;
int bonusy[4];
int bonusx[4];
long second;
int againflag;



/* Main Routine                                                            */
		
int main()
{
srand(times());

	
SetDelay();

do
{       
	level=1;       
	lives=3;        
	levelflag=0;    
	score=0;
	
	StatusLine();
	DisplayTitle();
	GetInput();
		
	
	do
		{
		if(optionflag==1)
			{
			ClrWindow();
			GameOptions();
			GetInput();     
			}
		
		if(optionflag==3)
			{
			ClrWindow();
			DisplayInstructions();
			GetInput();
			}
		}
	
	while (optionflag!=2);
	
	WipeScreen();    
	
	do
		{
		StatusLine();
		CreatePlayfield();
		CountDown();
		SetDiamond();
		SetBonus();
		PlayGame();
			if (levelflag==0)
				DeadMeat();
			if (levelflag==1)
				NextLevel();    
		WipeScreen();
		}
	
	while (lives>0);

	GameOver();     
	PlayAgain();
	WipeScreen();
}
while (againflag!=0);


scr_clr();
scr_curson();

return;
}

/***************************************************************************/

SetDelay()

{
/* This is interesting. I have no idea how I'm going to do this one.
   The general idea, I would suppose, is to do a loop for 1 second.
   Each time the loop is executed, add 1 to a value. When the loop is
   finshed, the value will be equal to how many times the loop executed
   in one second. (such as value=one second). then use a formula like:  
   delay=2*xx. (the length of the delay would be 2 seconds, etc.) 
   This should make it possible for this program to be used by 8088
   machines, right up to pentium, and run at the same speed.
   I'm going to have to test this one.
*/

char time[8];
char sec[2];
second=0;
int lval;
int lval2;
int seedval;

	times(time);        /* gets the current second so count can start  */
	sec[0]=time[7];     /* right as the next second starts (eleiminate */
	sec[1]="\0";        /* the possibillity that only a partial second */
	seedval=atoi(sec);  /* would be counted.)                          */ 

do
{
times(time);         /* Put the time in time$ (hh-mm-ss)                   */
sec[0]=time[7];      /* take the "one-second" byte of time$ (hold in sec)  */
sec[1]="\0";         /* null charecter (keep sec[] a string)                */   
lval=atoi(sec);      /* convert sec to an intiger                           */
}
while (lval==seedval);

do
{
	second++;    /* this will be the faux "second" value               */
	
	times(time);
	sec[0]=time[7];
	sec[1]="\0";
	lval2=atoi(sec); 
}
while (lval2==lval); /* stop counting when the next second is passed       */

/* Humm, Learn something new everyday!                                     */

/* PS.....
   After testing this routine on several computers, I found that although
   the second values grow in proportion to the chip and speed, it is not
   very reliable.  
   
   Example:     Processor       Clk Speed       Second value
		--------------------------------------------
		386             8 Mhz           2100
		386             16Mhz           4200
		386             25Mhz           4400
		386             25Mhz           5500            
		486             33Mhz          13100    
		486             33Mhz          14200    
		486DX2          66Mhz          24000    

   Looking at the values, You would assume that the routine would work
   fine.  However, there are problems. Here are my theorys:

		1)  I suck.
		2)  Computers suck.
		3)  Some computers handle certain events a little 
		    faster or slower. although the second value may indeed
		    be giving correct results, the other crud
		    arround the computer (such as a math coprocessor,
		    Very fast video card, overdrive chip, ect.) may be
		    making the rest of the program run more slowly or 
		    quickly BEFORE the delay.
		4)  I suck.     
*/

return;
}


/***************************************************************************/

StatusLine()
{

scr_setup();          /* Clear screen and put cursor to zero location      */
scr_clr();
scr_rowcol(0,0);
scr_cursoff();

scr_aputs("                         * D I A M O N D  G R A B '94 *",15);
scr_rowcol(0,0);
scr_aputs("  \32 B-O-N-U-S \33",8);
scr_rowcol(0,63);
scr_aputs("  \32 B-O-N-U-S \33",8);

/* place status line at bottom of screen                                   */

scr_rowcol(24,0);
scr_aputs(" SCORE:             LIVES:             LEVEL:",10);
scr_aputs("              (c) 1994 Stupidsoft.",7);
scr_rowcol(24,9);
scr_aputs("       ",2);
scr_rowcol(24,9);
printf("%ld",score);
scr_rowcol(24,47);
scr_aputs("  ",3);
scr_rowcol(24,47);
printf("%d",level);

scr_rowcol(24,28);    
	
	if (lives==3)
		scr_aputs("\352 \352 \352",4);
	else if (lives==2)
		scr_aputs("\352 \352   ",4);
	else if (lives==1)
		scr_aputs("\352     ",4);

return;
}

/***************************************************************************/    

DisplayTitle()
{

int x;
int y;
int h;
int v;
long delay;
long xx;
y=31;
optionflag=2;

for (x=11;x>=1;x--)             /* This creates the cheesey "exploding"    */
	{                       /* title screen window.  (but what are you */
	scr_rowcol(x,y);        /* going to do with ascii characters that  */
	scr_aputs("",5);       /* isn't cheesey?)                         */
	scr_rowcol(24-x,80-y);
	scr_aputs("",5);
	scr_rowcol(x,80-y);
	scr_aputs("",5);
	scr_rowcol(24-x,y);
	scr_aputs("",5);
	
	for (h=y+1;h<80-y;h++)
		{
		scr_rowcol(x,h);
		scr_aputs("",5);
		scr_rowcol(24-x,h);
		scr_aputs("",5);
		}
	
	for (v=x+1;v<24-x;v++)
		{
		scr_rowcol(v,y);
		scr_aputs("",5);
		scr_rowcol(v,80-y);
		scr_aputs("",5);
		}
	
delay=1.5*second;
for (xx=0;xx<delay;xx++)        
	{}      
	
	y=y-3;
	}

y=31;

for (x=11;x>=1;x--)
	{
	for (h=y;h<80-y;h++)
		{
		scr_rowcol(x,h);
		scr_aputs(" ",0);
		scr_rowcol(24-x,h);
		scr_aputs(" ",0);
		}
	
	for (v=x;v<25-x;v++)
		{
		scr_rowcol(v,y);
		scr_aputs(" ",0);
		scr_rowcol(v,80-y);
		scr_aputs(" ",0);
		}
	
delay=1.5*second;
for (xx=0;xx<delay;xx++)        
	{}      
	
	y=y-3;
	}
	scr_rowcol(1,0);        
	scr_aputs("",5);       
	scr_rowcol(1,79);
	scr_aputs("",5);
	scr_rowcol(23,0);
	scr_aputs("",5);
	scr_rowcol(23,79);
	scr_aputs("",5);
	
		for (y=1;y<79;y++)
			{
			scr_rowcol(1,y);
			scr_aputs("",5);
			scr_rowcol(23,y);
			scr_aputs("",5);
			}

		for (x=2;x<23;x++)
			{
			scr_rowcol(x,0);
			scr_aputs("",5);
			scr_rowcol(x,79);
			scr_aputs("",5);
			}

/***************************************************************************/

/* This is the DIAMOND GRAB title                                          */                                      

scr_rowcol(4,10);
scr_aputs("ͻ  ",1);           
scr_rowcol(5,10);
scr_aputs(" ͻ Ȼ ͻ   ͻ   ͻ  ͻ  ͻ ͻ ͻ",9);  
scr_rowcol(6,10);
scr_aputs("     Ȼ     ɼɻȻ   ɻɻ  ɼͻȻ   Ȼ   ͻ Ȼ",3);
scr_rowcol(7,10);
scr_aputs("          ɼ ȼ Ȼ  ȼ          ȼ    Ȼ ",11); 
scr_rowcol(8,10);
scr_aputs("     ɼ     ͻ             ɻ      ɼ ",3);
scr_rowcol(9,10);
scr_aputs(" ͼ ɼ             Ȼͼɼ  Ȼ    ͼ ɼ",9);
scr_rowcol(10,10);
scr_aputs("ͼ  ͼ ͼ  ͼ ͼ  ͼ  ͼ  ͼ ͼ ͼ",1);
scr_rowcol(11,10);
scr_aputs("                      ͻ ͻ   ͻ   ͻ",1);
scr_rowcol(12,10);
scr_aputs("                       ͻ   ͻ   ɼɻȻ   ͻ Ȼ",9);
scr_rowcol(13,10);
scr_aputs("                            ͼ  ͼɼ ɼ ȼ Ȼ  ͼ  ",3);
scr_rowcol(14,10);
scr_aputs("                          ͻ  ͻ    ͻ   ͻ  ",11);
scr_rowcol(15,10);
scr_aputs("                          ͻ    ȻȻ       ͼ ɼ",3);
scr_rowcol(16,10);
scr_aputs("                       ͼ  ͼ  ͼ ͼ  ͼ ͼ",9);
scr_rowcol(17,10);
scr_aputs("                      ͼ ",1);
scr_rowcol(13,8);             
scr_aputs("Another STUPID game",2);
scr_rowcol(14,7);
scr_aputs("from your  friends at",2);
scr_rowcol(15,8);
scr_aputs("    STUPIDSOFT!",2);

/***************************************************************************/

	scr_rowcol(2,2);   /* This makes the inside single-line box on the */     
	scr_aputs("",9);  /* title screen.                                */
	scr_rowcol(2,77);  
	scr_aputs("",9);
	scr_rowcol(19,2);
	scr_aputs("",9);
	scr_rowcol(19,77);
	scr_aputs("",9);
	
		for (y=3;y<77;y++)
			{
			scr_rowcol(2,y);
			scr_aputs("",9);
			scr_rowcol(19,y);
			scr_aputs("",9);
			}

		for (x=3;x<19;x++)
			{
			scr_rowcol(x,2);
			scr_aputs("",9);
			scr_rowcol(x,77);
			scr_aputs("",9);
			}

scr_rowcol(20,2);
scr_aputs("ͻ   ͻ   ͻ",9);
scr_rowcol(21,2);
scr_aputs("                                                                      ",9);
scr_rowcol(22,2);
scr_aputs("ͼ   ͼ   ͼ",9);

scr_rowcol(21,4);
scr_aputs(" Setup Game Options ",8);
scr_rowcol(21,33);
scr_aputs(" LET ME PLAY!! ",64);
scr_rowcol(21,58);
scr_aputs("Game Instructions",8);

return;
}

/***************************************************************************/

GameOptions()
{

scr_rowcol(3,25);
scr_aputs("ͻ",13);  
scr_rowcol(4,25);
scr_aputs("                           ",13);
scr_rowcol(5,25);
scr_aputs("ͼ",13);

scr_rowcol(4,27);                   *
scr_aputs("    Setup Game Options   ",14);

scr_rowcol(7,6);
scr_aputs("I have made every attempt to ensure that this game runs at a proper",10);
scr_rowcol(8,6);
scr_aputs("speed on every computer it runs on, no matter how fast or slow.",10);
scr_rowcol(10,6);
scr_aputs("If you are having trouble with the speed your computer is running",3);
scr_rowcol(11,6);
scr_aputs("this program, you may manually enter the delay rate from this prompt.",3);
scr_rowcol(13,6);
scr_aputs("a delay rate of 0 would result in the fastest gameplay, and a delay",12);
scr_rowcol(14,6);
scr_aputs("rate of over 32000 would be the slowest.",12);
scr_rowcol(16,6);
scr_aputs("Currently, your delay rate is set at ",9);
printf("%ld.",second);

scr_curson();

do
	{
	scr_rowcol(17,6);
	printf("                Enter new delay rate ");
	scanf("%ld",&second);
	}
while (second<0);

scr_cursoff();

return;
}

/***************************************************************************/

GetInput()
{
int ch;

optionflag=2;

do
	{
	ch=scr_csts();  /* check keyboard buffer                           */
	
	switch (ch)
		{
	
		case (LEFT): 
			{
			if (optionflag!=1)  
				{
				optionflag--;
				}
				break;
			}
	
		case (RIGHT): 
			{
			if (optionflag!=3)
				{
				optionflag++;
				}
				break;
			}              
	
		case (RETURN):
			{}
		}

if (optionflag==1)
	{
	scr_rowcol(21,4);
	scr_aputs(" Setup Game Options ",64);
	scr_rowcol(21,33);
	scr_aputs(" LET ME PLAY!! ",8);
	scr_rowcol(21,57);
	scr_aputs(" Game Instructions ",8);
	}

if (optionflag==2)
	{
	scr_rowcol(21,4);
	scr_aputs(" Setup Game Options ",8);
	scr_rowcol(21,33);
	scr_aputs(" LET ME PLAY!! ",64);
	scr_rowcol(21,57);
	scr_aputs(" Game Instructions ",8);
	}

if (optionflag==3)
	{
	scr_rowcol(21,4);
	scr_aputs(" Setup Game Options ",8);
	scr_rowcol(21,33);
	scr_aputs(" LET ME PLAY!! ",8);
	scr_rowcol(21,57);
	scr_aputs(" Game Instructions ",64);
	}

	}       
while (ch!=RETURN);

return;
}

/***************************************************************************/

ClrWindow()
{
int x;

for (x=3;x<19;x++)
	{
	scr_rowcol(x,4);
	printf("                                                                        ");
	}

return;
}

/***************************************************************************/

/*  Text for Instructions Screen: 
    The object of this game is to manuver your snake-type-thing arround a
    obstacle filled playfield and "grab" diamond's.             
    To complete a level you must get all of the diamond's on the playfield.  
    If you also get all three bonus wafers, you recieve a bonus score of 
    level X 10000.
    Touching anything other than a diamond or bonus wafer will cost you one
    of your three lifes. 
    The speed, number of diamond's, and your tail length will increase 
    after every new level.
    Use your arrow keys to move your snake.
*/

DisplayInstructions()
{
scr_rowcol(3,25);
scr_aputs("ͻ",13);  
scr_rowcol(4,25);
scr_aputs("                           ",13);
scr_rowcol(5,25);
scr_aputs("ͼ",13);

scr_rowcol(4,27);
scr_aputs("Instructions for Gameplay",14);

scr_rowcol(7,4);
scr_aputs("\4",3);
scr_rowcol(7,7);
scr_aputs("The object of this game is to manuver your snake-type-thing arround a",10);
scr_rowcol(8,7);
scr_aputs("obstacle filled playfield and GRAB diamonds.",10);
scr_rowcol(9,4);
scr_aputs("\4",3);
scr_rowcol(9,7);
scr_aputs("To complete a level you must get all of the diamond's on the",2);
scr_rowcol(10,7);
scr_aputs("playfiled.",2);
scr_rowcol(11,4);
scr_aputs("\4",3);
scr_rowcol(11,7);
scr_aputs("If you also get all three bonus wafers, you recieve a bonus score of",10);
scr_rowcol(12,7);
scr_aputs("level X 10000.",10);
scr_rowcol(13,4);
scr_aputs("\4",3);
scr_rowcol(13,7);
scr_aputs("Touching anything other than a diamond or bonus wafer will cost you",2);
scr_rowcol(14,7);
scr_aputs("one of your three lives.",2);
scr_rowcol(15,4);
scr_aputs("\4",3);
scr_rowcol(15,7);
scr_aputs("The speed, number of diamond's, and your tail length will increase",10);
scr_rowcol(16,7);
scr_aputs("after every new level.",10);
scr_rowcol(17,4);
scr_aputs("\4",3);
scr_rowcol(17,7);
scr_aputs("Use your arrow keys to manipulate your snake.",2);

return;
}

/***************************************************************************/
CreatePlayfield()
{

int x;
int y;
int h;
int v;
long xx;
long delay;

y=31;

for (x=11;x>=1;x--)             
	{                      
	
	for (h=y;h<81-y;h++)
		{
		scr_rowcol(x,h);
		scr_aputs("\334",5);
		scr_rowcol(24-x,h);
		scr_aputs("\337",5);
		}
	
	for (v=x+1;v<24-x;v++)
		{
		scr_rowcol(v,y);
		scr_aputs("\333",5);
		scr_rowcol(v,80-y);
		scr_aputs("\333",5);
		}
	
delay=1.5*second;
for (xx=0;xx<delay;xx++)        
	{}      
	
	y=y-3;
	}

y=31;

for (x=11;x>=1;x--)
	{
	for (h=y;h<80-y;h++)
		{
		scr_rowcol(x,h);
		scr_aputs(" ",0);
		scr_rowcol(24-x,h);
		scr_aputs(" ",0);
		}
	
	for (v=x;v<25-x;v++)
		{
		scr_rowcol(v,y);
		scr_aputs(" ",0);
		scr_rowcol(v,80-y);
		scr_aputs(" ",0);
		}
	
delay=1.5*second;
for (xx=0;xx<delay;xx++)        
	{}      
	
	y=y-3;
	}


/* Draw box around screen using ascii char 219 (solid block) */

for (x=0; x<80; x++)  /* horizontal lines                                  */
	
	{
	scr_rowcol(23,x);
	scr_aputs("\337",5); 
	scr_rowcol(1,x);
	scr_aputs("\334",5);
	}

for (y=2; y<23; y++)  /* vertical lines                                    */
	
	{
	scr_rowcol(y,79);
	scr_aputs("\333",5);
	scr_rowcol(y,0);
	scr_aputs("\333",5);
	}


/* place obsticals in playfield                                            */

for(x=7; x<=76; x=x+9)
	{
	for(y=4; y<=22; y=y+4)
		{
		scr_rowcol(y,x);
		scr_aputs("\19",14);
		scr_aputs("\8",5);
		scr_aputs("\18",14);
		}
	}
return;
}

/***************************************************************************/

CountDown()

{  
int x;
int y;
long xx;
long delay;
int number;


/* Put window on screen to hold message                                    */

scr_rowcol(9,26);
scr_aputs("ͻ",1);  
scr_rowcol(10,26);
scr_aputs("                          ",1);
scr_rowcol(11,26);
scr_aputs("ͼ",1);
/* Put message on screen, then delay for x ammount of time                 */

scr_rowcol(10,27);
scr_aputs("       On Your Mark       ",8);

	for (number=0;number<14;number++)
	{
	
	if  (number>5)
		{
		scr_rowcol(10,27);
		scr_aputs("       G E T  S E T       ",15);     
		}
	
	y=53;

	scr_rowcol(10,33);
	scr_aputs(" ",0);
	scr_rowcol(10,46);
	scr_aputs(" ",0);

		for(x=27;x<=33;x++)
			
			{
			y=y-1;
			scr_rowcol(10,x);  /* create first row of inward   */
			scr_aputs(">",4);  /*  moving ><                   */ 
			scr_rowcol(10,y);
			scr_aputs("<",4);
	
				
	
					if (x > 27)
					
					{
					scr_rowcol(10,x-1);  /* deletes    */ 
					scr_aputs(" ",0);    /* previous   */
					scr_rowcol(10,y+1);  /* row        */
					scr_aputs(" ",0);
					}       
			
			delay=2.2*second;
			
			for (xx=0;xx<delay;xx++)
				{}
			}
	}

for (x=9;x<12;x++)  /* clear box on screen                                 */
	{
	for (y=26;y<54;y++)
		{
		scr_rowcol(x,y);
		scr_aputs(" ",0);
		}
	}
return;
}
		      
/***************************************************************************/

SetDiamond()

{
int x;
int y;
int i;
int check;
 
     if (level<=10)
	diamonds=(level*3);             

else if (level>10)
	diamonds=30;
		
	for(i=0;i<diamonds;i++)
	{
		do
		{
			while ((x>23) || (x<2))
				x=rand() % 23;
		
			while ((y>79) || (y<1))
				y=rand() % 79;
			
			scr_rowcol(x,y);                
			check=scr_sinp();
			y=0;
			x=0;
		}
		while (check!=32);               
		
		scr_aputs("\4",9);
	}

return;
}
/***************************************************************************/

SetBonus()
{
int i;
int x;
int y;
int check;

for(i=0;i<=2;i=i+1)     
	{
			do
				{
				while ((x>23) || (x<2))
					x=rand() % 23;
		
				while ((y>78) || (y<1))
					y=rand() % 78;
		
				bonusx[i]=x;
				bonusy[i]=y;
				
				scr_rowcol(x,y);
				check=scr_sinp();
				x=0;
				y=0;
				}
			while (check!=32);      
	}

return;
}
/***************************************************************************/

PlayGame()

{
int row;
int col;
int hit;
int move;
int ch;
long delay;
long xx;
long yy;
int count;
int spin;
int dia;
int leveldone;
int flashflag;
int bonus;
int x;
int y;
int i;
int movexy[1500][2];
int tail;
int erasetail;

int rotate[4];          /* these are the pieces that make up the bonus     */   
rotate[0]=196;          /* Wafer (-,\,|,/)                                 */
rotate[1]=92;
rotate[2]=179;
rotate[3]=47;
  
int head[5];            /* these are the pieces that make up the gamepiece */
head[1]=30;
head[2]=31;
head[3]=17;
head[4]=16;

row=11;                 /* starting position */
col=40;
move=1;                 /* starting direction */
count=0;
spin=0;
leveldone=0;
dia=0;
bonus=0;
flashflag=0;
tail=0;
erasetail=0;


resume:

do                      /* while not hit an obstical                       */
{
	
	ch=scr_csts();  /* check keyboard buffer to get player direction   */
	switch (ch)
	{
	case (UP):    {move=1;
		       break;}
	case (DOWN):  {move=2;
		       break;}
	case (LEFT):  {move=3;
		       break;}
	case (RIGHT): {move=4;
		       break;}  
	}
	
	     if (move==1)                 
		{row--; 
		 delay=(13*second)-((level*second)/3);} 
	else if (move==2)             
		{row++; 
		 delay=(13*second)-((level*second)/3);}
	else if (move==3)
		{col--; 
		 delay=(10*second)-((level*second)/3);}
	else if (move==4)
		{col++; 
		 delay=(10*second)-((level*second)/3);}
		
/************************ put player on the screen *************************/

scr_rowcol(row,col);            /* plot new position on playfield          */
hit=scr_sinp();                 /* check to see if player hits an obstical */
scr_aputs(" ",15);              /* put player piece on screen              */
scr_rowcol(row,col); 
printf("%c",head[move]);

if (tail!=0)    
	{
	scr_rowcol(movexy[tail][1],movexy[tail][2]);  
	scr_aputs("\376",7);    /* replace head with tail                  */
	}

tail++;                         /* erase end of tail after so long         */
movexy[tail][1]=row;
movexy[tail][2]=col;
	
	if (tail>50+(level*10)) /* lengthen the tail a little every level  */
		{
		erasetail++;    
		scr_rowcol(movexy[erasetail][1],movexy[erasetail][2]);
		scr_aputs(" ",0);
		}

score=score+15;                 /* score givin for moving one position     */
scr_rowcol(24,9);               /* print score to screen                   */           
printf("%ld",score);

for (xx=0;xx<=delay;xx++)       /* delay game to keep it playable          */
	{}      


/********************** routine to "animate" playfield *********************/

count++;

for(x=7; x<=76; x=x+9)
	{
	for(y=4; y<=22; y=y+4)
		{
		if (count<=5)
			{
			scr_rowcol(y,x);
			scr_aputs("\18",14);
			scr_aputs("\11",80);
			scr_aputs("\19",14);
			}
		if (count>5)
			{
			scr_rowcol(y,x);
			scr_aputs("\19",14);
			scr_aputs("\8",5);
			scr_aputs("\18",14);
			}
		}
	}
if (count==10)
	{count=0;}

/*********************** routine to animate bonus wafer ********************/

for (i=0;i<=2;i++)
	{
	scr_rowcol(bonusx[i],bonusy[i]);
	scr_aputs(" ",12);
	scr_rowcol(bonusx[i],bonusy[i]);
	printf("%c",rotate[spin]);      
	}
	spin++;
	if (spin>3)
		{spin=0;}

/*********************** bonus indicator doo-hickey ************************/

if (bonus==3)
	{
	if (flashflag==0)
		{
		scr_rowcol(0,0);
		scr_aputs("  \33 B-O-N-U-S \32",4);
		scr_rowcol(0,63);
		scr_aputs("  \33 B-O-N-U-S \32",4);
		flashflag=1;
		}
	else if (flashflag==1)
		{
		scr_rowcol(0,0);
		scr_aputs("  \32 B-O-N-U-S \33",8);
		scr_rowcol(0,63);
		scr_aputs("  \32 B-O-N-U-S \33",8);
		flashflag=0;
		}
	}
}
while (hit==32);                /* if no obsticals are hit, keep moving    */
				
/********************** Something is in the road... ************************/

if (hit==4)                     /* diamond has been hit                    */
	{
	score=score+325;
	dia=dia+1;      
	if ((level*3)==dia)     /* level done                              */
		
		{
		levelflag=1;
		level++;
		}
	
	if (levelflag==1)
		{return;}       
	
	goto resume;
	}


for (i=0;i<=2;i++)              /* check for hitting a bonus wafer          */
	{
	if ((row==bonusx[i]) && (col==bonusy[i]))                               
		{
		scr_rowcol(row,col);
		scr_aputs("\376",15);
		bonusx[i]=-1;  /* if hit, hide the token. (Not a good      */
		bonusy[i]=-1;  /* programming technique, but hey, it's     */
			       /* late, and I'm tired.)                    */
		bonus=bonus+1;
		
		if (bonus==3)   
			score=score+(level*5000);
		goto resume;
		}               
	}


return;
}

/***************************************************************************/

DeadMeat()
{
int i;
int x;
int y;
long xx;
long delay;
int check;

for(i=0;i<1500;i++)
	{
		do
		{
		while ((x>23) || (x<2))
			x=rand() % 23;
		
		while ((y>79) || (y<1))
			y=rand() % 79;
		
		scr_rowcol(x,y);                
		check=scr_sinp();
		y=0;
		x=0;
		}
		while (check==219);
	
	scr_aputs("\333",4);
	}

lives--;
delay=60*second;
for (xx=0;xx<delay;xx++);

return;
}                     

/**************************************************************************/

NextLevel()
{
long xx;
long delay;
int yy;
int color;
levelflag=0;

/* Put window on screen to hold message                                    */

scr_rowcol(9,26);
scr_aputs("ͻ",13);  
scr_rowcol(10,26);
scr_aputs("                          ",13);
scr_rowcol(11,26);
scr_aputs("ͼ",13);

for (yy=0;yy<65;yy++)
	{
	scr_rowcol(10,27);
	scr_aputs(" -=|=-  NEXT LEVEL  -=|=- ",color);
	color++;                
		if (color>14)
			{color=1;}
	delay=3*second;
	for (xx=0;xx<delay;xx++)
			{}
	}
return;
}

/***************************************************************************/

WipeScreen()
{
int x;
int y;
int y2;
long xx;
long delay;
y2=80;

for (y=0;y<41;y++)
	{
	for (x=1;x<24;x++)
		{
		scr_rowcol(x,y);
		scr_aputs(" ",0);       
		scr_rowcol(x,y2-y);
		scr_aputs(" ",0);
		}
		
		delay=1*second;
		for (xx=0;xx<delay;xx++)
			{}
	}

delay=10*second;
for (xx=0;xx<delay;xx++)
	{}

return;
}

/***************************************************************************/

GameOver()
{
int x;
int y;
int y2;
long xx;
long delay;
int ch;
y2=75;
y=2;

for (x=2;x<12;x++)
	{
	y=y+3;
	y2=y2-3;
	scr_rowcol(x,y);
	scr_aputs("G M",11);
	scr_rowcol(x,y2);
	scr_aputs("V R",11);
	scr_rowcol(24-x,y+1);
	scr_aputs("A E",11);
	scr_rowcol(24-x,y2-1);
	scr_aputs("O E",11);
	
	delay=.4*second;
	for (xx=1;xx<delay;xx++)
	
	scr_rowcol(x,y);
	scr_aputs("   ",8);
	scr_rowcol(x,y2);
	scr_aputs("   ",8);
	scr_rowcol(24-x,y+1);
	scr_aputs("   ",8);
	scr_rowcol(24-x,y2-1);
	scr_aputs("   ",8);
	}

scr_rowcol(12,35);
scr_aputs("GAME  OVER",11);

return;
}

/***************************************************************************/
PlayAgain()
{
int ch;

scr_rowcol(17,7);
scr_aputs("ͻ  ͻ",9);  
scr_rowcol(18,7);
scr_aputs("                                                              ",9);
scr_rowcol(19,7);
scr_aputs("ͼ  ͼ",9);

do
{
	ch=scr_csts();  /* check keyboard buffer to get player direction   */
		switch (ch)
		{
		case (LEFT):  {againflag=1;
			       break;}
		case (RIGHT): {againflag=0;
			       break;}  
		}

if (againflag==1)
	{
	scr_rowcol(18,12);
	scr_aputs(" I WANT TO PLAY AGAIN ",64);
	scr_rowcol(18,43);
	scr_aputs(" I HAVE BETTER THINGS TO DO ",8);
	}

if (againflag==0)
	{
	scr_rowcol(18,12);
	scr_aputs(" I WANT TO PLAY AGAIN ",8);
	scr_rowcol(18,43);
	scr_aputs(" I HAVE BETTER THINGS TO DO ",64);
	}

}
while (ch!=RETURN);

return;
}

/***************************************************************************/

/* Well, There it is.  After a few weeks of nights and sundays spent at the
   keyboard, its finally done.  If you somehow got ahold of this program, and
   are interested in programming and want to ask me some questions about some
   routine I used, feel free to drop me a line.
	
   Internet  : tamoore@voyager.net     
   Snail Mail: Todd A. Moore
	       S. Stephan Bridge Rd.
	       Grayling MI. 49738
	
   If you are an experianced C programmer, and would like to give me some 
   pointers, you would find me most willing to listen.
   
   Books on C I recommend:
    
	C By Example            By Greg Perry           Que
	C For Rookies           By Greg Perry           Que
   
	C for rookies gives an overview of ansi C and gives the you the basic
   tools for Creating C programs.  Very easy to read, as well as kind of
   funny.  It comes with a disk that contains Mark DeSmet`s C compiler
   PCC (The one used to create this program), a very good Text Editor (mouse
   control, pop-up calculator, pop-up ascii reference table, multiple files,
   clipboard, Ect.), and all of the source code that is in the book.
   
	C By Example Picks up where Rookies left off. At more than 600 pages, it
   is a very good reference manual. It Shows you the commands, Gives you the
   proper syntax, then gives you several examples of how the command would be
   used in a typical C program.  
   
   Happy Programming!!!
*/
