(*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)
{}
{}
{}
{[] About han2hanJ ͻ}
{                                      }
{       Hangul  Hanja Converter       }
{            for DOS-J Plus            }
{                                      }
{          Copyright (c) 1997          }
{     by Jung-heon Park : spc1000      }
{                                      }
{ͼ}
{}
{}
{}
(*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*)

PROGRAM han2hanJ(Input, Output, OldFile, NewFile, BakFile);

{$X+,S-}


USES    Dos, Crt, Objects, Drivers, Views, Menus, Dialogs, App;

CONST
        cmAbout     = 100;
        cmConvert   = 101;
        cmFntOption = 102;

TYPE
        DialogData = record
                CheckBoxData    : Word;
                RadioButtonData : Word;
                InputLineData   : string[128]
        end;

        TConvApp = object(Tapplication)
                procedure HandleEvent(var Event: TEvent); virtual;
                procedure InitMenuBar; virtual;
                procedure InitStatusLine; virtual;
                procedure FntOption;
                procedure Convert;
        end;

        PFontWindow = ^TFontWindow;
        TFontWindow = object(TWindow)
        end;

        PFontDialog = ^TFontDialog;
        TFontDialog = object(TDialog)
        end;

var
        FontDialogData : DialogData;
        file_name      : string;
        file_handle    : word;

procedure TConvApp.HandleEvent(var Event: TEvent);

procedure About;
var
        D       : PDialog;
        Control : PView;
        R       : TRect;
begin
        R.Assign(0, 0, 40, 11);
        D := New(PDialog, Init(R, 'About han2hanJ'));
        with D^ do
        begin
                Options := Options or ofCentered;
                R.Grow(-1, -1);
                Dec(R.B.Y, 3);
                Insert(New(PStaticText, Init(R,
                        #13 +
                        ^C'Hangul  Hanja Converter'#13 +
                        ^C'for DOS-J Plus'#13 +
                        #13 +
                        ^C'Copyright (c) 1997'#13 +
                        ^C'by Jung-heon Park : spc1000')));
                R.Assign(15, 8, 25, 10);
                Insert(New(PButton, Init(R, 'O~K', cmOk, bfDefault)))
        end;
        if ValidView(D) <> nil then
        begin
                Desktop^.ExecView(D);
                Dispose(D, Done)
        end
end;

begin
        TApplication.HandleEvent(Event);
        if Event.What = evCommand then
        begin
                case Event.Command of
                        cmAbout     : About;
                        cmConvert   : Convert;
                        cmFntOption : FntOption;
                else
                        Exit
                end;
                ClearEvent(Event)
        end
end;

procedure TConvApp.InitMenuBar;
var
        R : TRect;
begin
        GetExtent(R);
        R.B.Y := R.A.Y+1;
        MenuBar := New(PMenuBar, Init(R, NewMenu(
                NewSubMenu('~S~elect', hcNoContext, NewMenu(
                        NewItem('~A~bout...', 'F1', kbF1, cmAbout, hcNoContext,
                        NewLine(
                        NewItem('~C~onvert', 'F2', kbF2, cmConvert, hcNoContext,
                        NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
                        nil))))),
                NewSubMenu('~O~ption', hcNoContext, NewMenu(
                        NewItem('~F~ont...', 'F3', kbF3, cmFntOption, hcNoContext,
                        nil)),
                nil))
        )))
end;

procedure TConvApp.InitStatusLine;
var
        R : TRect;
begin
        GetExtent(R);
        R.A.Y := R.B.Y-1;
        StatusLine := New(PStatusLine, Init(R,
                NewStatusDef(0,$FFFF,
                        NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
                        NewStatusKey('~F1~ About', kbF1, cmAbout,
                        NewStatusKey('~F2~ Convert', kbF2, cmConvert,
                        NewStatusKey('~F3~ Font', kbF3, cmFntOption,
                        NewStatusKey('~F10~ Menu', kbF10, cmMenu,
                        nil))))),
                nil)
        ))
end;

procedure TConvApp.FntOption;
var
        Bruce   : PView;
        Dialog  : PFontDialog;
        R       : TRect;
        Control : Word;
begin
        R.Assign(20, 6, 60, 19);
        Dialog := New(PFontDialog, Init(R, 'Font Options'));
        with Dialog^ do
        begin
                R.Assign(3, 3, 18, 6);
                Bruce := New(PCheckBoxes, Init(R,
                        NewSItem('~H~iragana',
                        NewSItem('~K~atakana',
                        NewSItem('Han~j~a',
                        nil)))
                ));
                Insert(Bruce);
                R.Assign(2, 2, 18, 3);
                Insert(New(PLabel, Init(R, 'HangulJapanese', Bruce)));
                R.Assign(22, 3, 37, 6);
                Bruce := New(PRadioButtons, Init(R,
                        NewSItem('~S~tandard',
                        NewSItem('~B~old',
                        NewSItem('Sol~i~d',
                        nil)))
                ));
                Insert(Bruce);
                R.Assign(21, 2, 31, 3);
                Insert(New(PLabel, Init(R, 'Font type', Bruce)));
                R.Assign(3, 8, 37, 9);
                Bruce := New(PInputLine, Init(R, 34));
                Insert(Bruce);
                R.Assign(2, 7, 22, 8);
                Insert(New(PLabel, Init(R, 'Back up old file as', Bruce)));
                R.Assign(15, 10, 25, 12);
                Insert(New(PButton, Init(R, '~O~K', cmOK, bfDefault)));
                R.Assign(28, 10, 38, 12);
                Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)))
        end;
        Dialog^.SetData(FontDialogData);
        Control := DeskTop^.ExecView(Dialog);
        if Control <> cmCancel then Dialog^.GetData(FontDialogData);
        Dispose(Dialog, Done)
end;

procedure TConvApp.Convert;
const
        BufMax      = 512;
        BlockSize   = 1;
var
        OldFile,
        NewFile,
        BakFile    : file;
        NumRead,
        NumWritten : word;
        IOBuf      : array[1..BufMax] of byte;
        Window     : PFontWindow;
        R          : TRect;

procedure WriteSec(SecLoc, SecNum, SecDis :word);
var
        Count,
        Temp : integer;
begin
        Assign(NewFile, 'han2hanj.fnt');
        {$I-}
        Reset(NewFile, BlockSize);
        {$I+}
        if IOResult <> 0 then
        begin
                NormVideo; ClrScr;
                TextColor(LightRed+Blink); Write('[Warning!] ');
                TextColor(White); Write('file not found ');
                TextColor(Yellow); WriteLn('"HAN2HANJ.FNT"'#13#10);
                NormVideo; Halt
        end;
        Assign(OldFile, 'jis.fnt');
        Reset(OldFile, BlockSize);
        case SecDis of
                0 : Seek(NewFile, SecLoc*512);
                1 : Seek(NewFile, 625*512);
                2 : Seek(NewFile, 655*512);
                3 : Seek(NewFile, 720*512)
        end;
        Seek(OldFile, SecLoc*512);
        repeat
                BlockRead(NewFile, IOBuf, SizeOf(IOBuf), NumRead);
                for Count := 1 to BufMax do
                begin
                        Temp := IOBuf[Count];
                        case FontDialogData.RadioButtonData of
                                {$R-}
                                1 : IOBuf[Count] := Temp * 2 or Temp;
                                 (* IOBuf[Count] := Temp div 2 or Temp *)
                                2 : IOBuf[Count] := 255-(255-Temp * 2 or Temp)
                                 (* IOBuf[Count] := 255-(255-Temp div 2 or Temp) *)
                                {$R+}
                        end
                end;
                BlockWrite(OldFile, IOBuf, NumRead, NumWritten);
                Dec(SecNum);
        until(SecNum=0) or (NumWritten<>NumRead);
        Close(NewFile);
        Close(OldFile)
end;

procedure FontInit;
begin
        Assign(OldFile, 'jis.fnt');
        Rewrite(OldFile, BlockSize);
        Close(OldFile)
end;

procedure Hiragana;
begin
        GotoXY(28,11); Write('hiragana.');
        WriteSec(0, 30, 0)
end;

procedure HiraHan;
begin
        GotoXY(28,11); Write('hiragana.');
        WriteSec(0, 30, 1)
end;

procedure Katakana;
begin
        GotoXY(28,12); Write('katakana.');
        WriteSec(30, 65, 0)
end;

procedure KataHan;
begin
        GotoXY(28,12); Write('katakana.');
        WriteSec(30, 65, 2)
end;

procedure Hanja;
begin
        GotoXY(28,13); Write('hanja.   ');
        WriteSec(95, 465, 0)
end;

procedure HanHan;
begin
        GotoXY(28,13); Write('hanja.   ');
        WriteSec(95, 465, 3)
end;

begin
        R.Assign(15, 5, 65, 15);
        Window := New(PFontWindow, Init(R, 'Converting . . .',0));
        DeskTop^.Insert(Window);
        TextBackGround(Blue);
        GotoXY(28,9); Write('Wait for a moment please !');
        with FontDialogdata do
        begin
                Assign(OldFile, 'jis.fnt');
                SetFAttr(OldFile, Archive);
                {$I-}
                Reset(OldFile, BlockSize);
                {$I+}
                if (IOResult = 0) and (InputLineData <> '') then
                begin
                        Assign(BakFile, InputLineData);
                        SetFAttr(BakFile, Archive);
                        {$I-}
                        Rewrite(BakFile, BlockSize);
                        {$I+}
                        if IOResult <> 0 then
                        begin
                                Assign(BakFile, 'jis.old');
                                Rewrite(BakFile, BlockSize);
                                InputLineData := 'JIS.OLD'
                        end;
                        repeat
                                BlockRead(OldFile, IOBuf, SizeOf(IOBuf), NumRead);
                                BlockWrite(BakFile, IOBuf, NumRead, NumWritten);
                        until(NumRead=0) or (NumWritten<>NumRead);
                        Close(OldFile);
                        Close(BakFile)
                end;
                FontInit;
                case CheckboxData of
                        0 : begin Hiragana; Katakana; Hanja  end;
                        1 : begin HiraHan;  Katakana; Hanja  end;
                        2 : begin Hiragana; KataHan;  Hanja  end;
                        3 : begin HiraHan;  KataHan;  Hanja  end;
                        4 : begin Hiragana; Katakana; HanHan end;
                        5 : begin HiraHan;  Katakana; HanHan end;
                        6 : begin Hiragana; KataHan;  HanHan end;
                        7 : begin HiraHan;  KataHan;  HanHan end
                end
        end;
        file_name := 'JIS.FNT'#0;
        asm
                push    ds
                mov     ax, 3d01h
                mov     dx, offset file_name
                inc     dx
                int     21h
                jc      @error
                mov     [file_handle], ax
                mov     ax, 4200h
                mov     bx, [file_handle]
                mov     cx, 0004h
                mov     dx, 5e80h
                int     21h
                jc      @error
                mov     ah, 40h
                mov     cx, 00h
                int     21h
                jc      @error
                mov     ah, 3eh
                int     21h
        @error:
                pop     ds
        end;
        GotoXY(28,14); Write('Completion :)');
        NormVideo; Delay(1000);
        Dispose(Window, Done)
end;


VAR
        ConvApp : TConvApp;

procedure OpenScreen;
type
        CrtType = record
                          Ch   : char;
                          Attr : byte
                  end;
        ScrBuf  = array[1..25, 1..80] of CrtType;
var
        CrtBuf  : ScrBuf absolute $b800:0;
        Buf     : array[1..80] of byte;
        TempBuf : ScrBuf;
        TextX,
        TextY,
        Count   : integer;
begin
        TempBuf  := CrtBuf;
        for TextY := 1 to 25 do
        begin
                Delay(5);
                CrtBuf[TextY, 40].Ch   := chr($db);
                CrtBuf[TextY, 40].Attr := $70;
                CrtBuf[TextY, 41].Ch   := chr($db);
                CrtBuf[TextY, 41].Attr := $70
        end;
        for TextX := 40 downto 1 do
        begin
                for Count := 1 to 25 do
                begin
                        Move(CrtBuf[Count, 2], Buf, 78);
                        Move(Buf, CrtBuf[Count, 1], 78);
                        Move(CrtBuf[Count, 41], Buf, 78);
                        Move(Buf, CrtBuf[Count, 42], 78)
                end
        end
end;


BEGIN
        OpenScreen;
        with FontDialogData do
        begin
                CheckboxData    := 6;
                RadioButtonData := 0;
                InputLineData   := 'JIS.OLD'
        end;
        ConvApp.Init;
        ConvApp.Run;
        ConvApp.Done;
        TextBackGround(Blue); TextColor(White);
        Write('        Font-Converter for DOS-J Plus (c) 1997,');
        WriteLn(' Jung-heon Park (spc1000)        ');
        NormVideo
END.
