{$I COPYRGHT.INC}

(*---------------------------------------------------------------------------*
   This unit implements the boolean evaluator for evaluating the KEY field.
 *---------------------------------------------------------------------------*)


Unit BoolExpr;
Interface
Uses BIN_DB;


Function Expression( Expr       : String;
                     Current    : ContextType):Boolean;

Implementation


Function CleanSpaces(S : String):String;
Begin
While Pos(' ',S)>0 Do
 Delete(S,Pos(' ',S),1);
CleanSpaces:=S;
End;


Var ExpPtr : Byte;

Function BoolExpression( S          : String;
                         CurrPlayer : Integer;
                         CurrRoom   : Integer):Boolean;

Function Check(ObjNr : Integer;CurrPlayer : Integer):Boolean;
Var Tmp : Database;
Begin
Tmp.Init;
Tmp.ReadObj(ObjNr);
If Tmp.IsPlayer
   Then Check:=ObjNr=CurrPlayer
   Else Check:=Tmp.ObjRec.Location=CurrPlayer;
Tmp.Final;
End;

Function CheckLevel(CurrPlayer : Integer;Level : Char):Boolean;
Var Tmp : Database;
    Lev : Byte;
Begin
Tmp.Init;
Tmp.ReadObj(CurrPlayer);
Lev:=Pos(Level,' PBWG');
If (Lev=0) Or
   (Tmp.ObjRec.ObjLevel>=(Lev-1))
   Then CheckLevel:=True
   Else CheckLevel:=False;
Tmp.Final;
End;


Function Peek:Char;
Begin
If ExpPtr>Length(S)
   Then Peek:=#00
   Else Peek:=S[ExpPtr]
End;

Function GetChar:Char;
Begin
If ExpPtr>Length(S)
   Then GetChar:=#00
   Else Begin
        GetChar:=S[ExpPtr];
        Inc(ExpPtr);
        End;
End;

Procedure Skip;
Begin
Inc(ExpPtr);
End;

Function GetConst:Integer;
Var Temp : Integer;
Begin
Temp:=0;
While Peek in ['0'..'9'] Do
 Temp:=(Temp*10)+(Ord(GetChar)-48);
GetConst:=Temp;
End;

Function SimpleExpression:Boolean;Forward;

Function Factor:Boolean;
Var Temp : Boolean;
Begin
If Peek in ['(','!','@']
   Then Begin
        Case GetChar Of
         '!' : Temp:=Not SimpleExpression;
         '(' : Begin
               Temp:=SimpleExpression;
               Skip;
               End;
         '@' : Temp:=CheckLevel(CurrPlayer,GetChar);
        End; {CasE}
        End
   Else Begin
        If Peek in ['0'..'9']
           Then Temp:=Check(GetConst,CurrPlayer);
        End;
Factor:=Temp;
End;

Function Term:Boolean;
Var Temp : Boolean;
Begin
Temp:=Factor;
If Peek='&'
   Then Begin
        Skip;
        Temp:=Temp And Factor;
        End;
Term:=Temp;
End;

Function SimpleExpression:Boolean;
Var Temp : Boolean;
Begin
Temp:=Term;
If Peek ='|'
   Then Begin
        Skip;
        Temp:=Temp Or Term;
        End;
SimpleExpression:=Temp;
End;

Begin
S:=CleanSpaces(S);
ExpPtr:=1;
BoolExpression:=SimpleExpression;
End;

Function Expression( Expr       : String;
                     Current    : ContextType):Boolean;
Begin
If Expr<>''
   Then Expression:= BoolExpression(Expr,Current.Player,Current.Room)
   Else Expression:=True;
End;
End.
