Unit Misc;
Interface
Uses Dos;

(*---------------------------------------------------------------------------*
   UpStr    Convert a string to uppercase
   MakeStr  Add a CHAR to a string until the length is LEN
 *---------------------------------------------------------------------------*)
Function UpStr(S : String):String;
Function MakeStr(S : String;C : Char;Len : Byte):String;

(*---------------------------------------------------------------------------*
  Convert Nr to string and viceversa
 *---------------------------------------------------------------------------*)
Function Nr2Str(Nr : Word):String;
Function Str2Nr(S : String):Integer;
Function Nr2FStr(Nr : Word;Len : Byte):String;

(*---------------------------------------------------------------------------*
  Clean up an string. Delete leading and trailing spaces
 *---------------------------------------------------------------------------*)
Function CleanUp(S : String):String;

(*---------------------------------------------------------------------------*
  MakeTimeString     Convert a longint timestamp to a string
  TimeStamp          Return a complete time/date string
 *---------------------------------------------------------------------------*)
Function MakeTimeString(Stamp : LongInt):String;
Function TimeStamp:String;

(*---------------------------------------------------------------------------*
   Splits a commandline <Object>=<Action> in the object and the action
   part
 *---------------------------------------------------------------------------*)
Function SplitCommand(     InpStr : String;
                       Var ObjName: String;
                       Var Action : String):Boolean;

Implementation
(*---------------------------------------------------------------------------*)
Function UpStr(S : String):String;
Var C : Byte;
Begin
For C:=1 To Length(S) Do
 S[C]:=Upcase(S[C]);
UpStr:=S;
End;

(*---------------------------------------------------------------------------*)
Function Nr2Str(Nr : Word):String;
Var Temp : String;
Begin
Str(Nr,Temp);
Nr2Str:=Temp;
End;

Function Nr2FStr(Nr : Word;Len : Byte):String;
Var Temp : String;
Begin
Str(Nr:Len,Temp);
Nr2FStr:=Temp;
End;

(*---------------------------------------------------------------------------*)
Function Str2Nr(S : String):Integer;
Var Err : Integer;
    Tmp : Integer;
Begin
Val(S,Tmp,Err);
If Err<>0
   Then Tmp:=0;
Str2Nr:=Tmp
End;


(*---------------------------------------------------------------------------*)
Function CleanUp(S : String):String;
Begin
While (S<>'') and (S[1]=' ') Do Delete(S,1,1);
While (S<>'') And (S[Length(S)]=' ') Do Dec(S[0]);
CleanUp:=S;
End;

(*---------------------------------------------------------------------------*)
Function SplitCommand(     InpStr : String;
                       Var ObjName: String;
                       Var Action : String):Boolean;
Begin
SplitCommand:=False;
If Pos('=',InpStR)=0
   Then Exit;
ObjName:=Copy(InpStr,1,Pos('=',InpStr)-1);
Action:=InpStr;
Delete(Action,1,Length(ObjName)+1);
SplitCommand:=True;
End;

(*---------------------------------------------------------------------------*)
Function Nr2DTStr(Nr : Word):String;
Var Tmp : String;
Begin
Str(Nr:2,Tmp);
If Tmp[1]=' '
   Then Tmp[1]:='0';
Nr2DTStr:=Tmp;
End;


(*---------------------------------------------------------------------------*)
Function MakeTimeString(Stamp : LongInt):String;
Var D       : DateTime;
    Tmp     : String[5];
Begin
UnpackTime(Stamp,D);
Tmp:=Nr2DTStr(D.Hour)+':'+Nr2DTStr(D.Min);
MakeTimeString:=Tmp;
End;


(*---------------------------------------------------------------------------*)
Const MonthList : Array[1..12] Of String[3] =
       ('Jan','Feb','Mar','Apr','May','Jun',
        'Jul','Aug','Sep','Oct','Nov','Dec');

Function TimeStamp:String;
Var Year,Month,Day,
    Hour,Minute,Seconds     : Word;
    Dum                     : Word;
Begin
GetTime(Hour,Minute,Seconds,Dum);
GetDate(Year,Month,Day,Dum);
Dec(Year,1900);

TimeStamp:= Nr2DTStr(Hour)         +':'+
            Nr2DTStr(Minute)       +':'+
            Nr2DTStr(Seconds)      +' ('+
            Nr2DTStr(Day)          +' '+
            MonthList[Month]       +' '+
            Nr2DTStr(Year)         +')';

End;

Function MakeStr(S : String;C : Char;Len : Byte):String;
Begin
While Length(S)<Len Do
 S:=S+C;
MakeStr:=S;
End;


End.