/********* User Interface library ***********/
int     printf(char *format, ...);
void    unprintf(void);
void    Qtext(char *format, ...);
int     Qchoice(char **buttons, int bcount, char *header, ...);
int     Qmenu(char **choices, int ccount, char *header);
Boolean Qquestion(char *question, ...);
Boolean Qnumber(int *num, int min, int max, char *header);
Boolean Qstring(char *string, int size, char *header);
Boolean Qfile(char *suffix, char *button, char *inpath, char *outpath, Boolean force_suffix, char *header);
Boolean Qlist(char *choicestr, int *choice, char **items, int icount, int *ipos, char *header);
int     Qcolor(void);
ErrCode Qerror(ErrCode err, char *format, ...);
Boolean RubBox(int *x, int *y, int *w, int *h);
Boolean RubCircle(int *x, int *y, int *rad);
Boolean RubLine(int x1, int y1, int *x2, int *y2);
int     RubPoly(int **x, int **y);
Boolean DragBox(int *x, int *y, int *w, int *h);
void    WaitClick(int *x, int *y, int *left, int *right, int *key);
void    PollInput(int *x, int *y, int *left, int *right, int *key);
void    WaitInput(int *x, int *y, int *left, int *right, int *key);
Boolean GetAbort(void);
Boolean SetAbort(Boolean abort);
void    SetAbortHandler(Boolean (*handler)(void *data), void *data);
Boolean HideCursor(void);
Boolean ShowCursor(void);
Boolean Qscroll(int *choice, char **items, int icount, int *ipos, char **button_texts, char *header);
Boolean UdQnumber(int *num, int min, int max,Errcode (*update)(void *data, int num), void *data, char *fmt,...);
/********* Graphics library ***********/
void    GetSize(int *width, int *height);
void    GetAspectRatio(int *x, int *y);
int     GetColor(void);
void    SetColor(int color);
void    Clear(void);
void    Dot(int x, int y);
int     GetDot(int x, int y);
void    Line(int x1, int y1, int x2, int y2);
void    Box(int x, int y, int w, int h);
void    Circle(int cx, int cy, int radius);
ErrCode Poly(int ptcount, int *x, int *y);
ErrCode Spline(int ptcount, int *x, int *y);
ErrCode Oval(double angle, int xcen, int ycen, int xrad, int yrad);
ErrCode Star(double angle, int xcen, int ycen, int rad);
ErrCode Petal(double angle, int xcen, int ycen, int rad);
ErrCode Rpoly(double angle, int xcen, int ycen, int rad);
ErrCode Spiral(double angle, int xcen, int ycen, int rad, double turns);
ErrCode Fill(int x, int y);
ErrCode FillTo(int x, int y, int to_color);
ErrCode Edge(int color);
void    SetColorMap(int index, int r, int g, int b);
void    GetColorMap(int index, int *r, int *g, int *b);
void    GetScreenColorMap(Screen *s, int *maparray);
void    SetScreenColorMap(Screen *s, int *maparray);
void    GetPhysicalSize(int *width, int *height);
/********* Text library ***********/
void    Text(int x, int y, char *string);
void    WordWrap(int x, int y, int width, int height, char *text);
void    SetJustify(int just);
int     GetJustify(void);
int     StringWidth(char *string);
int     FontHeight(void);
int     TallestChar(void);
void    GetFontName(char *name);
ErrCode LoadFont(char *name);
void    GetFontDir(char *dir);
void    Qfont(void);
/********* Graphics Modes library ***********/
ErrCode SetInk(char *name);
void    GetInk(char *buf);
void    SetInkStrength(int percent);
int     GetInkStrength(void);
void    SetInkDither(Boolean dither);
Boolean GetInkDither(void);
void    SetFilled(Boolean fill);
Boolean GetFilled(void);
void    SetBrushSize(int size);
int     GetBrushSize(void);
void    SetKeyMode(Boolean clear);
Boolean GetKeyMode(void);
void    SetKeyColor(int color);
int     GetKeyColor(void);
void    SetMaskUse(Boolean use_it);
Boolean GetMaskUse(void);
void    SetMaskCreate(Boolean make_it);
Boolean GetMaskCreate(void);
void    SetStarPoints(int points);
int     GetStarPoints(void);
void    SetStarRatio(int ratio);
int     GetStarRatio(void);
void    SetSplineTCB(int t, int c, int b);
void    GetSplineTCB(int *t, int *c, int *b);
void    SetTwoColorOn(Boolean setit);
Boolean GetTwoColorOn(void);
void    SetTwoColor(int color);
int     GetTwoColor(void);
void    SetClosed(Boolean closed);
Boolean GetClosed(void);
void    SetCycleDraw(Boolean cycle);
Boolean GetCycleDraw(void);
Boolean GetMultiFrame(void);
void    SetMultiFrame(Boolean multi);
/********* Turtle Graphics library ***********/
void    Move(double amount);
void    Back(double amount);
void    Left(double angle);
void    Right(double angle);
void    PenUp(void);
void    PenDown(void);
Boolean IsDown(void);
void    MoveTo(double x, double y, double angle);
void    Where(double *x, double *y, double *angle);
void    Home(void);
/********* Time Oriented Function library ***********/
long    Clock1000(void);
void    sleep(double seconds);
void    NextFrame(void);
void    BackFrame(void);
void    SetFrame(int frame);
int     GetFrame(void);
ErrCode SetFrameCount(int count);
int     GetFrameCount(void);
void    PlayFlic(long frames);
void    SetSpeed(int speed);
int     GetSpeed(void);
ErrCode InsertFrames(int count);
ErrCode DeleteFrames(int count);
ErrCode OverTime(ErrCode (*effect)(double time, void *data), void *data);
ErrCode OverAll(ErrCode (*effect)(double time, void *data), void *data);
ErrCode OverSegment(ErrCode (*effect)(double time, void *data), void *data);
void    SetTimeSelect(Boolean is_multi);
Boolean GetTimeSelect(void);
void    SetFSA(int fsa);
int     GetFSA(void);
void    SetSegStart(int frame);
int     GetSegStart(void);
void    SetSegEnd(int frame);
int     GetSegEnd(void);
void    SetStill(Boolean still);
Boolean GetStill(void);
void    SetInSlow(Boolean InSlow);
Boolean GetInSlow(void);
void    SetOutSlow(Boolean OutSlow);
Boolean GetOutSlow(void);
void    SetPingPong(Boolean PingPong);
Boolean GetPingPong(void);
void    SetReverse(Boolean reverse);
Boolean GetReverse(void);
void    SetComplete(Boolean complete);
Boolean GetComplete(void);
/********* Cel library ***********/
Boolean CelExists(void);
void    CelPaste(void);
void    CelMove(int dx, int dy);
void    CelMoveTo(int x, int y);
void    CelTurn(double angle);
void    CelTurnTo(double angle);
ErrCode CelNextFrame(void);
ErrCode CelBackFrame(void);
ErrCode CelSetFrame(int frame);
int     CelGetFrame(void);
int     CelFrameCount(void);
ErrCode CelWhere(int *x, int *y, double *angle);
ErrCode CelGet(int x, int y, int width, int height);
ErrCode CelClip(void);
/********* Swap Screen library ***********/
Boolean SwapExists(void);
void    SwapClip(void);
void    SwapRelease(void);
ErrCode SwapTrade(void);
/********* Optics library ***********/
void    OptClearState(void);
void    OptSetState(struct optState *os);
void    OptGetState(struct optState *os);
void    OptFreeState(struct optState *os);
void    OptClearPos(void);
void    OptSetPos(struct optPos *op);
void    OptGetPos(struct optPos *op);
void    OptClearPath(void);
void    OptSetPath(int ptcount, int *x, int *y);
int     OptGetPath(int **x, int **y);
void    OptFreePath(int **x, int **y);
void    OptDefaultCenters(void);
void    OptContinue(void);
int     OptGetElement(void);
ErrCode OptSetElement(int el);
ErrCode OptToFrame(double time);
ErrCode OptToSegment(int start, int stop);
ErrCode OptToAll(void);
/********* Screen library ***********/
Screen  *GetPicScreen(void);
Screen  *GetSwapScreen(void);
Screen  *GetUndoScreen(void);
Screen  *GetCelScreen(void);
ErrCode AllocScreen(Screen **screen, int width, int height);
void    FreeScreen(Screen **screen);
void    GetScreenSize(Screen *s, int *x, int *y);
void    SetPixel(Screen *s, int color, int x, int y);
int     GetPixel(Screen *s, int x, int y);
void    SetBlock(Screen *s, char *pixbuf, int x, int y, int width, int height);
void    GetBlock(Screen *s, char *pixbuf, int x, int y, int width, int height);
void    IconBlit(char *source, int snext, int sx, int sy, int width, int height, Screen *dest, int dx, int dy, int color);
void    Blit(Screen *source, int sx, int sy, int width, int height, Screen *dest, int dx, int dy);
void    KeyBlit(Screen *source, int sx, int sy, int width, int height, Screen *dest, int dx, int dy, int key_color);
void    CopyScreen(Screen *source, Screen *dest);
void    TradeScreen(Screen *a, Screen *b);
void    PicDirtied(void);
/********* Misc. Functions library ***********/
void    exit(ErrCode err);
void    NewFlic(void);
ErrCode Reset(void);
ErrCode ResizeReset(int width, int height);
int     GetChangeCount(void);
int     PocoVersion(void);
void    Redo(void);
void    Restore(void);
int     rnd(int max);
int     rand(void);
void    srand(int seed);
long    clock(void);
Boolean IsBatchRun(void);
void    PocoChainTo(char *program_path);
/********* Autodesk Animator File library ***********/
ErrCode LoadFlic(char *name);
ErrCode SaveFlic(char *name);
ErrCode LoadPic(char *name);
ErrCode SavePic(char *name);
ErrCode LoadCel(char *name);
ErrCode SaveCel(char *name);
ErrCode LoadPath(char *name);
ErrCode SavePath(char *name);
ErrCode LoadPoly(char *name);
ErrCode SavePoly(char *name);
ErrCode LoadColors(char *name);
ErrCode SaveColors(char *name);
ErrCode LoadTitles(char *name);
ErrCode SaveTitles(char *name);
ErrCode LoadMask(char *name);
ErrCode SaveMask(char *name);
ErrCode SaveScreenPic(Screen *s, char *name);
ErrCode LoadScreenPic(Screen *s, char *name);
/********* (C Standard) FILE library ***********/
FILE    *fopen(char *name, char *mode);
void    fclose(FILE *f);
int     fread(void *buf, int size, int count, FILE *f);
int     fwrite(void *buf, int size, int count, FILE *f);
int     fprintf(FILE *f, char *format, ...);
int     fseek(FILE *f, long offset, int mode);
long    ftell(FILE *f);
int     fflush(FILE *f);
int     getc(FILE *f);
int     fgetc(FILE *f);
int     putc(int c, FILE *f);
int     fputc(int c, FILE *f);
char    *fgets(char *s, int maxlen, FILE *f);
int     fputs(char *s, FILE *f);
/********* (C standard) String library ***********/
int     sprintf(char *buf, char *format, ...);
int     strcmp(char *a, char *b);
int     stricmp(char *a, char *b);
int     strncmp(char *a, char *b, int maxlen);
int     strlen(char *a);
char    *strcpy(char *dest, char *source);
char    *strncpy(char *dest, char *source, int maxlen);
char    *strcat(char *dest, char *source);
char    *strdup(char *source);
char    *strchr(char *source, int c);
char    *strrchr(char *source, int c);
char    *strstr(char *string, char *substring);
char    *stristr(char *string, char *substring);
int     atoi(char *string);
/********* (C Standard) Memory Manager library ***********/
void    *malloc(int size);
void    *calloc(int size_el, int el_count);
void    free(void *pt);
void    *memcpy(void *dest, void *source, int size);
void    *memmove(void *dest, void *source, int size);
int     memcmp(void *a, void *b, int size);
void    *memset(void *dest, int source, int size);
/********* (C Standard) Math library ***********/
double  acos(double x);
double  asin(double x);
double  atan(double x);
double  atan2(double y, double x);
double  ceil(double x);
double  cos(double x);
double  cosh(double x);
double  exp(double x);
double  fabs(double x);
double  floor(double x);
double  fmod(double x, double y);
double  log(double x);
double  log10(double x);
double  pow(double x, double y);
double  sin(double x);
double  sinh(double x);
double  sqrt(double x);
double  tan(double x);
double  tanh(double x);
/********* DOS library ***********/
ErrCode fnsplit(char *path, char *device, char *dir, char *file, char *suf);
ErrCode fnmerge(char *path, char *device, char *dir, char *file, char *suf);
Boolean DosExists(char *filename);
ErrCode DosCopy(char *source, char *dest);
ErrCode DosDelete(char *filename);
ErrCode DosRename(char *old, char *new);
ErrCode SetDir(char *dir);
ErrCode GetDir(char *dir);
int     DirList(char ***list, char *wild, Boolean get_dirs);
void    FreeDirList(char ***list);
void    GetResourceDir(char *dir);
void    GetProgramDir(char *dir);
/********* Global Variable library ***********/
ErrCode GlobalVarGet(char *name, char *value);
ErrCode GlobalVarSet(char *name, char *value);
ErrCode GlobalVarDelete(char *name);
ErrCode GlobalVarFlush(void);
ErrCode GlobalVarFirst(char **name, char **value);
ErrCode GlobalVarNext(char **name, char **value);
