
      User's Manual for High-Performance File-Compression Program

                          LHarc Version 1.12B
                                04/29/89

           Copyright (c) Haruyasu Yoshizaki (Yoshi), 1988-89

                                                    Nifty Serve PFF00253
                                                    ASCII PCS   pcs02846

------------------------------------------------------------------------

0. It Came to Pass One Day...

   After reading "A Hard Disk Cookbook" from Shouei Press, I had a
   strong desire to write my own archiving utility.  On the Nifty Serve
   network, I was first exposed to Mr. Miki's Larc, which surpassed the
   well-known PKware in compression ratios, as reported in the Forum
   Software Debut and Review.  The next shock came when I saw Mr.
   Okumura's LZari, which has even better compaction-ratio performance.
   I started to rewrite LZari for in assembly level language, trying to
   make it run faster, but I could find no way of speeding up the
   process of de-archiving.

   So, as an alternative, I used adaptive Huffman coding with an LZSS
   encoder in order to achieve a similar rate of compression with a
   faster decompression process.  This is the idea used in LHarc.

   No one can be sure of eradicating all possible bugs, yet if SPACE is
   more valuable than TIME to you, please give this program a try.  It
   may be slower in execution, but it achieves the tightest compression
   ratios of any general archiver in the present environment (copyright
   reserved).


1. How to Use It:

   Just type "LHarc" to see the help screen.


   Command-line synopsis:
   ======================

   LHarc [command] [/<switches>[-|+|2|<option>]] <archive_name>
         [<path_name>] [<home_directory_name>\ | <drive_name>:]

         You may place switch(es) at any place following the
         command.  A group of switches can be specified together.


   Terminology:
   ============

   A path name comprises a directory name and a file name:

        a:\tc\include\stdio.ext
        |<---- Path_name ---->|
        |<Directory_>||<File_>|
        |<-- name -->||<name >|


   Commands:
   =========

   a (Add)

   LHarc a Archive.LZH file1.ext

        Adds 'file1.ext' to 'Archive.LZH'.  If 'Archive.LZH' does
        not exist, then LHarc creates it.  If a file with the name
        'file1.ext' already exists in the archive, then LHarc will
        replace it with the specified file.


   u (Update)

   LHarc u Archive.LZH file1.ext

        Adds 'file1.ext' to 'Archive.LZH', the same as with the 'a'
        command.  However, if 'file1.ext' already exists in the
        archive, LHarc will check its time stamp, and will keep the
        newer one and ignore the older one.  (The /c switch forces
        LHarc to skip this time-stamp comparison.)


   m (Move)

   LHarc m Archive.LZH file1.ext

        is equivalent to

   LHarc u Archive.LZH file1.ext
   DEL file1.ext

        Beware the fact that the second line is always active.  You
        might lose the file 'file1.ext' for eternity.


   f (Freshen)

   LHarc f Archive.LZH file1.ext

        Replaces 'file1.ext' in 'Archive.LZH' with the newer one
        only if a file with this name already exists in the archive.
        Otherwise, no action is taken.  (The /c switch forces LHarc
        to skip this time-stamp comparison.)


   e (Extract) or x (eXtract)

   LHarc e Archive.LZH

        Extracts all the files from 'Archive.LZH' to the specified
        drive or directory.  If the specified directory does not
        exist, then LHarc will prompt you whether to create it.

   LHarc e Archive.LZH file1.ext

       Extracts only 'file1.ext' from 'Archive.LZH'.  If a file with
       the name 'file1.ext' exists in the home directory, then LHarc
       will refrain from extraction if the existing file has the
       same time stamp or is newer.  (The /c switch forces LHarc to
       skip this time-stamp comparison.)

   LHarc e Archive.LZS file.ext

        Extracts 'file.ext' from an .LZS file archived with Larc
        3.xx.

        NOTE:  Larc is another popular archiver on Japanese PDS's.


   p (disPlay)

   LHarc p Archive.LZH file1.ext

        Extracts 'file1.ext' from 'Archive.LZH' and redirects it to
        standard output.

   LHarc p /v Archive.LZH file1.ext

        Invokes the default utility LESS to format and display the
        redirected output.  LHarc creates a temporary file
        'LHARC.TMP' for review that will be deleted later.

   LHarc p /vsee Archive.LZH file1.ext

        Invokes the text formatter SEE, which then displays
        'file1.ext' to standard output in a paged format.  Refer to
        PC-LESS.ARC, LIST64A.ARC, and SEE15.ARC.  (These should be
        available in most BBS libraries.)


   d (Delete)

   LHarc d Archive.LZH file1.ext

        Deletes 'file1.ext' from 'Archive.LZH'.


   l (List)

   LHarc l Archive.LZH

        Lists information about all the files in 'Archive.LZH'.
        Each file takes one line of output.  A '+' before the file
        name indicates that a directory na e is stored with the file
        name. (The /x switch forces LHarc to display extended file
        names.)

        If you specify file names and extensions, then only the
        files with matching names or extensions will be listed:

   LHarc l Archive.LZH *.c *.h readme.DOC

        Lists information on all the .C, .H, and README.DOC files
        in 'Archive.LZH'.


   v (View)

   LHarc v Archive.LZH

        Which is equivalent to:

   LHarc l /x Archive.LZH

        Lists information about all the files in 'Archive.LZH',
        except that each listing takes two lines: the first for the
        full path name, and the second for the rest of the
        information.  (The /x switch forces LHarc to display
        extended file names.)


   s (Self-extract)

   LHarc s [/x] [k<KEY>] Archive.LZH

        Creates a self-extracting file 'Archive.COM' (or
        'Archive.EXE' if larger than 64K) from 'Archive.LZH' on the
        specified drive or directory.

        NOTE:  There are now two versions of self-extracting
               models.  The switch /x after s command specifies
               large SFX to be made.  This always makes a file
               Archive.EXE.  AUTOEXEC.BAT file can run on this
               /x switch if key word KEY is properly typed.
               You may self-extract a file of size more than
               1 Mb in this mode.  Without the /x switch, you
               have 'Archive.COM' or 'Archive.EXE' according to
               the reduced size.  To have self-extracting file,
               it is as large as the 640K DOS free-memory area.
               Please check normally, to see whether your self-
               extracting file exceeds 400K in size.  If more,
               use the /x switch then.


   (no command specified)

   LHarc Archive.LZH

        Acts exactly the same as the 'l' command.  This optional
        action is temporary.  Don't count on it in future versions.

   LHarc t Archive.LZH

        Will check integrity of the archived file Archive.LZH by
        CRC check.  This is new in this version 1.12.


   Switches:
   =========

   Specify switch(es) following the switch character '/'.  If you want
   to specify more than one switch, type characters continuously
   without any intervening spaces, like "/rxwe:\work" or "/cxvless".
   When the 'v' and 'w' switches are used with other switches, they must
   be specified at the end of a sequence, as shown in the above
   examples.

   You may place a '+' or '-' sign after switches, with the following
   meanings: '+' turns the switch on, and '-' turns the switch off.
   The '2' creates a special option for the /r and /v switches (see
   below).  If you just specify /<switch> without '+' or '-', then
   <switch> will be toggled from 'on' to 'off' or vice versa.

   NOTE:  Use only lowercase letters for switches.  Capital letters
          are reserved for future use.


   /x[-|+] (eXtend file names)

        Extends file names with directory names.  This switch
        determines whether to store only the file name or the full
        path name.

        Suppose you are in the root directory, \, and you have two
        files '\tc\include\sys\stat.h' and '\stat.h':

   LHarc a Archive.LZH stat.h

        Adds only the file 'stat.h' from the current (root)
        directory to 'Archive.LZH', but

   LHarc a Archive.LZH stat.h \tc\include\sys\stat.h

        Will fail with the message "Same name in another path"
        because extended directory names are not specified.
        However,

   LHarc a /x Archive.LZH stat.h \tc\include\sys\stat.h

        Adds both files to 'Archive.LZH'.  Then:

   LHarc e Archive.LZH stat.h

        Extracts only one 'stat.h' file, to the root directory,
        whereas:

   LHarc e /x Archive.LZH stat.h

        Extracts two 'stat.h' files: one to the root directory, and
        the other to the directory \tc\include\sys\.


   Use of the /r switch allows storage of all files with the same name
   by recursively searching directories.  Thus,

   LHarc a /r Archive.LZH stat.h

        Adds two 'stat.h' files, with path names, to 'Archive.LZH':
        one from the root directory, and the other from the
        directory \tc\include\sys\.

        The /r switch always sets the /x switch simultaneously.  If
        you don't want full path names, include /x- after specifying
        the /r switch.


   /p[-|+] (distinguish Path names)

        Distinguishes between file names extended by directory
        names.  Suppose your archive 'tc.lzh' contains both 'stat.h'
        and '\sys\stat.h'.  Then:

   LHarc e tc stat.h

        Extracts both 'stat.h' files, and the older one will be
        over-written by the newer one.  Furthermore,

   LHarc e /p tc stat.h

        Extracts only 'stat.h', and

   LHarc e tc sys\stat.h

        Extracts only '\sys\stat.h'.


   /c[-|+] (skip time-stamp Comparison)

   LHarc [efux] /c Archive.LZH [file1.ext file2.ext ...]

        If a file with the same name is to be created, the default
        action of LHarc is to compare the time stamp of each pair of
        files, and some will be overwritten and some just ignored.
        This switch forces LHarc to overwrite any existing files
        with extracted ones of the same name.


   /m[-|+] (no Message)

   LHarc [<command>] /m Archive.LZH [file1.ext file2.ext ...]

        By default, LHarc will ask questions like "Overwrite [Y/
        N]?".  This switch suppresses these prompts, and LHarc will
        continue as if "y" is typed in.


   /a[-|+] (any Attribute)

   LHarc a /a Archive.LZH file1.arc

        Adds 'file1.arc' to 'Archive.LZH'.

        Normally, LHarc will not archive files with hidden,
        read-only, or system attributes.  The /a switch forces LHarc
        also to archive files with these attributes.


   /r[-|+|2] (Recursively)

   There are three modes of collecting files to be archived:

        (a) specified file(s):  /r-

            Adds files with specified file names only (default mode).

        (b) across directories:  /r or /r+

            LHarc a /r Archive.LZH *.C

                 Adds to 'Archive.LZH' all the files with
                 extension '.C' - this switch forces LHarc to
                 disregard directory names and add all files
                 with the specified file name(s) in the working
                 directory and its branches.  All file names
                 will be extended by directory names.  This
                 switch is used to archive all versions or all
                 files of a similar type.

        (c) specified directory:  /r2

            LHarc a /r2 Archive.LZH \DOC

                 Adds to 'Archive.LZH' all the files in the
                 directory specified by the path \DOC, similar
                 to the Unix -r option.  This switch is used to
                 archive a complete directory (other than the
                 root).

        The /r and /r2 switches will invoke the /x switch
        simultaneously.  You may have to toggle the /x switch off
        (with /x-) after using /r or /r2.  The /x- switch forces
        LHarc to disregard stored directory names.


   /w[-|+|<directory name>] (set Working directory)

   LHarc a /w[d:\TMP] Archive.LZH [file1.ext file2.ext ...]

        Creates all temporary files in the directory \TMP on drive
        D: - if no directory name is specified, the current directory
        becomes the working directory.  All the temporary files
        created in the process of archiving will reside in that
        directory and be deleted later.  This switch overrides
        setting the working directory with an environment variable
        (see below).

   The /w switch is used when

        (1) you have no room in the directory where the archive is,
            or
        (2) you want your work done silently and swiftly on a RAM
            disk.


   /v[-|+|2|<redirection utility name>] (View by page)

   LHarc p /v Archive.LZH file1.ext

        Extracts 'file1.ext' from 'Archive.LZH' and invokes the
        default utility LESS for formatted display to standard
        output.

        NOTE:  LESS.COM is an utility similar to MORE.COM of
               MS-DOS and something more, but less than the
               "less" of American Unix networks.  PC-LESS.ARC or
               LIST64A.ARC (available from many BBS sources in
               the U.S.A.) works as well as the Japanese
               utility.

   LHarc p /v2 [/v<utility name>] Archive.LZH file1.ext

        Invokes the specified utility for formatted display to
        standard output, but suppresses the output of path names or
        file names.  This switch is provided for viewing binary files
        with a dump utility.


   LHarc first creates an un-archived file LHARC.TMP and then invokes
   the specified utility, usually a page formatter like SEE.EXE or
   LIST.EXE.  Temporary files will normally be deleted after you have
   viewed the output.

   LHarc /n Archive.LZH

        No indicator.  LHarc now uses ANSI escape sequence to report
        the progress of archiving.  For IBM-PC users, the display will
        end in somewhat ugry expression.  This switch will suppress
        the escape code.

   LHarc s /x /k<KEY> Archive.LZH

        The switch /k encodes key word <KEY>, or any word, for
        auto-executable file Archive.EXE run.  For detail, see
        section 3.


   Archive name (path name):
   =========================

   All files archived by LHarc have the same format as those archived
   by Larc, except that Larc uses the extension .LZS.  When you specify
   a different extension for the archive name, LHarc will prompt you
   with:


      "Extension of archive is not '.LZH.' Continue processing? [Y/N]"


   Wildcards are valid with the 'e', 'x', 'p', 'l', 'v', and 's' commands:

   LHarc e *.LZH *.c

        Extracts all files with extension .C from all archives in
        the current directory.


   Home directory name (drive name):
   =================================

   If you specify a home directory name, then everything will happen in
   that directory as though it were the current directory.  Specify a
   home directory name ending with either '\' or ':'.  All the files
   will be archived without storing this directory name unless you use
   the /x switch.

   Example:  In the following directory tree:

                           |-- BIN --
                           |
          |-- \ --|-- TC --|-- LIB --
                           |
                           |-- INCLUDE --|-- SYS --|-- STAT.H

   From your root directory, \, typing

   LHarc a /r Archive.LZH stat.h tc\include\

        Will add '\tc\include\sys\stat.h' to 'Archive.LZH' with the
        path name "\SYS\STAT.H" from your home directory \tc\
        include\.


   File name (path name):
   ======================

   File or path names of files to be archived must be specified, or
   else LHarc will automatically assume *.* with no directory names.
   The wildcards '*' and '?' behave exactly as in DOS.  You cannot use
   them to specify directories except with the /r2 switch, similar to
   the Unix -r option for cp, mv, and rm.


   Switch character:
   =================

   If you are using some other character, like '-', in place of the
   forward slant '/' as a switch delimiter (from DOS Function 37H, Set
   Vector), you have to use your delimiter, say '-', in place of '/',
   like "-cx".  You may then use '/' for a directory delimiter, similar
   to Unix convention.  (You can use '-' as a switch character with
   LHarc anyway.)

   The above comment may not apply unless you are running MS-DOS 3.xx.


2. Setting Switches in an Environment Variable

   You may set any of LHarc's default switches with the environment
   variable 'LHARC':

   SET LHARC=/we: /r2

        Will set drive E: as the working directory and archive all
        files in directory mode.


   You may also specify LHarc's working directory with the environment
   variable 'TMP':

   SET TMP=E:

   but the /w switch will override this setting.


3. Self-Extracting Files

   Now we have revised this part of the problem extensively.  As you
   have seen in the first screen of this software, a totally new text
   file is introduced for all self-extracting files made by LHarc.
   This is controlled by naming such a file with the single character
   '!' to prompt LHarc to display this special file.  Edit an ASCII file
   and then rename to just '!'.  On typing file name of compressed .EXE
   or.COM file, LHarc looks for this text file first of all and displays
   it on the screen with a [Y/N] prompt to let you read it all.  Namely,
   it is an auto-executable file for the display only, no harm, no
   danger.  Not to worry.

   You may send E-mail archived by Lharc, say the first page separated
   with name '!'.  Then this part of your mail, when de-archived, will
   appear on the screen with Continue [Y/N]?  Isn't it appealing?  I call
   this new feature by the name telop.  You may archive files with telop
   '!' included.  You don't see telop from outside, yet you just see the
   telop and type to know what are there by seeing telop screen.  You can
   archive files with short description, which is visible without really
   de-archiving.

   Moreover, there are two models for the SFX, self extractor,
   available for your convenience and for the safety from trojans.

   1.  Small SFX: This model supports files of small enough to work
       within the available memory size.  You can't make a self-
       extracting of size more than 640 Kilobytes theoretically.
       You will likely not wish to use this size if over 400k from
       a practical standpoint.  A few people may even have trouble
       supplying 400k remaining memory.  If any question use large
       SFX now explained.

   2.  Large SFX.  You can make self-extracting size of up to 1
       Megabytes.  Beside you can incorporate self-executable
       AUTOLARC.BAT file to make programs run automatically.  I
       have provided a 'key word' system for the auto-run.  You have
       to know the 'key word' to let it run for the first trial.
       After then the self-extracting auto-run program learns to
       work without the 'key word'.


To make a small SFX:
--------------------
   LHarc s Archive.LZH

        Makes a self-extract file Archive.COM or Archive.EXE
        accoring to the size of the file.  If a telop file ! is
        included, you will see the telop display first and then you
        may type [Y/N] to have files un-archived or just let it be.
        To record telop file ! on your disk, type:

   LHarc e Archive.COM>!

        or, if an .EXE file:

   LHarc e Archive.EXE>!



To make a large SFX:
--------------------
   LHarc s /x Archive.LZH

        or for auto-run, self-extract file add the /k switch and
        key word:

   LHarc s /x /kKEY Archive.LZH
                ---

        Usingh the /x switch specifies the large SFX is to be made.
        KEY stands for a key word, only used if Archive.LZH contains
        an AUTOLARC.BAT file, which you make.  You will always have
        an .EXE file with the /x switch so in the above case, it will
        create Archive.EXE.  You may include a '!' text file as this
        is always available.


   Archive [/ed:] [/x]

        for an auto-run file having an AUTOLARC.BAT file:

   Archive KEY

        or

   Archive key [/ed:] [/x]

        NOTE:  The key word need not be secret at all.  If a
               public word, and some concern is present, just
               type:
                           Archive

               without key word and the contents will then be
               extracted for inspection without auto-run.
               This makes the LHarc auto-run very versatile
               and still minimizes problems with Trojan horse.

        To un-archive you have to type key word to run AUTOLARC.BAT.
        Without this key word, the file just extracts itself without
        prompt.  If it learns the key word once, then it will run
        automatically at anytime on any directory, WITHOUT adding
        the key word.  This may be hazardous.  The key word is not
        case-sensitive.  KEY and key both can make it run.  The upper
        limit of the reduced size for self-extracting is at least
        1MB.  Try it on your own system.

        Thew optional /e switch specifies the directory [d:]on which
        archived files to be expanded.  If Archive.LZH has files with
        path_names, then files reproduced with these path_names on
        respective sub-directories.  If such sub-directories do not
        exist, Archive[.EXE] file will automatically create them.

        This /e switch is new in this version.  The AUTOLARC.BAT file
        is reproduced on your curent directory, with or without this
        /e switch.

        The attribute of of all the archived files is always 20H.  If
        you want them to be read only, you can do it by AUTOLARC.BAT
        with a line something like:

            chmod -w file?.*

        If Archive.LZH contains file1.EXE file1.DOC file2.EXE
        file2.DOS...[etc.]


4. Archive File Header

   LHarc's header is compatible with that of Larc.  Methods of
   archiving are two:

            -lh0-   stored as it was, and
            -lh1-   compressed by LZHuf coding.

   LHarc can extract files stored in Larc-created archives (with the
   extension .LZS) if they are type 4 or 5.

NOTE:  Larc is another Japanese archiver, with source code published
       in a Journal.  It is now available in the United States, also.


5. Result Codes

   LHarc returns the following result codes to the parent process:

       0  Normally finished.

       1  Process finished with nonexistent file names ignored
          during archiving, or CRC error occurred during
          un-archiving.

       2  Process terminated by fatal error; no archives created or
          files moved.

       3  Unable to write the temporary files into the archive.  Work
          file renamed as 'LHARC.)2(', original archive deleted.  Try
          renaming LHARC.)2( as your archive, although it could be
          damaged.


6. Temporary Files

              LHARC.)1(   Original archive, renamed.
              LHARC.)2(   Work file used to create new archive.
              LHARC.TMP   Work file created for review by some page
                          formatter.

   If a file with any of these names already exists, then the behavior
   of LHarc is unpredictable.


7. My Distribution Policy

   Under the following conditions, you may freely copy and distribute
   this software:

   1.  Under all circumstances, "Copyright by Haruyasu Yoshizaki"
       must be attached to the copy.

   2.  This manual or its hardcopy should go together with the
       software.

   3.  You may modify the program, but in that case, you must
       distribute the complete source code for the program,
       including your specific contributions, and you must make it
       clear that you have made such modifications.

   4.  You must try to distribute the latest version available.

   5.  I assume no warranty for any claim of damage you may sustain
       by using this software.

   6.  I have no obligation to revise the program to correct any
       fault in this software.

   7.  For the commercial use of this software, I add the following:

         a.  The entire software made incorporating this program
             should not be copy protected in the sense that the
             DISKCOPY program of MS-DOS makes an imperfect copy.

         b.  Every part of the package should print the name
             "LHarc" and the copyright banner.

         c.  The distribution policy of this software should be
             printed either in the manual, in the package, or on
             the disk label.


8. Acknowledgments

   Special gratitude to H. Okumura, who uploaded the code for LZari in
   PC-VAN on which this LZHuf coding is based and to K. Miki, who re-
   posted LZARI on Nifty Serve and who is the author of Larc I.  For all
   those who contributed reviews, comments, and bug reports, I thank you
   very much.

   I also appreciate the work and personal cost (both in his time and
   financial cost to telephone the United States) that Prof. Kenjirou
   Okubo has contributed to make this available to interested users in
   the United States.

   The .EXE file for LHarc is nearly 2K smaller owing to use of pcs27162
   by S. Takanami.  I honor this utility and thank him for letting me
   use it to prepare LHarc.

   I have made so many revisions to LHarc, yet I do not think I can
   ever expel all the bugs dwelling inside.  I would appreciate your
   comments and bug reports.  Please route them to me via the SDR Forum
   of Nifty Serve or salon.pds of ASCII Net.


9. References

   1) Labo, A.P., A Hard Disk Cookbook:  Shouei Press (1987).

   2) Kurita, T., Huffman coding, bit:  Jewelry Box of Computing 43,
      vol. 20, no. 7, pp. 100-101 (1988).

   3) Miki, K., Documentation for Larc:  LARC.MAN


10. History of Revisions

Ver. 1.12b
    1. Fixed AUTOLARC.BAT bug for auto-run after auto-extract.

Ver. 1.12
    1. 't' command to test integrity of archived file.
    2. Change of Screen display due to new commands and switches.
    3. Bug fixed for CRC error check with archived file of size zero.
    4. New telop file '!' with Large and Small SFX.

Ver. 1.01

    1. Minor touchups to help screen and program messages.
    2. Editorial polishing of User's Manual for clarity and readability.

Ver. 1.00

    1. Mode without work file added.
    2. /r switch forces /x switch on simultaneously.

Ver. 0.07c

    1. Removed bug in detecting memory shortage.
    2. Compacted self-extracting program.

Ver. 0.07a

    1. Ver. 0.05-0.07 break down Heap areas.  Corrected.
    2. Accepts any directory name with any attributes.

Ver. 0.07

    1. Prohibited actions to a write-protected archive.
    2. 'm' command now removes files made by older versions.
    3. Error-handling routine revised in dealing with wildcards for
       archive names.
    4. No command specified is now interpreted as 'l' command specified.
    5. Error level 1 returned when CRC checking detects an error during
       un-archiving.
    6. Program now halts when self-extraction process meets an error.
    7. Bug fixed in CRC checking when a directory name is met in un-
       archiving process.

Ver. 0.06b

    1. Removed possibility of a damaged cluster appearing in failing to
       re-create (= freshen) an archived file.
    2. Removed '+' bug in redirecting output with 'p' command.

Ver. 0.06

    1. If a file transaction fails with 'u', 'm', or 'f' command, LHarc
       will leave the archive as it was.
    2. File attributes were sometimes misunderstood by 'f' command.  This
       possibility eliminated.

Ver. 0.05

    1. CRC checks extended to self-extracting files.
    2. Completely recursive modes made possible for 'a,u,m' commands.
    3. Meets requirements of APPEND.EXE of MS-DOS version 3.3.
    4. '\' no longer needed at end of working-directory name with /w
       switch.

Ver. 0.04

    1. Support for environment variable 'TMP'.
    2. "LHarc p /v a.lzh a_file" used to delete 'a_file' in case of an
       error.  Bug fixed.
    3. Added check for a file with the same name in making a self-
       extracting file.
    4. In a self-extracting archive, if a file with the same name of
       larger size existed, then LHarc kept the difference when it was
       overwritten by one of smaller size.  This bug removed.

Ver. 0.03

    1. Environment variable 'LHARC' sets some of the switches.
    2. Made it possible to specify '+', '-' by switches.
    3. /v switch included.
    4. Wildcards can now be used for archive names with 'e,x,p,l,v,s'
       commands.
    5. Home directory names had some interactions with Kanji-code.  Fixed.
    6. Fixed header-file bugs of self-extracting .EXE files.

Ver. 0.02

    1. Support of 'm' command.
    2. Larc 3.xx compatibility.  Type 4, 5 .LZS files are un-archived.
    3. Accepts systems with different switch characters.
    4. Minor bugs fixed with 'e' command.
    5. Revised format for 'l' command.

Ver. 0.01

    1. Support of self-extracting files.
    2. 'p' command added.
    3. /c switch applies for more combinations of commands and switches.
    4. Error handling revised.
    5. Bug fixed in 'l' command.
    6. New algorithm introduced in sorting path names.


11. Comments

a. Some other algorithms I have in mind

   For some specific files, the compression ratios are not as good as
   with PKware's PKZIP.  For such files, I may use LZSS compression with
   correlated arithmetic compression.  This is an effective method, and
   my experiments show that the ratios are no less than PKware's.  Yet
   it takes too much time in both the archiving and de-archiving
   processes, with much higher memory consumption.  Consequently, I
   intend to keep working on this LZHuf algorithm.

   Naturally, I am ready to accept any comments, and I continue to
   experiment.


b. Naming of LHarc

   Some people have expressed concern over the fact that the string
   "arc" is contained in the name "LHarc." I make the following
   statements just for them.

   The crucial points in SEA's suit against PKware were the way in
   which PKware advertised and sold PK(x)arc with an emphasis on its
   ARC compatibility, and the loss of profits from shareware
   contributions.

   This is not the case with LHarc.  I have used a different archiving
   method and made it a freeware program with a format incompatible
   with ARC.  Therefore, I hope I will not be bothered by similar
   accusations.
                                - end -
