
// structures and defines used in the plays and playbook and team files
#define MAX_PLAY_NAME    16
#define MAX_SERIES_NAME  10

#define MAX_PLAYS 	 	 80
#define MAX_LINEPLAYS	 40
#define MAX_FORMATIONS	 40


#define MAX_PLAY_RATINGS 20
#define MAX_READ_RATINGS 20

#define MAX_NUMBER_SERIES 10
#define MAX_SERIES_VALUE 9
#define MIN_SERIES_VALUE 0

#define MAX_MOTION_MOVES 6
#define MAX_DEF_ALIGNS 11


struct FormationInfo
{
	char	Name[MAX_PLAY_NAME];
	UBYTE	Position[11];
	short X[11];
	short Y[11];
};

struct LineMacroInfo
{
	BYTE type;
	BYTE first_cmd;
	BYTE second_cmd;
	BYTE third_cmd;
};

struct LinePlayInfo
{
	UBYTE Stance;	// each bit is stance 0-3 pnt  1-pass block
	char  PlayName[MAX_PLAY_NAME];
	struct LineMacroInfo Commands[5];
};



struct OffUsageInfo
{
	UBYTE run;  // times play has been run
	UBYTE lost; // times running play lost yardage or pass was sacked
	BYTE avg;   // average gain for this play
	UBYTE complete; // completions from this play
};

struct DefUsageInfo
{
	UBYTE run;		// times play has been run
	BYTE avg_run;  // average gain by running plays
	BYTE avg_pass; // average gain by passing plays
	UBYTE complete;// number of completions against
};

struct MotionInfo
{
	BYTE Who;
	short X;
	short Y;
};

// defines used by the def play aligns bits
#define ALIGN_DONOT_FOLLOW	0x01
#define ALIGN_CONTAIN_MAN	0x02
#define ALIGN_FAKE_BLITZ	0x04
#define ALIGN_GAP				0x08
#define ALIGN_OVER			0x10
#define ALIGN_OUTSIDE		0x20
#define ALIGN_WALKAWAY		0x40

#define ALIGN_LINECMDS		0x38

struct OffPlay
{
	UBYTE	Info;			// basic info about the type of play(this will expand) 0-NULL Play
	char	Series;
	UBYTE PlayRatings[MAX_PLAY_RATINGS];
	UBYTE ReadRatings[MAX_READ_RATINGS];
	char  PlayName[MAX_PLAY_NAME];
	struct OffUsageInfo Usage[4][3]; // 4 downs by 3 categories
	struct Command Commands[6][4];  // only commands for non-linemen
	struct MotionInfo Motion[MAX_MOTION_MOVES];
	char  Formation;  // default formation for this play
	char	Lineplay;   // index into lineplay array for default lineplay
	char	Hole;       // positive is to the offenses right and negative left
};


struct DefPlay
{
	UBYTE	Info;			// basic info about the type of play(this will expand) 0-NULL Play
	char	Series;
	UBYTE PlayRatings[MAX_PLAY_RATINGS];
	UBYTE ReadRatings[MAX_READ_RATINGS];
	UBYTE Aligns[MAX_DEF_ALIGNS];
	char  PlayName[MAX_PLAY_NAME];
	struct DefUsageInfo Usage[4]; // 4 categories - short yardage,medium,normal,long
	struct Command Commands[11][3];
	char  Formation;  // default formation for this play
};

struct PlayBook
{
	UWORD Version;
	char Title[31];
	char CtrlZ;
	char Off_Series_Names[MAX_NUMBER_SERIES][MAX_SERIES_NAME];
	char Def_Series_Names[MAX_NUMBER_SERIES][MAX_SERIES_NAME];
	UBYTE Number_off_plays;
	UBYTE Number_def_plays;
	UBYTE Number_line_plays;
	UBYTE Number_of_Off_Formations;
	UBYTE Number_of_Def_Formations;
	struct FormationInfo	OffFormations[MAX_FORMATIONS];
	struct FormationInfo	DefFormations[MAX_FORMATIONS];
	struct LinePlayInfo LinePlays[MAX_LINEPLAYS];
	struct OffPlay OffPlays[MAX_PLAYS];
	struct DefPlay DefPlays[MAX_PLAYS];
};



enum PLAYRATING_TYPE
{
	FIRST_DOWN_PR,
	SECOND_DOWN_PR,
	THIRD_DOWN_PR,
	FOURTH_DOWN_PR,
	AHEAD_PR,
	BEHIND_PR,
	FIRST_QTR_PR,
	SECOND_QTR_PR,
	THIRD_QTR_PR,
	FOURTH_QTR_PR,
	ZERO_TO_3_PR,
	FOUR_TO_7_PR,
	EIGHT_TO_11_PR,
	TWELVE_PLUS_PR,
	OPPGL_TO_3_PR,
	OPP4_TO_20_PR,
	OPP21_TO_MID_PR,
	MID_TO_10_PR,
	TEN_TO_GL_PR,
	TWOMINUTE_PR
};
