
// structures and defines used in the plays and playbook and team files
#define MAX_DESCRIPTION  30
#define MAX_TEAMNAME     13
#define MAX_CITYNAME     31
#define MAX_PLAYER_FNAME 11
#define MAX_PLAYER_LNAME 21
#define MAX_COACHNAME    31

#define MAX_PLAYERS	   50
#define NUM_REFEREES   7
#define NUM_COACHES	   2
#define MAX_STARTERS   80
#define TEAM_SIZE 	   50
#define NUM_PLAYERS TEAM_SIZE*2 		// number of player sprites in the game
#define NUM_PEOPLE	   NUM_PLAYERS + NUM_REFEREES


#define MAX_COACH_RATINGS 8
#define MAX_TEAM_RATINGS  8
#define MAX_SPECIALTIES	6

enum PLAYER_RATING_TYPE
{
	POS_RATING=0,
	ATHLETIC_ABILITY,
	FITNESS,
	INJURY,
	EXPERIENCE,
	SPEED,
	QUICKNESS,
	HANDS,
	FUMBLEDEF,
	RUSHING,
	PASSING,
	BLOCK_P,
	BLOCK_R,

	TACKLING,
	PASS_RUSH,
	FIGHT_BLOCK, // 15
};

// the rest of the 20 spots (16-19) are shared depending on player type
// each of these should be used as an index by (DEFINE%4 + 16)
#define ROUTES 16		 // receivers and runners
#define TOUGH_YDS 17
#define REC_NON_USED 18
#define REC_NON_USED2 19

#define MAN_COVER 20	  // defenders
#define ZONE_COVER 21
#define INTERCEPT 22
#define DEF_NON_USED 23

#define PRESSURE 24	  // quarterbacks
#define READCVRG 25
#define PASS_R	  26
#define PASS_L	  27

#define KICK_LEN 28	  // kickers
#define KICK_ACC 29
#define HANGTIME 30
#define ONSIDEKICK 31

#define PUNT_LEN 32	  // punters
#define PUNT_ACC 33
#define PHANGTIME 34
#define RELEASETIME 35

#define SNAP_ABILITY 36	 // linemen
#define SNAP_LONG	 37
#define SPECIAL_NON_USED 38
#define SPECIAL_TEAMS 39

struct RosterInfo
{
	char FName[MAX_PLAYER_FNAME];
	char LName[MAX_PLAYER_LNAME];
	char Number;
	UBYTE Weight;
	UBYTE Height;
	char Position;
	UBYTE Rating[20];
	BYTE Specialty;
	UBYTE Special_rating;
};


struct TeamSpec
{
	char Description[MAX_DESCRIPTION];
	char CtrlZ;
	UWORD Version;
	char TeamName[MAX_TEAMNAME];
	char CityName[MAX_CITYNAME];
	char CoachName[MAX_COACHNAME];
	UBYTE Year;
	UBYTE Uniform;
	char Playbook[9];					// name of the default playbook for this team
	BYTE filler[6];
	char Starters[MAX_STARTERS];
	UBYTE CoachRatings[MAX_COACH_RATINGS];
	UBYTE TeamRatings[MAX_TEAM_RATINGS];
	struct RosterInfo Players[MAX_PLAYERS];
};



struct FieldPoint
{
	short x;
	short y;
};

struct Command
{
	short	type;
	short	x;
	short y;
	short z;
};


//
// Play defines for position types
//  this is used to define the type of player someone is and is
//  used in the team file as part of each players definition
//
enum PLAYER_TYPES
{
	CENTER,
	GUARD,
	TACKLE,
	TIGHTEND,
	QUARTERBACK,
	RUNNINGBACK,
	FULLBACK,
	WIDERECEIVER,
	PUNTER,
	KICKER,
	DEF_TACKLE,
	DEF_END,
	OUTSIDE_LB,
	MIDDLE_LB,
	CORNERBACK,
	STRONG_SAFETY,
	FREE_SAFETY,
	OPEN_POSITION,
	NUMBER_OF_POSITIONS
};


