/* Erstes echtes Testprogramm fr GUI
 * Stephan Schild, 14.09.1994, 19.09.1995
 */

#include <grx.h>
#include <mousex.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include <gui.h>             /* Grafisches User Interface */

#include <osfcn.h>           /* fuer sleep() */
#include<pc.h>               /* fuer sound() */

/* Globale Variablen fr Minenspiel */
unsigned char *Spielfeld;    /* Startadresse Spielfelddaten */
int dlX, dlY;                /* Offsets fr Spielfeldadressierung */
int kanteXY = 7, kanteZ = 7; /* Spielfeldgre und Hhe */
int minen, markiert, offen;  /* Anzahlen fr Minen, ... */
int dichte;                  /* Minendichte */
int xpos, ypos, zpos;        /* Koords fr Suchen() ??? */
int x_0, y_0, z_0;           /* relative Koordinaten Bildschirm */
int gewonnen;                /* logische Spielzustnde */
int spielende;               /* logische Spielzustnde */
int ax, ay, az;              /* Anzahl sichtbarer Spielfelder */
int fb, fh, eh;              /* Gre von Einzelfeldern und Ebenen */
int x_base = 220, y_base;    /* 3D-Koordinaten-Ursprung (x fest, y in repaint() */
char pausieren = FALSE;
unsigned long int zeit = 0;  /* Spielzeit-Zhler */
int gespeichert;             /* Zaehler fuer Abspeichern */
char name[21];               /* Spielername fr HighScore */
unsigned long int magic;     /* Spielerkennung, fast eindeutig */

/* Datensatz fr HighScoreListe */
struct SpielerDaten {
   unsigned long int magicId; /* magic-Identnummer eines Spielstandes */
   char name[21];             /* Spielername */
   int kX, kZ;                /* Kantenlngen */
   int schwer;                /* Schwierigkeitsgrad */
   unsigned long int zeit;    /* Spielzeit */
   char datum[9];             /* Spieldatum */
   unsigned long int punkte;  /* gewichtete Punkte fr's Spiel */
   unsigned long int pruef;   /* Prfsumme fr korrekte Datenstze */
   int gespeichert;           /* Zaehler fuer abspeichern */
};
struct SpielerDaten spieler[32];  /* Feld von SpielerDaten fr HighScore */

/* Fllmuster fr 3-fach Mauscursor */
unsigned char mybits[] = { 0xbb, 0x00, 0xee, 0x00 };
GrBitmap mybitmap = { 0, 4, mybits, 0, 0, 0 };

extern int _stklen = 256000;   /* Platz fr Rekursives Aufraeumen() */
int rec_count;                 /* Sicherheitszhler fr Rekursionsabbruch */

/* Sondercursor fr Tod, Pause, Sieg definieren */
GrCursor *cursor_tot, *cursor_pause, *cursor_sieg;
int tot_farbe[4];
char pix_tot[]=
{  0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,
   0,0,0,1,3,3,3,3,3,3,3,3,3,1,0,0,0,
   0,0,1,3,3,3,3,3,3,3,3,3,3,3,1,0,0,
   0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,
   0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,
   1,3,3,1,1,1,1,3,3,3,1,1,1,1,3,3,1,
   1,3,3,1,1,1,1,1,3,1,1,1,1,1,3,3,1,
   1,3,3,3,1,1,1,3,3,3,1,1,1,3,3,3,1,
   0,1,3,3,3,3,3,1,1,1,3,3,3,3,3,1,0,
   0,0,1,3,3,3,1,1,1,1,1,3,3,3,1,0,0,
   0,0,1,3,3,3,1,1,1,1,1,3,3,3,1,0,0,
   0,0,0,1,2,3,3,3,3,3,3,3,2,1,0,0,0,
   0,0,0,1,3,2,2,2,2,2,2,2,3,1,0,0,0,
   0,0,0,1,3,2,3,2,3,2,3,2,3,1,0,0,0,
   0,0,0,1,2,2,3,2,3,2,3,2,2,1,0,0,0,
   0,0,0,0,1,3,2,2,2,2,2,3,1,0,0,0,0,
   0,0,0,0,1,3,3,3,3,3,3,3,1,0,0,0,0,
   0,0,0,0,0,1,3,3,3,3,3,1,0,0,0,0,0,
   0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0
};
char pix_pause[]=
{  0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,
   0,3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,0,
   0,3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,0,
   0,0,3,1,3,3,3,3,3,3,3,3,3,1,3,0,0,
   0,0,3,1,3,3,3,3,3,3,3,3,3,1,3,0,0,
   0,0,0,3,1,3,3,2,2,2,3,3,1,3,0,0,0,
   0,0,0,0,3,1,2,2,2,2,2,1,3,0,0,0,0,
   0,0,0,0,0,3,1,2,2,2,1,3,0,0,0,0,0,
   0,0,0,0,0,0,3,1,2,1,3,0,0,0,0,0,0,
   0,0,0,0,0,0,3,1,2,1,3,0,0,0,0,0,0,
   0,0,0,0,0,0,3,1,2,1,3,0,0,0,0,0,0,
   0,0,0,0,0,3,1,3,2,3,1,3,0,0,0,0,0,
   0,0,0,0,3,1,3,3,2,3,3,1,3,0,0,0,0,
   0,0,0,3,1,3,3,2,2,2,3,3,1,3,0,0,0,
   0,0,3,1,3,3,3,2,2,2,2,3,3,1,3,0,0,
   0,0,3,1,3,3,2,2,2,2,2,3,3,1,3,0,0,
   0,3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,0,
   0,3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,0,
   0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,
};
char pix_sieg[]=
{  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,2,1,1,1,1,1,2,0,0,0,0,0,
   0,0,0,2,1,1,3,3,3,3,3,1,1,2,0,0,0,
   0,0,2,1,3,3,3,3,3,3,3,3,3,1,2,0,0,
   0,2,1,3,3,3,3,3,3,3,3,3,3,3,1,2,0,
   0,1,3,3,2,2,3,3,3,3,3,2,2,3,3,1,0,
   2,1,3,2,1,1,2,3,3,3,2,1,1,2,3,1,2,
   1,3,3,2,1,1,2,3,3,3,2,1,1,2,3,3,1,
   1,3,3,3,2,2,3,3,3,3,3,2,2,3,3,3,1,
   1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,
   1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,
   1,3,3,1,1,3,3,3,3,3,3,3,1,1,3,3,1,
   2,1,3,2,1,1,3,3,3,3,3,1,1,2,3,1,2,
   0,1,3,3,2,1,1,1,1,1,1,1,2,3,3,1,0,
   0,2,1,3,3,3,2,1,1,1,2,3,3,3,1,2,0,
   0,0,2,1,3,3,3,3,3,3,3,3,3,1,2,0,0,
   0,0,0,2,1,1,3,3,3,3,3,1,1,2,0,0,0,
   0,0,0,0,0,2,1,1,1,1,1,2,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};

/* Unterprogramme */
void Aufraeumen(int x, int y, int z);   /* rekursives Aufrumen */
int  Summe(int x, int y, int z);  /* Minen-Summe aus Umgebung bestimmen */
void ZeigSpielfeld(void);         /* gesamtes Spielfeld anzeigen */
void ZeigFeld(int x, int y, int z, int h, int muster); /* Einzelfeld */
void ZeigMausFelder(int i, int j, int k);  /* Mausumgebung anzeigen */
void Abraeumen(void);                 /* Spiel auflsen (nach Ende) */
void Init(void);                       /* Globale Vars setzen */
void Info(void);                       /* Informationsfenster schreiben */
void NameEingeben(void);               /* Spielername fr HiScore abfragen */
void NameOK(gui_event ge);             /* OK-Button-Handler Spielername */
void PruefsummeBilden(void);  /* erstellt eine Prfsumme fr jeden Datensatz */
void PruefsummeTesten(void);  /* lscht Datenstze mit falscher Prfsumme */
void SavedateiLaden(gui_event ge);
void SavedateiSchreiben(gui_event ge);
int  HighScore(void);


/* Button-Notify-Handler */
void BN_Neu(gui_event event)
{  /* Button Neu */
   Init();
}
void BN_Pause(gui_event event)
{  /* Button Pause */

   if (spielende) return;  /* Spiel ist zuende, keine Pause machen */

   if (pausieren) {
      pausieren = FALSE;
      MouseSetCursor(gui_cursor_point);
      ZeigSpielfeld();
   }
   else {
      pausieren = TRUE;
      MouseSetCursor(cursor_pause);
      ZeigSpielfeld();
   }
}

void Suchen(gui_event ge);   /* Button-Notify-Handler: Suchen */

void BN_Ende(gui_event event)
{  /* Button Ende */
   exit(0);
}
void BN_Opts(gui_event event)
{  /* Button Optionen */
   gui_show_window(3);
}
void BN_Datei(gui_event event)
{  /* Button Speichern */
   SavedateiSchreiben(event);
}
void BN_Besten(gui_event event)
{  /* Button Bestenliste */
   gui_show_window(2);
}
void BN_BestFertig(gui_event event)
{  /* Button Fertig, auf Bestenliste */
   gui_hide_window(2);
}
void BN_OptsFertig(gui_event event)
{  /* Button Fertig, auf Optionen */
/*   gui_hide_window(3); */
   Init();
}

void Alert_HiScore(gui_event event)
{  /* Button Fertig, auf HighScore-Alert-Fenster */
   gui_hide_window(5);  /* Mogel-Alert schlieen */
   gui_show_window(2);  /* Highscore zeigen */
}

void repaint_miner(void);              /* Repaint-Handler Hauptfenster */
void ZeigHiScore(void);                /* Repaint-Handler HighScoreListe */
void Steuern(gui_event ge);            /* Eventhandler Hauptfenster */
void Scroll(gui_event event);          /* Scroller-Handler */
void ZeitAnsage(gui_event event);      /* Zeit-Handler */
unsigned long int Punktewertung(unsigned long int);

int main(void)
{
   int maxX, maxY;
   gui_textfeld *gt;

   /* Grafikmodus einschalten */
   GrSetMode(GR_default_graphics);

   maxX = GrScreenX();
   maxY = GrScreenY();

   /* GUI-Elemente anmelden */
   gui_create_window(1, 6, 1, "3D Minensucher V 1.0", 0, 0, maxX, maxY,
      0, Steuern, NULL, 0, repaint_miner);

   gui_create_button(1, 1, 0, 0, "_Neu",         100, 150, 0, 0, BN_Neu, 0);
   gui_create_button(1, 2, 0, 0, "_Pause",       100, 180, 0, 0, BN_Pause, 0);
   gui_create_button(1, 3, 0, 0, "_Suchen",      100, 210, 0, 0, Suchen, 0);
   gui_create_button(1, 4, 0, 0, "_Ende",        100, 260, 0, 0, BN_Ende, 0);
   gui_create_button(1, 5, 0, 0, "_Optionen",    100, 310, 0, 0, BN_Opts, 0);
   gui_create_button(1, 6, 0, 0, "S_ichern ",    100, 340, 0, 0, BN_Datei, 1);
   gui_create_button(1, 7, 0, 0, "_Bestenliste", 100, 370, 0, 0, BN_Besten, 0);
   /* Infobereich auf Hauptfenster */
   gui_create_message(1, 1, "    Minenfeld", 10, 15, GrBlack(), GrWhite());
   gui_create_textfeld(1, 1, 8, 0, "     ", 6, 30, 16, 16);
   gui_create_textfeld(1, 2, 8, 0, "    Minen:", 6, 45, 5, 5);
   gui_create_textfeld(1, 3, 8, 0, "     Zeit:", 6, 60, 10, 10);
   gui_create_textfeld(1, 4, 8, 0, "   Punkte:", 6, 75, 9, 9);

   gui_create_menu(1, 0, "Dateimenu");
   gui_create_menuitem(1, 1, 0, "Sichern", SavedateiSchreiben, 0);
   gui_create_menuitem(1, 2, 0, "Laden", SavedateiLaden, 0);

   gui_create_scroller(1, 1, 2, 0, 5, 5, 0, "X", maxX, maxY,
      maxX, maxY, Scroll);       /* unsichtbar anlegen (auerhalb Screen) */
   gui_create_scroller(1, 2, 3, 0, 5, 5, 5, "Y", maxX, maxY,
      maxX, maxY, Scroll);
   gui_create_scroller(1, 3, 3, 0, 5, 5, 5, "Z", maxX, maxY,
      maxX, maxY, Scroll);

   gui_create_window(2, 6, 0, "Bestenliste", 100, 10, 580, 470,
      0, NULL, NULL, 0, ZeigHiScore);
   gui_create_button(2, 1, 0, 0, " OK ", 0, 10, 0, 0, BN_BestFertig, 0);
   gui_create_message(2, 1,
      "    Name              Datum Minenfeld Level  Zeit   Punkte",
      5, 23, GrBlack(), GrWhite());

   gui_create_window(3, 4, 0, "Optionen", 100, 100, 325, 250,
      0, NULL, NULL, 0, NULL);
   gui_create_button(3, 1, 0, 0, " OK ", 0, 0, 0, 0, BN_OptsFertig, 0);
   gui_create_textfeld(3, 1, 21, 0, "            Breite:", 10, 50, 3, 3);
   gui_create_textfeld(3, 2, 21, 0, "              Hhe:", 10, 70, 3, 3);
   gui_create_textfeld(3, 3, 21, 0, "Schwierigkeitsgrad:", 10, 100, 2, 2);
   gt = gui_textfeld_adr(3, 1);
   if (gt) gt->min = 5;
   gt = gui_textfeld_adr(3, 2);
   if (gt) gt->min = 1;
   gt = gui_textfeld_adr(3, 3);
   if (gt) {
      gt->min = 1;
      gt->max = 50;
   }
   gui_set_textfeld(3, 1, "7");
   gui_set_textfeld(3, 2, "7");
   gui_set_textfeld(3, 3, "8");

   gui_create_window(4, 5, 0, "Wer war das?", 300, 30, 550,
      150, 0, NULL, NULL, 1, NULL);

   gui_create_button(4, 1, 0, 0, " OK ", 0, 0, 0, 0, NameOK, 0);
   gui_create_textfeld(4, 1, 4, 0, "Name:", 2, 35, 20, 20);

   gui_create_window(5, 5, 0, "W A R N U N G", 210, 180, 430, 300,
      -1, NULL, NULL, -1, NULL);
   gui_create_button(5, 1, 0, 0, " OK ", 0, 10, 0, 0, Alert_HiScore, 0);
   gui_create_message(5, 1, "Das Spiel ist schon in", 10, 30, GrBlack(), GrWhite());
   gui_create_message(5, 2, "   der Bestenliste.", 10, 44, GrBlack(), GrWhite());
   gui_create_message(5, 3, "  Bitte nicht mogeln!", 10, 72, GrBlack(), GrWhite());


   /* Globale Variablen setzen */
   Init();

   /* Hauptschleife fr Eventsteuerung */
   gui_main_loop(ZeitAnsage, 1);

   /* Programmende, Grafik aus (wird normalerweise nicht erreicht) */
   GrSetMode(GR_default_text);

   exit(0);
}

/* Unterprogramme Minenspiel */
/**********************************************************/
void Init(void)
{  /* Globale Vars setzen */
   char text[20];
   int i, j, k, adr, h;

   tot_farbe[0] = 3;         /* Farbtabelle fr TOT-Cursor */
   tot_farbe[1] = GrBlack();
   if (GrNumColors() > 16) tot_farbe[2] = GrAllocColor(128,128, 128);
   else tot_farbe[2] = 8;    /* VGA-Farbtabelle */
   tot_farbe[3] = GrWhite();

   cursor_tot = GrBuildCursor(pix_tot, 17, 19, 9, 11, tot_farbe);
   cursor_pause = GrBuildCursor(pix_pause, 17, 19, 9, 11, tot_farbe);
   cursor_sieg = GrBuildCursor(pix_sieg, 17, 19, 9, 11, tot_farbe);

   /* allgemeine globale Variablen setzen */
   gewonnen = FALSE;
   spielende = FALSE;
   zeit = 0;                        /* Spielzeit nullen */
   pausieren = FALSE;               /* Pause aus */
   magic = time(NULL);              /* Spiel-Kennung, spaeter verbessern ? */
   HighScore();                     /* HiScore-Liste einlesen */
   MouseSetCursor(gui_cursor_point);

   strcpy(text, gui_get_textfeld(3, 1));  /* Optionsfenster abfragen */
   kanteXY = atoi(text);
   if (kanteXY < 5) {                     /* zu kleine Felder verhindern */
      kanteXY = 5;
      gui_set_textfeld(3, 1, "5");
   }
   strcpy(text, gui_get_textfeld(3, 2));
   kanteZ = atoi(text);
   if (kanteZ < 1) {
      kanteZ = 1;
      gui_set_textfeld(3, 2, "1");
   }
   if (kanteZ > kanteXY) {
      kanteZ = kanteXY;
      sprintf(text, "%d", kanteXY);
      gui_set_textfeld(3, 2, text);
   }
   strcpy(text, gui_get_textfeld(3, 3));
   dichte = atoi(text);
   if (dichte < 1) {
      dichte = 1;
      gui_set_textfeld(3, 3, "1");
   }
   if (dichte > 50) {
      dichte = 50;
      gui_set_textfeld(3, 3, "50");
   }

   dlY = kanteZ;
   dlX = kanteXY*dlY;

   Spielfeld = (char *)malloc(kanteXY*kanteXY*kanteZ*sizeof(char));

   /* hier Schwierigkeitsgrad bercksichtigen */
   minen = kanteXY*kanteXY*kanteZ*dichte/100;
   markiert = 0;
   offen = 1;                /* Startfeld wird gleich aufgedeckt */

   /* Spielfeld auf Null setzen */
   for (i = 0; i < kanteXY; i++) {
      for (j = 0; j < kanteXY; j++) {
         for (k = 0; k < kanteZ; k++) {
              adr = i*dlX+j*dlY+k;
              *(Spielfeld+adr) = 2;     /* nur verdeckt, keine Mine ... */
         }
      }
   }
   x_0 = 0; y_0 = 0; z_0 = 0;    /* relative Bildschirmkoordinaten */
   xpos = 0; ypos = 0; zpos = 0; /* Koords fr Suchen() initialisieren */
   /* Minen auswrfeln */
   srandom(time(NULL));          /* Zufallszahlen initialisieren */
   h = 0;
   while (h < minen) {
      i = random()%kanteXY;    /* Minen nicht doppelt und */
      j = random()%kanteXY;    /* nicht zu nah am */
      k = random()%kanteZ;     /* Startfeld (0, 0, 0) legen */
      if ((*(Spielfeld+(i*dlX+j*dlY+k)) == 2)&&((i+j+k) > 3)) {
         *(Spielfeld+(i*dlX+j*dlY+k)) += 1;     /* Mine gelegt */
         h++;
      }
   }
   *(Spielfeld+(0*dlX+0*dlY+0)) = 0;            /* freies Startfeld */

   /* Infobereich auf Spielfeld-Fenster anlegen */
   gui_show_window(1);

   /* Wenn neues Spiel, dann alten Editbereich schlieen */
   sprintf(text, "%dx%dx%d %d", kanteXY, kanteXY, kanteZ, dichte);
   gui_set_textfeld(1, 1, text);
   sprintf(text, "%d", minen);
   gui_set_textfeld(1, 2, text);
   gui_set_textfeld(1, 3, "0:00:00");
   gui_set_textfeld(1, 4, "0");
}

/**********************************************************/
void repaint_miner(void)
{ /* Repaint-Handler Hauptfenster, Einzelfeld- und Gesamtgre an
   * Fenstergre anpassen
   */
   int fhh, fhb;
   int b, h;
   float hilf;
   gui_scroller *gs;
   float tl;               /* exakteTicklnge (-breite) */

   /* Spielfeldgre bestimmen */
   y_base = gui_window_height(1)-20;   /* Platz fr X-Scroller lassen */
   b = gui_window_width(1)-x_base-20;  /* Zeichenbreite */
   h = y_base;                         /* Zeichenhhe */

   if ((h < 50)||(b < 50)) {        /* Zu klein, lohnt nicht */
      gs = gui_scroller_adr(1, 1);
      gs->zustand |= gui_SCROLLER_INVISIBLE;    /* X-Scroller aus */
      gs = gui_scroller_adr(1, 2);
      gs->zustand |= gui_SCROLLER_INVISIBLE;    /* Y-Scroller aus */
      gs = gui_scroller_adr(1, 3);
      gs->zustand |= gui_SCROLLER_INVISIBLE;    /* Z-Scroller aus */

      return;
   }
   fh = 15;    /* Mindestwert fr Einzelfeld-Hhe */
   hilf = ((float)h)/fh + 0.0625;
   hilf = sqrt(hilf) - 0.25;
   ay = (int)hilf;
   az = ay;
   if (az < 3) az = 3;
   if (az > kanteZ) {   /* zuviele Ebenen passen */
      az = kanteZ;
      ay = ((float)h/az-(float)fh/2)/((float)fh);
   }
   if (ay < 3) ay = 3;
   if (ay > kanteXY) ay = kanteXY;
   fh = (float)h/(ay*az+.5*az);
   if (fh < 1) fh = 1;                /* sonst  gibts DIV BY ZERO-ERROR */
   ax = ((float)(b-ay*fh))/(2*fh);
   if (ax < 3) ax = 3;
   if (ax > kanteXY) ax = kanteXY;
   if (ax < ay) {     /* tiefer als breit, bringts nicht */
      ax = ay;
      if (45*ax > b) {   /* Mindest-Einzelfeldgre einkalkulieren */
         ax = b/45;
         ay = ax;
      }
   }
   fhb = b/(2*ax+ay);
   fhh = h/(ay*az+.5*az);
   if (fhh < fhb) fh = fhh;
   else fh = fhb;
   if (fh < 1) fh = 1;
   fb = 2*fh;
   eh = ay*fh+fh/2;
   if (ax < kanteXY) {                 /* X-Scroller bestimmen und zeigen */
      gs = gui_scroller_adr(1, 1);
      gs->zustand &= 0xFFFB;           /* Scroller an */
      gs->ticks = kanteXY;
      gs->bereich = ax;
      gs->pos = x_0;
      gs->x1 = x_base;
      gs->y1 = y_base+3;
      gs->x2 = x_base+ax*fb;
      gs->y2 = y_base+20;

      /* Ticklnge berechnen */
      tl = ((float)(gs->x2-gs->x1))/kanteXY;
      if (tl < 2) gs->typ &= 0xFFFD;
      else gs->typ |= 2;

      gs->ticklen = tl;
   }
   else {                              /* X-Scroller verstecken */
      gs = gui_scroller_adr(1, 1);
      gs->zustand |= gui_SCROLLER_INVISIBLE;    /* Scroller aus */
   }
   if (ay < kanteXY) {                 /* Y-Scroller bestimmen und zeigen */
      gs = gui_scroller_adr(1, 2);
      gs->zustand &= 0xFFFB;           /* Scroller an */
      gs->ticks = kanteXY;
      gs->bereich = ay;
      gs->pos = kanteXY-ay-y_0;
      gs->x1 = x_base+ax*fb+ay*fh+2;
      gs->y1 = y_base-eh+fh/2;
      gs->x2 = x_base+ax*fb+ay*fh+19;
      gs->y2 = y_base;

      /* Ticklnge berechnen */
      tl = ((float)(gs->y2-gs->y1))/kanteXY;
      if (tl < 2) gs->typ &= 0xFFFD;
      else gs->typ |= 2;

      gs->ticklen = tl;
   }
   else {                              /* Y-Scroller verstecken */
      gs = gui_scroller_adr(1, 2);
      gs->zustand |= gui_SCROLLER_INVISIBLE;    /* Scroller aus */
   }
   if (az < kanteZ) {                  /* Z-Scroller bestimmen und zeigen */
      gs = gui_scroller_adr(1, 3);
      gs->zustand &= 0xFFFB;           /* Scroller an */
      gs->ticks = kanteZ;
      gs->bereich = az;
      gs->pos = kanteZ-az-z_0;
      gs->x1 = x_base-20;
      gs->y1 = y_base-ay*eh;
      gs->x2 = x_base-6;
      gs->y2 = y_base;

      /* Ticklnge berechnen */
      tl = ((float)(gs->y2-gs->y1))/kanteZ;
      if (tl < 2) gs->typ &= 0xFFFD;
      else gs->typ |= 2;

      gs->ticklen = tl;
   }
   else {                              /* Z-Scroller verstecken */
      gs = gui_scroller_adr(1, 3);
      gs->zustand |= gui_SCROLLER_INVISIBLE;    /* Scroller aus */
   }
   ax--; ay--; az--;

   ZeigSpielfeld();

   /* Info-Flche auf Hauptfenster */
   GrFramedBox(5, 5, x_base-25, 105, 3, &gui_win_col);
}

/**********************************************************/
void Scroll(gui_event ge)
{ /* Scroll-Leisten-Handler */
   gui_scroller *gs;

   gs = (gui_scroller *)ge.ptr;
   switch (gs->handle) {
      case 1: x_0 = gs->pos; break;
      case 2: y_0 = kanteXY-gs->pos-gs->bereich; break;
      case 3: z_0 = kanteZ-gs->pos-gs->bereich;  break;
   }
   ZeigSpielfeld();
}

/**********************************************************/
void Steuern(gui_event ge)
{  /* Eventhandler Hauptfenster */
   int sx, sy;              /* Mauskoordinaten, bezogen auf Spielfeld */
   int u, v, w;             /* Maus auf 3D-Spielfeld, Hilfsvars */
   int i, j, k, h;
   static int ualt=0, valt=0, walt=0;    /* alte Maus-3D-Koordinaten */
   float f;
   char text[20];           /* Hilfsstring fr Textausgabe */

   if (pausieren) return;

   /* als letztes die Abfrage auf Spielfeldkoordinaten */
   sx = ge.wx-x_base;   /* Mauskoordinaten auf Spielfeld-X-Y-System */
   sy = y_base-ge.wy;   /* Ecke links unten */
   w = sy/eh;           /* Ebene */
   f = sy%eh;
   u = (sx-f)/fb;
   f = f/fh;
   v = (int)f;                         /* eigentlich will ich Integer */
   if ((u >= 0)&&(u <= ax)&&(v >= 0)&&(v <= ay)&&(w >= 0)&&(w <= az)) {
      /* wirklich ein Spielfeld, umrechnen auf absolute Koord. */
      u += x_0;
      v += y_0;
      w += z_0;
      h = *(Spielfeld+(u*dlX+v*dlY+w));
      if ((ge.me.flags & M_LEFT_UP)&&(!spielende)) {
         /* Spielfeld aufdecken */
         if (h == 3) { /* verdeckte Mine, tot */
            spielende = TRUE;
            /* Auf 'ne Mine getreten, Explosionsgeraeusch versuchen */
            j = 40;
            for (i = 0; i < 20; i++) {
               j += 5-random()%10;
               sound(j);
               usleep(1);
            }
            sound(0);
            pausieren = TRUE;
            MouseSetCursor(cursor_tot);
         }
         else {
            if (h == 2) { /* verdecktes freies Feld */
               Aufraeumen(u, v, w);
               if (offen+minen == kanteZ*kanteXY*kanteXY) {
                  gewonnen = TRUE;
                  MouseSetCursor(cursor_sieg);
                  ZeitAnsage(ge);
                  spielende = TRUE;
                  pausieren = TRUE;
                  NameEingeben();         /* Name fr HiScore eingeben */
               }
            }
            else if (h >= 16) { /* WARN-Feld */
               i = h/16+1;              /* Rechtsshift 4 und +1 */
               if (i == 16) i = 1;
               i *= 16;                 /* Linksshift 4 */
               i += (h&15); /* Zustandbits von h bernehmen */
               h = i;
               *(Spielfeld+(u*dlX+v*dlY+w)) = h;
               ZeigFeld(u, v, w, h, FALSE);  /* Warn anzeigen */
            }
         }
      }
      else if ((ge.me.flags & M_RIGHT_UP)&&(!spielende)) {
         /* Spielfeld markieren */
         if ((h == 2)||(h == 3)) {    /* nicht markiert, nicht frei */
            h += 4;
            *(Spielfeld+(u*dlX+v*dlY+w)) = h;  /* markieren */
            markiert++;
         }
         else {
            if ((h&4) == 4) {      /* Mark aufheben, Warn setzen */
               h += 12;            /*    -4+16 => 12 */
               *(Spielfeld+(u*dlX+v*dlY+w)) = h;
               markiert--;
            }
            else {
               h = h&15;             /* Warn aufheben */
               *(Spielfeld+(u*dlX+v*dlY+w)) = h;
            }
         }
         ZeigFeld(u, v, w, h, FALSE); /* gendertes Warn anzeigen */
         sprintf(text, "%d", minen-markiert);
         gui_set_textfeld(1, 2, text);
      }
      else {
         /* nichts passiert, nur 3-fach Cursor zeichnen ? */
         if ((u != ualt)||(v != valt)||(w != walt)) {
            /* alte Maus-Umgebung normalsetzen */
            if ((ualt >= x_0)&&(ualt <= x_0+ax)&&(valt >= y_0)&&
                (valt <= y_0+ay)) {
               for(k = walt-1; k <= walt+1; k++) {
                  if ((k >= z_0)&&(k <= z_0+az)) {
                     h = *(Spielfeld+(ualt*dlX+valt*dlY+k));
                     ZeigFeld(ualt, valt, k, h, FALSE);
                  }
               }
            }
            /* Maus-Umgebung zeigen */
            for(k = w-1; k <= w+1; k++) {
               if ((k >= z_0)&&(k <= z_0+az)) {
                  h = *(Spielfeld+(u*dlX+v*dlY+k));
                  ZeigFeld(u, v, k, h, TRUE);
               }
            }
            ualt = u; valt = v; walt = w;

         }
      }
   }

}

/**********************************************************/
void ZeigSpielfeld(void)
{ /* Ausgabe des sichtbaren Bildbereichs */
   int i, j, k, h, c;
   int feld[4][2];

   if (GrNumColors() > 16) c = GrAllocColor(80, 80, 80);
   else c = 8;
   for(k = z_0; k <= z_0+az; k++) {        /* az Ebenen */
      /* Ebenenhintergrund zeichnen */
      feld[0][0] = x_base-5;
      feld[0][1] = y_base+2-(k-z_0)*eh;
      feld[1][0] = x_base+(ax+1)*fb;
      feld[1][1] = y_base+2-(k-z_0)*eh;
      feld[2][0] = x_base+(ax+1)*fb+(ay+1)*fh+3;
      feld[2][1] = y_base-(ay+1)*fh-(k-z_0)*eh;
      feld[3][0] = x_base+(ay+1)*fh-1;
      feld[3][1] = y_base-(ay+1)*fh-(k-z_0)*eh;
      GrFilledConvexPolygon(4, feld, c);
      for(i = x_0; i <= x_0+ax; i++) {     /* ax Felder in X-Richtung */
         for(j = y_0; j <= y_0+ay; j++) {  /* ay Felder in Y-Richtung */
            h = *(Spielfeld+(i*dlX+j*dlY+k));
            ZeigFeld(i, j, k, h, FALSE);
         }
      }
   }

}

/**********************************************************/
void ZeigFeld(int i, int j, int k, int h, int muster)
{  /* Ausgabe eines Einzelfeldes, evtl. mit Muster fr Mausfeld */
   int summe;
   int farbe;
   int px1, py1, px2, py2;               /* Ecken der Einzelfelder */
   int feld[4][2];
   char text[10], text1[10];

   px1 = x_base+(i-x_0)*fb +(j-y_0)*fh; /* Feldbreite=fb Pixel */
   py1 = (k-z_0)*eh +(j-y_0)*fh;
   px2 = px1+fb-2;                /* 2 Pixel Platz als */
   py2 = py1+fh-2;                /*   Trennung */
   py1 = y_base-py1; /* Umrechnung auf Bildschirmkoordinaten */
   py2 = y_base-py2;
   feld[0][0] = px1;    feld[0][1] = py1;  /* Ecken des Polygons */
   feld[1][0] = px2;    feld[1][1] = py1;
   feld[2][0] = px2+fh; feld[2][1] = py2;
   feld[3][0] = px1+fh; feld[3][1] = py2;

   if (h > 15) {
      if (GrNumColors() > 16) farbe = GrAllocColor(255, 255, 0); /* warn, Gelb */
      else farbe = 14;
   }
   else if ((h&4) == 4) {
      if (GrNumColors() > 16) farbe = GrAllocColor(255, 0, 0);   /* markiert */
      else farbe = 12;
   }
   else if ((h&2) == 2) {
      if (GrNumColors() > 16) farbe = GrAllocColor(128, 128, 128); /* verdeckt */
      else farbe = 7;
   }
   else {
      if (GrNumColors() > 16) farbe = GrAllocColor(255, 255, 255);    /* freies Feld, Wei */
      else farbe = GrWhite();
   }

/*   setcolor(farbe); */                  /* Randfarbe setzen */

   if ((h&8) == 8) {                  /* falsch markiert/gewarnt */
      if ((h&1) == 0) {
         if (GrNumColors() > 16) farbe = GrAllocColor(0, 0, 255);
         farbe = 9;      /* eigentlich frei */
      }
      else {
         if (GrNumColors() > 16) farbe = GrAllocColor(128, 0, 0);
         farbe = 4;                 /* Mine */
      }
   }

   if  (pausieren&&(!spielende)) farbe = GrBlack();

   if (!muster) GrFilledConvexPolygon(4, feld, farbe);
   else {
      if (GrNumColors() > 16) mybitmap.bmp_fgcolor = GrAllocColor(80, 80, 80);
      else mybitmap.bmp_fgcolor = 8;
      mybitmap.bmp_bgcolor = farbe;
      GrPatternFilledConvexPolygon(4, feld, (GrPattern *)&mybitmap);
   }

   if (h == 0) {                      /* freies Feld */
      summe = Summe(i, j, k);
      if (summe > 0) {
         itoa(summe, text, 10);
         GrTextXY(px1+fb/2, py1-fh/2-5, text, GrBlack(), GrNOCOLOR);
      }
   }
   if (h >= 15) {                   /* verdchtiges Feld */
      summe = ((h/16)-1)%5+1;    /* Rechtsshift 4, umcodieren in 5er-Gruppen */
/*      sprintf(text, "%d", summe); */   /* => 3 Gruppen von je 1 bis 5 */
      itoa(summe, text, 10);
      summe = h/16;                 /* Rechtsshift 4 */
      if (summe < 6) strcpy(text1, "a");
      else if (summe < 11) strcpy(text1, "b");
      else strcpy(text1, "c");
      strcat(text1, text);
      GrTextXY(px1+fb/2, py1-fh/2-5, text1, GrBlack(), GrNOCOLOR);
   }

}

/**********************************************************/
void Aufraeumen(int x, int y, int z)
{  /* rekursives Aufrumen um leere Felder */
   int i, j, k;
   int hoff;                  /* HilfsVar fr Offset */

   hoff = x*dlX+y*dlY+z;
   if (*(Spielfeld+(hoff)) == 2) {  /* einfach verdeckt, nicht markiert */
      *(Spielfeld+(hoff)) = 0;      /* auf frei ndern */
      offen ++;                     /* ein freies Feld mehr */
      if ((x>=x_0)&&(x<ax+x_0+1)&&(y>=y_0)&&(y<ay+y_0+1)&&
          (z>=z_0)&&(z<az+z_0+1))
         ZeigFeld(x, y, z, 0, FALSE);         /* sichtbares Feld, zeigen */
   }
   else return;

   if (rec_count < 3000) {                /* Rekursionstiefe */
      rec_count++;

      if (Summe(x, y, z) == 0) {          /* Minensumme Umgebung = 0 */
         for (i = x-1; i <= x+1; i++) {
            if ((i>=0)&&(i<kanteXY)) {
               for (j = y-1; j <= y+1; j++) {
                  if ((j>=0)&&(j<kanteXY)) {
                     for (k = z-1; k <= z+1; k++) {
                        if ((k>=0)&&(k<kanteZ)) Aufraeumen(i, j, k);
                     }  /* next k */
                  }  /* end if j */
               }  /* next j */
            }  /* end if i */
         }  /* next i */
      }   /* end if */

      rec_count--;
   }

}

/**********************************************************/
int Summe(int x, int y, int z)
{   /* Minen-Summe um geklicktes Feld bilden */
    int i, j, k, s, h;
    int hi, hj, hk;        /* Hilfs-Vars fr Pointerarithmetik */

    s = 0;                 /* Minen-Summe in Nachbarschaft */
    for (i = x-1; i <= x+1; i++) {
       if ((i>=0)&&(i<kanteXY)) {
          hi = i*dlX;
          for (j = y-1; j <= y+1; j++) {
             if ((j>=0)&&(j<kanteXY)) {
                hj = j*dlY + hi;
                for (k = z-1; k <= z+1; k++) {
                   hk = hj+k;
                   if ((k>=0)&&(k<kanteZ)) {
                      h = *(Spielfeld+(hk));
                      if ((h&1) == 1)  s++;
                   }
                }
             }
          }
       }
    }
    return s;
}

/**********************************************************/
void Suchen(gui_event ge)
{  /* Bildschirm auf NCHSTES verdecktes Feld (oder falsch markiertes) setzen
    * verndert globale x0/y0/z0-Koordinaten
    * benutzt globale xpos/ypos/zpos-Koordinaten, in Init() jedesmal genullt
    */
   int i, j, k, h;
   int status=0, spalten=0;  /* Rckgabewert, Endkontrolle */
   gui_scroller *gs;

   while (status == 0) {
      zpos +=az;
      if (zpos >= kanteZ-1) {  /* Randkontrolle */
         zpos = 0;
         ypos += ay;
      }
      if (ypos >= kanteXY-1) {  /* Nicht schachteln, weil vom vorherigen Spiel */
         ypos = 0;            /* berall zu groe Startwerte brig sein knnen. */
         xpos += ax;
      }
      if (xpos >= kanteXY-1) {  /* Randkontrolle */
         xpos = 0;
         spalten += ax;     /* ermglicht Kontrolle fr NICHTS GEFUNDEN */
      }                     /*    (Grenze der ueren [hi] Schleife) */
      if (xpos > kanteXY-ax-1) xpos = kanteXY-ax-1;
      if (ypos > kanteXY-ay-1) ypos = kanteXY-ay-1;
      if (zpos > kanteZ-az-1) zpos = kanteZ-az-1;

      for (i = xpos; i <= xpos+ax; i++) {   /* ist irgendwas in Sicht ? */
         for (j = ypos; j <= ypos+ay; j++) {  /* Wenn ja: Fertig */
            for (k = zpos; k <= zpos+az; k++) {
               h = *(Spielfeld+(i*dlX+j*dlY+k)); /* verdeckt oder falsch markiert */
               if ( (((h&2)==2)&&((h&4)==0)) || ((h&8)==8) ) status = 1;
            }
         }
      }
      if (spalten > kanteXY) status = -1;
   }
   if (status == 1) {
      x_0 = xpos; y_0 = ypos; z_0 = zpos;
   }

   /* es fehlt noch: Scroller aktualisieren */
   gs = gui_scroller_adr(1, 1);       /* X-Scroller */
   gs->pos = x_0;
   gui_show_scroller(1, 1);
   gs = gui_scroller_adr(1, 2);       /* Y-Scroller */
   gs->pos = kanteXY-gs->bereich-y_0;
   gui_show_scroller(1, 2);
   gs = gui_scroller_adr(1, 3);       /* Z-Scroller */
   gs->pos = kanteZ-gs->bereich-z_0;
   gui_show_scroller(1, 3);

   ZeigSpielfeld();

   return;
}

/**********************************************************/
void ZeitAnsage(gui_event event)
{ /* Zeit-Handler in gui_main_loop */
   char zahl[15];
   unsigned long int t1;    /* fr Gesamtzeit-Schtzung (Punktewertung) */
   int sec, std, min;

   if (!pausieren) {
      zeit++;
      if (markiert) {
         if (gewonnen) t1 = zeit;          /* schaetzen unnoetig */
         else t1 = zeit*minen/markiert;    /* geschtzte Gesamtzeit */
         if (t1 < 1) t1 = 1;
         t1 = Punktewertung(t1);
         sprintf(zahl, "%lu", t1);
         gui_set_textfeld(1, 4, zahl);
      }
      std = zeit/3600;              /* volle Stunden */
      min = (zeit-std*3600)/60;     /* volle Minuten */
      sec = zeit-std*3600-min*60;   /* Restsekunden */
      sprintf(zahl, "%d:%02d:%02d", std, min, sec);
      gui_set_textfeld(1, 3, zahl);
   }
}

/**********************************************************/
unsigned long int Punktewertung(unsigned long int t)
{
   unsigned long int pkt;

   pkt = ((long int)kanteXY*kanteZ*dichte/(1.5*pow(t, 0.33))*
              (25.0+3.0*dichte*dichte+pow((minen/20.0), 1.3)));
   if (kanteZ == 1) {
      pkt = pkt/(25/(kanteXY-4)+1);
   }
   return pkt;
}

/**********************************************************/
void NameOK(gui_event ge)
{ /* Textfeldinhalt in globalen Namen umkopieren, in HiScore einordnen */
   gui_window *gw;

   strcpy(name, gui_get_textfeld(gui_win->handle, 1));
   gui_hide_window(gui_win->handle);
   /* In HiScore einsortieren und anzeigen */
   HighScore();
   /* Wurde Mogel-Alert geffnet? */
   gw = gui_window_adr(5);    /* Pointer auf Mogel-Alert */
   if ((gw)&&(!(gw->zustand & 1))) gui_show_window(2);   /* kein Alert */
}

/**********************************************************/
void NameEingeben(void)
{  /* Alert-Window fuer Namenseingabe aufmachen, falls HiScoreeintrag ntig.
    */

   if (Punktewertung(zeit) > spieler[30].punkte) {
      gui_set_textfeld(4, 1, spieler[31].name);
      gui_show_window(4);
   }
}

/**********************************************************/
void PruefsummeBilden(void)
{  /* erstellt eine Prfsumme fr jeden Datensatz, in spieler[i].pruef */
   int i, j;
   unsigned long int summe;

   for (i = 0; i < 32; i++) {
      summe = spieler[i].magicId;
      for (j = 0; spieler[i].name[j] != 0; summe += spieler[i].name[j++]);
      summe += spieler[i].kX;
      summe += spieler[i].kZ;
      summe += spieler[i].zeit;
      for (j = 0; j < 8; summe += spieler[i].datum[j++]);
      summe += spieler[i].punkte;
      spieler[i].pruef = summe;
   }
}

/**********************************************************/
void PruefsummeTesten(void)
{  /* lscht Datenstze mit falscher Prfsumme */
   int i, j;
   unsigned long int summe;

   for (i = 0; i < 32; i++) {
      summe = spieler[i].magicId;
      for (j = 0; spieler[i].name[j] != 0; summe += spieler[i].name[j++]);
      summe += spieler[i].kX;
      summe += spieler[i].kZ;
      summe += spieler[i].zeit;
      for (j = 0; j < 8; summe += spieler[i].datum[j++]);
      summe += spieler[i].punkte;
      if (spieler[i].pruef != summe) {  /* Fehler: Datensatz lschen */
         spieler[i].magicId = 0;
         strcpy(spieler[i].name, "Stephan Schild");
         spieler[i].kX = 0;
         spieler[i].kZ = 0;
         spieler[i].schwer = 0;
         spieler[i].zeit = 99999;
         strcpy(spieler[i].datum, "19.09.95");
         spieler[i].punkte = 0;
      }
   }
}

/**********************************************************/
void SavedateiLaden(gui_event ge)
{  /* Savedatei laden, Rckgabe 0 fr Erfolg, 1 fr Probleme beim Laden */
   FILE *in;
   long int *vars;
   unsigned long int h;    /* Hilfsvariable fuer Pruefsumme (vars[29]) */
   int fehler = 0, i;
   char text[25]="";

   if ((vars = (long int *)malloc(30*sizeof(long int))))
   { /* Speicherreservierung erfolgreich, los gehts */
      if ((in = fopen("SAVE0001.3DM", "rb")) != NULL) {
         /* globale Variablen einlesen */
         fread(text, sizeof(text), 1, in);  /* nicht benutzt, ermgl. verschiedene Spielstnde */
         fread(vars, sizeof(vars), 30, in);

         /* Auswerten der globalen Variablen */
         dlX = vars[0]; dlY = vars[1]; /* dl = vars[2]; nicht mehr verwendet */
         kanteXY = vars[3]; kanteZ = vars[4]; minen = vars[5];
         markiert = vars[6]; offen = vars[7]; dichte = vars[8];
         xpos = vars[9]; ypos = vars[10]; zpos = vars[11];
         x_0 = vars[12]; y_0 = vars[13]; z_0 = vars[14];
         gewonnen = vars[15]; spielende = vars[16]; ax = vars[17];
         ay = vars[18]; az = vars[19]; fb = vars[20];
         fh = vars[21]; eh = vars[22]; x_base = vars[23];
         y_base = vars[24]; pausieren = vars[25]; zeit = vars[26];
         gespeichert = vars[27]; magic = vars[28];

         h = 0;
         for(i = 0; i < 29; h += vars[i++]);    /* Pruefsumme */
         if (h == vars[29]) {       /* Pruefsumme OK, Spielfeld lesen */
            free(Spielfeld);   /* altes Spielfeld freigeben */
            h = ((unsigned long int)kanteZ)*kanteXY*kanteXY;
            if ((Spielfeld = (unsigned char *) malloc(h))) {
               fread(Spielfeld, sizeof(char), h, in);
               fehler = FALSE;   /* Abspeichern erfolgreich */
               SavedateiSchreiben(ge);    /* Speicheranzahl hochzhlen */
               sprintf(text, "%dx%dx%d %d", kanteXY, kanteXY, kanteZ, dichte);
               gui_set_textfeld(1, 1, text);
               sprintf(text, "%d", minen-markiert);
               gui_set_textfeld(1, 2, text);
            }
         }
         fclose(in);

         if (fehler) {
            /* ernsthafter Fehler, Datenstruktur zerstrt */
            Init();
         }
         else {
            gui_move_window(0, 0);     /* Bildaufbau */
            SavedateiSchreiben(ge);    /* Speicheranzahl hochzhlen */
         }
      }

   }
   free(vars);
   if (spielende&&(!gewonnen)) MouseSetCursor(cursor_tot);
   else if (spielende) MouseSetCursor(cursor_sieg);
   else MouseSetCursor(gui_cursor_point);
}

/**********************************************************/
void SavedateiSchreiben(gui_event ge)
{  /* Savedatei schreiben */
   FILE *in;
   long int *vars;
   unsigned long int i;
   int fehler = TRUE;
   char text[25]="Miner3D Savegame 1\n\32";

   if ((vars = (long int *)malloc(30*sizeof(long int))))
   { /* Speicherreservierung erfolgreich, los gehts */
      /* Strafzeit: Anzahl speichern als Prozent von Gesamtzeit addieren */
      zeit += (float)zeit*((float)gespeichert/100.0);
      gespeichert++;

      vars[0] = dlX; vars[1] = dlY; vars[2] = time(NULL);   /* Zeit nur so, war frei */
      vars[3] = kanteXY; vars[4] = kanteZ; vars[5] = minen;
      vars[6] = markiert; vars[7] = offen; vars[8] = dichte;
      vars[9] = xpos; vars[10] = ypos; vars[11] = zpos;
      vars[12] = x_0; vars[13] = y_0; vars[14] = z_0;
      vars[15] = gewonnen; vars[16] = spielende; vars[17] = ax;
      vars[18] = ay; vars[19] = az; vars[20] = fb;
      vars[21] = fh; vars[22] = eh; vars[23] = x_base;
      vars[24] = y_base; vars[25] = pausieren; vars[26] = zeit;
      vars[27] = gespeichert; vars[28] = magic;
      vars[29] = 0;
      for(i = 0; i < 29; vars[29] += vars[i++]);   /* Pruefsumme */

      if ((in = fopen("SAVE0001.3DM", "wb+")) != NULL) {
         fwrite(text, sizeof(text), 1, in);  /* nicht benutzt, ermgl. verschiedene Spielstnde */
         fwrite(vars, sizeof(long int), 30, in);
         i = (unsigned long int)kanteZ*kanteXY*kanteXY;
         fwrite(Spielfeld, sizeof(char), i, in);
         fclose(in);

         fehler = FALSE;   /* Abspeichern erfolgreich */
      }
      free (vars);
   }

}

/**********************************************************/
int HighScore(void)
{
   FILE *in, *out;
   int i, pos;
   char eingabe[21];
   char *datei = "MINER3D.SCO";
   struct tm *date;
   time_t jetzt;

   /* Spielerdaten auf Default setzen (falls Spielstand-Datei fehlt) */
   for (i = 0; i < 32; i++) {
      spieler[i].magicId = 0;
      strcpy(spieler[i].name, "Stephan Schild");
      spieler[i].kX = 0;
      spieler[i].kZ = 0;
      spieler[i].schwer = 0;
      spieler[i].zeit = 99999;
      strcpy(spieler[i].datum, "30. 1.95");
      spieler[i].punkte = 0;
      spieler[i].pruef = 0;
   }                     /*1   5    0    5    0 */
   strcpy(spieler[0].name, "      Idee und");
   strcpy(spieler[0].datum, "");
   strcpy(spieler[1].name, "   Programmierung");
   strcpy(spieler[1].datum, "");
   strcpy(spieler[2].name, "        von");
   strcpy(spieler[2].datum, "");
   strcpy(spieler[3].name, "");
   strcpy(spieler[3].datum, "");
   strcpy(spieler[4].name, "   Stephan Schild");
   strcpy(spieler[4].datum, "");
   strcpy(spieler[5].name, "");
   strcpy(spieler[5].datum, "");
   strcpy(spieler[6].name, "  8. Dezember 1993");
   strcpy(spieler[6].datum, "");
   strcpy(spieler[7].name, "        ...");
   strcpy(spieler[7].datum, "");
   strcpy(spieler[8].name, " 19. September 1995");
   strcpy(spieler[8].datum, "");
   strcpy(spieler[9].name, "");
   strcpy(spieler[9].datum, "");
   strcpy(spieler[10].name, "");
   strcpy(spieler[10].datum, "");
   strcpy(spieler[11].name, "Copyright: GNU");
   strcpy(spieler[11].datum, "");
   strcpy(spieler[12].name, "General Public License");
   strcpy(spieler[12].datum, "");
   PruefsummeBilden();

   /* Falls vorhanden, HiScore einlesen */
   if ((in = fopen(datei, "rb")) != NULL) {
      fread(eingabe, sizeof(eingabe), 1, in);     /* Version prfen */
      if (strncmp(eingabe, "Miner3D V 1.0a   ", 15) == 0) {
         fread(spieler, sizeof(spieler[0]), 32, in);
         PruefsummeTesten();
      }
      fclose(in);
   }
   /* Falls Spiel schon einmal gespielt wurde: Kein Sieg mglich */
   pos = 0;
   for (i = 0; i < 31; i++) {      /* unten: Alert: !!! gemogelt !!! */
      if (spieler[i].magicId == magic) {
         gewonnen = FALSE;
         pos = i+1;
      }
   }
   if ((pos > 0)&&(pos < 31)) gui_show_window(5);  /* Mogel-Alert */

   /* Falls nicht gewonnen: HiScore nur einlesen */
   if (gewonnen == FALSE) return 1;

   /* Einsortieren, Namen abfragen und HiScore ausgeben */
   spieler[31].magicId = magic;
   spieler[31].kX = kanteXY;
   spieler[31].kZ = kanteZ;
   spieler[31].schwer = dichte;
   spieler[31].zeit = zeit;
   time(&jetzt);
   date = localtime(&jetzt);
   sprintf(spieler[31].datum, "%2u.%2u.", date->tm_mday, date->tm_mon+1);
   sprintf(eingabe, "%4u", date->tm_year+1900);
   strcat(spieler[31].datum, &(eingabe[2]));
   spieler[31].punkte = Punktewertung(zeit);
   /* einsortieren */
   pos = 31;
   for (i = 29; i >= 0; i--) {
       if (spieler[31].punkte > spieler[i].punkte) pos = i;
   }
   if (pos < 30) {           /* Gut genug fr HiScore? */
      strcpy(eingabe, spieler[31].name);  /* Default-Name */
      strcpy(spieler[31].name, name);
      for (i = 29; i >= pos; i--) {   /* Platz machen fr Neuen */
         spieler[i+1].magicId = spieler[i].magicId;
         strcpy(spieler[i+1].name, spieler[i].name);
         spieler[i+1].kX = spieler[i].kX;
         spieler[i+1].kZ = spieler[i].kZ;
         spieler[i+1].schwer = spieler[i].schwer;
         spieler[i+1].zeit = spieler[i].zeit;
         strcpy(spieler[i+1].datum, spieler[i].datum);
         spieler[i+1].punkte = spieler[i].punkte;
         spieler[i+1].pruef = spieler[i].pruef;
      }
      spieler[pos].magicId = spieler[31].magicId;  /* Neuen eintragen in Score */
      strcpy(spieler[pos].name, spieler[31].name);
      spieler[pos].kX = spieler[31].kX;
      spieler[pos].kZ = spieler[31].kZ;
      spieler[pos].schwer = spieler[31].schwer;
      spieler[pos].zeit = spieler[31].zeit;
      strcpy(spieler[pos].datum, spieler[31].datum);
      spieler[pos].punkte = spieler[31].punkte;
      spieler[pos].pruef = spieler[31].pruef;
   }

   /* HighScore abspeichern ? */
   if (pos < 30) {   /* hat sich gendert, abspeichern */
      if ((out = fopen(datei, "wb")) == NULL) {
         fprintf(stderr, "Fehler beim Schreiben des High-Scores.\n");
         exit(1);
      }
      strcpy(eingabe, "Miner3D V 1.0a   \n\32");
      fwrite(eingabe, sizeof(eingabe), 1, out);
      PruefsummeBilden();
      fwrite(spieler, sizeof(spieler[0]), 32, out);
      fclose(out);
   }

   return(0);
}

/**********************************************************/
void ZeigHiScore(void)
{ /* Repaint-Handler fuer Highscore-Fenster
   * globale Spielerdaten (in Init gelesen) anzeigen
   */
   int i, h;
   long int ht;
   long int std, min, sec;
   char text[61], groesse[11], hilf[50], hilf1[50];

   GrHLine(5, 475, 38, GrBlack());    /* von Namen absetzen */

   for(i = 0; i < 30; i++) {
      sprintf(groesse, "%ux%ux%u", spieler[i].kX, spieler[i].kX, spieler[i].kZ);
      strcpy(hilf1, spieler[i].name);
      if (strlen(hilf1) < 15)
          sprintf(hilf, "%-14s %8s %9s", hilf1, spieler[i].datum, groesse);
      else {                     /* Name UND Datum sind zu lang */
         h = 23-strlen(hilf1)-1;
         strcpy(text, spieler[i].datum);
         if (h > 5) text[5] = 0;
         else { if (h > 1) text[2] = 0; else text[0] = 0;}
         while (strlen(text) < h) strcat(text, " ");
         sprintf(hilf, "%s %s %9s", hilf1, text, groesse);
      }
      ht = spieler[i].zeit;
      std = ht/3600;                   /* Stunden Spielzeit */
      min = (ht-3600*std)/60;          /* Minuten Spielzeit */
      sec = ht-3600*std-60*min;        /* Sekunden Spielzeit */
      sprintf(hilf1, "%3lu:%02lu:%02lu", std, min, sec);
      sprintf(text, "%2u: %-33s %3u %9s%7lu", i+1, hilf,
              spieler[i].schwer, hilf1, spieler[i].punkte);
      GrTextXY(5, 40+i*13, text, GrBlack(), GrWhite());
   }

}