/*

           ⮣ 䠩 ...... VR072.C
              ᨨ ...... 0.72
                      ...... 22.02.95
                 ⨯ ...... VR047.C

         *.pp ⨭  ८ࠧ⥫   *.pp2
       (  ன  梥⮢ 0...63),  ⮤
       ᤢ 梥⮢ 0...191 -> 64...255  뢠
       ࢮ砫 梥⮢ 192...255.

*/


#include <dos.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <io.h>
#include <stdlib.h>


typedef unsigned char  byte;
typedef unsigned int   word;
typedef unsigned long  dword;


int  Getscrmode(void);
word Read(int handle,void far *buf,word len);
word Write(int handle,void far *buf,word len);
void Scrmode(int mode,int safeoldscr);
void VGA256pal(void *rgb);
void LoadPicture(char *name);
void ShowPic0(void);
void ShowPic1(void);
void Savescreen(void);


#define LENPIC  64000l//ࠧ ⨭  VGA ࠭;

int  handle;
char file[80];

int  oldmode;
word vseg=0xA000,voff=0;//segment/offset video-RAM;

byte far pic0[LENPIC];//ਣ쭠 ⨭  ᪠
byte pal0[256][3];//ᨢ  

byte far pic1[LENPIC];//⨭ pic0, ८ࠧ  pal1
byte pal1[256][3];//ᨢ   [color][rgb]

int col;
word w;

byte far *screen=(byte far *)0xA0000000l;//砫 VGA ࠭
char pcnum[10]="\r\n\r\n256\r\n";//ப  ஧筮 梥




void main(int argc,char *argv[])
{
int cmd;

if (argc<2)// ⮫쪮 1- 㬥 -  ᠬ ணࠬ!
  {
  printf("\n<<< *.pp->*.pp2 converter >>> (C) Vadim Madgazin, 1995\n\n");
  printf("1=palette/colors 0...255    2=palette/colors 64...255\n"
         "F2=save *.pp2               ESC=end\n\n");
  printf("Input filename.ext of *.pp picture: ");
  gets(file);
  }
else strcpy(file,argv[1]);

LoadPicture(file);

oldmode=Getscrmode();
Scrmode(0x13,0);//室  ०;

ShowPic0();//ਣ쭠 ⨭  ࠭;

back:
if ((cmd=getch())==0) cmd=1000+getch();

switch(cmd)
  {
  default: goto back;

  case '1': ShowPic0(); break;
  case '2': ShowPic1(); break;

  case 1060://F2;
    ShowPic1(); Savescreen(); goto end;

  case 27://ESC;
  case 'Q':
  case 'q': goto end;
  }
goto back;

end:
//⪠ ࠭  室  ⥪ ०:
Scrmode(oldmode,0);
}

int Getscrmode(void)
//頥 ⥪ -;
{
_AH=0x0F;
geninterrupt(0x10);
_AH=0;
return _AX;
}

void Scrmode(int mode,int safeoldscr)
//⠭ - mode
// ⪠ ࠭, ᫨ safeoldscr ࠢ ;
{
if (safeoldscr>0) safeoldscr=0x80;
mode=mode | safeoldscr;
_AL=mode;
_AH=0;
geninterrupt(0x10);
}

void VGA256pal(void *rgb)
//⠭ 梥 (0...63)  256 ॣ஢  VGA,
  //rgb -  㪠⥫  ᨢ ஥  r,g,b, r,g,b, ...
{
word far *fpuns;//far 㪠⥫  ᨢ;
word far **pfpuns;//㪠⥫  ।饥;

fpuns=(word far *)rgb;//far  ᨢ rgb[numreg][3];
pfpuns=&fpuns;

_ES=*((word *)pfpuns+1);// ᥣ;
_DX=*(word *)pfpuns;//ᬥ饭;
_CX=256;//᫮ ॣ஢;
_BX=0;// ॣ;
_AX=0x1012;
geninterrupt(0x10);
}

void LoadPicture(char *name)
{
handle=open(name,O_RDONLY|O_BINARY,S_IREAD);
Read(handle,pic0,LENPIC);
Read(handle,pal0,768);
//஧ 梥  :
//Read(handle,&numpclr[0],9);
close(handle);
}

void ShowPic0(void)
{
VGA256pal(pal0);
movedata(FP_SEG(pic0),FP_OFF(pic0),vseg,voff,LENPIC);
}

void ShowPic1(void)
{

//ᤢ pal0  pal1
for (col=0; col<256; ++col)
  {
  if (col<64)//⮥   pal1
    {
    pal1[col][0]=0;
    pal1[col][1]=0;
    pal1[col][2]=0;
    }
  else//ᤢ  
    {
    pal1[col][0]=pal0[col-64][0];
    pal1[col][1]=pal0[col-64][1];
    pal1[col][2]=pal0[col-64][2];
    }
  }

//८ࠧ ⨭ pic0->pic1 (ᤢ 梥⮢)
for (w=0; w<LENPIC; ++w)
  {
  col=pic0[w];
  if (col<192) col+=64;
  else         col=0;//㭨⮦ 梥 pic0  直  㫥묨
  pic1[w]=col;
  }

VGA256pal(pal1);
movedata(FP_SEG(pic1),FP_OFF(pic1),vseg,voff,LENPIC);
}

void Savescreen(void)
{
//७ .pp->.pp2
strcat(file,"2");

_fmode=O_BINARY;
//   ( ࠭ ண 䠩!):
if ((handle=creat(file,S_IREAD|S_IWRITE))==-1) return;

Write(handle,screen,LENPIC);
Write(handle,(void far *)pal1,768);
Write(handle,(void far *)pcnum,9);
close(handle);
}

word Read(int handle,void far *buf,word len)
{
static word n;
return _dos_read(handle,buf,len,&n);
}

word Write(int handle,void far *buf,word len)
{
static word n;
return _dos_write(handle,buf,len,&n);
}

