'============================================================
' ARCADE WHEEL OF WEALTH by William Yu 08-01-1995
' Like the game show WHEEL OF FORTUNE
' EGA Required
'   Program may NOT be modified and distributed in commercial
' products.  Permission granted to modify code but to retain
' original authors name.
'
' This program can be modified to run under QBasic, remove
' occurences of ColorPrint and replace it with something
' equivalent.
'
' To add/remove/edit puzzles look for *.DAT
' Simple format for editing
' All words should be in capitals, but modify the code for
' UCASE$ statements to prevent dummy edits.
'   EDIT PHRASE.DAT
' 1                <--- Counter (Increase as you add more)
' EMPTY            <--- CAPITALS ONLY
' EMPTY            <--- Minimum of 6 lines per puzzle
' WHAT GOES UP     <--- The Phrase
' MUST GO DOWN
' EMPTY            <--- Empty is displayed as blank lines
' EMPTY
'
' Trick of CLUE.DAT
'  EDIT CLUE.DAT
' 2
' FIRE              <--- If using BLANK CLUE
' EMPTY
'   ? TRUCK         <--- Minimum of 7 lines per puzzle
'   ? ALARM         <--- You MUST include the ? at beginning or end
'   ? FIGHTERS
' EMPTY
' EMPTY
' COTTON            <--- If using just CLUE
' EMPTY
'    RABBIT'S TAIL  <--- Minimum of 7 which includes CLUE
'    OR NATURAL     <--- No ? are neccessary
'    FIBER
' EMPTY
' EMPTY
'
' Modify as you wish, the code could use a lot of optimizing.
' I left out the EDIT feature in the game, but you can add
' your own.  As my optimized game uses a different format
' for the DATA Files.
'============================================================

'$DYNAMIC
'$INCLUDE: 'QB.BI'
DEFINT A-Z
DECLARE SUB DrawBoard ()
DECLARE SUB SideWrite (Mot$, PosX, PosY, Couleur, Opt)
DECLARE SUB DrawWheel ()
DECLARE SUB EmptyChar ()
DECLARE SUB ColorPrint (TEXT$, Row%, Col%, FC%, BC%)
DECLARE SUB Pause (ticks%)
DECLARE SUB WhatColor ()
DECLARE SUB CenterPrint (Col%, PrnText$)

DIM Puzzles$(6), LetPuzz$(15), Alpha(26)

ALLBEGIN:
CLS
SCREEN 7, 0, , 0

CIRCLE (49, 60), 65, 10, .55, 3
CIRCLE (268, 60), 65, 10, .55, 2.55
CIRCLE (158, 60), 65, 10, .55, 2.55
CIRCLE (160, 130), 200, 10, , , 1 / 10
CIRCLE (160, 160), 200, 10, 3, 6, 1 / 10
PAINT (268, 60), 2, 10
CIRCLE (160, 130), 200, 15, , , 1 / 10
CIRCLE (160, 140), 200, 15, , , 1 / 10
PAINT (160, 115), 8, 15
PAINT (160, 130), 1, 15

CIRCLE (160, 140), 200, 7, , , 1 / 10
CIRCLE (160, 130), 200, 15, , , 1 / 10
CIRCLE (160, 160), 200, 15, 3, 6, 1 / 10
PAINT (160, 175), 7, 15
CALL ColorPrint("ARCADE", 21, 10, 4, 7)
CALL ColorPrint(" WHEEL OF WEALTH", 21, 17, 15, 7)
LOCATE 25, 5: COLOR 10: PRINT "PROGRAMMED BY WILLIAM YU 1994-95";

CALL ColorPrint(CHR$(16), 6, 14, 12, 2)
CALL ColorPrint("ONE PLAYER", 6, 16, 14, 2)
CALL ColorPrint("TWO PLAYERS", 8, 16, 15, 2)
CALL ColorPrint("THREE PLAYERS", 10, 16, 15, 2)
CALL ColorPrint("EXIT GAME", 12, 16, 15, 2)

Rw = 1
DO
  V$ = INKEY$
  IF V$ = CHR$(0) + "P" THEN Rw = Rw + 1: Dn = 1: GOSUB PRE
  IF V$ = CHR$(0) + "H" THEN Rw = Rw - 1: Dn = 0: GOSUB PRE
  IF V$ = CHR$(13) THEN GOTO ENTER
  IF V$ = CHR$(27) THEN GOTO ENDGAME
LOOP

PRE:
IF Rw = 2 OR Rw = 0 THEN CALL ColorPrint("  ONE PLAYER", 6, 14, 15, 2)
IF Rw = 3 AND Dn = 1 THEN CALL ColorPrint("  TWO PLAYERS", 8, 14, 15, 2)
IF Rw = 1 AND Dn = 0 THEN CALL ColorPrint("  TWO PLAYERS", 8, 14, 15, 2)
IF Rw = 4 AND Dn = 1 THEN CALL ColorPrint("  THREE PLAYERS", 10, 14, 15, 2)
IF Rw = 2 AND Dn = 0 THEN CALL ColorPrint("  THREE PLAYERS", 10, 14, 15, 2)
IF Rw = 5 AND Dn = 1 THEN CALL ColorPrint("  EXIT GAME", 12, 14, 15, 2)
IF Rw = 3 AND Dn = 0 THEN CALL ColorPrint("  EXIT GAME", 12, 14, 15, 2)

IF Rw = 5 THEN Rw = 1
IF Rw = 0 THEN Rw = 4
IF Rw = 1 THEN CALL ColorPrint(CHR$(16), 6, 14, 12, 2): CALL ColorPrint("ONE PLAYER", 6, 16, 14, 2)
IF Rw = 2 THEN CALL ColorPrint(CHR$(16), 8, 14, 12, 2): CALL ColorPrint("TWO PLAYERS", 8, 16, 14, 2)
IF Rw = 3 THEN CALL ColorPrint(CHR$(16), 10, 14, 12, 2): CALL ColorPrint("THREE PLAYERS", 10, 16, 14, 2)
IF Rw = 4 THEN CALL ColorPrint(CHR$(16), 12, 14, 12, 2): CALL ColorPrint("EXIT GAME", 12, 16, 14, 2)
RETURN

ENTER:
IF Rw = 1 THEN Players = 1: GOTO DrawPlayers
IF Rw = 2 THEN Players = 2: GOTO DrawPlayers
IF Rw = 3 THEN Players = 3: GOTO DrawPlayers
IF Rw = 4 THEN GOTO ENDGAME

DrawPlayers:
LINE (100, 35)-(230, 100), 2, BF
IF Players >= 1 THEN
  CIRCLE (160, 50), 20, 14
  PAINT (160, 50), 14
  LINE (155, 68)-(130, 75), 9
  LINE (130, 75)-(134, 108), 9
  LINE (165, 68)-(190, 75), 9
  LINE (190, 75)-(186, 108), 9
  LINE (155, 68)-(165, 68), 9
  LINE (186, 108)-(134, 108), 9
  PAINT (160, 100), 9
  LINE (131, 92)-(195, 106), 12, B
  LINE (132, 93)-(194, 105), 0, BF
  LOCATE 13, 18: PRINT "$0"
END IF
IF Players >= 2 THEN
  CIRCLE (40, 50), 20, 12
  PAINT (40, 50), 12
  LINE (35, 68)-(10, 75), 9
  LINE (10, 75)-(14, 108), 9
  LINE (45, 68)-(70, 75), 9
  LINE (70, 75)-(66, 108), 9
  LINE (35, 68)-(45, 68), 9
  LINE (66, 108)-(14, 108), 9
  PAINT (40, 100), 9
  LINE (11, 92)-(75, 106), 12, B
  LINE (12, 93)-(74, 105), 0, BF
  LOCATE 13, 3: PRINT "$0"
END IF
IF Players = 3 THEN
  CIRCLE (280, 50), 20, 11
  PAINT (280, 50), 11
  LINE (275, 68)-(250, 75), 9
  LINE (250, 75)-(254, 108), 9
  LINE (285, 68)-(310, 75), 9
  LINE (310, 75)-(306, 108), 9
  LINE (275, 68)-(285, 68), 9
  LINE (306, 108)-(254, 108), 9
  PAINT (280, 100), 9
  LINE (251, 92)-(315, 106), 12, B
  LINE (252, 93)-(314, 105), 0, BF
  LOCATE 13, 33: PRINT "$0"
END IF
IF Players = 1 THEN TURN$ = "NOONE": GOTO StartGame

Round = 1
BL = 0
HIPRM& = 0
HIPYM& = 0
HIPBM& = 0

PlayerStartsHere:
EmptyChar
COLOR 10
IF Players >= 2 THEN LOCATE 13, 3: PRINT "       "
IF Players > 1 THEN LOCATE 13, 18: PRINT "       "
IF Players = 3 THEN LOCATE 13, 33: PRINT "       "
COLOR 10
IF Players >= 2 THEN LOCATE 13, 3: PRINT "$" + LTRIM$(STR$(HIPRM&))
IF Players > 1 THEN LOCATE 13, 18: PRINT "$" + LTRIM$(STR$(HIPYM&))
IF Players = 3 THEN LOCATE 13, 33: PRINT "$" + LTRIM$(STR$(HIPBM&))
IF Round < 7 THEN LOCATE 25, 5: COLOR 14: PRINT " PRESS ANY KEY TO BEGIN ROUND"; Round;
IF Round = 7 THEN LOCATE 25, 9: COLOR 14: PRINT "HERE ARE THE FINAL SCORES";
A$ = INPUT$(1)
LOCATE 25, 6: PRINT SPACE$(33);
IF Round = 7 THEN BL = 1: GOTO StartGame
COLOR 15
IF Players >= 2 THEN LOCATE 13, 3: PRINT "$0     "
IF Players > 1 THEN LOCATE 13, 18: PRINT "$0     "
IF Players = 3 THEN LOCATE 13, 33: PRINT "$0     "
DEL = 0
IF Round = 1 THEN TURN$ = "RED"
IF Round = 2 THEN TURN$ = "YELLOW"
IF Players = 2 THEN
IF Round = 3 THEN TURN$ = "RED"
IF Round = 4 THEN TURN$ = "YELLOW"
IF Round = 5 THEN TURN$ = "RED"
IF Round = 6 THEN TURN$ = "YELLOW"
END IF
IF Players = 3 THEN
IF Round = 3 THEN TURN$ = "BLUE"
IF Round = 4 THEN TURN$ = "RED"
IF Round = 5 THEN TURN$ = "YELLOW"
IF Round = 6 THEN TURN$ = "BLUE"
END IF
PRM = 0
PYM = 0
PBM = 0
Solving = 0
IF Players > 1 THEN PCOPY 0, 2
IF TURN$ = "RED" THEN
  DO
	LINE (11, 92)-(75, 106), 14, B
	Pause (1): DEL = DEL + 1
	LINE (11, 92)-(75, 106), 12, B
	Pause (1): DEL = DEL + 1
  LOOP UNTIL DEL >= 100 OR INKEY$ <> ""
END IF
IF TURN$ = "YELLOW" THEN
  DO
	LINE (131, 92)-(195, 106), 14, B
	Pause (1): DEL = DEL + 1
	LINE (131, 92)-(195, 106), 12, B
	Pause (1): DEL = DEL + 1
  LOOP UNTIL DEL >= 100 OR INKEY$ <> ""
END IF
IF TURN$ = "BLUE" THEN
  DO
	LINE (251, 92)-(315, 106), 14, B
	Pause (1): DEL = DEL + 1
	LINE (251, 92)-(315, 106), 12, B
	Pause (1): DEL = DEL + 1
  LOOP UNTIL DEL >= 100 OR INKEY$ <> ""
END IF

StartGame:
CLS

FOR I = 1 TO 26
  Alpha(I) = I + 64
NEXT I

InitializePuzzle:
SPW = 0
PMoney = 0

RANDOMIZE TIMER
J = INT(RND * 12) + 1

IF J = 1 AND BL = 0 OR J = 11 AND BL = 0 OR J = 12 AND BL = 0 THEN OPEN "PHRASE.DAT" FOR INPUT AS #1
IF J = 1 AND BL = 1 OR J = 11 AND BL = 1 OR J = 12 AND BL = 1 THEN GOTO InitializePuzzle
IF J = 2 AND BL = 0 THEN OPEN "B&A.DAT" FOR INPUT AS #1
IF J = 2 AND BL = 1 THEN GOTO InitializePuzzle
IF J = 3 THEN OPEN "PLACE.DAT" FOR INPUT AS #1
IF J = 4 THEN OPEN "S&R.DAT" FOR INPUT AS #1
IF J = 5 THEN OPEN "THING.DAT" FOR INPUT AS #1
IF J = 6 AND BL = 0 THEN OPEN "CLUE.DAT" FOR INPUT AS #1
IF J = 6 AND BL = 1 THEN GOTO InitializePuzzle
IF J = 7 THEN OPEN "MEGAWORD.DAT" FOR INPUT AS #1
IF J = 8 THEN OPEN "QUOTE.DAT" FOR INPUT AS #1
IF J = 9 THEN OPEN "PEOPLE.DAT" FOR INPUT AS #1
IF J = 10 THEN OPEN "SLANG.DAT" FOR INPUT AS #1

B = 6
IF J = 6 THEN B = 7
  INPUT #1, NumPuzzles
  RANDOMIZE TIMER
  RandPuzzle = INT(RND * NumPuzzles) + 1
  IF RandPuzzle <> 1 THEN
	FOR I = 1 TO RandPuzzle - 1
	 FOR N = 1 TO B
	   LINE INPUT #1, JUNK$
	 NEXT N
	NEXT I
  END IF
  IF J = 6 THEN LINE INPUT #1, ClueWord$
  FOR I = 1 TO 6
	LINE INPUT #1, Puzzles$(I)
  NEXT I
CLOSE

DrawBoard
COLOR 13
IF J = 1 OR J = 11 OR J = 12 THEN LOCATE 1, 35: PRINT "PHRASE"
IF J = 2 THEN LOCATE 1, 27: PRINT "BEFORE & AFTER"
IF J = 3 THEN LOCATE 1, 36: PRINT "PLACE"
IF J = 4 THEN LOCATE 1, 30: PRINT "STAR & ROLE"
IF J = 5 THEN LOCATE 1, 36: PRINT "THING"
IF J = 6 THEN LOCATE 1, 37: PRINT "CLUE"
IF J = 7 THEN LOCATE 1, 33: PRINT "MEGAWORD"
IF J = 8 THEN LOCATE 1, 32: PRINT "QUOTATION"
IF J = 9 THEN LOCATE 1, 35: PRINT "PEOPLE"
IF J = 10 THEN LOCATE 1, 36: PRINT "SLANG"

Index = 0: Xcor = 17: Ycor = 30: I = 1

DO
  Index = Index + 1
  IF Puzzles$(Index) <> "EMPTY" THEN
	Start = 1: I = 1
	LengthLine = LEN(Puzzles$(Index))
	DO
	 LetPuzz$(I) = MID$(Puzzles$(Index), Start, 1)
	 IF LetPuzz$(I) <> " " THEN
	   PAINT (Xcor, Ycor), 15, 10
	   IF LetPuzz$(I) = "&" OR LetPuzz$(I) = "-" OR LetPuzz$(I) = "'" OR LetPuzz$(I) = "?" THEN
		PAINT (Xcor, Ycor), 14, 10
		PALETTE 8, 0
		CALL SideWrite(LetPuzz$(I), Xcor - 12, Ycor - 1, 0, 11)
		LOCATE 1, 1: PRINT " ": PALETTE 8, 8
	   END IF
	 END IF
	 Xcor = Xcor + 22
	 I = I + 1: Start = Start + 1
	LOOP UNTIL I > LengthLine
  END IF
  Xcor = 17
  Ycor = Ycor + 23
LOOP UNTIL Index = 6
MAXLETTERS = I

IF BL = 1 THEN GOTO BONUSLAND

MAIN:
LOCATE 2, 3: COLOR 10, 0: PRINT CHR$(16); : COLOR 12: PRINT " SPIN WHEEL"
COLOR 15: LOCATE 2, 19: PRINT "BUY VOWEL"
LOCATE 2, 32: PRINT "SOLVE"
Col = 1
DO
  V$ = INKEY$
  IF V$ = CHR$(0) + "M" THEN Col = Col + 1: GOSUB MAINMOVE
  IF V$ = CHR$(0) + "K" THEN Col = Col - 1: GOSUB MAINMOVE
  IF V$ = CHR$(13) THEN GOTO MAINSEL
  IF V$ = CHR$(27) THEN GOSUB VERIFY
LOOP

MAINMOVE:
  COLOR 15
  LOCATE 2, 3: PRINT "  SPIN WHEEL    BUY VOWEL    SOLVE"
  COLOR 10
  IF Col = 4 THEN Col = 1
  IF Col = 0 THEN Col = 3
  IF Col = 1 THEN LOCATE 2, 3: PRINT CHR$(16); : COLOR 12: PRINT " SPIN WHEEL"
  IF Col = 2 THEN LOCATE 2, 17: PRINT CHR$(16); : COLOR 12: PRINT " BUY VOWEL"
  IF Col = 3 THEN LOCATE 2, 30: PRINT CHR$(16); : COLOR 12: PRINT " SOLVE"
RETURN

MAINSEL:
IF Col = 1 THEN LOCATE 2, 3: PRINT STRING$(35, " "): PCOPY 0, 1: GOSUB SPINWHEEL
IF Col = 2 THEN LOCATE 2, 3: PRINT STRING$(35, " "): GOSUB BUYVOWEL
IF Col = 3 THEN LOCATE 2, 3: PRINT STRING$(35, " "): PCOPY 0, 1: GOTO Solve
GOTO MAIN

BUYVOWEL:
EmptyChar
IF Players = 1 AND PMoney < 250 THEN LOCATE 2, 12: COLOR 12: PRINT "VOWEL'S COST $250": A$ = INPUT$(1): LOCATE 2, 12: PRINT STRING$(20, " "): RETURN
IF Players >= 2 AND TURN$ = "RED" AND PRM < 250 THEN LOCATE 2, 12: COLOR 12: PRINT "VOWEL'S COST $250": A$ = INPUT$(1): LOCATE 2, 12: PRINT STRING$(20, " "): RETURN
IF Players >= 2 AND TURN$ = "YELLOW" AND PYM < 250 THEN LOCATE 2, 12: COLOR 12: PRINT "VOWEL'S COST $250": A$ = INPUT$(1): LOCATE 2, 12: PRINT STRING$(20, " "): RETURN
IF Players = 3 AND TURN$ = "BLUE" AND PBM < 250 THEN LOCATE 2, 12: COLOR 12: PRINT "VOWEL'S COST $250": A$ = INPUT$(1): LOCATE 2, 12: PRINT STRING$(20, " "): RETURN
IF Players = 1 THEN PMoney = PMoney - 250
IF TURN$ = "RED" THEN PRM = PRM - 250
IF TURN$ = "YELLOW" THEN PYM = PYM - 250
IF TURN$ = "BLUE" THEN PBM = PBM - 250
LOCATE 1, 1: PRINT STRING$(20, " ")
LOCATE 1, 2: COLOR 14
  IF TURN$ = "RED" THEN COLOR 12: PRINT "$" + LTRIM$(STR$(PRM))
  IF TURN$ = "YELLOW" THEN COLOR 14: PRINT "$" + LTRIM$(STR$(PYM))
  IF TURN$ = "BLUE" THEN COLOR 11: PRINT "$" + LTRIM$(STR$(PBM))
IF Players = 1 THEN PRINT "$" + LTRIM$(STR$(PMoney))
Xbox = 251: Ybox = 165
Xbox2 = 265: Ybox2 = 177
LINE (251, 165)-(265, 177), 12, B

DO
  LetChosen$ = INKEY$
  IF LetChosen$ = CHR$(0) + "M" THEN Xbox = Xbox + 16: R = 1: GOSUB VRight
  IF LetChosen$ = CHR$(0) + "K" THEN Xbox = Xbox - 16: R = 0: GOSUB VRight
  IF LetChosen$ = CHR$(0) + "P" THEN Ybox = Ybox + 16: R = 2: GOSUB VRight
  IF LetChosen$ = CHR$(0) + "H" THEN Ybox = Ybox - 16: R = 3: GOSUB VRight
  IF LetChosen$ = CHR$(13) THEN GOSUB SELVOWEL: RETURN
LOOP

VRight:
  IF Ybox = 149 THEN Ybox = Ybox + 16: RETURN
  IF Ybox = 197 THEN Ybox = Ybox - 16: RETURN
  IF Xbox = 283 AND Ybox = 181 AND R = 2 THEN Ybox = Ybox - 16: RETURN
  IF Xbox = 283 AND Ybox = 181 THEN Xbox = Xbox - 16: RETURN
  IF Xbox = 299 THEN Xbox = Xbox - 16: RETURN
  IF Xbox = 235 THEN Xbox = Xbox + 16: RETURN
  IF R = 1 THEN LINE (Xbox - 16, Ybox)-(Xbox - 2, Ybox + 12), 0, B
  IF R = 0 THEN LINE (Xbox + 16, Ybox)-(Xbox + 30, Ybox + 12), 0, B
  IF R = 2 THEN LINE (Xbox, Ybox - 16)-(Xbox + 14, Ybox - 4), 0, B
  IF R = 3 THEN LINE (Xbox, Ybox + 16)-(Xbox + 14, Ybox + 28), 0, B
  LINE (Xbox, Ybox)-(Xbox + 14, Ybox + 12), 12, B
RETURN

SELVOWEL:
COLOR 3, 0
PASS = 0
LINE (Xbox, Ybox)-(Xbox + 14, Ybox + 12), 0, B
IF Xbox = 251 AND Ybox = 165 AND Alpha(1) = 65 THEN LetChosen$ = "A": LOCATE 22, 33: PRINT "A": Alpha(1) = 1: PASS = 1
IF Xbox = 267 AND Ybox = 165 AND Alpha(5) = 69 THEN LetChosen$ = "E": LOCATE 22, 35: PRINT "E": Alpha(5) = 1: PASS = 1
IF Xbox = 283 AND Ybox = 165 AND Alpha(9) = 73 THEN LetChosen$ = "I": LOCATE 22, 37: PRINT "I": Alpha(9) = 1: PASS = 1
IF Xbox = 251 AND Ybox = 181 AND Alpha(15) = 79 THEN LetChosen$ = "O": LOCATE 24, 33: PRINT "O"; : Alpha(15) = 1: PASS = 1
IF Xbox = 267 AND Ybox = 181 AND Alpha(21) = 85 THEN LetChosen$ = "U": LOCATE 24, 35: PRINT "U"; : Alpha(21) = 1: PASS = 1
IF PASS = 0 AND Players > 1 THEN GOSUB UPDATESTATS
IF PASS = 1 THEN GOSUB LetterChose
RETURN

SELECTLETTER:
Xbox = 20: Ybox = 165
Xbox2 = 34: Ybox2 = 177
LINE (20, 165)-(34, 177), 12, B

DO
  LetChosen$ = INKEY$
  IF LetChosen$ = CHR$(0) + "M" THEN GOSUB GoRight
  IF LetChosen$ = CHR$(0) + "K" THEN GOSUB GoLeft
  IF LetChosen$ = CHR$(0) + "P" THEN GOSUB GoDown
  IF LetChosen$ = CHR$(0) + "H" THEN GOSUB GoUp
  IF LetChosen$ = CHR$(13) THEN GOSUB SELLETTER: RETURN
LOOP

GoRight:
  Clr = 0
  GOSUB SelectBox
  Xbox = Xbox + 16
  IF Xbox = 196 THEN Xbox = 20: Ybox = Ybox + 16
  IF Xbox = 20 AND Ybox = 197 THEN Ybox = 181
  Clr = 12
  GOSUB SelectBox
RETURN

GoLeft:
  Clr = 0
  GOSUB SelectBox
  Xbox = Xbox - 16
  IF Xbox = 4 THEN Xbox = 180
  IF Ybox = 181 AND Xbox = 180 THEN Ybox = 165: Xbox = 180
  Clr = 12
  GOSUB SelectBox
RETURN

GoUp:
  Clr = 0
  GOSUB SelectBox
  Ybox = Ybox - 16
  IF Ybox = 149 THEN Ybox = 181
  Clr = 12
  GOSUB SelectBox
RETURN

GoDown:
  Clr = 0
  GOSUB SelectBox
  Ybox = Ybox + 16
  IF Ybox = 197 THEN Ybox = 165
  Clr = 12
  GOSUB SelectBox
RETURN

SelectBox:
  IF Xbox = 180 AND Ybox = 181 THEN
	LINE (Xbox, Ybox)-(Xbox + 46, Ybox + 12), Clr, B
  ELSE
	LINE (Xbox, Ybox)-(Xbox + 14, Ybox + 12), Clr, B
  END IF
RETURN

SELLETTER:
  COLOR 3, 0
  PASS = 0
  IF Xbox = 20 AND Ybox = 165 AND Alpha(2) = 66 THEN LetChosen$ = "B": LOCATE 22, 4: PRINT "B": Alpha(2) = 1: PASS = 1
  IF Xbox = 36 AND Ybox = 165 AND Alpha(3) = 67 THEN LetChosen$ = "C": LOCATE 22, 6: PRINT "C": Alpha(3) = 1: PASS = 1
  IF Xbox = 52 AND Ybox = 165 AND Alpha(4) = 68 THEN LetChosen$ = "D": LOCATE 22, 8: PRINT "D": Alpha(4) = 1: PASS = 1
  IF Xbox = 68 AND Ybox = 165 AND Alpha(6) = 70 THEN LetChosen$ = "F": LOCATE 22, 10: PRINT "F": Alpha(6) = 1: PASS = 1
  IF Xbox = 84 AND Ybox = 165 AND Alpha(7) = 71 THEN LetChosen$ = "G": LOCATE 22, 12: PRINT "G": Alpha(7) = 1: PASS = 1
  IF Xbox = 100 AND Ybox = 165 AND Alpha(8) = 72 THEN LetChosen$ = "H": LOCATE 22, 14: PRINT "H": Alpha(8) = 1: PASS = 1
  IF Xbox = 116 AND Ybox = 165 AND Alpha(10) = 74 THEN LetChosen$ = "J": LOCATE 22, 16: PRINT "J": Alpha(10) = 1: PASS = 1
  IF Xbox = 132 AND Ybox = 165 AND Alpha(11) = 75 THEN LetChosen$ = "K": LOCATE 22, 18: PRINT "K": Alpha(11) = 1: PASS = 1
  IF Xbox = 148 AND Ybox = 165 AND Alpha(12) = 76 THEN LetChosen$ = "L": LOCATE 22, 20: PRINT "L": Alpha(12) = 1: PASS = 1
  IF Xbox = 164 AND Ybox = 165 AND Alpha(13) = 77 THEN LetChosen$ = "M": LOCATE 22, 22: PRINT "M": Alpha(13) = 1: PASS = 1
  IF Xbox = 180 AND Ybox = 165 AND Alpha(14) = 78 THEN LetChosen$ = "N": LOCATE 22, 24: PRINT "N": Alpha(14) = 1: PASS = 1
  IF Xbox = 20 AND Ybox = 181 AND Alpha(16) = 80 THEN LetChosen$ = "P": LOCATE 24, 4: PRINT "P"; : Alpha(16) = 1: PASS = 1
  IF Xbox = 36 AND Ybox = 181 AND Alpha(17) = 81 THEN LetChosen$ = "Q": LOCATE 24, 6: PRINT "Q"; : Alpha(17) = 1: PASS = 1
  IF Xbox = 52 AND Ybox = 181 AND Alpha(18) = 82 THEN LetChosen$ = "R": LOCATE 24, 8: PRINT "R"; : Alpha(18) = 1: PASS = 1
  IF Xbox = 68 AND Ybox = 181 AND Alpha(19) = 83 THEN LetChosen$ = "S": LOCATE 24, 10: PRINT "S"; : Alpha(19) = 1: PASS = 1
  IF Xbox = 84 AND Ybox = 181 AND Alpha(20) = 84 THEN LetChosen$ = "T": LOCATE 24, 12: PRINT "T"; : Alpha(20) = 1: PASS = 1
  IF Xbox = 100 AND Ybox = 181 AND Alpha(22) = 86 THEN LetChosen$ = "V": LOCATE 24, 14: PRINT "V"; : Alpha(22) = 1: PASS = 1
  IF Xbox = 116 AND Ybox = 181 AND Alpha(23) = 87 THEN LetChosen$ = "W": LOCATE 24, 16: PRINT "W"; : Alpha(23) = 1: PASS = 1
  IF Xbox = 132 AND Ybox = 181 AND Alpha(24) = 88 THEN LetChosen$ = "X": LOCATE 24, 18: PRINT "X"; : Alpha(24) = 1: PASS = 1
  IF Xbox = 148 AND Ybox = 181 AND Alpha(25) = 89 THEN LetChosen$ = "Y": LOCATE 24, 20: PRINT "Y"; : Alpha(25) = 1: PASS = 1
  IF Xbox = 164 AND Ybox = 181 AND Alpha(26) = 90 THEN LetChosen$ = "Z": LOCATE 24, 22: PRINT "Z"; : Alpha(26) = 1: PASS = 1
  IF Xbox = 180 AND Ybox = 181 THEN GOTO ALLBEGIN
  Clr = 0
  IF Xbox = 180 AND Ybox = 181 THEN
	LINE (Xbox, Ybox)-(Xbox + 46, Ybox + 12), Clr, B
  ELSE
	LINE (Xbox, Ybox)-(Xbox + 14, Ybox + 12), Clr, B
  END IF
  FOR I = 65 TO 90
	IF UCASE$(LetChosen$) = CHR$(I) THEN
	 JK = 1: EXIT FOR
	ELSE
	 JK = 0
	END IF
  NEXT I
  IF PASS = 0 AND Players > 1 THEN GOSUB UPDATESTATS
  IF PASS = 1 THEN GOSUB LetterChose
RETURN

LetterChose:
IF LetChosen$ = " " THEN RETURN
Index = 0: Xcor = 17: Ycor = 30: I = 1
NumFound = 0

DO
  Index = Index + 1
  IF Puzzles$(Index) <> "EMPTY" THEN
	Start = 1: I = 1
	LengthLine = LEN(Puzzles$(Index))
	DO
	 LetPuzz$(I) = MID$(Puzzles$(Index), Start, 1)
	 IF LetPuzz$(I) = UCASE$(LetChosen$) THEN
	   PAINT (Xcor, Ycor), 14, 10
	   PALETTE 8, 0
	   CALL SideWrite(UCASE$(LetChosen$), Xcor - 12, Ycor - 1, 0, 11)
	   LOCATE 1, 1: PRINT " ": PALETTE 8, 8
	   NumFound = NumFound + 1
	 END IF
	 Xcor = Xcor + 22
	 I = I + 1: Start = Start + 1
	LOOP UNTIL I > LengthLine
  END IF
  Xcor = 17
  Ycor = Ycor + 23
LOOP UNTIL Index = 6
IF BL = 0 AND Players > 1 AND Solving = 0 AND NumFound = 0 THEN GOSUB UPDATESTATS
RETURN

UPDATESTATS:
LOCATE 1, 1: PRINT SPACE$(20)
PCOPY 0, 1
PCOPY 2, 0
IF Players > 1 THEN
  LOCATE 13, 3: COLOR 15
  EXSP = 6 - LEN(STR$(PRM))
  PRINT "$" + LTRIM$(STR$(PRM)) + SPACE$(EXSP)
  EXSP = 6 - LEN(STR$(PYM))
  LOCATE 13, 18: PRINT "$" + LTRIM$(STR$(PYM)) + SPACE$(EXSP)
END IF
EXSP = 6 - LEN(STR$(PBM))
IF Players = 3 THEN LOCATE 13, 33: PRINT "$" + LTRIM$(STR$(PBM)) + SPACE$(EXSP)
EXC = 0
IF Players > 1 AND EXC = 0 AND TURN$ = "RED" THEN TURN$ = "YELLOW": EXC = 1
IF Players = 2 AND EXC = 0 AND TURN$ = "YELLOW" THEN TURN$ = "RED": EXC = 1
IF Players = 3 AND EXC = 0 AND TURN$ = "YELLOW" THEN TURN$ = "BLUE": EXC = 1
IF Players = 3 AND EXC = 0 AND TURN$ = "BLUE" THEN TURN$ = "RED"
PCOPY 0, 2
DEL = 0
IF TURN$ = "RED" THEN
  DO
	LINE (11, 92)-(75, 106), 14, B
	Pause (1): DEL = DEL + 1
	LINE (11, 92)-(75, 106), 12, B
	Pause (1): DEL = DEL + 1
  LOOP UNTIL DEL >= 100 OR INKEY$ <> ""
END IF
IF TURN$ = "YELLOW" THEN
  DO
	LINE (131, 92)-(195, 106), 14, B
	Pause (1): DEL = DEL + 1
	LINE (131, 92)-(195, 106), 12, B
	Pause (1): DEL = DEL + 1
  LOOP UNTIL DEL >= 100 OR INKEY$ <> ""
END IF
IF TURN$ = "BLUE" THEN
  DO
	LINE (251, 92)-(315, 106), 14, B
	Pause (1): DEL = DEL + 1
	LINE (251, 92)-(315, 106), 12, B
	Pause (1): DEL = DEL + 1
  LOOP UNTIL DEL >= 100 OR INKEY$ <> ""
END IF
PCOPY 1, 0
LOCATE 1, 2
  IF TURN$ = "RED" THEN COLOR 12: PRINT "$" + LTRIM$(STR$(PRM))
  IF TURN$ = "YELLOW" THEN COLOR 14: PRINT "$" + LTRIM$(STR$(PYM))
  IF TURN$ = "BLUE" THEN COLOR 11: PRINT "$" + LTRIM$(STR$(PBM))
RETURN

Solve:
LOCATE 22, 1: PRINT STRING$(40, " ")
LOCATE 24, 1: PRINT STRING$(40, " ");
I = 0: SolvePuz$(1) = "": SolvePuz$(2) = ""
Answer$(1) = "": Answer$(2) = ""
LOCATE 22, 1: COLOR 14: PRINT "SOLVE: "
L = 22: Y = 0
W = 8: COLOR 10
WD = 1
FOR BACK = 1 TO 6
  BackUp$(BACK) = Puzzles$(BACK)
NEXT BACK
DO
  I = I + 1
  A = 0
  IF I = 4 THEN L = L + 1: W = 8
  IF Puzzles$(I) <> "EMPTY" THEN
	IF I >= 4 THEN WD = 2
	A = INSTR(1, Puzzles$(I), "?")
	IF A > 1 THEN Puzzles$(I) = RTRIM$(LEFT$(Puzzles$(I), A - 1))
	IF A = 1 THEN Puzzles$(I) = RTRIM$(MID$(Puzzles$(I), A + 1, 14))
	Buf$ = LTRIM$(Puzzles$(I))
	SolvePuz$(WD) = SolvePuz$(WD) + RTRIM$(LTRIM$(Puzzles$(I))) + " "
	P = LEN(Buf$)
	FOR U = 1 TO P
	 LOCATE L, W: PRINT "-";
	 IF MID$(Buf$, U, 1) = " " THEN LOCATE L, W: PRINT " ";
	 IF MID$(Buf$, U, 1) = "'" THEN LOCATE L, W: PRINT "'";
	 IF MID$(Buf$, U, 1) = "-" THEN LOCATE L, W: PRINT CHR$(250)
	 IF MID$(Buf$, U, 1) = "&" THEN LOCATE L, W: PRINT "&";
	 W = W + 1
	NEXT U
	W = W + 1
	IF W <= 40 THEN LOCATE L, W: PRINT " ";
  END IF
LOOP UNTIL I = 6
SolvePuz$(1) = RTRIM$(SolvePuz$(1))
IF WD = 2 THEN SolvePuz$(2) = RTRIM$(SolvePuz$(2))
IF WD = 1 THEN Answer$(2) = "": SolvePuz$(2) = ""
LOCATE 22, 8: COLOR 13: LINE INPUT Answer$(1)
IF WD = 2 THEN LOCATE 23, 8: COLOR 13: LINE INPUT Answer$(2)
  FOR BACK = 1 TO 6
	Puzzles$(BACK) = BackUp$(BACK)
  NEXT BACK
IF UCASE$(RTRIM$(Answer$(1))) + UCASE$(RTRIM$(Answer$(2))) = SolvePuz$(1) + SolvePuz$(2) OR BL = 1 THEN
  IF TURN$ = "RED" AND PRM < 200 THEN PRM = 200
  IF TURN$ = "YELLOW" AND PYM < 200 THEN PYM = 200
  IF TURN$ = "BLUE" AND PBM < 200 THEN PBM = 200
  FOR X = 65 TO 90
	IF Alpha(X - 64) <> 1 THEN Solving = 1: LetChosen$ = CHR$(X): GOSUB LetterChose
  NEXT X
  IF J = 6 THEN
	LOCATE 22, 1: PRINT SPACE$(40)
	LOCATE 23, 1: PRINT SPACE$(40)
	LOCATE 22, 1: COLOR 14: PRINT "CLUE IS: "; : COLOR 13
	LINE INPUT ClueAnswer$
	IF UCASE$(ClueAnswer$) = ClueWord$ THEN
	 LOCATE 23, 10: COLOR 12: PRINT "YOU GOT IT!"
	 IF TURN$ = "RED" THEN PRM = PRM + 1000
	 IF TURN$ = "YELLOW" THEN PYM = PYM + 1000
	 IF TURN$ = "BLUE" THEN PBM = PBM + 1000
	ELSE
	 LOCATE 23, 5: COLOR 10: PRINT "NOPE, THE CLUE IS "; ClueWord$
	END IF
  END IF
  IF Players = 1 THEN
  LOCATE 2, 1: COLOR 15: PRINT "Play Another Round [Y/N]? ";
  DO
	A$ = INPUT$(1)
  LOOP UNTIL UCASE$(A$) = "Y" OR UCASE$(A$) = "N"
  COLOR 10: PRINT A$
  IF UCASE$(A$) = "Y" THEN GOTO StartGame
  IF UCASE$(A$) = "N" THEN GOTO ALLBEGIN
  END IF
  IF Players > 1 AND BL = 0 THEN
	IF TURN$ = "RED" THEN HIPRM& = HIPRM& + PRM
	IF TURN$ = "YELLOW" THEN HIPYM& = HIPYM& + PYM
	IF TURN$ = "BLUE" THEN HIPBM& = HIPBM& + PBM
	Round = Round + 1
	IF Round < 6 THEN LOCATE 2, 1: COLOR 15: PRINT "Play Round"; Round; "[Y/N]? ";
	IF Round = 6 THEN LOCATE 2, 1: COLOR 15: PRINT "Play Round Last Round [Y/N]? ";
	IF Round = 7 THEN A$ = INPUT$(1): PCOPY 2, 0: GOTO PlayerStartsHere
  DO
	A$ = INPUT$(1)
  LOOP UNTIL UCASE$(A$) = "Y" OR UCASE$(A$) = "N"
  COLOR 10: PRINT A$
  IF UCASE$(A$) = "Y" THEN PCOPY 2, 0: GOTO PlayerStartsHere
  IF UCASE$(A$) = "N" THEN GOTO ALLBEGIN
  END IF
END IF
  IF BL = 1 THEN
	LOCATE 22, 1: PRINT SPACE$(40)
	LOCATE 24, 1: PRINT SPACE$(40);
	LOCATE 23, 2: COLOR 15: PRINT "ANOTHER GAME [Y/N]? ";
  DO
	A$ = INPUT$(1)
  LOOP UNTIL UCASE$(A$) = "Y" OR UCASE$(A$) = "N"
  COLOR 10: PRINT A$
  IF UCASE$(A$) = "Y" THEN GOTO ALLBEGIN
  IF UCASE$(A$) = "N" THEN GOTO ENDGAME
  END IF
PCOPY 1, 0
IF Players > 1 THEN GOSUB UPDATESTATS
GOTO MAIN

BONUSLAND:
LOCATE 22, 1: PRINT SPACE$(40)
LOCATE 24, 1: PRINT SPACE$(40);
PALETTE 8, 0
CALL SideWrite("BONUS LAND", 115, 2, 12, 11)
LOCATE 1, 1: PRINT " "
PALETTE 8, 8
LOCATE 1, 2: COLOR 10: PRINT "6 Consonants"
LOCATE 2, 2: PRINT "2 Vowels"
Constants$ = "BCDFGHJKLMNPQRSTVWXYZ"
FOR T = 1 TO 6
  Cons$(T) = ""
  Vows$(T) = ""
NEXT T
C = 7
LOCATE 22, 1: COLOR 15: PRINT "Select 6 Consonants: "; : COLOR 12
DO
A$ = INPUT$(1)
FOR R = 1 TO 21
  FOR T = 1 TO 6
	IF UCASE$(A$) = Cons$(T) THEN EXIT FOR
  NEXT T
  IF UCASE$(A$) = Cons$(T) THEN EXIT FOR
  IF UCASE$(A$) = MID$(Constants$, R, 1) THEN C = C - 1: PRINT A$; " "; : Cons$(C) = UCASE$(A$): Alpha(ASC(Cons$(C)) - 64) = 1
NEXT R
LOOP UNTIL C = 1

Vowels$ = "AEIOU"
V = 3
LOCATE 24, 5: COLOR 15: PRINT "Select 2 Vowels: "; : COLOR 12
DO
A$ = INPUT$(1)
FOR R = 1 TO 21
  FOR T = 1 TO 2
	IF UCASE$(A$) = Vows$(T) THEN EXIT FOR
  NEXT T
  IF UCASE$(A$) = Vows$(T) THEN EXIT FOR
  IF UCASE$(A$) = MID$(Vowels$, R, 1) THEN V = V - 1: PRINT A$; " "; : Vows$(V) = UCASE$(A$): Alpha(ASC(Vows$(V)) - 64) = 1
NEXT R
LOOP UNTIL V = 1
FOR T = 1 TO 6
  LetChosen$ = Cons$(T): GOSUB LetterChose
NEXT T
FOR T = 1 TO 2
  LetChosen$ = Vows$(T): GOSUB LetterChose
NEXT T
GOTO Solve

VERIFY:
PCOPY 0, 1
LOCATE 1, 1: COLOR 15: PRINT "QUIT GAME [Y/N]? ";
  DO
	A$ = INPUT$(1)
  LOOP UNTIL UCASE$(A$) = "Y" OR UCASE$(A$) = "N"
  COLOR 10: PRINT A$
  IF UCASE$(A$) = "Y" THEN GOTO ALLBEGIN
  IF UCASE$(A$) = "N" THEN PCOPY 1, 0: RETURN

SPINWHEEL:

IF SPW = 0 THEN
DrawWheel
SPW = 1
WheelX = 1: WheelN = 1
ELSE
PCOPY 3, 0
END IF

LOCATE 14, 1: COLOR 10: PRINT CHR$(16)

LOCATE 1, 1: PRINT SPACE$(40)
LOCATE 1, 1: COLOR 15: PRINT "SPIN POWER: "; : COLOR 12: PRINT ""
I = 23: M = 0
EmptyChar
DO
  IF I < 40 AND M = 1 THEN I = I + 1: LOCATE 1, I: PRINT ""
  IF I = 40 THEN M = 0
  Pause (1)
  IF I > 12 AND M = 0 THEN I = I - 1: LOCATE 1, I: PRINT "  "
  IF I = 12 THEN M = 1
LOOP UNTIL INKEY$ <> ""
M = I - 5
WheelY = 1

PCOPY 0, 4

SCREEN 7, 0, 0, 4

DO
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (160, 60), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (140, 60), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (120, 70), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (100, 70), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (80, 90), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (80, 105), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (90, 120), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (90, 130), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (110, 140), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (140, 145), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (170, 145), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (210, 145), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (245, 130), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (270, 110), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (290, 95), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (280, 80), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (250, 60), WheelX, 15
WheelX = WheelX - 1
IF WheelX = 0 THEN WheelX = 14
PAINT (220, 50), WheelX, 15
WheelX = WheelN
WheelY = WheelY + 1
WheelN = WheelN + 1
IF WheelN = 16 THEN WheelN = 1
WhatColor
PCOPY 0, 4
LOOP UNTIL WheelY = M
SCREEN 7, 0, 0, 0
PCOPY 0, 3

MONEY = POINT(80, 105)
EmptyChar
LOCATE 25, 18: COLOR 10
IF MONEY = 1 THEN Cash = 400
IF MONEY = 2 THEN Cash = 200
IF MONEY = 3 THEN Cash = 500
IF MONEY = 4 THEN Cash = 750
IF MONEY = 5 THEN Cash = 150
IF MONEY = 6 THEN Cash = 600
IF MONEY = 7 THEN Cash = 5000
IF MONEY = 8 THEN
  SLEEP 5: EmptyChar
  IF Players = 1 THEN PMoney = 0
  IF TURN$ = "RED" THEN PRM = 0
  IF TURN$ = "YELLOW" THEN PYM = 0
  IF TURN$ = "BLUE" THEN PBM = 0
  PCOPY 1, 0
  IF Players > 1 THEN GOSUB UPDATESTATS
  LOCATE 1, 1: PRINT STRING$(20, " ")
  LOCATE 1, 2: COLOR 14
  IF TURN$ = "RED" THEN COLOR 12: PRINT "$" + LTRIM$(STR$(PRM))
  IF TURN$ = "YELLOW" THEN COLOR 14: PRINT "$" + LTRIM$(STR$(PYM))
  IF TURN$ = "BLUE" THEN COLOR 11: PRINT "$" + LTRIM$(STR$(PBM))
  IF Players = 1 THEN PRINT "$" + LTRIM$(STR$(PMoney))
  RETURN
END IF
IF MONEY = 9 THEN Cash = 2500
IF MONEY = 10 THEN Cash = 800
IF MONEY = 11 THEN Cash = 1000
IF MONEY = 12 THEN Cash = 3500
IF MONEY = 13 THEN Cash = 450
IF MONEY = 14 THEN
  SLEEP 5: EmptyChar
  PCOPY 1, 0
  IF Players > 1 THEN GOSUB UPDATESTATS
  RETURN
END IF
SLEEP 5
EmptyChar
PCOPY 1, 0
CenterPrint 1, "$" + LTRIM$(STR$(Cash))
GOSUB SELECTLETTER
LOCATE 1, 15: PRINT SPACE$(12)
IF Players = 1 THEN PMoney = PMoney + (Cash * NumFound)
IF TURN$ = "RED" THEN PRM = PRM + (Cash * NumFound)
IF TURN$ = "YELLOW" THEN PYM = PYM + (Cash * NumFound)
IF TURN$ = "BLUE" THEN PBM = PBM + (Cash * NumFound)
LOCATE 1, 2: COLOR 14
  IF TURN$ = "RED" THEN COLOR 12: PRINT "$" + LTRIM$(STR$(PRM))
  IF TURN$ = "YELLOW" THEN COLOR 14: PRINT "$" + LTRIM$(STR$(PYM))
  IF TURN$ = "BLUE" THEN COLOR 11: PRINT "$" + LTRIM$(STR$(PBM))
IF Players = 1 THEN PRINT "$" + LTRIM$(STR$(PMoney))
RETURN

ENDGAME:
COLOR 7, 0: CLS : SCREEN 0, 0, , 0: WIDTH 80, 25

REM $STATIC
SUB CenterPrint (Col, PrnText$)

  Row = 20 - (LEN(PrnText$) / 2) + 1
  LOCATE Col, Row: PRINT PrnText$;

END SUB

SUB ColorPrint (TEXT$, Row%, Col%, FC%, BC%)
  'Thanks to who ever posted this code I can't remember your name
  'but it works great so insert your name here _____________
  DIM inreg AS RegTypeX, outreg AS RegTypeX
  C$ = STRING$(LEN(TEXT$), 219)       ' String of solid chars
' for backgrnd
  inreg.ax = &H1300             ' Video service 13h, subfunction
' 0
  inreg.bx = BC%                ' Background colour
  inreg.cx = LEN(TEXT$)         ' String length
  inreg.dx = 256 * (Row% - 1) + (Col% - 1)      ' Text pos. in
' "origin 0"
  inreg.es = VARSEG(C$)           ' String's segment
  inreg.bp = SADD(C$)           ' String's address
  CALL INTERRUPTX(&H10, inreg, outreg)     ' Output the
' background
  inreg.bx = (FC% XOR BC%) + &H80   ' BL=ForeColor; BH=&H80 uses
' XOR to draw
  inreg.es = VARSEG(TEXT$)
  inreg.bp = SADD(TEXT$)
  CALL INTERRUPTX(&H10, inreg, outreg) ' Output the text, XORing
' w/backgrnd

END SUB

SUB DrawBoard
Xcor = 6: Xcor2 = 26
Ycor = 25: Ycor2 = 45
LINE (1, 22)-(317, 163), 7, BF

DO
  DO
	LINE (Xcor, Ycor)-(Xcor2, Ycor2), 2, BF
	LINE (Xcor, Ycor)-(Xcor2, Ycor2), 10, B
	Xcor = Xcor + 22: Xcor2 = Xcor + 20
  LOOP UNTIL Xcor >= 300
  Ycor = Ycor + 23: Ycor2 = Ycor + 20
  Xcor = 6: Xcor2 = 26
LOOP UNTIL Ycor >= 150

LOCATE 22, 4: COLOR 11: PRINT "B C D F G H J K L M N        A E I"
LOCATE 24, 4: PRINT "P Q R S T V W X Y Z QUIT!    O U";
END SUB

DEFSNG A-Z
SUB DrawWheel
CLS

PALETTE 15, 0
CIRCLE (160, 100), 150, 15, , , 1 / 2
CIRCLE (160, 100), 20, 15, , , 1 / 2

FOR X = -6.2 TO 1 STEP .35
  CIRCLE (160, 100), 150, 15, X, , 1 / 2
NEXT X

DEFINT A-Z

PAINT (160, 60), 1, 15
PAINT (140, 60), 2, 15
PAINT (120, 70), 3, 15
PAINT (100, 70), 4, 15
PAINT (80, 90), 5, 15
PAINT (80, 105), 6, 15
PAINT (90, 120), 7, 15
PAINT (90, 130), 8, 15
PAINT (110, 140), 9, 15
PAINT (140, 145), 10, 15
PAINT (170, 145), 11, 15
PAINT (210, 145), 12, 15
PAINT (245, 130), 13, 15
PAINT (270, 110), 14, 15
PAINT (290, 95), 1, 15
PAINT (280, 80), 2, 15
PAINT (250, 60), 3, 15
PAINT (220, 50), 4, 15

CIRCLE (160, 100), 20, 14, , , 1 / 2
PAINT (160, 100), 15, 14
CIRCLE (160, 100), 20, 15, , , 1 / 2
CIRCLE (160, 100), 10, 0, , , 1 / 2
PAINT (160, 100), 0
PALETTE 15, 15

END SUB

SUB EmptyChar
DO
  K$ = INKEY$
LOOP UNTIL K$ = ""

END SUB

SUB Pause (ticks%)
	DEF SEG = 0
	DO UNTIL TestTick% > ticks%
	   LastTick% = GetTick%
	   GetTick% = PEEK(&H46C)
		IF LastTick% <> GetTick% THEN
		 TestTick% = TestTick% + 1
		END IF
	LOOP
	DEF SEG
END SUB

SUB SideWrite (Mot$, PosX, PosY, Couleur, Opt) STATIC
FOR Nombre = 1 TO LEN(Mot$)
	LOCATE 1, 1: COLOR 8
	PRINT MID$(Mot$, Nombre, 1)        'print word's letters one by one
	FOR X = 0 TO 7
	 FOR Y = 0 TO 7                   'use 0 TO 13 for EGA
	   IF POINT(X, Y) THEN            'read pixel on/off for sideways copy
		 IF Opt = 1 THEN
			PSET (Y + PosX, 8 - X + PosY - (8 * Nombre)), Couleur
		 ELSEIF Opt = 2 THEN
			PSET (Y + PosX, 8 - X + PosY - (8 * Nombre) + Y), Couleur
		 ELSEIF Opt = 3 THEN
			PSET (X + PosX, PosY + (8 * Nombre) + Y), Couleur
		 ELSEIF Opt = 4 THEN
			PSET (8 - Y + PosX, PosY + (8 * Nombre) + X), Couleur
		 ELSEIF Opt = 5 THEN
			PSET (8 - Y + PosX, PosY + (8 * Nombre) + X - Y), Couleur
		 ELSEIF Opt = 6 THEN
			PSET (Y + PosX + Y, 8 - X + PosY - (8 * Nombre)), Couleur
			PSET (1 + Y + PosX + Y, 8 - X + PosY - (8 * Nombre)), Couleur
		 ELSEIF Opt = 7 THEN
			PSET (Y + PosX + Y, 8 - X + PosY - (8 * Nombre) + Y), Couleur
			PSET (1 + Y + PosX + Y, 8 - X + PosY - (8 * Nombre) + Y), Couleur
		ELSEIF Opt = 8 THEN
			PSET (X + PosX + X, PosY + (8 * Nombre) + Y), Couleur
			PSET (1 + X + PosX + X, PosY + (8 * Nombre) + Y), Couleur
		 ELSEIF Opt = 9 THEN
			PSET (X + PosX + (Nombre * 8), PosY + Y), Couleur
		 ELSEIF Opt = 10 THEN
			PSET (X + PosX + (Nombre * 8) - Y, PosY + Y), Couleur
		 ELSEIF Opt = 11 THEN
			PSET (X + PosX + (Nombre * 8), PosY + Y + Y), Couleur
			PSET (X + PosX + (Nombre * 8), 1 + PosY + Y + Y), Couleur
		 ELSEIF Opt = 12 THEN
			PSET (X + PosX + (Nombre * 8) - Y, PosY + Y + Y), Couleur
			PSET (X + PosX + (Nombre * 8) - Y, 1 + PosY + Y + Y), Couleur
		 END IF
	   END IF
	 NEXT Y
	NEXT X
NEXT Nombre
END SUB

SUB WhatColor

MONEY = POINT(80, 105)
LOCATE 25, 10: COLOR 10: PRINT SPACE$(21);
IF MONEY = 1 THEN CenterPrint 25, "$400"
IF MONEY = 2 THEN CenterPrint 25, "$200"
IF MONEY = 3 THEN CenterPrint 25, "$500"
IF MONEY = 4 THEN CenterPrint 25, "$750"
IF MONEY = 5 THEN CenterPrint 25, "$150"
IF MONEY = 6 THEN CenterPrint 25, "$600"
IF MONEY = 7 THEN CenterPrint 25, "$5000"
IF MONEY = 8 THEN CenterPrint 25, "BANKRUPT"
IF MONEY = 9 THEN CenterPrint 25, "$2500"
IF MONEY = 10 THEN CenterPrint 25, "$800"
IF MONEY = 11 THEN CenterPrint 25, "$1000"
IF MONEY = 12 THEN CenterPrint 25, "$3500"
IF MONEY = 13 THEN CenterPrint 25, "$450"
IF MONEY = 14 THEN CenterPrint 25, "LOSE A TURN"

END SUB

