{$G+ }

{ Clak-A-Void v.0.7b             Source Distribution
(c) 1995 Jari Savander , Henri Block, Timo Pihlaja and Tero makela.
-------------------------------------------------------------------------}
unit status;

{---------------------------------------------------------------------------}
interface
{---------------------------------------------------------------------------}

const
_datanpaikka: array [1..7] of longint =
(0,14050,28100,42150,60319,77078,117918);
_c_red = 16;
_c_green = 31;
_c_yellow = 192;

type vohjustype = array [0..7] of integer;

procedure statusbar(pisteet,energia,shield,lasertype,level:integer;
tutka:boolean;ohjukset:vohjustype;where:word);

procedure b_fix(where:word);
procedure initstatus;
procedure freestatus;
procedure loadPCX(num:integer;where:word);


{---------------------------------------------------------------------------}
implementation
{---------------------------------------------------------------------------}

const

_palkkix = 120;
_palkkiy = 200;
_digitx  = 8;
_digity  = 13;
_digitp  = 21; { ?? }
_typex   = 16;
_typey   = 14;
_typep   = 41; { ?? }
_type1p  = 234; { ?? }
_type2p  = 287; { ?? }
_ohjusx  = 18;
_ohjusy  = 6;
_ohjusp  = 285; { ?? }

{$i d0.inc }
{$i d1.inc }
{$i d2.inc }
{$i d3.inc }
{$i d4.inc }
{$i d5.inc }
{$i d6.inc }
{$i d7.inc }
{$i d8.inc }
{$i d9.inc }
{$i m1.inc}
{$i m2.inc}
{$i m3.inc}
{$i m4.inc}
{$i m5.inc}
{$i lt1.inc}
{$i lt3.inc}
{$i lvi1.inc}
{$i lvi2.inc}
{$i lvi3.inc}
{$i lvi4.inc}
{$i lvi5.inc}

var
_statbackp:pointer;
_statback:word;
_statfrontp:pointer;
_statfront:word;

_digit:array [0..9] of pointer;
_ohjus:array [1..5] of pointer;


{same as cbitmap on gamevga but does not chk for transparency..}
procedure cbitmapn(x,y,xs,ys,fk:integer;Sprite:pointer;where:word); assembler;
asm
  push ds; lds si,[sprite]; mov es,[where]; xor di,di; mov ax,[y];
  shl ax,6; mov di,ax; shl ax,2; add di,ax; add di,[x]; mov dx,(fk);
  mov bx,ys; @l1: mov cx,xs; @l0: lodsb; or al,al; jz @skip;
  mov [es:di],al; @skip: inc di; dec cx; jnz @l0; add di,dx; dec bx;
  jnz @l1; pop ds;
end;


procedure putdigit(x:integer;Sprite:pointer;where:word);
begin
  cbitmapn(x,_digitp,_digitx,_digity,320-_digitx,sprite,where);
end;

procedure puttype(x:integer;Sprite:pointer;where:word);
begin
  cbitmapn(x,_typep,_typex,_typey,320-_typex,sprite,where);
end;

procedure putohjus(y:integer;Sprite:pointer;where:word);
begin
  cbitmapn(_ohjusp,y,_ohjusx,_ohjusy,320-_ohjusx,sprite,where);
end;

procedure viiva(xa,xb,y:integer; from,where:word); assembler;
{will do a 'scanline' copying its colors from other screen}
asm
  push ds;mov bx,[xa]; cmp bx,0; jz @out; mov cx,[xb]; jcxz @out; cmp bx,cx;
  jb @skip; xchg bx,cx; @skip: dec bx; inc cx; sub cx,bx;
  mov ax,[y]; shl ax,6; mov di,ax; shl ax,2; add di,ax; add di,bx;
  @l1:
  mov es,[from]; mov al,[es:di]; mov es,[where]; stosb;
  loop @l1;
  @out: pop ds;
end;

procedure markscore(score:integer;digit:byte;where:word);
var pist,nextit:integer;
begin
pist := score mod 10;
putdigit(287 - 8 * digit,_digit[pist],where);
nextit := score div 10;
if (nextit > 0 ) then markscore(nextit,digit+1,where);
end;

{----------------------------------------------------------------------------}

procedure LoadPCX (num:integer; where:word);
{loads PCX , dont take colors}
VAR f:file;

    res:word;
    temp:pointer;
    i: integer;

BEGIN
    assign (f,'cav.dta');
    reset (f,1);
    seek (f,_datanpaikka[num]+128);
  getmem (temp,65535);
  blockread (f,temp^,65535,res);
  asm
    push ds
    mov  ax,[where]
    mov  es,ax
    xor  di,di
    xor  ch,ch
    lds  si,temp
@Loop1 :
    lodsb
    mov  bl,al
    and  bl,$c0
    cmp  bl,$c0
    jne  @Single

    mov  cl,al
    and  cl,$3f
    lodsb
    rep  stosb
    jmp  @Fin
@Single :
    stosb
@Fin :
    cmp  di,63999
    jbe  @Loop1
    pop  ds
  end;
  freemem (temp,65535);
  close (f);
END;


{----------------------------------------------------------------------------}

procedure initstatus;
var i:integer;
begin
getmem(_statbackp,64000);
_statback := seg(_statbackp^);
getmem(_statfrontp,64000);
_statfront := seg(_statfrontp^);

loadPCX(4,_statfront);
loadPCX(5,_statback);

_digit[0] := addr(_digit0);
_digit[1] := addr(_digit1);
_digit[2] := addr(_digit2);
_digit[3] := addr(_digit3);
_digit[4] := addr(_digit4);
_digit[5] := addr(_digit5);
_digit[6] := addr(_digit6);
_digit[7] := addr(_digit7);
_digit[8] := addr(_digit8);
_digit[9] := addr(_digit9);

_ohjus[1] := addr(_msl1);
_ohjus[2] := addr(_msl2);
_ohjus[3] := addr(_msl3);
_ohjus[4] := addr(_msl4);
_ohjus[5] := addr(_msl5);

end;

procedure freestatus;
begin
freemem(_statbackp,64000);
freemem(_statfrontp,64000);
end;

{----------------------------------------------------------------------------}



procedure b_fix(where:word);
var y:word;
begin
 for y := 0 to 199 do begin
  viiva(199,210,y,_statfront,where);
  viiva(310,319,y,_statfront,where);
  viiva(1,1,y,_statfront,where);
 end;
 for y := 0 to 1 do viiva(1,319,y,_statfront,where);
 for y := 198 to 199 do viiva(1,319,y,_statfront,where);
end;

procedure statusbar(pisteet,energia,shield,lasertype,level:integer;
tutka:boolean;ohjukset:vohjustype;where:word);

var

x1,x2,y,dy:word;
pistet,lasi,kilpi:integer;

begin

{palkki}
for y := 0 to 199 do viiva(201,319,y,_statfront,where);

if (tutka) then begin
 x1 := 201; x2 := 319;
 for y := 129 to 199 do viiva(x1,x2,y,_statback,where);
end;

pistet := pisteet; {div 100; ei sittenkaan hyv!}
markscore(pistet,0,where);

lasi := energia div 10; {maksimi laseri 500?}
kilpi := shield div 5; {maksimi kilpi 200?}

{LASERI}
x1 := 213; x2 := 234;
dy := 130 - (lasi+5);
for y := 75 to dy do viiva(x1,x2,y,_statback,where);

{KILPI}
x1 := 253; x2 := 272;
dy := 110 - (kilpi +2);
for y := 68 to dy do viiva(x1,x2,y,_statback,where);

dy :=0;
for y := 0 to 7 do begin
if ohjukset[y] <> 0 then begin
  putohjus(116 - dy * 6,_ohjus[ohjukset[y]],where);
  dy := dy +1;
 end;
end;

{laserityyppi}
case lasertype of
  1 : puttype(_type1p,@_lt1,where);
  3 : puttype(_type1p,@_lt3,where);
end;
{leveli}
case level of
  1: puttype(_type2p,@_lvi1,where);
  2: puttype(_type2p,@_lvi2,where);
  3: puttype(_type2p,@_lvi3,where);
  4: puttype(_type2p,@_lvi4,where);
  5: puttype(_type2p,@_lvi5,where);
end;

end;

{-------------------------------------------------------------------------}
begin
end.

