echo off
echo.     ------------------------------------
echo.     DeuTex Functionalities demonstration
echo.     ------------------------------------
echo.
echo.  you must put trinity.wad in this directory
echo.  doom.wad should be in the \doom directory
echo.
pause
echo. Checking existence of trinity.wad
if  exist trinity.wad  goto chk1
echo Error!   trinity.wad is not in this directory.
goto end
:chk1
echo. Checking existence of DOOM.WAD
if  exist \doom\doom.wad goto chk2
if  exist \doom2\doom2.wad goto chk2
echo Error! \doom\doom.wad does not exist 
goto end
:chk2
echo. All is OK!
echo.
echo. ----------------------------------------
echo. Now listing the directory of trinity.wad
echo. ----------------------------------------
echo.
pause

rem ***DeuTex***
deutex  -wadir trinity.wad   > dir666.txt
type dir666.txt | more
del dir666.txt

echo.
echo. Now trying to extract entries of trinity.wad
echo. in the current directory
echo.
pause

rem ***DeuTex***
deutex -dir . -extract trinity.wad

echo.
echo. -----------------
echo. Look at the mess!
echo. -----------------
echo.
pause
dir /s | more
echo.
echo. ----------------------------------
echo. The file WADINFO.TXT describes the 
echo.  contents of the PWAD trinity.wad
echo. ----------------------------------
echo.
pause
type wadinfo.txt | more
echo.
echo. ------------------------------------------
echo. Now rebuilding trinity.wad as trinidad.wad
echo. ------------------------------------------
echo.
pause

rem ***DeuTex*** 
deutex -dir . -make wadinfo.txt trinidad.wad
echo.
echo. -----------------------------------------------
echo. trinidad.wad was built. successfuly? let's check!
echo. -----------------------------------------------
echo.
dir
echo.
echo. ----------------------------------
echo. now calling DOOM with trinidad.wad
echo. ----------------------------------
echo.
pause
echo copying trinidad.wad into \DOOM directory 
copy trinidad.wad \doom\trinidad.wad
cd \doom
doom -file trinidad.wad
echo.
echo. Are you satisfied?
echo. If yes, tell me: mail montanuy@dmi.ens.fr
echo. If no, tell me also!
echo. And if there was a bug, sorry!
echo.

:end
echo the end