DEFINE value
DEFINE test
DEFINE StartX
DEFINE StartY
DEFINE TargetX
DEFINE TargetY
DEFINE BasketX
DEFINE BasketY
DEFINE BasketZ
DEFINE StandardX
DEFINE StandardY
DEFINE myX
DEFINE myY
DEFINE myZ
DEFINE TempX
DEFINE TempY
DEFINE diffX
DEFINE diffY
DEFINE rnd
DEFINE speed
DEFINE frames
DEFINE distance
DEFINE cookieID
DEFINE rndnumber

// Initialization
GET_STATE STANDARDPOSITION StandardX StandardY
GET_STATE BASKETPOSITION BasketX BasketY BasketZ

SEQUENCE SWITCH BallB

SUPPRESS 0
DRAW CURRENT

// Do nothing until signalled
Waiting:
	SIGNAL GET 0 value
	IF value = 1
		// DEBUG SENTENCE 3 Ball says Shoot
		GOTO Shoot
	ENDIF

	SIGNAL GET 1 value
	IF value = 1
		// DEBUG SENTENCE 3 Ball says Pass
		GOTO PassBall
	ENDIF

	SIGNAL GET 10 value
	IF value = 1
		// DEBUG SENTENCE 3 Ball says Dunk
		GOTO Dunk
	ENDIF

	SIGNAL GET 8 value
	IF value = 1
		// DEBUG SENTENCE 5 Ball says Take Me Out
		DRAW CURRENT
		GOTO Waiting
	ENDIF
	
	SIGNAL GET 9 value // timeout
	IF value = 1
		DRAW CURRENT
		COOKIE ME cookieID
		SUPPRESS 0
		IF Z > 0
			PATH ARC
			PATH FRAMES 10
			PATH FINISH X Y 0
			value = 0
			WHILE value = 0
				WHILE FlagDone = 0
					PATH NEXT myX myY myZ
					MOVE TO myX myY myZ
					DRAW NEXT
				ENDWHILE
				BALL BOUNCE 0 value
			ENDWHILE
		ENDIF
		DRAW CURRENT
		SIGNAL CLEAR 0
		GOTO Waiting
	ENDIF
	
	SIGNAL GET 3 value
	IF value = 1
		// DEBUG SENTENCE 4 Ball says Loose Ball
		SUPPRESS 0
		COOKIE ME cookieID
		IF Z > 0
			PATH ARC
			PATH FRAMES 10
			RNDNUM -15 15 rndnumber
			X += rndnumber
			RNDNUM -15 15 rndnumber
			Y += rndnumber
			PATH FINISH X Y 0
			value = 0
			WHILE value = 0
				WHILE FlagDone = 0
					PATH NEXT myX myY myZ
					MOVE TO myX myY myZ
					DRAW NEXT
				ENDWHILE
				SIGNAL GET 3 value
				IF value = 0
					POP
					GOTO Waiting
				ENDIF
				BALL BOUNCE 0 value
			ENDWHILE
		ENDIF
		DRAW CURRENT
	ELSE
		DRAW CURRENT
	ENDIF
	
GOTO Waiting


// Shoot the ball
Shoot:
	SUPPRESS 0

	BALL SHOT
	
	COOKIE ME cookieID
	
	GET_STATE BALLPOSITION myX myY myZ
	PATH START myX myY myZ
	
	frames = 13
	DISTANCE myX myY BasketX BasketY distance
	distance /= 60
	frames += distance
	PATH FRAMES frames
	
	PATH GRAVITY 350

	PATH ARC
	PATH FINISH BasketX BasketY BasketZ

	StartX = myX
	StartY = myY

	//	need to calculate success before players move or blockers change.
	SINKIT value

	PATH NEXT myX myY myZ
	
	WHILE FlagDone = 0
		PATH NEXT myX myY myZ
		MOVE TO myX myY myZ
		DRAW NEXT
		SIGNAL GET 2 test // ball no longer in flight
		IF test = 0
			POP
			BALL BOUNCE 1 value
			IF value = 1
				GOTO Waiting
			ELSE
				GOTO MissBounceLoop
			ENDIF
		ENDIF
	ENDWHILE

	IF value = 1
		GOTO SinkIt
	ELSE
		GOTO MissShot
	ENDIF

GOTO Waiting


// Pass the ball
PassBall:
	SUPPRESS 0

	SIGNAL SET 2
	COOKIE ME cookieID

	GET_STATE BALLPOSITION myX myY myZ
	MOVE TO myX myY myZ
	
	GET_STATE PASSPOSITION TargetX TargetY myZ
	PATH ARC
	
	SIGNAL GET 15 test
	SIGNAL CLEAR 15
	IF test = 1
		DEBUG SENTENCE_VAL 3 Pass to Human frames
		GET_STATE PASSFRAMES frames
		PATH FRAMES frames
	ELSE
		DEBUG SENTENCE 3 Pass to Computer
		PATH SPEED 20
	ENDIF
	
	PATH GRAVITY 350
	PATH FINISH TargetX TargetY myZ

	// do one non-draw frame to get away from the player
	PATH NEXT myX myY myZ
	MOVE TO myX myY myZ
	
	WHILE FlagDone = 0
		PATH NEXT myX myY myZ
		MOVE TO myX myY myZ
		DRAW NEXT
		
		SIGNAL GET 2 value
		IF value = 0				// ball not inflight
			POP
			SIGNAL GET 3 value
			IF value = 0	//	receiver got it
				GOTO Waiting
			ELSE			//	missed or knocked away
				BALL BOUNCE 1 value
				IF value = 1
					GOTO Waiting
				ELSE
					GOTO MissPassLoop
				ENDIF
			ENDIF
		ENDIF
	ENDWHILE
	
	DRAW NEXT
	
	SIGNAL GET 2 value
	IF value = 0				// ball not inflight
		GOTO Waiting
	ENDIF
	
	DEBUG SENTENCE 3 BALL PASS MISSED!!!
	
	BALL LOOSE
	
	BALL BOUNCE 0 value
	
MissPassLoop:
	WHILE FlagDone = 0
		SIGNAL GET 3 value		// did someone pickit up?
		IF value = 0
			// SUPPRESS 1
			POP					// pop out of while loop
			GOTO Waiting
		ENDIF
		
		PATH NEXT myX myY myZ
		MOVE TO myX myY myZ
		
		BALL IS_IN_BOUNDS test
		IF test = 0
			SIGNAL GET 9 test	// are we in a timeout?
			IF test = 0
				SIGNAL GET 8 test // are we already taking the ball out?
				IF test = 0
					// DEBUG SENTENCE 2 PASS OUTOBOUNDS
					BALL OUTOBOUNDS	// no, so turn the ball over
				ENDIF
			ENDIF
			BOUND COURT myX myY
			MOVE TO myX myY myZ
		ENDIF
	
		DRAW NEXT
	ENDWHILE
	
	BALL BOUNCE 0 value
	
	IF value = 0
		GOTO MissPassLoop
	ENDIF

	value = 1
	WHILE value = 1
		DRAW CURRENT
		SIGNAL GET 3 value
	ENDWHILE

GOTO Waiting


// Dunk are always good.
Dunk:
	COOKIE ME cookieID
	SIGNAL CLEAR 10			// slam dunk over
	DUNKIT rndnumber		// is slams missed
	IF rndnumber = 0
		MOVE TO BasketX BasketY BasketZ
		GOTO MissShot
	ENDIF
	// fall into 'SinkIt' code...
	
// Shot is good.
SinkIt:
	SEQUENCE SWITCH BallB
	COOKIE ME cookieID
	
	// tell net to swish
	RNDNUM 0 1 rndnumber
	IF rndnumber = 0
		SIGNAL SET 12				// swish
	ELSE
		SIGNAL SET 13				// fancy swish
	ENDIF

	RECORD SCORE
	BALL SCORE
	
	PATH STRAIGHT				// fall to the floor
	PATH FRAMES 10
	PATH GRAVITY 350
	PATH START BasketX BasketY BasketZ
	PATH FINISH BasketX BasketY 0		// X Y of floor under the basket

	SET_STATE TRANSITION 0
		
	PATH NEXT myX myY myZ
	MOVE TO myX myY myZ
	SUPPRESS 0
	DRAW NEXT
	
	test = 0
	
SinkBounceLoop:
	
	WHILE FlagDone = 0
		IF test = 1
			SIGNAL GET 3 value
			IF value = 0			// someone picked me up
				// SUPPRESS 1
				POP					// pop out of while loop
				GOTO Waiting
			ENDIF
		ENDIF
		
		PATH NEXT myX myY myZ
		MOVE TO myX myY myZ
		DRAW NEXT
	
	ENDWHILE
	
	SIGNAL GET 7 value // if we think a basket was just made
	IF value = 0
		GOTO Waiting
	ENDIF
	test = 1
	SIGNAL SET 3	// ball loose
	
	BALL BOUNCE 0 value
	
	IF value = 0
		GOTO SinkBounceLoop
	ENDIF

	value = 1
	WHILE value = 1
		DRAW CURRENT
		SIGNAL GET 3 value
	ENDWHILE

GOTO Waiting


// Maybe I won't.
MissShot:
	DEBUG SENTENCE 5 Missed Shot - Loose Ball
	RECORD MISSED				//for announcer

	PATH ARC					// bounce off rim
	PATH FRAMES 12
	TempX = BasketX
	RNDNUM 20 100 rnd
	TempX -= rnd
	PATH FINISH TempX BasketY 0
	
	COOKIE ME cookieID
	
	BALL LOOSE
	
	FlagDone = 0
MissBounceLoop:
	WHILE FlagDone = 0
		SIGNAL GET 3 value			// did someone pickit up?
		IF value = 0
			// SUPPRESS 1
			POP					// pop out of while loop
			GOTO Waiting
		ENDIF
	
		PATH NEXT myX myY myZ
		MOVE TO myX myY myZ
		
		BALL IS_IN_BOUNDS test
		IF test = 0
			SIGNAL GET 9 test	// are we in a timeout?
			IF test = 0
				SIGNAL GET 8 test // are we already taking the ball out?
				IF test = 0
					// DEBUG SENTENCE 2 PASS OUTOBOUNDS
					BALL OUTOBOUNDS	// no, so turn the ball over
				ENDIF
			ENDIF
			BOUND COURT myX myY
			MOVE TO myX myY myZ
		ENDIF
	
		MOVE TO myX myY myZ

		DRAW NEXT
	ENDWHILE

	BALL BOUNCE 0 value
	
	IF value = 0
		GOTO MissBounceLoop
	ENDIF

	// value = 1
	// WHILE value = 1
	// 	DRAW CURRENT
	// 	SIGNAL GET 3 value
	// ENDWHILE

GOTO Waiting

END SCRIPT	// Ball
