unit BSound;

{ ͵ }
{   BSound V2.2 -- WAV Playing Routines for TP/BP 7.0 (DOS)   }
{ ͵ }
{        Copyright (c) 1994,95 by Solar Designer \ BPC        }
{ ͵ }

interface
{$S-,R-,Q-,I-,N-,E-,G+}
   uses
      DOS, Objects;

   function  InitSound(S               :PStream) :Word;
      { Initialize sound parameters for the specified stream }

   procedure SetRate(Rate              :Word);

   procedure StartSound;
   procedure StopSound;
      { Start/stop playing }

   procedure PauseSound;
   procedure ContinueSound;
      { Pause/continue playing w/o changing the position }

   procedure ExecSound(const Path, CmdLine       :String);
      { This one is still a little dangerous when playing from a TDosStream }
      { I don't have time now to make it safe :( }

   const
      bsOk       = 0;
      bsInvFormat= 1;
      bsReadError= 2;

   const
      LastTimer    :Pointer= nil;
      TimerInt =   8;

      PlayingSound :Boolean= False;

      SoundBufSize :Word =   1024;

      SoundVolume  :Word =   64;
      { 0 (Off) .. 64 (Normal Max) .. 256 (More than normal) }

      SoundRepeat  :Boolean= False;

      SoundReset   :Boolean= False;
      { Set to True if playing in DOS Shell }

   type
      TSoundDevice=(sdNone, sdPCSpeaker, sdSoundBlaster, sdCovox1, sdCovox2);
   const
      SoundDevice  :TSoundDevice =     sdPCSpeaker;

   var
      EmsAvail     :Boolean;

      SoundStream  :PStream;
      SoundCheckDos,
      SoundCheckEms:Boolean;

      SoundHandle  :Word;

      SoundBuffer  :Pointer;
      SoundRead,
      SoundBufPos  :Word;

      SoundStart,
      SoundSize,
      SoundPos     :LongInt;

      TimerRate,
      TimerDiv,
      TimerIndex,
      TimerDelay   :Word;

      SoundValue   :Byte;

   var
      DosActive    :^Word;
   const
      DosActiveVal :Word =   0;

   const
      SoundFileId  :Array [1..4] of Char = 'RIFF';

   type
      TSoundHeader=
      record
         IdRIFF    :Array [1..4] of Char;
         FileSize  :LongInt;
         IdWAVEfmt :Array [1..8] of Char;
         Unknown1  :LongInt;
         Unknown2  :LongInt;
         Frequency1:LongInt;
         Frequency2:LongInt;
         Unknown3  :LongInt;
         IdData    :Array [1..4] of Char;
         DataSize  :LongInt;
      end;

   var
      SoundHeader  :TSoundHeader;

implementation

   const
      SineTable    :Array [0..$FF] of Byte=
     (1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,
      2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
      3,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  5,
      5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,
      6,  6,  6,  6,  6,  6,  6,  6,  7,  7,  7,  7,  7,  7,  7,
      7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
      8,  8,  9,  9,  9,  9,  9,  9,  9, 10, 10, 10, 10, 11, 11,
     12, 12, 13, 14, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 23,
     24, 26, 27, 28, 29, 30, 31, 33, 34, 35, 36, 38, 39, 40, 41,
     43, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 57, 58, 58,
     59, 60, 61, 62, 63, 64, 64, 65, 66, 66, 67, 67, 67, 67, 67,
     67, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 69,
     69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 70, 70, 70, 70, 70,
     70, 70, 70, 70, 70, 70, 70, 70, 71, 71, 71, 71, 71, 71, 71,
     71, 71, 71, 71, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72,
     72, 72, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 74, 74,
     74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 75, 75, 75, 75,
     75, 75);

   var
      SEmsCurHandle,
      SEmsCurPage  :Word;
      ResetInt     :Boolean;

   function  InitSound;
   begin
      StopSound; SoundStream:=nil;
      if S=nil then
      begin
         InitSound:=bsReadError; Exit;
      end;
      S^.Read(SoundHeader, SizeOf(SoundHeader));
      if LongInt(SoundHeader.IdRIFF)<>LongInt(SoundFileId)
      then InitSound:=bsInvFormat else
      begin
         SoundSize:=SoundHeader.DataSize;
         SetRate(Word(SoundHeader.Frequency1));

         SoundStart:=S^.GetPos; SoundPos:=0;

         if S^.Status=stOk then
         begin
            SoundStream:=S;

            SoundCheckDos:=
               (TypeOf(SoundStream^)=TypeOf(TBufStream)) or
               (TypeOf(SoundStream^)=TypeOf(TDosStream));

            SoundCheckEms:=
               EmsAvail and
               (TypeOf(SoundStream^)=TypeOf(TEmsStream));

            InitSound:=bsOk;
         end
         else InitSound:=bsReadError;
      end;
   end;

   procedure SetRate;
   assembler;
   asm
      cli
      mov  cx,Rate
      mov  TimerRate,cx
      cmp  cx,18
      jbe  @@Default
      mov  dx,12h
      mov  ax,34DCh
      div  cx
      mov  TimerDiv,ax

      xor  ax,ax
      cwd
      inc  dx
      div  TimerDiv
      mov  TimerDelay,ax
      jmp  @@Exit
@@Default:
      mov  TimerDiv,0
      mov  TimerDelay,1
@@Exit:
      sti
   end;

   procedure RestoreEmsMapping;
   begin
      if not SoundCheckEms then Exit;
      asm
         mov  ah,48h
         mov  dx,SoundHandle
         int  67h
      end;
      EmsCurHandle:=SEmsCurHandle; EmsCurPage:=SEmsCurPage;
   end;

   function  GetByte                   :Byte;
   begin
      if SoundBufPos>=SoundRead then
      begin
         GetByte:=$80;
         if SoundCheckDos and (DosActive^>DosActiveVal) then Exit;

         asm
            mov  al,20h
            out  20h,al
         end;
         ResetInt:=False;

         if SoundCheckEms then
         begin
            asm
               mov  ah,47h
               mov  dx,SoundHandle
               int  67h
            end;
            SEmsCurHandle:=EmsCurHandle; SEmsCurPage:=EmsCurPage;
         end;

         SoundRead:=SoundBufSize;
         if SoundRead>SoundSize-SoundPos then SoundRead:=SoundSize-SoundPos;
         SoundStream^.Read(SoundBuffer^, SoundRead);
         Inc(SoundPos, SoundRead); SoundBufPos:=0;

         if (SoundRead=0) and SoundRepeat then
         begin
            SEmsCurHandle:=$FFFF; SEmsCurPage:=$FFFF;

            SoundRead:=0; SoundPos:=0;
            SoundStream^.Reset; SoundStream^.Seek(SoundStart);
         end else
         if (SoundRead=0) or (SoundStream^.Status<>stOk) then
         begin
            RestoreEmsMapping; StopSound; Exit;
         end;

         RestoreEmsMapping;
      end;

      asm
         les  bx,SoundBuffer
         add  bx,SoundBufPos
         mov  al,es:[bx]
         mov  SoundValue,al
         inc  SoundBufPos

         leave
         retn
      end;
   end;

   procedure InitSpeaker;
   assembler;
   asm
      cmp  SoundDevice,sdPCSpeaker
      jne  @@Exit
      mov  al,0B0h
      out  43h,al
      mov  al,1
      out  42h,al
      dec  ax
      out  42h,al

      in   al,61h
      or   al,3
      out  61h,al

      mov  al,90h
      out  43h,al
@@Exit:
   end;

   procedure InitSoundBlaster;
   assembler;
   asm
      cmp  SoundDevice,sdSoundBlaster
      jne  @@Exit
      mov  dx,226h
      mov  al,1
      out  dx,al
      in   al,dx
      in   al,dx
      in   al,dx
      in   al,dx
      in   al,dx
      in   al,dx
      xor  ax,ax
      out  dx,al
      mov  dl,2Ch
      xor  cx,cx
@@Wait:
      in   al,dx
      test al,80h
      loopnz @@Wait
      mov  al,0D1h
      out  dx,al
@@Exit:
   end;

   procedure Working; assembler;
   asm end;

   procedure TimerProc;
   assembler;
   asm
      cmp  sp,200h
      jb   @@Abort

      cmp  byte ptr cs:Working,False
      je   @@Continue

@@Abort:
      push ax
      mov  al,20h
      out  20h,al
      pop  ax
      iret

@@Continue:
      not  byte ptr cs:Working

      pusha
      push ds
      push es
      push seg @DATA
      pop  ds

      mov  ResetInt,True

      cmp  PlayingSound,0
      jnz  @@Playing
      pushf
      call dword ptr LastTimer
      jmp  @@Exit

@@Playing:
      dec  TimerIndex
      jne  @@SkipReset
      mov  ax,TimerDelay
      mov  TimerIndex,ax
      pushf
      call dword ptr LastTimer

      cmp  SoundReset,0
      je   @@SkipReset
      call InitSpeaker

@@SkipReset:
      call GetByte

      cmp  SoundVolume,64
      je   @@NormalVolume
      sub  al,80h
      cbw
      imul SoundVolume

      sar  ax,6

      cmp  ax,07Fh
      jle  @@A
      mov  al,07Fh
      jmp  @@B
@@A:
      cmp  ax,-80h
      jge  @@B
      mov  al,-80h
@@B:
      add  al,80h

@@NormalVolume:
      cmp  SoundDevice,sdPCSpeaker
      jne  @@CheckSB
      mov  bx,offset SineTable
      xlat
      out  42h,al
      jmp  @@Exit

@@CheckSB:
      cmp  SoundDevice,sdSoundBlaster
      jne  @@CheckCovox
      mov  dx,22Ch
      mov  ah,al
      mov  cx,100h
@@SB1:
      in   al,dx
      test al,80h
      loopnz @@SB1
      mov  al,10h
      out  dx,al
      mov  cx,100h
@@SB2:
      in   al,dx
      test al,80h
      loopnz @@SB2
      mov  al,ah
      jmp  @@OutByte

@@CheckCovox:
      cmp  SoundDevice,sdCovox1
      jne  @@Covox2
      mov  dx,378h
      jmp  @@OutByte
@@Covox2:
      mov  dx,278h

@@OutByte:
      out  dx,al

@@Exit:
      cli

      cmp  ResetInt,False
      je   @@SkipResetInt
      mov  al,20h
      out  20h,al
@@SkipResetInt:

      pop  es
      pop  ds
      popa

      not  byte ptr cs:Working
      iret
   end;

   procedure StartSound;
   begin
      if (SoundStream=nil) or (SoundDevice=sdNone) then Exit;

      StopSound;

      if SoundBufSize>MaxAvail then Exit;

      if SoundCheckEms then
      begin
         asm
            mov  ah,43h
            mov  bx,1
            int  67h
            or   ah,ah
            jz   @@Ok
            mov  dx,-1
@@Ok:
            mov  SoundHandle,dx
         end;
         if SoundHandle=$FFFF then Exit;
      end;

      GetMem(SoundBuffer, SoundBufSize);

      SoundRead:=0;

      SoundStream^.Reset; SoundStream^.Seek(SoundStart);
      SoundPos:=0;

      GetIntVec(TimerInt, LastTimer);

      TimerIndex:=TimerDelay;

      PlayingSound:=True;
      ContinueSound;
      asm mov byte ptr cs:Working,False end;
   end;

   procedure StopSound;
   begin
      if not PlayingSound then Exit;

      PauseSound;
      PlayingSound:=False;
      if SoundBuffer<>nil then FreeMem(SoundBuffer, SoundBufSize);
      SoundBuffer:=nil;

      if SoundCheckEms then
      asm
         mov  ah,45h
         mov  bx,1
         mov  dx,SoundHandle
         int  67h
      end;
   end;

   procedure PauseSound;
   begin
      if not PlayingSound then Exit;

      asm
         mov  al,36h
         cli
         out  43h,al
         xor  ax,ax
         out  40h,al
         out  40h,al
         sti

         in   al,61h
         and  al,0FCh
         out  61h,al
      end;
      SetIntVec(TimerInt, LastTimer);
   end;

   procedure ContinueSound;
   begin
      if not PlayingSound then Exit;
      SetIntVec(TimerInt, @TimerProc);
      if TimerDiv<>0 then
      asm
         mov  al,36h
         cli
         out  43h,al
         mov  ax,TimerDiv
         out  40h,al
         mov  al,ah
         out  40h,al
         sti
      end;
      InitSpeaker; InitSoundBlaster;
   end;

   procedure ExecSound;
   begin
      SwapVectors;
      asm inc byte ptr DosActiveVal+1 end;
      Exec(Path, CmdLine);
      asm dec byte ptr DosActiveVal+1 end;
      SwapVectors;
   end;

   var
      LastExitProc :Pointer;

   procedure BSoundExitProc; far;
   begin
      StopSound; ExitProc:=LastExitProc;
   end;

begin
   asm
      mov  ah,34h
      int  21h
      dec  bx
      mov  word ptr DosActive,bx
      mov  word ptr DosActive+2,es

      mov  EmsAvail,False
      mov  ax,3567h
      int  21h
      mov  ax,es
      or   ax,bx
      jz   @@NoEMS
      not  EmsAvail
@@NoEMS:
   end;
   LastExitProc:=ExitProc; ExitProc:=@BSoundExitProc;
end.
