{$P+}
uses
   Objects, Memory,
   BIOSKeys,
   Unpack,
   BSound,
   GraphDrv, UniFont, GModes, RGB,
   DrawSpc, DrawLat, DrawNum;

const
   VStr =          '1.0 BETA';

   DataFile =      'ENDLESS.DAT';
   ScoresHeader =  $48474948; { 'HIGH' }

   SprCount =      14;
   FoodSprCount =  5;
   SprXSize =      10;
   SprYSize =      10;
   SprSize =       SprXSize*SprYSize+4;
   MXRange  =      80;
   MYRange  =      60-4;
   MFoodCount =    75;
   MaxTime =       12*182;
   MaxL =          MaxTime;

const
   MaxEnergy =     75;

   FoodParams      :Array [0..FoodSprCount-1] of
   record
      Reward       :Integer;
      Freq         :Integer;
      Sound        :(fsAnimal, fsWeed, fsBonus, fsPoison);
   end = (
   (Reward:25;  Freq:100; Sound:fsAnimal),
   (Reward:10;  Freq:100; Sound:fsWeed),
   (Reward:10;  Freq:100; Sound:fsWeed),
   (Reward:100; Freq:3;   Sound:fsBonus),
   (Reward:-50; Freq:20;  Sound:fsPoison));

type
   TScore =
   record
      Name         :String[31];
      Score        :Integer;
      ScrX, ScrY   :Word;
      CRC          :Word;
   end;

   THighScores =   Array [1..10] of TScore;

   TDir =          (sdRight, sdUp, sdLeft, sdDown);

   TSnakePart =
   object(TPoint)
      Part         :Byte;
      ToEnd, ToHead:TDir;
   end;

   TFoodParams =
   object(TPoint)
      Index        :Byte;
   end;

   TSnakePartSpr = Array [1..SprXSize*SprYSize+4] of Byte;

   PGame =         ^TGame;

   TSnake =
   object(TObject)

      Owner        :PGame;

      Range        :TPoint;
      FoodCount    :Integer;

      LeftTime     :Integer;
      Len, FLen    :Integer;
      Dir          :TDir;
      ScrollPos    :TPoint;

      Message      :String[39];
      MessageTime  :Integer;

      Food         :Array [0..MFoodCount-1] of TFoodParams;
      Body         :Array [0..MaxL-1] of TSnakePart;
      BodySpr      :Array [0..SprCount-1] of ^TSnakePartSpr;
      BackSpr      :^TSnakePartSpr;
      FoodSpr      :Array [0..FoodSprCount-1] of ^TSnakePartSpr;

      constructor Init(AXRange, AYRange,
                       AFoodCount      :Integer);

      procedure InitPicts(var Picts    :TStream);
      procedure InitField;

      procedure DrawField;

      function  Play                             :Word;

      procedure NextTurn;
      procedure UpdateInfo;

      function  ValidPos(Pos           :TPoint)  :Boolean;

      procedure ShowBody(i             :Integer);
      procedure ClearBody(i            :Integer);

      procedure ShowFood(i             :Integer);
      procedure NewFood(n              :Integer);
      procedure CheckFood(n            :Integer);

      procedure CheckBounds(n          :Integer);

      procedure SetMessage(const Msg   :String);
   end;

   TGame =
   object(TObject)
      Snake        :TSnake;

      DataUnpack   :TUnpackList;
      Data         :TMemoryStream;

      BadHeader    :Boolean;
      HighScores   :THighScores;

      constructor Init;
      destructor Done; virtual;

      procedure InitGraph;
      procedure InitPalette;
      procedure InitSound;
      procedure InitSnake;

      procedure Title;

      procedure Sound(const Name       :String);

      procedure Run;

      procedure ReadScores;
      procedure WriteScores;
      procedure AddScore(Score         :Word);
      procedure ShowScores(Added       :Integer);
   end;

const
   PartByDir       :Array [TDir, TDir] of Byte =
   ((0 ,3,0,4),(3, 0,2,1),(0,2, 0,5),(4,1,5, 0));

   DirCoords       :Array [TDir] of TPoint =
   ((x:1; y:0), (x:0; y:-1), (x:-1; y:0), (x:0; y:1));


function  ReadKey                      :Word;
assembler;
asm
   mov  ah,1
   int  16h
   jz   @@NoKey

   xor  ax,ax
   int  16h
   ret

@@NoKey:
   xor  ax,ax
end;

{ TSnake }

constructor TSnake.Init;
begin
   Inherited Init;

   Range.X:=AXRange; Range.Y:=AYRange;
   FoodCount:=AFoodCount;

   Len:=3; LeftTime:=MaxTime;
end;

procedure TSnake.InitPicts;
var
   i               :Integer;
begin
   for i:=0 to SprCount-1 do
   begin
      New(BodySpr[i]);
      Picts.Read(BodySpr[i]^, SprSize);
   end;

   New(BackSpr);
   Picts.Read(BackSpr^, SprSize);

   for i:=0 to FoodSprCount-1 do
   begin
      New(FoodSpr[i]);
      Picts.Read(FoodSpr[i]^, SprSize);
   end;
end;

procedure TSnake.InitField;
var
   i               :Integer;
begin
   Body[0].x:=Range.X shr 1; Body[0].y:=Range.Y shr 1;
   ShowBody(0);

   for i:=1 to Len-1 do
   begin
      Body[i].x:=Body[i-1].x+DirCoords[Dir].x;
      Body[i].y:=Body[i-1].y+DirCoords[Dir].y;
      Body[i].Part:=0;
      Body[i].ToEnd:=sdLeft;
      Body[i].ToHead:=sdRight;
      ShowBody(i);
   end;

   for i:=0 to FoodCount-1 do NewFood(i);
end;

procedure TSnake.DrawField;
var
   x, y            :Integer;
begin
   for y:=0 to Range.Y-1 do
   for x:=0 to Range.X-1 do
   PutImage(x*SprXSize, y*SprYSize, BackSpr);

   Line(0, Range.Y*SprYSize, Range.X*SprXSize, Range.Y*SprYSize, LightMagenta);
   Bar(0, Range.Y*SprYSize+1, GetMaxX, GetMaxY, LightGray);
   OutTextXY(2 *8, Range.Y*SprYSize+24, 'Score:', Yellow);
   OutTextXY(15*8, Range.Y*SprYSize+24, 'Energy:', Yellow);
   OutTextXY(29*8, Range.Y*SprYSize+24, 'Time:', Yellow);

   UpdateInfo;
end;

function  TSnake.Play;
var
   LDir1, LDir     :TDir;
   Key             :Word;

   Timer           :LongInt absolute $0040:$006C;
   LTimer          :LongInt;
   TimeStep        :LongInt;
begin
   LongInt(ScrollPos):=0;

   LDir:=Dir;
   repeat
      TimeStep:=1+Ord(FLen<MaxEnergy);
      repeat until (Timer<LTimer) or (Timer-LTimer>=TimeStep);
      LTimer:=Timer;

      Dec(LeftTime, TimeStep);
      if LeftTime<=0 then Break;

      Key:=ReadKey;
      LDir1:=Dir;

      case Key of
         kbLeft:   if LDir<>sdRight then Dir:=sdLeft;
         kbUp:     if LDir<>sdDown then Dir:=sdUp;
         kbRight:  if LDir<>sdLeft then Dir:=sdRight;
         kbDown:   if LDir<>sdUp then Dir:=sdDown;
         kbPgUp:   if Dir>sdRight then Dec(Dir) else Dir:=sdDown;
         kbHome:   if Dir<sdDown then Inc(Dir) else Dir:=sdRight;
      end;
      if Dir<>LDir1 then LDir:=Dir;

      NextTurn;
      UpdateInfo;

   until Key=kbEsc;

   if Len<3 then Len:=3;
   Play:=Len-3;
end;

procedure TSnake.NextTurn;
var
   i               :Integer;
begin
   if FLen=0 then
   begin
      ClearBody(0);
      for i:=0 to Len-2 do Body[i]:=Body[i+1];
      case Body[0].ToHead of
         sdRight:  Body[0].Part:=7;
         sdUp:     Body[0].Part:=8;
         sdLeft:   Body[0].Part:=9;
         sdDown:   Body[0].Part:=6;
      end;
      ShowBody(0);
      Body[Len-2].Part:=PartByDir[Body[Len-1].ToEnd, Dir];
      Body[Len-2].ToHead:=Dir;
      ShowBody(Len-2);

      if Len>3 then
      begin
         ClearBody(0);
         Dec(Len);
         for i:=0 to Len-1 do Body[i]:=Body[i+1];
      end;
   end
   else
   begin
      Inc(Len);
      Body[Len-2].Part:=PartByDir[Body[Len-2].ToEnd, Dir];
      Body[Len-2].ToHead:=Dir;
      ShowBody(Len-2);

      Dec(FLen);

      if FLen=0 then
      begin
         Owner^.Sound('WOLFWHST');
         if Random(2)=0
         then SetMessage('I''m hungry !!!')
         else SetMessage('I''m getting weaker !!!');
      end;
   end;

   Body[Len-1].x:=Body[Len-2].x+DirCoords[Dir].x;
   Body[Len-1].y:=Body[Len-2].y+DirCoords[Dir].y;
   Body[Len-1].ToHead:=Dir;
   case Dir of
      sdRight:
      begin
         Body[Len-1].Part:=13;
         Body[Len-1].ToEnd:=sdLeft;
      end;
      sdLeft:
      begin
         Body[Len-1].Part:=11;
         Body[Len-1].ToEnd:=sdRight;
      end;
      sdDown:
      begin
         Body[Len-1].Part:=12;
         Body[Len-1].ToEnd:=sdUp;
      end;
      sdUp:
      begin
         Body[Len-1].Part:=10;
         Body[Len-1].ToEnd:=sdDown;
      end;
   end;

   CheckBounds(Len-1);
   CheckFood(Len-1);
   ShowBody(Len-1);
end;

procedure TSnake.UpdateInfo;
var
   bs              :String[5];
   TimeSec         :Integer;
   CPy, CSy        :Integer;
const
   LastMsgTime     :Integer= 0;
   LastTimeSec     :Integer= 0;
begin
   CPy:=Range.Y*SprYSize+24;
   CSy:=Range.Y*SprYSize+(24+8-1);
   if DTextSettings.SizeY>1 then Inc(CSy, 7);

   Str(Len-3, bs);
   Bar(9*8, CPy-1, 9*8+31, CSy, $19);
   OutTextXY(9*8, CPy, bs, White);

   Str(FLen, bs);
   Bar(23*8, CPy-1, 23*8+31, CSy, $19);
   OutTextXY(23*8, CPy, bs, White);

   TimeSec:=LongDiv(LongMul(LeftTime, 10), 182);
   if TimeSec<>LastTimeSec then
   begin
      Str(TimeSec, bs);
      Bar(35*8, CPy-1, 35*8+23, CSy, $19);
      OutTextXY(35*8, CPy, bs, White);
      LastTimeSec:=TimeSec;
   end;

   if (MessageTime=0) or (MessageTime>LastMsgTime) then
   begin
      Bar(8, Range.Y*SprYSize+3, DriverPtr^.SizeX-8, Range.Y*SprYSize+4+DTextSettings.SizeY shl 3, $19);
      if MessageTime>0 then
      OutTextXY(16, Range.Y*SprYSize+4, Message, Yellow);
   end;
   LastMsgTime:=MessageTime;
   if MessageTime>=0 then Dec(MessageTime);
end;

function  TSnake.ValidPos;
begin
   ValidPos:=
      (Pos.X+ScrollPos.X>=1) and (Pos.X+ScrollPos.X<=Range.X) and
      (Pos.Y+ScrollPos.Y>=1) and (Pos.Y+ScrollPos.Y<=Range.Y);
end;

procedure TSnake.ShowBody;
begin
   if ValidPos(Body[i]) then
   begin
      ClearBody(i);
      PutBlock((Body[i].x-1+ScrollPos.X)*SprXSize, (Body[i].y-1+ScrollPos.Y)*SprYSize,
         BodySpr[Body[i].Part]);
   end;
end;

procedure TSnake.ClearBody;
begin
   if ValidPos(Body[i]) then
   PutImage((Body[i].x-1+ScrollPos.X)*SprXSize, (Body[i].y-1+ScrollPos.Y)*SprYSize,
      BackSpr);
end;

procedure TSnake.ShowFood;
begin
   if ValidPos(Food[i]) then
   PutBlock((Food[i].x-1+ScrollPos.X)*SprXSize, (Food[i].y-1+ScrollPos.Y)*SprYSize,
      FoodSpr[Food[i].Index]);
end;

procedure TSnake.NewFood;
var
   i, FoodRnd      :Integer;
   Ok              :Boolean;
   FoodSum         :Array [0..FoodSprCount] of Integer;
begin
   FoodSum[0]:=0;
   for i:=0 to FoodSprCount-1 do FoodSum[i+1]:=FoodSum[i]+FoodParams[i].Freq;

   repeat
      Ok:=True;
      Food[n].x:=Random(Range.X)+1-ScrollPos.X;
      Food[n].y:=Random(Range.Y)+1-ScrollPos.Y;

      FoodRnd:=Random(FoodSum[FoodSprCount]);
      for i:=1 to FoodSprCount do
      if FoodRnd<FoodSum[i] then Break;
      Food[n].Index:=i-1;

      for i:=0 to Len-1 do
      if (Body[i].x=Food[n].x) and (Body[i].y=Food[n].y) then Ok:=False;

      for i:=0 to FoodCount-1 do
      if (i<>n) and (Food[i].x=Food[n].x) and (Food[i].y=Food[n].y) then Ok:=False;
   until Ok;
   ShowFood(n);
end;

procedure TSnake.CheckFood;
var
   i               :Integer;
begin
   for i:=0 to FoodCount-1 do
   if (Body[n].x=Food[i].x) and (Body[n].y=Food[i].y) then
   begin
      Inc(FLen, FoodParams[Food[i].Index].Reward);
      if FLen<0 then FLen:=0;

      with Owner^ do
      if (FLen>=MaxEnergy) and (FoodParams[Food[i].Index].Sound<fsBonus) then
      begin
         Sound('TARZAN');
         SetMessage('I''m powerful !!!');
      end else
      case FoodParams[Food[i].Index].Sound of
         fsAnimal:
         begin
            if Random(2)=0
            then SetMessage('I''m feeling better!')
            else SetMessage('That was a nice meal!');
            case Random(3) of
               0: Sound('SQUEEK');
               1: Sound('DUCK');
               2:
               begin
                  Sound('ANIMALS');
                  SetMessage('I love the animals ...');
               end;
            end;
         end;
         fsWeed:
         begin
            Sound('DROPLET');
            If FLen<MaxEnergy div 3
            then SetMessage('That was a plant ...')
            else SetMessage('I hate eating weed :(');
         end;
         fsBonus:
         begin
            Sound('DROPLET');
            SetMessage('I''ve picked up a bonus pack!')
         end;
         fsPoison:
         begin
            Sound('OUCH');
            SetMessage('It tastes awful!')
         end;
      end;
      NewFood(i);
   end;
end;

procedure TSnake.CheckBounds;
var
   i, k            :Integer;
   LScrollPos      :TPoint;
   Field1, Field2  :Array [1..MXRange, 1..MYRange] of Byte;

const
   LightC          :TRGBColor =
   (R:63; G:0; B:0);
var
   SaveC           :TRGBColor;

function  ValidPosL(Pos                :TPoint)  :Boolean;
begin
   ValidPosL:=
      (Pos.X+LScrollPos.X>=1) and (Pos.X+LScrollPos.X<=Range.X) and
      (Pos.Y+LScrollPos.Y>=1) and (Pos.Y+LScrollPos.Y<=Range.Y);
end;

begin
   LScrollPos:=ScrollPos;
   while Body[n].x+ScrollPos.X<1 do Inc(ScrollPos.X);
   while Body[n].x+ScrollPos.X>Range.X do Dec(ScrollPos.X);
   while Body[n].y+ScrollPos.Y<1 do Inc(ScrollPos.Y);
   while Body[n].y+ScrollPos.Y>Range.Y do Dec(ScrollPos.Y);
   if LongInt(ScrollPos)<>LongInt(LScrollPos) then
   begin
      FillChar(Field1, SizeOf(Field1), $FF);
      FillChar(Field2, SizeOf(Field2), $FF);

      for i:=0 to n do
      with Body[i] do
      begin
         if ValidPosL(Body[i]) then Field1[x+LScrollPos.X, y+LScrollPos.Y]:=Part;
         if ValidPos(Body[i]) then Field2[x+ScrollPos.X, y+ScrollPos.Y]:=Part;
      end;

      for i:=0 to FoodCount-1 do
      with Food[i] do
      begin
         if ValidPosL(Food[i]) then Field1[x+LScrollPos.X, y+LScrollPos.Y]:=$FE;
         if ValidPos(Food[i]) then Field2[x+ScrollPos.X, y+ScrollPos.Y]:=$FE;
      end;

      for i:=0 to n do
      with Body[i] do
      begin
         if ValidPosL(Body[i]) then
         if Field1[x+LScrollPos.X, y+LScrollPos.Y]<>Field2[x+LScrollPos.X, y+LScrollPos.Y] then
         if Field2[x+LScrollPos.X, y+LScrollPos.Y]=$FF then
         PutImage((x-1+LScrollPos.X)*SprXSize,(y-1+LScrollPos.Y)*SprYSize, BackSpr);

         if ValidPos(Body[i]) then
         begin
            if Field1[x+ScrollPos.X, y+ScrollPos.Y]=$FE then
            begin
               PutImage((x-1+ScrollPos.X)*SprXSize, (y-1+ScrollPos.Y)*SprYSize, BackSpr);
               Field1[x+ScrollPos.X, y+ScrollPos.Y]:=$FF;
            end;

            if Field1[x+ScrollPos.X, y+ScrollPos.Y]<>Field2[x+ScrollPos.X, y+ScrollPos.Y] then ShowBody(i);
         end;
      end;

      for i:=0 to FoodCount-1 do
      begin
         with Food[i] do
         if ValidPosL(Food[i]) then
         if (Field1[x+LScrollPos.X, y+LScrollPos.Y]=$FE) and
            (Field2[x+LScrollPos.X, y+LScrollPos.Y]=$FE) then
         PutImage((x-1+LScrollPos.X)*SprXSize, (y-1+LScrollPos.Y)*SprYSize, BackSpr);
      end;

      for i:=0 to FoodCount-1 do
      begin
         with Food[i] do
         if ValidPosL(Food[i]) then
         if (Field1[x+LScrollPos.X, y+LScrollPos.Y]=$FE) and
            (Field2[x+LScrollPos.X, y+LScrollPos.Y]<>$FE) then
         PutImage((x-1+LScrollPos.X)*SprXSize, (y-1+LScrollPos.Y)*SprYSize, BackSpr);

         ShowFood(i);
      end;
   end;

   for i:=Len-2 downto 0 do
   if (Body[i].x=Body[n].x) and (Body[i].y=Body[n].y) then
   begin
      GetRGB(0, SaveC);
      SetRGB(0, LightC);

      for k:=0 to i do ClearBody(k);
      for k:=0 to Len-i-2 do Body[k]:=Body[k+i];
      Dec(Len, i+1);
      FLen:=0;

      SetRGB(0, SaveC);

      Owner^.Sound('OUCH');
      if Random(2)=0
      then SetMessage('Oh, no! I''ve lost my tail!')
      else SetMessage('I''ve cut my tail! That''s too bad.');

      Break;
   end;
end;

procedure TSnake.SetMessage;
begin
   Message:=Msg; MessageTime:=27;
end;

{ TGame }

constructor TGame.Init;
begin
   Inherited Init;

   Data.Init(0, 64);
   DataUnpack.Init(DataFile, Data);
   DataUnpack.Unpack;

   if (DataUnpack.Status<>uzOk) or (Data.Status<>stOk) then
   begin
      WriteLn('Unable to unpack the data file'); Halt;
   end;

   ReadScores;

   Randomize;

   InitSound;
   InitGraph;
   InitPalette;
   InitSnake;

   Title;
   Snake.MessageTime:=0;
   Snake.DrawField;
   Snake.InitField;
end;

destructor TGame.Done;
begin
   Inherited Done;

   CloseGraph;

   WriteScores;
   DataUnpack.Done; Data.Done;
end;

procedure TGame.InitGraph;
var
   Key             :Char;
const
   Modes           :Array ['1'..'4'] of Word =
   (gm320x200x256, gm640x400x256, gm640x480x256, gm800x600x256);
begin
   if LoadDriver('VESA256.DRV')<>gdOk then
   begin
      WriteLn('Unable to load graphics driver'); Halt;
   end;

   WriteLn(#13#10+
      'Select video mode:'#13#10+
      ' 1 - VGA  320x200x256'#13#10+
      ' 2 - SVGA 640x400x256 (recommended)'#13#10+
      ' 3 - SVGA 640x480x256'#13#10+
      ' 4 - SVGA 800x600x256');

   repeat Key:=Char(ReadKey) until (Key>='1') and (Key<='4');

   InitDriver(Modes[Key]);
   SetGraphMode;

   if DriverPtr^.SizeY>=600 then DTextSettings.SizeY:=2;
end;

procedure TGame.InitPalette;
var
   Palette         :PRGBPalette;
begin
   New(Palette);
   DataUnpack.Seek('PALETTE');
   Data.Read(Palette^, SizeOf(TRGBPalette));
   SetRGBBlock(0, 256, Palette);
   Dispose(Palette);
end;

procedure TGame.InitSound;
var
   Key             :Char;
begin
   WriteLn(#13#10+
      'Select sound device:'#13#10+
      ' 0 - No sound'#13#10+
      ' 1 - PC Speaker'#13#10+
      ' 2 - Sound Blaster'#13#10+
      ' 3 - Covox in LPT1'#13#10+
      ' 4 - Covox in LPT2');

   repeat Key:=Char(ReadKey) until (Key>='0') and (Key<='4');
   SoundDevice:=TSoundDevice(Byte(Key)-Byte('0'));
end;

procedure TGame.InitSnake;
begin
   with DriverPtr^ do
   Snake.Init(SizeX div SprXSize, SizeY div SprYSize - 4,
      LongDiv(LongMul(LongDiv(LongMul(MFoodCount, SizeX), 800), SizeY), 600));
   Snake.Owner:=@Self;

   DataUnpack.Seek('SNAKE');
   Snake.InitPicts(Data);
end;

procedure TGame.Title;
var
   Pict            :^TPoint;
   Size            :LongInt;
begin
   DataUnpack.Seek('TITLE');
   Data.Read(Size, 4);
   GetMem(Pict, Size);
   Data.Read(Pict^, Size);
   Snake.DrawField;
   PutBlock((DriverPtr^.SizeX-Pict^.X) shr 1, (DriverPtr^.SizeY-Pict^.Y) shr 1 -16, Pict);
   FreeMem(Pict, Size);

   asm
      xor  ax,ax
      int  16h
   end;
end;

procedure TGame.Sound;
begin
   DataUnpack.Seek(Name);
   BSound.InitSound(@Data);
   BSound.StartSound;
end;

procedure TGame.Run;
begin
   AddScore(Snake.Play);
end;

procedure TGame.ReadScores;
var
   Stream          :TDosStream;
   Error           :Boolean;
   Line, CRC, Ofs  :Word;
   Header          :LongInt;
begin
   Stream.Init(DataFile, stOpenRead);
   Stream.Seek(Stream.GetSize-(SizeOf(THighScores)+4));
   Stream.Read(Header, 4);
   Stream.Read(HighScores, SizeOf(THighScores));
   Stream.Done;
   BadHeader:=Header<>ScoresHeader;
   Error:=BadHeader or (Stream.Status<>stOk);

   for Line:=Low(THighScores) to High(THighScores) do
   begin
      CRC:=HighScores[Line].CRC;
      Ofs:=0;
      repeat
         Dec(CRC, Word(Pointer(PChar(@HighScores[Line])+Ofs)^));
         Inc(Ofs, 2);
      until Ofs>=SizeOf(TScore)-2;
      if CRC<>0 then Error:=True;
   end;

   if Error then FillChar(HighScores, SizeOf(THighScores), 0);
end;

procedure TGame.WriteScores;
var
   Stream          :TDosStream;
   Line, Ofs       :Word;
const
   Header          :LongInt= ScoresHeader;
begin
   for Line:=Low(THighScores) to High(THighScores) do
   begin
      Ofs:=0; HighScores[Line].CRC:=0;
      repeat
         Inc(HighScores[Line].CRC, Word(Pointer(PChar(@HighScores[Line])+Ofs)^));
         Inc(Ofs, 2);
      until Ofs>=SizeOf(TScore)-2;
   end;

   Stream.Init(DataFile, stOpenWrite);
   if BadHeader
   then Stream.Seek(Stream.GetSize)
   else Stream.Seek(Stream.GetSize-(SizeOf(THighScores)+4));
   Stream.Write(Header, 4);
   Stream.Write(HighScores, SizeOf(THighScores));
   Stream.Done;
end;

procedure TGame.AddScore;
var
   Line, Shift     :Word;
begin
   Line:=Low(HighScores);
   repeat
      if Score>HighScores[Line].Score then
      begin
         for Shift:=High(HighScores) downto Line+1 do
            HighScores[Shift]:=HighScores[Shift-1];

         HighScores[Line].Name:='';
         HighScores[Line].Score:=Score;
         HighScores[Line].ScrX:=DriverPtr^.SizeX;
         HighScores[Line].ScrY:=DriverPtr^.SizeY;

         ShowScores(Line);
         Exit;
      end;
      Inc(Line);
   until Line>High(HighScores);

   ShowScores(0);
end;

procedure TGame.ShowScores;
const
   MaxNameLen =    21;

var
   Pos, EditPos,
   SizeC, SizeP    :TPoint;
   Line            :Word;
   NumS            :String[5];
   LineS           :String[63];

procedure Edit(var Text                :String);
var
   Key             :Word;
begin
   repeat
      Key:=ReadKey;

      if (GetFontPtr(Fonts, Char(Lo(Key)), $FFFF)<>nil) or (Lo(Key)=32) then
      if Length(Text)<MaxNameLen then
      begin
         Text:=Text+Char(Lo(Key));
         OutTextXY(EditPos.X+3+Length(Text) shl 3, EditPos.Y+4, Char(Lo(Key)), LightGray);
         OutTextXY(EditPos.X+2+Length(Text) shl 3, EditPos.Y+3, Char(Lo(Key)), White);
      end;
      if Key=kbBack then
      if Text<>'' then
      begin
         Bar(EditPos.X+2+Length(Text) shl 3, EditPos.Y+3, EditPos.X+(3+8)+Length(Text) shl 3, EditPos.Y+(4+8), DarkGray);
         Dec(Text[0]);
      end;
   until Key=kbEnter;
end;

begin
   if Added=0
   then Snake.SetMessage('Sorry, not in high scores ...')
   else Snake.SetMessage('Enter your name ...');
   Snake.MessageTime:=MaxInt;
   Snake.UpdateInfo;

   if DriverPtr^.SizeX=320 then SizeC.X:=28 else SizeC.X:=38;
   SizeC.Y:=High(THighScores);
   SizeP.X:=SizeC.X shl 3 +5; SizeP.Y:=(SizeC.Y shl 3)*DTextSettings.SizeY +5;

   Pos.X:=(DriverPtr^.SizeX-SizeP.X) shr 1;
   Pos.Y:=(DriverPtr^.SizeY-SizeP.Y) shr 1;

   Bar(Pos.X, Pos.Y, Pos.X+SizeP.X, Pos.Y+SizeP.Y, DarkGray);
   Rectangle(Pos.X+1, Pos.Y+1, Pos.X+SizeP.X-1, Pos.Y+SizeP.Y-1, Blue);

   for Line:=Low(THighScores) to High(THighScores) do
   with HighScores[Line] do
   begin
      Str(Score:5, NumS);
      FillChar(LineS, SizeOf(LineS), ' '); LineS[0]:=Char(SizeOf(LineS)-1);
      LineS:=Name+LineS; LineS[0]:=Char(MaxNameLen);
      LineS:=LineS+NumS;
      if SizeC.X>28 then
      begin
         Str(ScrX, NumS);
         LineS:=LineS+'   '+NumS;
         Str(ScrY, NumS);
         LineS:=LineS+'x'+NumS;
      end;

      if Line=Added then EditPos:=Pos;

      SetTextJustify(LeftText, TopText);
      OutTextXY(Pos.X+(8+3), Pos.Y+4, LineS, LightGray);
      OutTextXY(Pos.X+(8+2), Pos.Y+3, LineS, White);

      Inc(Pos.Y, DTextSettings.SizeY shl 3);
   end;

   if Added<>0 then Edit(HighScores[Added].Name) else
   asm
      xor  ax,ax
      int  16h
   end;
end;

var
   Game            :TGame;

begin
   WriteLn(#13#10'Endless Snake  Version '+VStr+'  Copyright (c) 1995 by Solar Designer \ BPC');

   Game.Init;
   Game.Run;
   Game.Done;
end.
