unit RGB;

{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Auxiliary Unit                  }
{                                                       }
{       Copyright (c) 1993-95 by Solar Designer         }
{                                                       }
{*******************************************************}

interface

   type
      TRGBColor=
      record
         r, g, b   :Byte;
      end;

      TRGBPalette= Array [0..255] of TRGBColor;
      PRGBPalette= ^TRGBPalette;

   procedure SetRGB(c                  :Integer;
                    var RGB            :TRGBColor);

   procedure GetRGB(c                  :Integer;
                    var RGB            :TRGBColor);

   procedure GetRGBBlock(First, Count  :Integer;
                         Palette       :PRGBPalette);

   procedure SetRGBBlock(First, Count  :Integer;
                         Palette       :PRGBPalette);

   procedure SetRGBPalette(Palette     :PRGBPalette);

   function  GetRGBBrightness(var RGB  :TRGBColor)         :Byte;

   function  GetNearestColor(var RGB   :TRGBColor;
                             Min, Max  :Integer;
                             Palette   :PRGBPalette)       :Integer;

implementation

   procedure SetRGB;
   assembler;
   asm
      mov  ax,1010h
      les  di,RGB
      mov  dh,es:[di]
      mov  cx,es:[di+1]
      xchg cl,ch
      mov  bx,c
      int  10h
   end;

   procedure GetRGB;
   assembler;
   asm
      mov  ax,1015h
      mov  bx,c
      int  10h
      les  di,RGB
      mov  es:[di],dh
      xchg cl,ch
      mov  es:[di+1],cx
   end;

   procedure GetRGBBlock;
   assembler;
   asm
      mov  bx,First
      mov  cx,Count
      les  dx,Palette
      mov  ax,1017h
      int  10h
   end;

   procedure SetRGBBlock;
   assembler;
   asm
      mov  bx,First
      mov  cx,Count
      les  dx,Palette
      mov  ax,1012h
      int  10h
   end;

   procedure SetRGBPalette;
   assembler;
   asm
      push ds
      lds  si,Palette

      mov  dx,3C8h
      xor  ax,ax
      out  dx,al
      inc  dx

      cld
      mov  cx,256*3
@@1:
      lodsb
      out  dx,al
      nop
      loop @@1

      pop  ds
   end;

   function  GetRGBBrightness;
   begin
      with RGB do GetRGBBrightness:=Integer(r)+Integer(g)+Integer(b);
   end;

   function  GetNearestColor;

      function  Diff(c1, c2            :Integer) :LongInt;
      begin
         Diff:=Sqr(LongInt(c1-c2));
      end;

   var
      i            :Integer;
      d, dmin      :LongInt;
      cRGB         :TRGBColor;
   begin
      GetNearestColor:=0; dmin:=$FFFF;
      for i:=min to max do
      begin
         if Palette=NIL then GetRGB(i,cRGB) else cRGB:=Palette^[i];
         d:=3*Diff(RGB.r,cRGB.r)+6*Diff(RGB.g,cRGB.g)+Diff(RGB.b,cRGB.b)+
            10*Diff(GetRGBBrightness(RGB),GetRGBBrightness(cRGB));
         if d<dmin then
         begin
            dmin:=d; GetNearestColor:=i;
         end;
      end;
   end;

end.
