
{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1992-95 by Solar Designer         }
{                                                       }
{*******************************************************}

unit UniFont;
{$R-,Q-,S-}
interface
uses
   Objects;

const
   fcRaster =      1;
   fcVector =      2;

type
   PFontChars =    ^TFontChars;
   TFontChars =    Array [0..255] of Word;

   PFontHeader =   ^TFontHeader;
   TFontHeader =
   record
      CharOfs      :PFontChars;
      c1, c2       :Char;
      Class        :Word;
      Next         :PFontHeader;
      Width,
      Height       :Word;
   end;

   TDrawProc =     Procedure (x1, y1, x2, y2, c  :Integer);

   TVectorParams =
   record
      AspX, AspY   :Byte;
      Angle,
      Sin, Cos     :Integer;
   end;

const
   VectorParams    :TVectorParams =
   (AspX:1; AspY:1; Angle:0; Sin:0; Cos:MaxInt);

   Fonts           :PFontHeader =      nil;

function  GetFontPtr(Font                        :PFontHeader;
                     c                           :Char;
                     Class                       :Word)    :PFontHeader;

procedure DrawChar(Font                          :PFontHeader;
                   Ch                            :Char;
                   x, y, Color                   :Integer;
                   xm, xd, ym, yd                :Word;
                   PLine, PRectangle, PBar       :Pointer);

function  QSin(x                                 :Integer) :Integer;
function  QCos(x                                 :Integer) :Integer;

procedure SetFontAngle(a                         :Integer);

procedure EvalXY(x, y                            :Integer;
                 var xa, ya                      :Integer);

implementation

   function GetFontPtr;
   assembler;
   asm
      les  di,Font
      mov  al,c
      mov  dl,byte ptr Class

@@Next:
      mov  cx,es
      or   cx,di
      jz   @@Exit

      test byte ptr es:[di].TFontHeader.Class,dl
      jz   @@ToNext

      cmp  al,es:[di].TFontHeader.c1
      jb   @@ToNext
      cmp  al,es:[di].TFontHeader.c2
      jbe  @@Exit

@@ToNext:
      les  di,es:[di].TFontHeader.Next
      jmp  @@Next

@@Exit:
      mov  dx,es
      mov  ax,di
   end;

   function QSin;
   const
      SinArray     :Array [0..90] of Integer=
      (0,
         572, 1144, 1715, 2286, 2856, 3425, 3993, 4560, 5126, 5690,
        6252, 6813, 7371, 7927, 8481, 9032, 9580,10126,10668,11207,
       11743,12275,12803,13328,13848,14364,14876,15383,15886,16384,
       16876,17364,17846,18323,18794,19260,19720,20173,20621,21062,
       21497,21925,22347,22762,23170,23571,23964,24351,24730,25101,
       25465,25821,26169,26509,26841,27165,27481,27788,28087,28377,
       28659,28932,29196,29451,29697,29934,30162,30381,30591,30791,
       30982,31163,31335,31498,31650,31794,31927,32051,32165,32269,
       32364,32448,32523,32587,32642,32687,32722,32747,32762,32767);

   var
      xn, r        :Integer;
   begin
      xn:=abs(x);
      if xn>360 then xn:=xn mod 360;
      case xn of
         0..90:    r:= SinArray[xn];
         91..180:  r:= SinArray[180-xn];
         181..270: r:=-SinArray[xn-180];
         271..360: r:=-SinArray[360-xn];
      end;
      if x>=0 then QSin:=r else QSin:=-r;
   end;

   function QCos;
   begin
      QCos:=QSin(x+90);
   end;

   procedure SetFontAngle;
   begin
      with VectorParams do
      begin
         Angle:=a; Sin:=QSin(a); Cos:=QCos(a);
      end;
   end;

   procedure EvalXY;
   begin
      with VectorParams do
      begin
         xa:=LongDiv(LongMul(x, Cos), MaxInt) +
             LongDiv(LongMul(LongDiv(LongMul(y, Sin), MaxInt), AspX), AspY);
         ya:=LongDiv(LongMul(y, Cos), MaxInt) -
             LongDiv(LongMul(LongDiv(LongMul(x, Sin), MaxInt), AspY), AspX);
      end;
   end;

   procedure DrawChar;
   var
      fp                               :PFontHeader;
      n                                :Byte;
      d                                :PByteArray;

      pc                               :Word;
      c, lc                            :Byte;
      xc, yc, xl, yl, xb, yb, xe, ye,
      x1, y1, x2, y2, x3, y3, x4, y4   :Integer;

      xk, yk, ck                       :Boolean;

   begin
      fp:=GetFontPtr(Font, Ch, fcVector);
      if fp=nil then Exit;
      d:=Ptr(DSeg, fp^.CharOfs^[Byte(Ch)-Byte(fp^.c1)]); n:=d^[0];

      xk:=(xm<>xd); yk:=(ym<>yd); ck:=xk or yk;

      pc:=0; c:=0;
      while pc<n do
      begin
         Inc(pc);
         lc:=c;
         asm
            les  di,d
            xor  ax,ax
            add  di,pc
            mov  al,es:[di]

            mov  dx,ax
            and  dl,003h
            mov  c,dl

            mov  cl,2
            shr  ax,cl

            mov  dx,ax
            and  dl,038h
            inc  cx
            shr  dx,cl
            mov  xc,dx

            and  al,007h
            mov  yc,ax
         end;

         if xk then
         asm
            mov  ax,xc
            mul  xm
            div  xd
            mov  xc,ax
         end;
         if yk then
         asm
            mov  ax,yc
            mul  ym
            div  yd
            mov  yc,ax
         end;

         if VectorParams.Angle<>0 then
         begin
            x3:=xc; y3:=yc; EvalXY(xc, yc, xc, yc);
         end;
         Inc(xc, x); Inc(yc, y);

         if ck and (lc>0) and ((xc<xl) xor (yc<yl)) then
         begin
            xb:=xc; yb:=yc; xe:=xl; ye:=yl;
         end
         else
         begin
            xb:=xl; yb:=yl; xe:=xc; ye:=yc;
         end;

         case lc of
            1: TDrawProc(PLine)(xb, yb, xe, ye, Color);
            0: ;
            2:
            if VectorParams.Angle=0 then
            TDrawProc(PRectangle)(xb, yb, xe, ye, Color) else
            begin
               EvalXY(x3, y1, x2, y2); Inc(x2, x); Inc(y2, y);
               EvalXY(x1, y3, x4, y4); Inc(x4, x); Inc(y4, y);
               TDrawProc(PLine)(xb, yb, x2, y2, Color);
               TDrawProc(PLine)(x2, y2, xe, ye, Color);
               TDrawProc(PLine)(xe, ye, x4, y4, Color);
               TDrawProc(PLine)(x4, y4, xb, yb, Color);
            end;
            3: TDrawProc(PBar)(xb, yb, xe, ye, Color);
         end;
         xl:=xc; yl:=yc; x1:=x3; y1:=y3;
      end;
   end;

end.
