' ***** OFFICIAL COPY ******
'
' ENIGMA BY ANDREW CLARE
'
' LAST UPDATE: Wednesday, 22nd March 1995
'
' VERSION aae
'

DATA 15,7,8,0
DATA 0,0,8,8,7,7,15,15,7,7,8,8
DATA 12,14,2,9,7,15

' *************************************************************************

' Enigma 1 data

DATA 2,1,0,1,0,28,0,3,1,1,55,1,1,0,0,40,0,1,0,54,1
DATA 0,1,0,0,0,1,1,1,1,43,31,50,1,0,1,4,1,0,0,1,5
DATA 0,0,0,0,1,37,0,6,1,1,41,1,1,0,0,1,0,0,1,0,0
DATA 1,0,1,1,1,0,1,1,1,1,33,1,0,0,1,0,0,1,0,0,1
DATA 0,0,1,7,34,0,36,0,8,1,0,1,0,0,0,0,1,0,0,1,9
DATA 0,1,1,1,1,0,1,1,1,1,0,1,1,0,1,1,35,0,1,0,0
DATA 0,0,1,10,39,0,0,0,11,1,0,1,0,0,0,1,0,1,30,0,1
DATA 1,0,1,1,1,0,1,1,1,1,0,1,0,0,0,1,0,1,0,1,0
DATA 0,0,1,12,32,0,38,0,13,1,0,1,14,0,0,1,0,0,0,0,0
DATA 0,1,1,1,1,0,1,42,1,1,0,1,1,1,0,1,0,1,1,1,1
DATA 0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,1,15
DATA 0,0,0,0,29,47,1,0,1,1,0,1,1,1,44,1,1,1,0,1,0
DATA 0,0,0,0,1,16,1,0,17,1,0,1,0,1,18,0,0,0,0,0,0
DATA 0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,0,1
DATA 0,1,0,0,1,0,0,19,1,1,1,1,1,0,0,1,20,0,1,0,0
DATA 0,21,1,0,1,1,1,0,0,0,1,0,0,0,1,1,1,0,1,1,0
DATA 1,1,0,0,0,0,49,0,1,0,0,0,1,0,0,22,1,0,0,46,0
DATA 23,1,0,1,1,1,1,0,0,0,1,0,48,0,1,1,1,1,0,1,1
DATA 0,0,0,1,0,0,45,0,1,0,0,0,1,0,0,0,0,0,0,1,0
DATA 1,0,1,0,0,1,1,0,0,0,1,0,0,0,1,1,1,1,1,1,0
DATA 0,0,0,0,1,0,50,0,1,0,0,0,1,0,0,0,0,0,0,0,0
DATA 2,22,11,11
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

' Enigma 2 data

DATA 2,31,3,30,0,4,29,5,0,1,0,1,6,0,0,0,0,0,0,0,0
DATA 1,1,1,1,0,1,1,1,1,34,0,0,0,0,0,0,0,0,0,0,0
DATA 7,1,8,28,0,0,0,0,0,0,1,1,32,1,1,1,47,1,1,1,32
DATA 52,1,1,1,1,1,1,1,1,0,1,0,0,1,9,38,0,37,1,1,0
DATA 0,1,10,1,23,1,16,1,1,0,1,0,1,1,1,38,11,37,1,1,0
DATA 0,1,16,42,49,43,42,16,1,0,1,0,0,1,1,38,0,37,12,1,0
DATA 0,1,1,43,0,0,42,1,1,0,1,1,0,1,1,1,35,1,1,1,0
DATA 0,1,17,43,0,0,42,16,1,0,1,0,0,1,13,44,0,45,14,1,0
DATA 0,1,1,41,15,16,1,1,1,0,1,0,1,1,1,0,0,0,1,1,0
DATA 0,1,17,41,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,1,0
DATA 0,1,1,42,0,0,1,0,1,0,1,1,0,1,1,0,0,0,1,1,0
DATA 0,1,15,41,41,42,1,0,1,0,1,0,0,1,18,46,19,40,20,1,0
DATA 0,1,1,15,1,16,1,0,1,0,1,0,1,1,1,1,15,1,1,1,0
DATA 0,1,1,1,1,1,1,0,1,0,1,0,0,0,0,1,41,23,23,1,0
DATA 0,1,54,0,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,21
DATA 0,1,1,0,1,0,1,0,0,0,31,5,1,1,1,1,1,1,1,1,1
DATA 0,0,0,0,1,0,22,1,1,0,1,1,23,0,0,0,0,0,0,0,0
DATA 1,1,1,0,1,0,1,0,0,0,0,0,0,1,49,1,49,1,49,1,49
DATA 0,48,0,0,1,0,0,0,1,0,1,1,1,1,1,1,23,1,23,1,24
DATA 0,1,53,0,0,0,51,51,1,0,0,11,12,11,12,1,1,1,1,1,1
DATA 25,1,26,1,1,1,0,27,1,0,0,0,0,0,0,0,39,36,33,50,55
DATA 22,43,21,11
DATA 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

' Enigma 3 data

DATA 18,1,0,0,0,0,0,19,1,1,55,1,1,0,0,1,46,1,1,46,1
DATA 0,1,0,45,45,45,1,1,1,0,0,0,1,0,20,46,20,46,0,0,1
DATA 0,1,0,45,0,0,19,54,1,30,28,29,1,45,1,1,46,1,0,0,46
DATA 0,1,0,1,1,1,1,1,1,29,30,28,1,0,36,0,0,1,46,1,1
DATA 44,44,44,44,44,1,0,62,1,28,29,30,1,0,1,0,20,46,20,46,20
DATA 0,44,0,0,0,1,0,1,0,0,0,0,0,1,1,46,1,1,46,1,0
DATA 0,0,0,44,18,0,73,0,0,1,1,1,0,46,20,0,46,20,0,1,4
DATA 1,1,1,1,1,1,1,1,0,1,0,1,0,1,1,1,1,1,1,1,1
DATA 0,36,0,0,0,0,2,36,0,1,1,1,0,0,77,11,1,0,0,0,1
DATA 35,36,35,36,36,36,36,1,0,0,0,0,0,1,0,0,37,0,1,0,0
DATA 0,0,0,36,5,0,36,36,1,0,1,43,1,1,1,0,0,1,1,1,0
DATA 0,36,36,36,36,0,0,36,36,71,1,0,43,17,3,1,0,37,12,11,0
DATA 0,36,0,0,0,36,0,0,36,0,1,0,1,1,1,38,38,38,1,1,1
DATA 0,36,0,36,0,36,36,0,36,0,1,0,43,14,39,0,0,0,0,1,15
DATA 9,0,0,36,0,36,31,0,0,0,1,0,43,1,1,0,60,60,0,1,40
DATA 36,36,36,36,34,36,36,31,36,0,1,0,43,0,0,0,60,60,0,0,13
DATA 8,0,0,0,0,34,36,0,36,0,1,0,43,0,0,0,0,0,0,0,0
DATA 0,36,36,36,36,36,36,0,36,0,1,0,43,41,1,0,0,42,42,1,1
DATA 0,0,0,36,0,0,36,6,36,0,1,0,43,16,1,0,0,42,17,0,54
DATA 1,1,33,36,0,36,36,36,36,0,1,0,43,43,43,43,0,1,0,43,43
DATA 0,1,0,0,0,7,32,0,0,10,1,0,0,0,0,0,0,1,0,43,61
DATA 2,22,6,11
DATA 11,8,1,21,14,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0

' Enigma 4 data

DATA 62,62,61,62,62,1,0,0,0,0,70,0,0,0,0,1,58,1,0,1,58
DATA 100,88,89,98,84,0,0,1,80,80,80,80,80,0,0,1,1,1,0,1,1
DATA 1,1,1,1,1,1,1,56,80,0,55,0,80,0,0,0,0,1,0,1,7
DATA 0,1,0,0,0,0,1,0,80,1,1,1,80,1,1,1,1,1,56,1,1
DATA 1,1,1,0,0,0,0,33,80,1,30,1,80,32,32,32,32,32,32,32,32
DATA 59,0,34,0,0,0,74,8,80,80,29,80,80,75,6,99,89,104,100,88,0
DATA 80,80,80,80,80,80,80,0,80,80,28,80,80,0,80,80,80,80,80,80,80
DATA 56,92,85,86,100,73,0,0,0,0,0,0,0,0,0,77,56,0,0,0,0
DATA 1,1,1,1,1,1,80,0,80,1,1,1,80,75,80,1,1,1,0,1,80
DATA 0,1,1,0,54,0,80,0,80,58,0,58,80,67,80,80,0,1,0,1,0
DATA 0,1,1,0,0,0,80,71,80,80,80,80,80,0,80,59,80,9,1,1,0
DATA 84,77,1,0,0,0,80,0,0,57,57,57,0,0,80,80,63,80,80,80,35
DATA 71,1,65,92,59,92,80,0,0,57,56,57,0,0,80,0,0,0,0,0,0
DATA 84,77,1,0,0,0,80,0,0,57,57,57,0,0,80,10,1,1,1,1,1
DATA 71,1,56,1,0,101,80,5,1,1,1,1,1,1,80,86,36,73,86,37,2
DATA 84,77,1,75,1,0,80,31,1,31,0,5,31,5,80,95,36,73,89,37,64
DATA 71,1,75,98,77,0,80,5,31,5,1,31,1,31,80,101,36,73,98,37,103
DATA 98,77,101,71,1,71,80,31,1,31,1,1,31,5,80,98,36,77,99,37,98
DATA 71,1,71,1,73,92,80,1,60,1,1,31,1,31,80,100,36,73,100,37,95
DATA 1,66,1,0,0,77,80,0,31,5,31,5,31,5,80,88,36,73,0,37,94
DATA 3,0,0,0,1,0,80,4,1,31,1,31,1,31,80,0,36,73,11,37,87
DATA 4,22,8,11
DATA 14,14,3,4,1,4,16,11,14,8,3,21,8,8,11,10,0,0,0,0

' Maze 5!!!!!!!!!!!!

DATA 61,80,0,98,84,84,92,84,84,98,98,98,101,101,101,101,98,98,65,80,56
DATA 101,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,56
DATA 0,0,0,80,26,15,80,98,70,77,73,75,77,66,80,64,65,80,59,56,1
DATA 0,57,0,80,71,71,80,80,75,71,73,75,71,80,80,1,1,80,1,1,80
DATA 0,0,0,0,82,0,56,80,73,71,73,75,78,80,57,0,82,0,0,82,82
DATA 53,53,1,1,1,1,80,80,71,75,73,75,78,80,57,0,0,56,56,0,0
DATA 53,0,27,1,56,1,59,80,71,77,77,77,78,80,57,0,0,0,0,0,0
DATA 27,53,58,1,75,80,80,80,80,80,80,80,80,80,80,80,1,1,1,1,1
DATA 80,80,53,1,0,80,58,56,1,1,0,1,1,56,58,80,98,0,84,0,92
DATA 94,85,0,53,0,80,80,80,80,80,1,80,80,80,80,80,0,74,70,76,0
DATA 0,0,53,80,80,80,59,0,31,80,1,80,70,56,67,80,101,73,59,77,101
DATA 0,80,71,56,56,80,80,80,5,0,52,0,0,80,80,80,0,72,71,78,0
DATA 0,80,56,56,80,80,56,57,31,80,1,80,1,56,0,80,101,0,0,0,101
DATA 27,80,56,80,46,80,80,80,80,1,1,1,80,80,80,80,1,1,1,1,1
DATA 0,80,80,46,20,0,0,0,80,0,55,0,80,0,0,0,56,81,82,83,84
DATA 0,80,50,80,46,80,80,28,80,80,80,80,80,57,62,62,62,70,74,74,75
DATA 57,50,24,0,0,80,28,0,70,1,0,2,80,70,70,70,62,83,84,81,82
DATA 80,80,80,80,80,80,80,80,80,80,56,80,80,60,60,70,62,74,75,76,70
DATA 0,70,82,74,81,73,83,70,0,60,80,60,0,99,60,70,62,82,83,84,81
DATA 104,73,81,70,83,72,82,71,80,0,80,0,80,62,60,70,62,75,70,76,76
DATA 104,73,83,73,82,70,81,71,80,0,57,0,80,70,70,70,62,63,81,82,54
DATA 16,22,17,11
DATA 11,18,1,19,14,21,19,13,3,1,8,3,11,9,15,13,0,0,0,0

' Maze 6 Data

DATA 6,0,0,0,0,0,0,0,0,64,1,0,0,0,0,0,0,0,0,0,25
DATA 0,1,1,1,1,1,1,1,1,1,54,1,1,1,1,1,1,1,1,1,0
DATA 0,1,59,59,59,59,59,59,59,1,0,1,59,59,59,59,59,59,59,1,0
DATA 0,1,59,58,58,58,58,58,58,80,66,80,58,58,58,58,58,58,59,1,0
DATA 0,1,59,58,57,57,57,57,57,80,0,80,57,57,57,57,57,58,59,1,0
DATA 0,1,59,58,57,56,56,56,56,80,32,80,56,56,56,56,57,58,59,1,0
DATA 0,1,59,58,57,56,0,0,0,80,51,80,0,0,0,56,57,58,59,1,0
DATA 0,1,59,58,57,56,0,0,0,80,36,80,0,0,0,56,57,58,59,1,0
DATA 0,1,59,58,57,56,0,0,0,1,47,1,0,0,0,56,57,58,59,1,0
DATA 0,1,59,58,57,56,0,0,80,80,82,80,80,0,0,56,57,58,59,1,64
DATA 1,1,59,58,57,56,0,0,80,0,55,0,80,0,0,56,57,58,59,1,1
DATA 65,1,59,58,57,56,0,0,80,80,80,80,80,0,0,56,57,58,59,1,0
DATA 0,1,59,58,57,56,0,0,0,80,64,80,0,0,0,56,57,58,59,1,0
DATA 0,1,59,58,57,56,0,0,0,80,56,80,0,0,0,56,57,58,59,1,0
DATA 0,1,59,58,57,56,0,0,0,80,0,80,0,0,0,56,57,58,59,1,0
DATA 0,1,59,58,57,56,56,1,1,80,80,80,1,1,56,56,57,58,59,1,0
DATA 0,1,59,58,57,57,57,1,60,85,0,104,61,1,57,57,57,58,59,1,0
DATA 0,1,59,58,58,58,58,1,85,85,0,104,104,1,58,58,58,58,59,1,0
DATA 0,1,59,59,59,59,59,1,0,0,0,0,0,1,59,59,59,59,59,1,0
DATA 0,1,1,1,1,1,1,1,89,89,0,100,100,1,1,1,1,1,1,1,0
DATA 21,0,0,0,0,0,0,1,62,89,0,100,63,1,64,0,0,0,0,0,10
DATA 12,22,19,11
DATA 1,10,12,1,21,12,7,21,11,5,11,15,11,19,0,0,0,0,0,0

' Key to data

'     0 - clear
'     1 - wall
'  2-27 - key (a-z)
' 28-53 - door (a-z)
'    54 - crystal
'    55 - EXIT
' 60-69 - teleport
' 70-79 - trap
'    80 - indestructible wall
' 81-106- letter

' *************************************************************************
SCREEN 12
DIM wall(256), keyz(256), door(256), teleport(256), portcullis(256)
DIM rface(256), bface(256), gface(256), bomb(256), heart(256)
DIM crystal(256), main(256), colour(256), orig(25, 25)
DIM map(25, 25)
RANDOMIZE TIMER

' start section
CLS
COLOR 15
PRINT " Press return."
COLOR 0
INPUT a$
IF a$ <> "love" THEN COLOR 1: GOTO restart
CLS
COLOR 13
cheatmode = 1
PRINT " Andrew Clare's private cheat mode!"
PRINT
PRINT " Cheat options:"
PRINT
PRINT "100000 life   : +1"
PRINT "Open doors    : +2"
PRINT "999 bombs     : +4"
PRINT "Walls to faces: +8"
PRINT "Select maze   : +16"
PRINT "999 lives     : +32"
PRINT "See ending    : +64"
PRINT "Mastermind    : +128"
PRINT
PRINT "Enter number."
snot:
INPUT n
IF n > 255 OR n < 0 THEN GOTO snot
IF n > 127 THEN n = n - 128: mmind = 1
IF n > 63 THEN n = n - 64: ending = 1: crys = 6
IF n > 31 THEN n = n - 32: lives = lives + 999
IF n > 15 THEN n = n - 16: levsel = 1
IF n > 7 THEN n = n - 8: wface = 1
IF n > 3 THEN n = n - 4: bomb = 999
IF n > 1 THEN n = n - 2: cheat = 1
IF n > 0 THEN n = n - 1: life = 100000
IF n > 0 THEN GOTO snot

IF life = 0 THEN life = 1335
IF lives = 0 THEN lives = 3
IF levsel = 1 THEN GOTO levsel

GOTO restart

levsel:
CLS
COLOR 14
PRINT "Select maze... 1-6"
spim:
INPUT m
IF m < 0 OR m > 6 THEN GOTO spim
game = m - 1
FOR quib = 1 TO game
LOCATE 2, 3
PRINT "Please wait,reading data."
FOR a = 1 TO 21
FOR b = 1 TO 21
READ map(a, b)
orig(a, b) = map(a, b)
NEXT: NEXT
READ exa, exb, starta, startb
FOR zip = 1 TO 10
READ tela(zip), telb(zip)
NEXT zip
LOCATE 2, 3: PRINT "                           "
NEXT quib

' CONTINUE LATER...

restart:

' OPTIONS

IF life < 50000 THEN life = 1500
IF lives < 500 THEN lives = 3

col1 = 15 'Main maze colour
col2 = 14 'Door colour
col3 = 13 'Key colour
col4 = 4  'Character colour
clr(1) = 15
clr(2) = 7
clr(3) = 8
IF cheatmode = 1 THEN GOTO chardraw
GOTO intro

intro:
DIM word(1649), nothing(1649)
CLS : COLOR col1
PRINT "ENIGMA"
GET (0, 0)-(56, 16), word
COLOR 0
CLS
PRINT "ENIGMA"
GET (0, 0)-(56, 16), nothing
COLOR col1
snip = 0: wai = 0

perm = 15
cheese:

 FOR scissors = 0 TO perm
COLOR col1
PUT (88, snip), nothing, PSET
snip = snip + scissors
PUT (88, snip), word, PSET
NEXT scissors
PUT (88, snip), nothing
perm = perm - 1: IF perm = 0 THEN cba = 1: GOTO brie

 FOR scissors = perm TO -perm STEP -1
COLOR col1
PUT (88, snip), nothing, PSET
snip = snip + scissors
PUT (88, snip), word, PSET
NEXT scissors
snip = 128
PUT (88, snip), nothing
perm = perm - 1: IF perm = 0 THEN cba = 2: GOTO brie
   
 FOR scissors = -perm TO 0
COLOR col1
PUT (88, snip), nothing, PSET
snip = snip + scissors
PUT (88, snip), word, PSET
NEXT scissors
perm = perm - 1: IF perm = 0 THEN cba = 3: GOTO brie
GOTO cheese

brie:
wai = 25
LOCATE 1, 1
COLOR 10
PRINT "Welcome to        ...the definitive version"
FOR w = 1 TO 1000: NEXT w
FOR snip = 128 TO 0 STEP -1
COLOR col1
PUT (88, snip), word, PSET
COLOR 0

COLOR col1
FOR w = 1 TO wai: NEXT w: NEXT snip: COLOR col1
PRINT
COLOR 14
PRINT "By Andrew Clare."
COLOR 13
PRINT " Press space to start."
DO
q$ = INKEY$
LOOP UNTIL q$ = " "


'****************************************************************************
'****************************************************************************

chardraw:
' CHARACTER DRAWING

CLS
LOCATE 1, 1: PRINT "  "

wall:
xxx = 1
yyy = 1
FOR poo = 1 TO 3
LINE (xxx, yyy)-(xxx + 15, yyy + 15), clr(poo), B
LINE (xxx, yyy)-(xxx + 15, yyy + 15), clr(poo)
LINE (xxx, yyy + 15)-(xxx + 15, yyy), clr(poo)
IF poo = 1 THEN PAINT (xxx + 10, yyy + 1), clr(1)
IF poo = 2 THEN PAINT (xxx + 1, yyy + 10), clr(2): PAINT (xxx + 14, yyy + 10), clr(2)
IF poo = 3 THEN PAINT (xxx + 10, yyy + 14), clr(3)
NEXT poo
GET (0, 0)-(16, 16), wall
LOCATE 1, 1: PRINT "  "

keyz:
xxx = 1
yyy = 1
LINE (0, 0)-(16, 16), 0, BF
COLOR col3
CIRCLE (xxx + 4, yyy + 12), 2
LINE (xxx + 4, yyy + 9)-(xxx + 4, yyy + 2)
LINE (xxx + 4, yyy + 2)-(xxx + 6, yyy + 2)
LINE (xxx + 4, yyy + 5)-(xxx + 5, yyy + 5)
COLOR col1
GET (0, 0)-(16, 16), keyz
LOCATE 1, 1: PRINT "  "

door:
LINE (0, 0)-(16, 16), 0, BF
xxx = 1
yyy = 1
LINE (xxx, yyy)-(xxx + 6, yyy + 14), col2, B
LINE (xxx + 3, yyy + 6)-(xxx + 3, yyy + 8)
GET (0, 0)-(16, 16), door
LOCATE 1, 1: PRINT "  "

tele:
LINE (0, 0)-(16, 16), 0, BF
xxx = 1
yyy = 1
COLOR col2
CIRCLE (xxx + 3, yyy + 3), 3
CIRCLE (xxx + 11, yyy + 3), 3
CIRCLE (xxx + 3, yyy + 11), 3
CIRCLE (xxx + 11, yyy + 11), 3
COLOR col1
GET (0, 0)-(16, 16), teleport
LOCATE 1, 1: PRINT "  "

port:
LINE (0, 0)-(16, 16), 0, BF
xxx = 1
yyy = 1
COLOR col3
CIRCLE (xxx + 7, yyy + 7), 3
PAINT (xxx + 7, yyy + 7)
COLOR col1
GET (0, 0)-(16, 16), portcullis
LOCATE 1, 1: PRINT "  "

faces:
LINE (0, 0)-(16, 16), 0, BF
xxx = 1: yyy = 1
FOR plip = 1 TO 3
IF plip = 1 THEN fff = 4
IF plip = 2 THEN fff = 1
IF plip = 3 THEN fff = 2
COLOR fff
CIRCLE (8, 8), 7
PAINT (8, 8)
COLOR 14
CIRCLE (8, 8), 7
LINE (6, 5)-(6, 6)
LINE (10, 5)-(10, 6)
LINE (7, 11)-(9, 11)
PSET (6, 10)
PSET (10, 10)
COLOR fff
IF plip = 1 THEN GET (0, 0)-(16, 16), rface
IF plip = 2 THEN GET (0, 0)-(16, 16), bface
IF plip = 3 THEN GET (0, 0)-(16, 16), gface
NEXT plip
LOCATE 1, 1: PRINT "  "

bombs:
COLOR 8
CIRCLE (6, 10), 5
PAINT (6, 10)
COLOR 14
CIRCLE (6, 10), 5
COLOR 3
LINE (8, 6)-(10, 3)
COLOR 14
CIRCLE (10, 3), 1
GET (0, 0)-(16, 16), bomb
LOCATE 1, 1: PRINT "  "
COLOR col1

chance:
COLOR 12
CIRCLE (5, 5), 3
CIRCLE (10, 5), 3
PAINT (5, 5), 12
PAINT (10, 5), 12
LINE (3, 7)-(7, 14)
LINE (12, 7)-(8, 14)
PAINT (7, 10), 12
GET (0, 0)-(16, 16), heart
LOCATE 1, 1: PRINT "  "
COLOR col1

multicolour:
CLS
FOR zob = 1 TO 16
LINE (zob, 1)-(zob, 16), INT(RND(1) * 16 + 0)
NEXT zob
GET (0, 0)-(16, 16), colour
CLS

crystal:
COLOR 15
LINE (6, 1)-(7, 1)
LINE (4, 2)-(7, 2)
LINE (3, 3)-(6, 3)
LINE (2, 4)-(5, 4)
LINE (1, 5)-(4, 5)
COLOR 11
LINE (3, 6)-(3, 7)
LINE (4, 6)-(4, 9)
LINE (5, 5)-(5, 11)
LINE (6, 4)-(6, 11)
LINE (7, 3)-(7, 11)
LINE (8, 1)-(8, 11)
LINE (9, 1)-(9, 11)
LINE (10, 2)-(10, 11)
LINE (11, 2)-(11, 9)
LINE (12, 3)-(12, 7)
LINE (13, 4)-(13, 5)
LINE (14, 5)-(14, 5)
COLOR 9
LINE (1, 5)-(1, 10)
LINE (2, 6)-(2, 11)
LINE (3, 8)-(3, 12)
LINE (4, 10)-(4, 12)
COLOR 3
LINE (11, 10)-(11, 12)
LINE (12, 8)-(12, 12)
LINE (13, 6)-(13, 11)
LINE (14, 6)-(14, 10)
COLOR 1
LINE (5, 12)-(10, 12)
LINE (4, 13)-(11, 13)
LINE (6, 14)-(9, 14)
COLOR 14
GET (0, 0)-(16, 16), crystal
CLS

mainspr:

CIRCLE (7, 7), 6, 8
PAINT (7, 7), 8
CIRCLE (7, 7), 4, 7
PAINT (7, 7), 7
CIRCLE (7, 7), 2, 15
PAINT (7, 7), 15
COLOR col1
GET (0, 0)-(15, 15), main
CLS

' **********

edgedraw:

GOTO nerp

thing:
clr(1) = 15
clr(2) = 7
clr(3) = 8
xxx = (b * 16)
yyy = (a * 16)
PUT (xxx, yyy), wall, PSET
RETURN

' ******
nerp:

' Draw status strip
PUT (16, 368), keyz, PSET
PUT (64, 368), bomb, PSET
PUT (128, 368), bface, PSET
PUT (296, 368), heart, PSET
LOCATE 24, 40: PRINT ":"
LOCATE 24, 4: PRINT ":"
LOCATE 24, 11: PRINT ":"
LOCATE 24, 19: PRINT ":"
IF mmind = 1 THEN GOTO mastermind
IF ending = 1 THEN GOTO ending

' Read original data

DIM q(30)
FOR m = 1 TO 22
READ q
NEXT m

newgame:
game = game + 1
IF game = 7 THEN GOTO success

GOSUB nocris: GOTO edge

nocris:
LOCATE 1, 49: PRINT "                "
IF crys = 0 THEN RETURN
FOR c = 1 TO crys
PUT (368 + c * 16, 0), crystal, PSET
NEXT c
RETURN

edge:
FOR b = 0 TO 22
a = 0
GOSUB thing
NEXT b
FOR a = 1 TO 21
b = 0
GOSUB thing
NEXT a
FOR a = 1 TO 21
b = 22
GOSUB thing
NEXT a
FOR b = 0 TO 22
a = 22
GOSUB thing
NEXT b

LOCATE 2, 3
PRINT "Reading data for maze:"; game
FOR a = 1 TO 21
FOR b = 1 TO 21
READ map(a, b)
orig(a, b) = map(a, b)
NEXT: NEXT
READ exa, exb, starta, startb
FOR zip = 1 TO 10
READ tela(zip), telb(zip)
NEXT zip
LOCATE 2, 3: PRINT "                           "
olife = life
ocrys = crys
GOTO ruberoid

soddy:
LOCATE 2, 3
PRINT "Reading data for maze:"; game
crys = ocrys
life = olife
keyno = 0
k = 0
GOSUB nocris
LOCATE 24, 5: PRINT "  "
FOR a = 1 TO 21
FOR b = 1 TO 21
map(a, b) = orig(a, b)
NEXT: NEXT
LOCATE 2, 3: PRINT "                           "
a = starta: b = startb

ruberoid:

' Draw exit
COLOR 14
LOCATE exa, exb: PRINT "EXIT"

'Default colours.
col1 = 15 'Main maze colour
col2 = 14 'Door colour
col3 = 13 'Key colour
col4 = 11 'Character colour
SCREEN 12


' Set start position
a = starta: b = startb
a$ = CHR$(17) + CHR$(16): b$ = CHR$(219) + CHR$(219): T$ = CHR$(168) + CHR$(63)
p$ = CHR$(58) + CHR$(58)
COLOR col1

' *  MAIN PROGRAM SEQUENCE  *

startmain:
IF life <= 0 THEN GOTO death
LOCATE 24, 20: PRINT life
LOCATE 24, 41: PRINT lives
IF a > 21 THEN a = 21
IF a < 1 THEN a = 1
IF b > 21 THEN b = 21
IF b < 1 THEN b = 1
 ' put a space on main character
PUT (b * 16, a * 16), main, PSET
aa = a + 1: bb = b * 2 + 1

' Draw blocks around character
FOR x = -1 TO 1
FOR y = -2 TO 2 STEP 2
doh = map(a + x, b + (y / 2))
xxx = (b + (y / 2)) * 16 - 1
yyy = (a + x) * 16 - 1
IF doh = 1 THEN GOTO blockdraw
IF doh > 1 AND doh < 28 THEN GOTO keydraw
IF doh > 27 AND doh < 54 THEN GOTO doordraw
IF doh = 54 THEN GOTO crysdraw
IF doh = 55 THEN a = xa: b = xb
IF doh = 56 THEN GOTO bombdraw
IF doh = 57 THEN GOTO rednex
IF doh = 58 THEN GOTO bluenex
IF doh = 59 THEN GOTO greenex
IF doh > 69 AND doh < 80 THEN GOTO portdraw
IF doh > 59 AND doh < 70 THEN GOTO teledraw
IF doh = 80 THEN GOTO blockdraw
IF doh > 80 THEN GOTO putletter

continue:
NEXT
NEXT
GOTO carryon

blockdraw:
IF wface = 1 THEN PUT (xxx, yyy), bface, PSET: GOTO flib
PUT (xxx, yyy), wall, PSET
flib:
GOTO continue
keydraw:
PUT (xxx, yyy), keyz, PSET
LOCATE aa + x, bb + y + 1: PRINT CHR$(doh + 63)
GOTO continue
doordraw:
PUT (xxx, yyy), door, PSET
LOCATE aa + x, bb + y + 1: PRINT CHR$((doh - 26) + 63)
GOTO continue
portdraw:
PUT (xxx, yyy), portcullis, PSET
GOTO continue
teledraw:
PUT (xxx, yyy), teleport, PSET
GOTO continue
putletter:
LOCATE aa + x, bb + y + 1
PRINT CHR$(map(a + x, b + y / 2) + 16)
GOTO continue
rednex:
PUT (xxx, yyy), rface, PSET
GOTO continue
bluenex:
PUT (xxx, yyy), bface, PSET
GOTO continue
greenex:
PUT (xxx, yyy), gface, PSET
GOTO continue
bombdraw:
PUT (xxx, yyy), bomb, PSET
GOTO continue
crysdraw:
PUT (xxx, yyy), crystal, PSET
GOTO continue

carryon:
' Draw character
PUT (b * 16, a * 16), main, PSET
GOTO piece

piece:
' Receive input
DO
q$ = INKEY$
LOOP UNTIL q$ <> ""
xa = a: xb = b
IF q$ = CHR$(0) + "H" THEN xa = xa - 1
IF q$ = CHR$(0) + "P" THEN xa = xa + 1
IF q$ = CHR$(0) + "K" THEN xb = xb - 1
IF q$ = CHR$(0) + "M" THEN xb = xb + 1
IF q$ = "d" THEN GOTO dropkey
IF q$ = "q" THEN GOTO rebirth
IF q$ = "b" THEN GOTO usebomb

' Find out next move and go to relevant routine
IF xa < 1 THEN xa = 1
IF xa > 21 THEN xa = 21
IF xb < 1 THEN xb = 1
IF xb > 21 THEN xb = 21
IF map(xa, xb) = 0 THEN LOCATE a + 1, b * 2 + 1: PRINT "  ": a = xa: b = xb: life = life - 1: GOTO startmain
IF map(xa, xb) = 1 THEN GOTO startmain
IF map(xa, xb) > 1 AND map(xa, xb) < 28 THEN GOTO keyroutine
IF map(xa, xb) > 27 AND map(xa, xb) < 54 THEN GOTO doorroutine
IF map(xa, xb) = 54 THEN GOTO getcrys
IF map(xa, xb) = 55 THEN GOTO biznis
IF map(xa, xb) = 56 THEN GOTO getbomb
IF map(xa, xb) = 57 THEN GOTO vlife
IF map(xa, xb) = 58 THEN GOTO xlife
IF map(xa, xb) = 59 THEN GOTO xxvlife
IF map(xa, xb) > 69 AND map(xa, xb) < 80 THEN GOTO trap
IF map(xa, xb) > 59 AND map(xa, xb) < 70 THEN GOTO teleport
IF map(xa, xb) = 80 THEN GOTO startmain
IF map(xa, xb) > 80 THEN GOTO piss
GOTO startmain

' Pick up a key when not holding one

keyroutine:

IF k = 1 THEN GOTO replacekey
' pick up first key
k = 1
keyno = map(xa, xb) - 1
LOCATE 24, 5: PRINT CHR$(keyno + 64)
map(xa, xb) = 0
piss:
LOCATE aa, bb: PRINT "  "
a = xa: b = xb: life = life - 1
GOTO startmain

' Pick up a key when holding another one

replacekey:
LOCATE 3, 49: PRINT "Do you want new key? Y/N "
DO:
q$ = INKEY$
LOOP UNTIL q$ <> ""
LOCATE 3, 49: PRINT "                          "
IF q$ <> "y" THEN GOTO yes
k = 1: funny = map(xa, xb)
map(xa, xb) = keyno + 1
keyno = funny - 1
yes:
LOCATE 24, 5: PRINT CHR$(keyno + 64)
LOCATE aa, bb: PRINT "  "
a = xa: b = xb: life = life - 1
GOTO startmain

' Drop a key

dropkey:
IF k = 0 THEN GOTO startmain
IF map(xa, xb) <> 0 THEN GOTO startmain
k = 0
map(xa, xb) = keyno + 1
keyno = 0
LOCATE 24, 5: PRINT " "
GOTO startmain

' Find a door
doorroutine:
IF k = 0 THEN GOTO fooey
LOCATE 24, 5: PRINT CHR$(keyno + 96)
fooey:
IF cheat = 1 THEN GOTO dooropen
IF k = 0 THEN GOTO startmain
doorno = map(xa, xb) - 27
IF keyno <> doorno THEN GOTO startmain

' Open a door

dooropen:
k = 0
keyno = 0
LOCATE 24, 5: PRINT "  "
map(xa, xb) = 0
a = xa: b = xb: life = life - 1
LOCATE aa, bb: PRINT "  "
GOTO startmain

teleport:
doris = map(xa, xb)
xb = tela(doris - 59)
xa = telb(doris - 59)
GOTO piss

trap:
abc = map(xa, xb) - 69
oo = 0: pp = 0
IF abc = 2 THEN pp = -1
IF abc = 3 THEN oo = 1: pp = -1
IF abc = 4 THEN oo = 1
IF abc = 5 THEN oo = 1: pp = 1
IF abc = 6 THEN pp = 1
IF abc = 7 THEN oo = -1: pp = 1
IF abc = 8 THEN oo = -1
IF abc = 9 THEN oo = -1: pp = -1
map(xa + pp, xb + oo) = 80
GOTO piss

getbomb:
bomb = bomb + 1
LOCATE 24, 12: PRINT bomb
map(xa, xb) = 0
GOTO piss

vlife:
life = life + 6
map(xa, xb) = 0
GOTO piss

xlife:
life = life + 11
map(xa, xb) = 0
GOTO piss

xxvlife:
life = life + 26
map(xa, xb) = 0
GOTO piss

usebomb:
IF bomb < 1 THEN GOTO startmain
bomb = bomb - 1
LOCATE 24, 12: PRINT bomb
FOR q = -1 TO 1
FOR p = -1 TO 1
h = p: i = q
IF a + h > 21 THEN a = 21: h = 0
IF a + h < 1 THEN a = 1: h = 0
IF b + i > 21 THEN b = 21: i = 0
IF b + i < 1 THEN b = 1: i = 0
IF map(a + h, b + i) > 79 OR map(a + h, b + i) = 55 THEN GOTO plop
map(a + h, b + i) = 0
LOCATE a + 1 + h, b * 2 + 1 + (i * 2)
PRINT "  "
plop:
NEXT p: NEXT q
GOTO piss

getcrys:
crys = crys + 1
map(xa, xb) = 0
GOSUB nocris
GOTO piss

biznis:
FOR y = 3 TO 44
FOR x = 2 TO 22
LOCATE x, y: PRINT " "
NEXT x, y
xxx = 0
yyy = 0
a = 0
b = 0
aa = 0
bb = 0
doh = 0
k = 0
keyno = 0
IF bomb > 99 THEN bomb = 1000: GOTO newgame
bomb = 0
GOTO newgame

' Out of life

rebirth:
lives = lives - 1
IF lives = 0 THEN GOTO death
FOR y = 3 TO 44
FOR x = 2 TO 22
LOCATE x, y: PRINT " ";
NEXT: NEXT
GOTO soddy

death:
COLOR 12
FOR y = 3 TO 44
FOR x = 2 TO 22
LOCATE x, y: PRINT " ";
NEXT: NEXT
COLOR 12
FOR noop = 16 TO 351
LINE (16, noop)-(351, noop)
NEXT noop
FOR noop = 16 TO 351
LINE (16, noop)-(351, noop)
NEXT noop
FOR y = 3 TO 44
FOR x = 2 TO 22
LOCATE x, y: PRINT " ";
NEXT: NEXT
COLOR 12

COLOR col1
LOCATE 3, 3: PRINT " G A M E   O V E R ! ! !"
LOCATE 5, 3: PRINT " You are now dead. "
END


' Reach goal

success:
FOR y = 3 TO 44
FOR x = 2 TO 22
LOCATE x, y: PRINT " "
NEXT x, y
'  IF ending = 1 THEN GOTO thend

ending:
' IF ending = 1 THEN GOTO thend
FOR ppp = 16 TO 336 STEP 16
FOR ooo = 16 TO 336 STEP 16
wun = INT(RND * 3) + 1
IF wun = 1 THEN PUT (ooo, ppp), rface
IF wun = 2 THEN PUT (ooo, ppp), bface
IF wun = 3 THEN PUT (ooo, ppp), gface
NEXT ooo
NEXT ppp

COLOR 14
FOR noop = 16 TO 351
LINE (16, noop)-(351, noop)
NEXT noop
COLOR 0
FOR noop = 16 TO 351
LINE (16, noop)-(351, noop)
NEXT noop

FOR ppp = 336 TO 16 STEP -16
FOR ooo = 336 TO 16 STEP -16
PUT (ooo, ppp), colour
NEXT: NEXT
DATA 15,7,8,0
FOR p = 1 TO 4
READ nob(p)
NEXT p

DATA 0,0,8,8,7,7,15,15,7,7,8,8
DIM c(12)
FOR m = 1 TO 12: READ c(m)
NEXT m: m = 0
FOR z = 16 TO 351
m = m + 1: IF m = 13 THEN m = 0
COLOR c(m)
LINE (z, 16)-(16, z), c(m)
NEXT z
FOR z = 16 TO 351
m = m + 1: IF m = 13 THEN m = 0
COLOR c(m)
LINE (351, z)-(z, 351), c(m)
NEXT z
FOR ooo = 16 TO 352
LINE (ooo, 16)-(ooo, 352), 0
NEXT ooo

CLS : COLOR 15
IF crys = 1 THEN PRINT "You have 1 crystal."
IF crys <> 1 THEN PRINT "You have"; crys; "crystals."
PUT (104, 72), main
c = crys
IF c > 0 THEN PUT (104, 40), crystal: GOSUB xyz
c = c - 1
IF c > 0 THEN PUT (72, 88), crystal: GOSUB xyz
c = c - 1
IF c > 0 THEN PUT (136, 88), crystal: GOSUB xyz
c = c - 1
IF c > 0 THEN PUT (104, 104), crystal: GOSUB xyz
c = c - 1
IF c > 0 THEN PUT (72, 56), crystal: GOSUB xyz
c = c - 1
IF c > 0 THEN PUT (136, 56), crystal: GOSUB xyz
IF crys = 0 THEN a$ = "As much skill as a disembowelled hamster."
IF crys = 1 THEN a$ = "Vegetable rating: cabbage"
IF crys = 2 THEN a$ = "Fruit rating: mango"
IF crys = 3 THEN a$ = "Not exactly Long John Silver."
IF crys = 4 THEN a$ = "You're hard. No,really."
IF crys = 5 THEN a$ = "You're almost cheese status."
IF crys = 6 THEN a$ = "You are now officially quite good."
LOCATE 9, 1: PRINT a$
IF crys = 6 THEN GOTO welldone
PRINT "Sadly,you're not good enough.Have a cold shower and try again."
FOR w = 1 TO 2500: NEXT w
go:
PRINT "Press enter to reset."
COLOR 0
INPUT a$
COLOR 15
RUN
xyz: FOR w = 1 TO 1000: NEXT w: RETURN

' MASTERMIND
welldone:
PRINT "Press enter to continue."
INPUT a$
IF cheatmode = 1 THEN GOTO thend
CLS : COLOR 15
PRINT "MASTERMIND"
PRINT "Guess the combination within 5 goes."
PRINT "Use the numbers from 1-6 to guess."
PRINT "Press space to enter or # to delete."
PRINT "+ signifies correct colour and correct position."
PRINT "- signifies correct colour and wrong position."
PRINT "Press enter to continue."
INPUT a$

mastermind:

RANDOMIZE TIMER
SCREEN 12
COLOR 15
CLS
PRINT "  *** MASTERMIND *** "
PRINT
RESTORE:
FOR z = 1 TO 16: READ q: NEXT z
DATA 12,14,2,9,7,15
FOR x = 1 TO 6
READ cl(x)
COLOR cl(x): PRINT x;
NEXT x

PRINT
COLOR 15
FOR zit = 1 TO 4
ans(zit) = INT(RND * 6) + 1
NEXT zit
PRINT
PRINT "       ";
FOR x = 1 TO 4
COLOR 15: PRINT "? ";
NEXT x
COLOR 15
PRINT
PRINT
PRINT " Turn  1 2 3 4  Result"
PRINT
T = 0

' MAIN SEQUENCE

mainstart:
T = T + 1
IF T = 6 THEN GOTO failure
LOCATE T + 7, 2: PRINT T
row = 0
newrow:
row = row + 1
LOCATE T + 7, row * 2 + 6: COLOR 15: PRINT "?"
nipnip:
DO
q$ = INKEY$
LOOP UNTIL q$ <> ""
IF VAL(q$) < 1 OR VAL(q$) > 6 THEN GOTO nipnip
guess(row) = VAL(q$)
LOCATE T + 7, row * 2 + 6: COLOR cl(VAL(q$)): PRINT CHR$(2): IF row = 4 THEN COLOR 15: GOTO check
GOTO newrow

check:

row = 0: LOCATE T + 7, 17: PRINT "Space/#"
DO:
q$ = INKEY$
LOOP UNTIL q$ <> ""
LOCATE T + 7, 17: PRINT "       "
IF q$ = "#" THEN GOTO newrow
LOCATE T + 7, 17: PRINT "       "

' CHECKING FOR BLACK

row = 0: win = 0
FOR x = 1 TO 4
x(x) = 0: y(x) = 0
NEXT x
LOCATE T + 7, row + 17
newrow2: row = row + 1
IF guess(row) = ans(row) THEN PRINT "+"; : x(row) = 1: y(row) = 1: win = win + 1
IF row <> 4 THEN GOTO newrow2

' Checking if you have won...
IF win = 4 THEN GOTO thend

' CHECKING FOR WHITE

row = 0
newrow3: row = row + 1
FOR a = 1 TO 4
IF guess(row) <> ans(a) THEN GOTO necks
IF x(row) > 0 THEN GOTO necks
IF y(a) > 0 THEN GOTO necks
x(row) = 2
y(a) = 2
PRINT "-";
necks: NEXT a
IF row = 4 THEN GOTO mainstart
GOTO newrow3

failure:
CLEAR : CLS : GOTO mastermind

' The End.
thend:
CLS : COLOR 15
a1 = 0
FOR d = 100 TO 0 STEP -.75
a1 = a1 + 1: IF a1 = 360 THEN a1 = 0
IF a1 < 90 OR (a1 < 270 AND a1 > 179) THEN GOTO sub1
IF (a1 < 180 AND a1 > 89) OR a1 > 269 THEN GOTO sub2
sub1:
x = d * SIN(a1)
y = d * COS(a1)
PUT (x + 100, -y + 100), crystal
GOTO nex
sub2:
x = d * COS(a1)
y = d * SIN(a1)
PUT (-x + 100, y + 100), crystal
GOTO nex
nex:
NEXT d: GOTO endrew

endrew:
FOR w = 1 TO 5000: NEXT w
COLOR 15
LOCATE 15, 1: PRINT "Press space to reset."
bidum:
COLOR INT(RND(1) * 16 + 0)
LOCATE 1, 1: PRINT "THE END"
FOR w = 1 TO 3: NEXT w
q$ = INKEY$: IF q$ <> " " THEN GOTO bidum
FOR w = 1 TO 1000: NEXT w: RUN

anykey:
LOCATE 24, 1: PRINT " Press any key to play again, or Q to quit."
DO: q$ = INKEY$: LOOP UNTIL q$ <> ""
IF q$ = "q" THEN END
CLEAR : RESTORE: GOTO restart

cheatend:
LOCATE 3, 3: PRINT " Don't be a complete spak. "
LOCATE 4, 3: PRINT " Start again and DON'T USE ANY CHEATS!"
LOCATE 5, 3: PRINT " You sad person.": GOTO anykey

' THIS IS AN OFFICIAL COPY OF ENIGMA, BY ANDREW CLARE.

'**************************************************************************





