/******************************************************************************\
**
** Project:		FistFight - DOS - SunStar
**
** Module:		Startup Module
**
** Programmer:	Mike Collins
**				561 S  1020 W
**				Orem, UT 84058
**				(801) 229-1837
**
** Description:
**				This is the startup code for FistFight.
**				All this program does is to pull up the SunStar Presents screen
**				and then the FistFight logo screen.
**				Each of these screens time out after 10 seconds or can be
**				canceled by pressing any key.
**
** Compiler:	Borland C++ version 3.1 or greater. Was tested with 4.52
**
** To make:		Compile FIST.CPP
**				Link	FIST.CPP,
**						EMS.LIB
**						and standard Borland LARGE MODEL libraries.
**
\******************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include "ems.h"
#include "bitmap.h"

FILE				*sslogo;
FILE				*fflogo;
BITMAPFILEHEADER	bmfh;
BITMAPINFOHEADER	bmih;
RGBQUAD				rgb[256];
char				*bmp;
char				*screen;

short	readBmp( FILE *infile );
void	displayBmp();
void	setPalette();
void	fadePalette( BYTE black );
void	waitKey();


void main()
{
	void	*tptr;
	short	pages = 0;

	clrscr();
	printf( "Fistfight(tm)\n\n" );
	tptr = farmalloc( 545000l );
	if( tptr )
		free( tptr );

	if( EMSAvailable() )
	{
		pages = EMSGetFreeCount();
	}

	if( tptr == NULL || pages < 162 )
	{
		if( tptr == NULL && pages < 162 )
		{
			printf( "Not enough conventional memory or EMS to run Fistfight.\n" );
		} else
		if( tptr == NULL )
		{
			printf( "Not enough conventional memory to run Fistfight.\n" );
		} else
		if( pages < 162 )
		{
			printf( "Not enough EMS to run Fistfight.\n" );
		}

		printf( "Conventional memory needed:  580k\n" );
		printf( "EMS memory needed:          2580K\n\n" );
		exit( 1 );
	}


	sslogo = fopen( "sslogo.bmp", "rb" );
	if( sslogo == NULL )
	{
		printf( "The file SSLOGO.BMP is missing. Please re-install Fistfight\n" );
		exit(1);
	}

	fflogo = fopen( "fflogo.bmp", "rb" );
	if( fflogo == NULL )
	{
		printf( "The file FFLOGO.BMP is missing. Please re-install Fistfight\n" );
		exit(1);
	}

	bmp = new char[ (WORD)64000l ];

	asm {
		mov	ax,0x13
		int	0x10
	}

	fadePalette( 1 );

	readBmp( sslogo );
	displayBmp();
	setPalette();
	waitKey();

	fadePalette( 1 );

	readBmp( fflogo );
	displayBmp();
	setPalette();
	waitKey();

	fadePalette( 1 );

	delete bmp;
	fclose( sslogo );
	fclose( fflogo );

	asm {
		mov	ax,0x03
		int	0x10
	}

    exit( 0 );
}



void	waitKey()
{
	struct time	t;
	long	val1, val2;
	gettime( &t );
	val1 = t.ti_hour*3600 + t.ti_min*60 + (t.ti_sec += 10);
	while( 1 )
	{
		gettime( &t );
		val2 = t.ti_hour*3600 + t.ti_min*60 + t.ti_sec;
		if( val2 > val1 )
			break;

		if( kbhit() )
		{
			while( kbhit() )
				getch();

			break;
		}
	}
}



void	fadePalette( BYTE black )
{
	RGBTRIPLE				temprgb[256];
	for( int i = 0; i < 256; i++ )
	{
		temprgb[i].red		= rgb[i].red/4;
		temprgb[i].green	= rgb[i].green/4;
		temprgb[i].blue		= rgb[i].blue/4;
	}

	short	offs = FP_OFF( &temprgb );
	short	segm = FP_SEG( &temprgb );
	for( int j = 0; j < 64; j++ )
	{
		if( black )
		{
			for( int i = 0; i < 256; i++ )
			{
				if( temprgb[i].red )	temprgb[i].red--;
				if( temprgb[i].green)	temprgb[i].green--;
				if( temprgb[i].blue)	temprgb[i].blue--;
			}
		} else
		{
			for( int i = 0; i < 256; i++ )
			{
				if( temprgb[i].red < 63)	temprgb[i].red++;
				if( temprgb[i].green < 63)	temprgb[i].green++;
				if( temprgb[i].blue < 63)	temprgb[i].blue++;
			}
		}

		asm {
			mov	es,segm
			mov	ax,0x1012
			mov bx,0
			mov	cx,256
			mov	dx,offs
			int	0x10
		}
	}
}


void	setPalette()
{
	RGBTRIPLE				temprgb[256];
	for( int i = 0; i < 256; i++ )
	{
		temprgb[i].red		= rgb[i].red/4;
		temprgb[i].green	= rgb[i].green/4;
		temprgb[i].blue		= rgb[i].blue/4;
	}
	short	offs = FP_OFF( &temprgb );
	short	segm = FP_SEG( &temprgb );
	asm {
		mov	es,segm
		mov	ax,0x1012
		mov bx,0
		mov	cx,256
		mov	dx,offs
		int	0x10
	}
}


void	displayBmp()
{
	WORD	j, i;
	j = (WORD)bmih.biSizeImage-320;
	i = 0;

	screen = (char *)MK_FP(0xA000,0);

	for( int y = 0; y < 200; y++ )
	{
		for( int x = 0; x < 320; x++ )
		{
			screen[i++] = bmp[j++];
		}

		j-=640;
	}
}


short	readBmp( FILE *infile )
{
	fread( (void *)&bmfh, sizeof( bmfh ), 1, infile );
	fread( (void *)&bmih, sizeof( bmih ), 1, infile );

	if( bmih.biSizeImage != (DWORD)64000l )
		return 1;

	fread( (void *)&rgb, (size_t)(sizeof( RGBQUAD ) * 256), 1, infile );
	fseek( infile, (long)bmfh.bfOffBits, SEEK_SET );
	fread( (void *)bmp, (size_t)64000l, 1, infile );
	fclose( infile );
	return 0;
}
