unit psoft2;
{esta es una unit que ayuda a realizar ventanas de dilogo.
Incluye un procedimiento para gestionar ficheros}

interface
type t_ruta=string[80];
     t_nom=string[12];
     t_barrai=record
                 prime,ulti,max,x,y,ancho,alto:integer;
                 c0,c1,c2,c3:byte;
                 vertical,mas_de_1:boolean;
              end;

function camino(ruta:t_ruta;nombre:t_nom):string;
procedure bloque(x1,y1,x2,y2:word;h,c1,c2,c3:byte);
procedure mensaje(m:string);
procedure edita_nombre_f(x,y:word;var nombre:t_nom;tipo:boolean);
procedure ventana_de_ficheros(titulo:t_ruta;var ruta:t_ruta;
          var nombre:t_nom;tipo:t_nom;var salvar:boolean);
procedure borra_barrai(var barra:t_barrai);
procedure pon_barrai(barra:t_barrai);
procedure usa_barrai(var barra:t_barrai);
procedure mueve_por_menu(tecla:char;var pri,selec:word;max,l:word;var act:boolean);

implementation
uses psoft1,graph,crt,dos;



function camino;
begin
if length(ruta)>3 then camino:=ruta+'\'+nombre
                  else camino:=ruta+nombre
end;



procedure bloque;
var i:word;
begin
 setfillstyle(1,c2);
 bar(x1,y1,x2,y2);
 for i:=0 to h-1 do begin
    setcolor(c1);
    line(x1+i,y2-i,x1+i,y1+i);
    line(x1+i,y1+i,x2-i,y1+i);
    setcolor(c3);
    line(x2-i,y1+i,x2-i,y2-i);
    line(x2-i,y2-i,x1+i,y2-i);
 end;
end;



procedure mensaje;
var pri,i,prov,y:byte;
    mm:string;
begin
 i:=0; y:=0;
 repeat
    pri:=i;
    repeat
       i:=i+1;
       if m[i]=' ' then prov:=i;
    until (i-pri>=30) or (i>=length(m));
    if prov=pri then prov:=i {caso de palabra muy larga}
    else if i=length(m) then prov:=i; {caso de fin de cadena}
    i:=prov;
    y:=y+1;
 until i>=length(m);

 bloque(30,90-y*4,290,110+y*4,2,15,7,8);
 y:=100-y*4;
 setcolor(0);
 i:=0;
 repeat
    pri:=i;
    repeat
       i:=i+1;
       if m[i]=' ' then prov:=i;
    until (i-pri>=30) or (i>=length(m));
    if prov=pri then prov:=i {caso de palabra muy larga}
    else if i=length(m) then prov:=i; {caso de fin de cadena}
    mm:=copy(m,pri+1,prov-pri);
    i:=prov;
    outtextxy(160-length(mm)*4,y,mm);
    y:=y+10;
 until i>=length(m);
 espera_pulsar_boton(rat_cualquiera);
end;




procedure edita_nombre_f;
{'Tipo' indica si se pueden introducir comodines ('*' y '?')}
const enter=chr(13);
      retroceso=chr(8);
var c:char;
    procedure pon_nombre(nombre:t_nom);
   begin
      setfillstyle(1,0);
      setcolor(15);
      bar(x,y,x+8*13,y+7);
      outtextxy(x,y,nombre+'');
   end;
 begin
 quita_cursor_de_raton;
 pon_nombre(nombre);
 repeat
    c:=readkey;
    case c of
      retroceso:if length(nombre)>0
                   then nombre:=copy(nombre,1,length(nombre)-1);
      '!'..')','+'..'-','0'..'9',';'..'>','@'..chr(255): {carac vlidos}
         if length(nombre)<12 then nombre:=nombre+c;
      '.':if (pos(c,nombre)=0) and (length(nombre)>0)
             then nombre:=nombre+c;
      '*','?':if tipo then nombre:=nombre+c;
    end;
    pon_nombre(nombre);
 until (c=enter) and not((length(nombre)=0)and tipo);
 setfillstyle(1,0);
 bar(x+length(nombre)*8,y,x+length(nombre)*8+8,y+7);
 pon_cursor_de_raton;
end;






procedure ventana_de_ficheros;
{presenta una ventana de dilogo para seleccionar un archivo
entre los directorios. 'salvar' indica el tipo de llamada a este
procedimiento. A la salida, salvar indica si se acept o se cancel.
Ej. de 'tipo': '*.*'}

type t_ficheros=array[1..256] of t_nom;
var lista:t_ficheros;
    nf,nd,pri:byte;
    f:file; {para borrar}

  procedure lee_directorio(ruta:t_ruta;nom:t_nom;var ficheros:t_ficheros;
            var nf,nd,pri:byte);
  {la ruta debe llevar unidad. Al salir nd apunta a la ltima entrada de
  tipo subdirectorio, y nf a la ltima entrada vlida}
  const temporal='temp.$$$';
  var temp:text;
      i:byte;
  begin
   pri:=1;
   assign(temp,temporal);
   setcolor(0);
   gotoxy(1,2);
   exec('\command.com','/c dir '+ruta+' /on /b /ad >'+temporal);

   i:=4;
   lista[1]:='A:';
   lista[2]:='B:';
   lista[3]:='C:';
   lista[4]:='D:';
   if length(ruta)>3 then begin
      inc(i);
      lista[i]:='..';
   end;
   reset(temp); {leemos directorios}
   while not eof(temp) and (i<255) do begin
      inc(i);
      readln(temp,ficheros[i]);
   end;
   nd:=i;
   close(temp);

   gotoxy(1,2);
   exec('\command.com','/c dir '+camino(ruta,nom)+' /on /b /a-d >'+temporal);
   reset(temp); {leemos archivos}
   while not eof(temp) and (i<255) do begin
      inc(i);
      readln(temp,ficheros[i]);
   end;
   nf:=i;
   close(temp);

   erase(temp);
  end;


  procedure pon_ruta(ruta:t_ruta);
  begin
   bloque(20,50,20+8*35,60,1,8,0,15);
   setcolor(15);
   if length(ruta)>34 then
      ruta:=copy(ruta,1,3)+'...'+copy(ruta,length(ruta)-28+1,28);
   outtextxy(22,52,ruta);
  end;


  procedure pon_nombre(var nombre:t_nom);
  begin
   bloque(20,65,20+8*14,75,1,8,0,15);
   setcolor(15);
   outtextxy(22,67,nombre);
  end;


  procedure pon_tipo(var tipo:t_nom);
  begin
   bloque(160,65,160+8*14,75,1,8,0,15);
   setcolor(15);
   outtextxy(162,67,tipo);
  end;


  procedure scroll_de_ficheros(var lista:t_ficheros;nf,nd,pri:byte);
  var i:byte;
  begin
   quita_cursor_de_raton;
   bloque(20,80,20+8*14,180,1,8,0,15);
   setcolor(15);
   i:=pri-1;
   while (i<nd) and (i<pri+9) do begin
      inc(i);
      outtextxy(22,82+(i-pri)*10,'<'+lista[i]+'>');
   end;
   while (i<nf) and (i<pri+9) do begin
      inc(i);
      outtextxy(22,82+(i-pri)*10,lista[i]);
   end;
   pon_cursor_de_raton;
  end;

  function esta_en_lista(nom:t_nom;var l:t_ficheros;nf:byte):boolean;
  var i:byte;
  begin
   i:=1;
   while (l[i]<>nom) and (i<>nf) do
      inc(i);
   if l[i]=nom then esta_en_lista:=true
               else esta_en_lista:=false;
  end;


  procedure presenta_ventana;
  begin
   quita_cursor_de_raton;
   bloque(10,25,310,195,2,15,7,8); {de ventana}
   bloque(14,29,306,39,1,8,7,15); {de titulo}
   bloque(22+8*14,80,37+8*14,95,1,15,7,8); {de arriba}
   bloque(22+8*14,100,37+8*14,115,1,15,7,8); {de abajo}
   bloque(180,90,265,105,2,15,7,8); {de aceptar}
   bloque(180,110,265,125,2,15,7,8); {de cancelar}
   bloque(180,160,265,175,2,15,7,8); {de Borrar}

   setcolor(0);
   outtextxy(160-length(titulo)*4,31,titulo);
   outtextxy(26+8*14,84,chr(30));
   outtextxy(26+8*14,104,chr(31));
   if salvar then outtextxy(190,94,' Salvar')
             else outtextxy(190,94,' Cargar');
   outtextxy(190,114,'Cancelar');
   outtextxy(190,164,' Borrar ');
   pon_ruta(ruta);
   pon_nombre(nombre);
   pon_tipo(tipo);
   scroll_de_ficheros(lista,nf,nd,pri);
   pon_cursor_de_raton;
  end;


  procedure elegir_fichero(var nombre:t_nom;var ruta:t_ruta;
            var lista:t_ficheros;var nf,nd,pri:byte);
  var y:byte;
  begin
   y:=(y_raton-80) div 10+pri;
   if y<5 then begin {caso de unidades}
      {$i-}
      gotoxy(1,2);
      exec(lista[y]+'\asd','');
      {$i+}
      if (doserror in [0,2]) then begin
         getdir(y,ruta);
         nombre:='';
         lee_directorio(ruta,tipo,lista,nf,nd,pri);
      end
      else begin
         quita_cursor_de_raton;
         mensaje('Error al pasar a la unidad especificada');
         pon_cursor_de_raton;
      end;
      presenta_ventana;
   end
   else if (y<=nd) then begin  {directorio}
      if lista[y]='..' then begin {caso hacia atrs}
         while ruta[length(ruta)]<>'\' do
            ruta:=copy(ruta,1,length(ruta)-1);
         if length(ruta)>3 then ruta:=copy(ruta,1,length(ruta)-1); {quita '\'}
      end
      else {caso hacia alate}
      ruta:=camino(ruta,lista[y]);
      lee_directorio(ruta,tipo,lista,nf,nd,pri);
      scroll_de_ficheros(lista,nf,nd,pri);
      nombre:='';
      pon_nombre(nombre);
      pon_ruta(ruta);
   end
   else if (y<=nf) then begin {archivo}
      nombre:=lista[y];
      pon_nombre(nombre);
   end;
  end; {de elgir fichero}

begin {de ventana_de_ficheros}
lee_directorio(ruta,tipo,lista,nf,nd,pri);
presenta_ventana;
repeat
   espera_pulsar_boton(rat_cualquiera);
   if ratonv_en_ventana(134,80,149,95) then begin {caso de pulsar arriba}
      while boton_presionado(rat_izquierdo) and (pri>1) do begin
         dec(pri); {de uno en uno}
         delay(50);
         scroll_de_ficheros(lista,nf,nd,pri);
      end;
      while boton_presionado(rat_derecho) and (pri>1) do begin
         if pri>10 then pri:=pri-10 else pri:=1; {de 10 en 10}
         delay(50);
         scroll_de_ficheros(lista,nf,nd,pri);
      end;
   end
   else if ratonv_en_ventana(134,100,149,115) then begin {caso de pulsar abajo}
      while boton_presionado(rat_izquierdo) and (pri<nf-9) do begin
         inc(pri); {de uno en uno}
         delay(50);
         scroll_de_ficheros(lista,nf,nd,pri);
      end;
      while boton_presionado(rat_derecho) and (pri<nf-9) do begin
         if pri<nf-18 then pri:=pri+10 else pri:=nf-9;
         delay(50); {de 10 en 10}
         scroll_de_ficheros(lista,nf,nd,pri);
      end;
   end
   else if ratonv_en_ventana(20,80,132,180) then
      elegir_fichero(nombre,ruta,lista,nf,nd,pri) {ficheros}
   else if ratonv_en_ventana(20,65,132,75) then begin
      if salvar then edita_nombre_f(22,67,nombre,false); {edita nombre}
   end
   else if ratonv_en_ventana(160,65,272,75) then begin {edita tipo}
      edita_nombre_f(162,67,tipo,true);
      lee_directorio(ruta,tipo,lista,nf,nd,pri);
      scroll_de_ficheros(lista,nf,nd,pri);
      nombre:='';
      pon_nombre(nombre);
      pon_ruta(ruta);
   end
   else if ratonv_en_ventana(180,160,265,175) then begin
      if esta_en_lista(nombre,lista,nf) and
      se_puede_escribir(camino(ruta,'')) then begin
        {$i+}
        assign(f,camino(ruta,nombre));
        erase(f);
        {$i-}
        lee_directorio(ruta,tipo,lista,nf,nd,pri);
        scroll_de_ficheros(lista,nf,nd,pri);
        nombre:='';
        pon_nombre(nombre);
        pon_ruta(ruta);
      end
      else begin
        mensaje('No se pudo borrar el fichero');
        presenta_ventana;
      end;
   end;

until ratonv_en_ventana(180,90,265,105) and (nombre<>'') {aceptar}
      or ratonv_en_ventana(180,110,265,125); {cancelar}
salvar:=ratonv_en_ventana(180,90,265,105);
quita_cursor_de_raton;
end; {de ventana_de_ficheros}


procedure borra_barrai;
begin
with barra do begin
   prime:=1;
   ulti:=1;
   max:=0;
end;
end;


procedure pon_barrai;
var s1,s2,s3:string[5];
begin
with barra do begin{todo el procedimiento}
if vertical then begin
end
else begin {horizontal}
   bloque(x,y,x+ancho+5,y+alto+12,1,c3,c2,c1);
   x:=x+3;y:=y+3;
   bloque(x+alto,y,x+ancho-alto,y+alto-1,1,c0,c3,c1);
   if max>0 then bloque(x+alto+round((ancho-3*alto)/max *(prime-1)),y,
          x+alto-1+round((ancho-3*alto)/max*ulti+alto),y+alto-1,1,c1,c2,c3);
   bloque(x,y,x+alto-1,y+alto-1,1,c1,c2,c3);
    setcolor(c1);line(x+alto-1,y,x,y+ alto div 2);
    setcolor(c3);line(x+alto-1,y+alto-1,x,y+ alto div 2);
   bloque(x+ancho-alto,y,x+ancho-1,y+alto-1,1,c1,c2,c3);
    setcolor(c1);line(x+ancho-alto,y,x+ancho-1,y+ alto div 2);
    setcolor(c3);line(x+ancho-alto,y+alto-1,x+ancho-1,y+ alto div 2);

   setcolor(c0);
   str(prime,s1);str(ulti,s2);str(max,s3);
   if mas_de_1 then outtextxy(x,y+alto+1,s1+'-'+s2+'  '+s3)
               else outtextxy(x,y+alto+1,s1+' de '+s3);
end;
end{de with}
end;



procedure usa_barrai;
begin
quita_cursor_de_raton;
   with barra do
   if vertical then begin
   end{de vertical}
   else begin {horizontal}
      if ratonv_en_ventana(x+3,y+3,x+alto+2,y+alto+2) then begin{flecha izq}
         if boton_presionado(rat_izquierdo) then
            while boton_presionado(rat_izquierdo) and (prime>1) do begin
               dec(prime);dec(ulti); {boton izq}
               delay(70); pon_barrai(barra);
            end
         else if boton_presionado(rat_derecho) then {boton der}
            while boton_presionado(rat_derecho) do begin
               if mas_de_1 then begin
                  if (ulti>prime) then begin
                     dec(ulti); {aumenta selec}
                     delay(70); pon_barrai(barra);
                  end;
               end
               else if prime>10 then begin
                  prime:=prime-10;ulti:=ulti-10; {mueve rpido}
                  delay(70); pon_barrai(barra);
               end                               {}
               else if prime>1 then begin        {}
                  ulti:=ulti-prime+1;prime:=1;   {}
                  delay(70); pon_barrai(barra);
               end;
            end
      end {de flecha izq}
      else if ratonv_en_ventana(x+ancho-alto+3,y+3,x+ancho+2,y+alto+2) then begin {flecha der}
         if boton_presionado(rat_izquierdo) then
            while boton_presionado(rat_izquierdo) and (ulti<max) do begin
               inc(prime);inc(ulti); {boton izq}
               delay(70); pon_barrai(barra);
            end
         else if boton_presionado(rat_derecho) then {boton der}
            while boton_presionado(rat_derecho) do begin
               if mas_de_1 then begin
                  if (ulti<max) then begin
                     inc(ulti); {aumenta selec}
                     delay(70); pon_barrai(barra);
                  end;
               end
               else if (ulti<=max-10) then begin
                  prime:=prime+10;ulti:=ulti+10; {mueve rpido}
                  delay(70); pon_barrai(barra);
               end                               {}
               else if ulti<max then begin       {}
                  prime:=prime+max-ulti;ulti:=max;{}
                  delay(70); pon_barrai(barra);
               end;
            end
      end {de flecha der}
      else if boton_presionado(rat_izquierdo) then {barra b_izq}
         while boton_presionado(rat_izquierdo) and (max<>0) do begin
            ulti:=ulti-prime;
            prime:=round((xv_raton-x-1.7*alto)/(ancho-3*alto)*max)+1;
            if prime<1 then prime:=1
               else if prime>max-ulti then prime:=max-ulti;
            ulti:=prime+ulti;
            delay(70); pon_barrai(barra);
         end {de barra b_izq}
      else if boton_presionado(rat_derecho) then {barra b_der}
         while boton_presionado(rat_derecho) and (max<>0) do begin
            ulti:=round((xv_raton-x-1.7*alto)/(ancho-3*alto)*max)+1;
            if ulti<prime then ulti:=prime
               else if ulti>max then ulti:=max;
            delay(70); pon_barrai(barra);
         end;
   end; {de horizontal}
pon_cursor_de_raton;
end;

procedure mueve_por_menu;
{tecla debe ser la tecla leda despus de leer NULO}
begin
act:=false;
case tecla of
  arriba:if selec>1 then begin
            dec(selec); act:=true;
         end;
  abajo:if selec<max then begin
            inc(selec); act:=true;
         end;
  inicio:if selec>1 then begin
            selec:=1; act:=true;
         end;
  fin:if selec<max then begin
            selec:=max; act:=true;
         end;
  repag:if selec>l then begin
            selec:=selec-l; act:=true;
         end
         else if selec>1 then begin
            selec:=1; act:=true;
         end;
  avpag:if selec<max+1-l then begin
            selec:=selec+l; act:=true;
         end
         else if selec<max then begin
            selec:=max; act:=true;
         end;
end;{del case}
if selec<pri then pri:=selec
else if selec>=pri+l then pri:=selec-l+1;
end;

end.