PROGRAM VToolTest;
{
 *************************************************************************
 *  Programa de demostracin de la Unit VOCTOOL, (W) en Borland Pascal   *
 *************************************************************************
 *                     (C) 1994 DATA BECKER GmbH & Co.                   *
 *                            MARCOMBO S.A.                              *
 *                         Autor : Axel Stolz                            *
 *************************************************************************
 * El lmite superior de memoria del programa principal se ha de bajar,  *
 * ya que sino el programa ocupa la memoria completa disponible. De modo *
 * que no queda memoria libre para el controlador y los datos de sam-    *
 * pling. Los parmetros de memoria se han de adaptar segn el programa  *
 * principal.                                                            *
 *************************************************************************
}

{$M 16000,0,50000}

USES Crt,Voctool;

VAR
   Sound : Pointer; { Puntero a los datos de sampling en memoria }
   Check : BOOLEAN; { Flag para la los controles booleanos   }
   Ch    : CHAR;    { Bfer de caracteres para la entrada de usuario }

PROCEDURE Error;
{
 * ENTRADA  : ninguna, los datos proceden de la variable global VOCErrStat
 * SALIDA   : ninguna
 * FUNCION  : Visualiza en pantalla el error SB como texto, incluido el
              nmero de error, y termina el programa con el Errorlevel que
              le corresponde el error.
}
BEGIN
   Write(' Error #',VOCErrStat:3,' =');
   PrintVOCErrMessage;
   WriteLn;
   HALT(VOCErrStat);
   END;

BEGIN
  ClrScr;

{ Controlador no ha sido inicializado }
  IF Not(VOCDriverInstalled) THEN Error;

{ Cargar el archivo DEMO.VOC en memoria }
  Check := VOCGetBuffer(Sound,'DEMO.VOC');

{ Archivo VOC no se pudo cargar }
  IF Not(Check) THEN Error;

{ Bucle principal del programa}
  WriteLn('Quiere escuchar el sonido (u)na vez o (v)arias?');
  Write('Opcin (u/v) : '); Ch := ReadKey; WriteLn; WriteLn;
  CASE UpCase(Ch) OF
   'U' : BEGIN
            Write('Pulse una tecla para interrumpir el sonido...');
            VOCOutput(Sound);
            REPEAT UNTIL KeyPressed OR (VOCStatusWord = 0);
            IF KeyPressed THEN VOCStop;
            END;
   'V' : BEGIN
            Ch := #0;
            Write('Pulse <ESC> para cancelar...');
            REPEAT
               VOCOutputLoop(Sound);
               REPEAT UNTIL KeyPressed OR (VOCStatusWord = 0);
               IF KeyPressed THEN Ch := ReadKey;
               UNTIL Ch = #27;
            VOCStop;
            END;
   END;

{ Liberar memoria del archivo VOC }
  Check := VOCFreeBuffer(Sound);
  IF Not(Check) THEN Error;
  END.
