PROGRAM TETRIS;
{ conu, emball et ficel
  par...  VIDAL    Dominique
          PEREIRA  Alfredo   }

USES
 crt;

CONST
 ncarre          = 4;
 npiece          = 7;
 npiece4         = npiece*4;

 xmax            = 10;
 ymax            = 20;
 xdecal          = 4;
 ydecal          = 24;

 score_ligne     = 10;
 score_piece     = 1;

 delais          = 1000;
 temps_init      = 10000;

 espace          = ' ';
 gf              = '';  {gris fonce}
 g               = '';  {gris}
 gc              = '';  {gris clair}
 b               = '';  {blanc}

 rotat           = ' ';
 gauche          = '4';
 droite          = '6';
 chute           = '5';
 fin_jeu         = 'F';


TYPE
 coord       = record
                x,y : integer;
               end;

 forme       = array[1..ncarre] of coord;

 coul_forme  = record
                c : char;
                f : forme;
               end;

 ensemble_cf = array[1..npiece4] of coul_forme;

 piece       = record
                rang : integer;
                ref  : coord;
                cf   : coul_forme;
               end;

 tableau     = array[0..xmax+1,0..ymax] of char;


CONST
 origine  : coord       = (x:xmax div 2;y:ymax-3);
 dep_gche : coord       = (x:-1;y:0);
 dep_dte  : coord       = (x:1;y:0);
 dep_bas  : coord       = (x:0;y:-1);
 suivant  : coord       = (x:22;y:14);

 ens      : ensemble_cf = ((c:gf;f:((x:0;y:0),(x:1;y:0),(x:0;y:1),(x:0;y:2))),
                           (c:g;f:((x:0;y:0),(x:1;y:0),(x:0;y:1),(x:1;y:1))),
                           (c:b;f:((x:0;y:0),(x:1;y:0),(x:-1;y:0),(x:2;y:0))),
                           (c:gc;f:((x:0;y:0),(x:-1;y:0),(x:0;y:1),(x:0;y:2))),
                           (c:b;f:((x:0;y:0),(x:1;y:0),(x:0;y:1),(x:-1;y:0))),
                           (c:gf;f:((x:0;y:0),(x:-1;y:0),(x:0;y:1),(x:1;y:1))),
                           (c:gc;f:((x:0;y:0),(x:1;y:0),(x:0;y:1),(x:-1;y:1))),

                           (c:gf;f:((x:0;y:0),(x:1;y:0),(x:-1;y:0),(x:1;y:1))),
                           (c:g;f:((x:0;y:0),(x:1;y:0),(x:0;y:1),(x:1;y:1))),
                           (c:b;f:((x:0;y:0),(x:0;y:1),(x:0;y:2),(x:0;y:3))),
                           (c:gc;f:((x:0;y:1),(x:-1;y:1),(x:1;y:1),(x:1;y:0))),
                           (c:b;f:((x:0;y:0),(x:0;y:1),(x:0;y:2),(x:-1;y:1))),
                           (c:gf;f:((x:0;y:0),(x:-1;y:1),(x:0;y:1),(x:-1;y:2))),
                           (c:gc;f:((x:0;y:0),(x:1;y:1),(x:0;y:1),(x:1;y:2))),

                           (c:gf;f:((x:0;y:0),(x:-1;y:2),(x:0;y:1),(x:0;y:2))),
                           (c:g;f:((x:0;y:0),(x:1;y:0),(x:0;y:1),(x:1;y:1))),
                           (c:b;f:((x:0;y:0),(x:1;y:0),(x:-1;y:0),(x:2;y:0))),
                           (c:gc;f:((x:0;y:0),(x:1;y:2),(x:0;y:1),(x:0;y:2))),
                           (c:b;f:((x:0;y:0),(x:1;y:1),(x:0;y:1),(x:-1;y:1))),
                           (c:gf;f:((x:0;y:0),(x:-1;y:0),(x:0;y:1),(x:1;y:1))),
                           (c:gc;f:((x:0;y:0),(x:1;y:0),(x:0;y:1),(x:-1;y:1))),

                           (c:gf;f:((x:-1;y:0),(x:-1;y:1),(x:0;y:1),(x:1;y:1))),
                           (c:g;f:((x:0;y:0),(x:1;y:0),(x:0;y:1),(x:1;y:1))),
                           (c:b;f:((x:0;y:0),(x:0;y:1),(x:0;y:2),(x:0;y:3))),
                           (c:gc;f:((x:0;y:0),(x:-1;y:0),(x:-1;y:1),(x:1;y:0))),
                           (c:b;f:((x:0;y:0),(x:1;y:1),(x:0;y:1),(x:0;y:2))),
                           (c:gf;f:((x:0;y:0),(x:-1;y:1),(x:0;y:1),(x:-1;y:2))),
                           (c:gc;f:((x:0;y:0),(x:1;y:1),(x:0;y:1),(x:1;y:2))) );



VAR
 arret,perdu,sortir            : boolean;
 piece_suivante                : boolean;
 nligne,score,niveau           : integer;
 i,temps                       : integer;
 touche                        : char;
 dep                           : coord;
 p,p_suiv                      : piece;
 tab                           : tableau;


FUNCTION test_rotation:integer;
 var
  i,test  : integer;
  temp    : coord;

 begin
  test:=p.rang+npiece;
  if test>npiece4 then
     test:=test-npiece4;
  i:=0;

  repeat
    inc(i);
    temp.x:=p.ref.x + ens[test].f[i].x;
    temp.y:=p.ref.y + ens[test].f[i].y;
    if (temp.x>=1) and (temp.x<=xmax) then
       begin
        if tab[temp.x , temp.y] <> espace then
        test:=0;
       end
    else
       test:=0;
  until (i=ncarre) or (test=0);

  test_rotation:=test;
 end;


FUNCTION test_deplacement(dep : coord):boolean;
 var
  i       : integer;
  test    : boolean;
  temp    : coord;

 begin
  test:=false;
  i:=0;
  temp.x:=p.ref.x+dep.x;
  temp.y:=p.ref.y+dep.y;

  repeat
   inc(i);
   if tab[temp.x + p.cf.f[i].x , temp.y + p.cf.f[i].y] <> espace then
      test:=true;
  until (i=ncarre) or test;

  test_deplacement:=test;
 end;


FUNCTION test_ligne(y:integer):boolean;
 var
  i       : integer;
  test    : boolean;

 begin
  test:=false;
  i:=0;

  repeat
   inc(i);
   if tab[i,y]=espace then
      test:=true;
  until (i=xmax) or test;

  test_ligne:=test;
 end;


PROCEDURE affiche_score;
 const
  long                = 5;
  coordniveau : coord = (x:56;y:16);
  coordlignes : coord = (x:56;y:18);
  coordpoints : coord = (x:56;y:20);

 begin
  gotoxy(coordniveau.x,coordniveau.y);
  write(niveau:long);
  gotoxy(coordlignes.x,coordlignes.y);
  write(nligne:long);
  gotoxy(coordpoints.x,coordpoints.y);
  write(score:long);
  gotoxy(1,1);
 end;


PROCEDURE affiche_perdu;
 const
  phrase             = 'PERDU.';
  coordperdu : coord = (x:xdecal+xmax+2-length(phrase) div 2;
                        y:ydecal-ymax);

 begin
  gotoxy(coordperdu.x,coordperdu.y);
  write(phrase);
 end;


PROCEDURE affiche(p : piece;vis : boolean);
 var
  i       : integer;
  car     : char;
  temp    : coord;

 begin
  if vis then
     car:=p.cf.c
  else
     car:=espace;
  temp.x:=xdecal+2*p.ref.x;
  temp.y:=ydecal-p.ref.y;

  for i:=1 to ncarre do
   begin
    gotoxy(temp.x+2*p.cf.f[i].x,temp.y-p.cf.f[i].y);
    write(car,car);
   end;

  gotoxy(1,1);
 end;


PROCEDURE nouveau_tableau; {initialise le tableau de jeu :
  au depart, il est vide}

 const
  non_blanc = b;

 var
  i,j,temp : integer;

 begin
  for i:=1 to xmax do
   for j:=1 to ymax do
    tab[i,j]:=espace;

  temp:=xmax+1;
  for j:=0 to ymax do
      begin
       tab[0,j]:=non_blanc;
       tab[temp,j]:=non_blanc;
      end;

  for i:=1 to xmax do
      tab[i,0]:=non_blanc;

 end;


PROCEDURE marque_tableau;
 {enregistre la piece dans le tableau
  une fois qu'elle s'est arretee}

 var
  i       : integer;

 begin
  for i:=1 to ncarre do
   tab[p.ref.x + p.cf.f[i].x , p.ref.y + p.cf.f[i].y]:=p.cf.c;
 end;


PROCEDURE affiche_tableau;
 {affiche l'interieur du tableau
  de jeu (sans le contour)}

 var
  i,j     : integer;

 begin
  for i:=1 to xmax do
   for j:=1 to ymax do
    begin
     gotoxy(2*i+xdecal,ydecal-j);
     write(tab[i,j],tab[i,j]);
    end;
  gotoxy(1,1);
 end;


PROCEDURE efface_ligne(y:integer);
 var
  i,j,max : integer;

 begin
  max:=origine.y-2;
  for j:=y to max do
   for i:=1 to xmax do
    tab[i,j]:=tab[i,j+1];
  affiche_tableau;
 end;


PROCEDURE controle_ligne;
 {quand une piece se pose, cette procedure
  verifie si une ligne a ete completee}

 var
  i,y     : integer;

 begin
  y:=p.ref.y;
  for i:=1 to ncarre do
   if test_ligne(y) then
      inc(y)
   else
      begin
       if nligne mod 10=9 then
        inc(niveau);
       efface_ligne(y);
       inc(nligne);
       inc(score,score_ligne);
      end;
 end;


PROCEDURE nouvelle_piece;
 begin
  if piece_suivante then
   begin
    affiche(p_suiv,false);
    p.cf:=p_suiv.cf;
    p.rang:=p_suiv.rang;
    p.ref:=origine;
    affiche(p,true);
    p_suiv.rang:=random(npiece)+1;
    p_suiv.cf:=ens[p_suiv.rang];
    affiche(p_suiv,true);
   end
  else
   begin
    p.rang:=random(npiece)+1;
    p.cf:=ens[p.rang];
    p.ref:=origine;
    affiche(p,true);
   end;
 end;


PROCEDURE rotation;
 var
  nouv_rang : integer;

 begin
  nouv_rang:=test_rotation;
  if nouv_rang<>0 then
     begin
      affiche(p,false);
      p.rang:=nouv_rang;
      p.cf:=ens[p.rang];
      affiche(p,true);
     end;
 end;


PROCEDURE deplacement(dep : coord);
 var
  i       : integer;

 begin
  if test_deplacement(dep) then
     begin
      if dep.y=-1 then
         begin
          arret:=true;
          i:=0;
          repeat
           inc(i);
           if (p.ref.y+p.cf.f[i].y)=origine.y then
           perdu:=true;
          until (i=ncarre) or perdu;
         end;
     end
   else
     begin
      affiche(p,false);
      inc(p.ref.x,dep.x);
      inc(p.ref.y,dep.y);
      affiche(p,true);
     end;
 end;


PROCEDURE quitter_tetris;
 begin
  arret:=true;
  perdu:=true;
  sortir:=true;
 end;


PROCEDURE parametres;
 const
  init_niv  = 'N';
  next      = 'P';
  commencer = 'S';
  quitter   = 'Q';

 procedure param_niveau;
  begin
   inc(niveau);
   if niveau>9 then
      niveau:=0;
   affiche_score;
  end;

 procedure param_suivante;
  begin
   if piece_suivante then
    begin
     piece_suivante:=false;
     affiche(p_suiv,false);
     end
    else
     begin
      piece_suivante:=true;
      p_suiv.rang:=p.rang;
      p_suiv.cf:=p.cf;
      affiche(p_suiv,true);
     end;
  end;

 begin
  piece_suivante := true;
  repeat
    repeat
    until keypressed;
    touche:=upcase(readkey);
    case touche of
         init_niv : param_niveau;
         next     : param_suivante;
         quitter  : quitter_tetris;
    end;
  until (touche=commencer) or (touche=quitter);
 end;


PROCEDURE initialisation;
 begin
  score:=0;
  nligne:=0;
  niveau:=0;
  affiche_score;
  arret:=false;
  perdu:=false;
  sortir:=false;
  nouveau_tableau;
  affiche_tableau;
  p_suiv.ref:=suivant;
  p_suiv.rang:=random(npiece)+1;
  p_suiv.cf:=ens[p_suiv.rang];
  affiche(p_suiv,true);
  p.rang:=p_suiv.rang;
  p.cf:=p_suiv.cf;
  p.ref:=origine;
  randomize;
 end;


PROCEDURE presentation;
 const
  coing='';
  coind='';
  bordv='';
  bordh='';
  texte0  : coord = (x:43;y:12);
  texte1  : coord = (x:40;y:16);
  texte2  : coord = (x:40;y:18);
  texte3  : coord = (x:40;y:20);
  texte5  : coord = (x:41;y:4);
  phrase0         = 'PIECE SUIVANTE';
  phrase1         = 'NIVEAU       : ';
  phrase2         = 'LIGNES       : ';
  phrase3         = 'POINTS       : ';
  phrase4         = 'Ŀ';
  phrase5         = '  JEU DE TETRIS  ';
  phrase6         = '';

 var
  i:integer;
  temp1,temp2,temp3:integer;

 begin
  clrscr;
  writeln('change_niveau:N suivant:P commencer:S quitter:Q  ');
  writeln('rotat:espace    gauche :4    droite:6  chute :5  fin_jeu:F  ');

  temp1:=xdecal+1;
  temp2:=xdecal+(xmax+1)*2;

  gotoxy(temp1,ydecal);
  write(coing);
  gotoxy(temp2,ydecal);
  write(coind);

  for i:=1 to origine.y do
   begin
    gotoxy(temp1,ydecal-i);
    write(bordv);
    gotoxy(temp2,ydecal-i);
    write(bordv);
   end;

  temp3:=xmax*2+1;
  for i:=2 to temp3 do
   begin
    gotoxy(xdecal+i,ydecal);
    write(bordh);
   end;

  gotoxy(texte0.x,texte0.y);
  write(phrase0);
  gotoxy(texte1.x,texte1.y);
  write(phrase1);
  gotoxy(texte2.x,texte2.y);
  write(phrase2);
  gotoxy(texte3.x,texte3.y);
  write(phrase3);
  gotoxy(texte5.x,texte5.y-1);
  write(phrase4);
  gotoxy(texte5.x,texte5.y);
  write(phrase5);
  gotoxy(texte5.x,texte5.y+1);
  write(phrase6);
 end;




BEGIN
 presentation;

 repeat
  initialisation;
  parametres;

  repeat
   nouvelle_piece;
   temps:=temps_init-delais*niveau;
   repeat
    for i:=1 to temps do
      begin
        if keypressed then
          begin
              touche:=readkey;
              touche:=upcase(touche);
              case touche of
                   rotat   : rotation;
                   gauche  : deplacement(dep_gche);
                   droite  : deplacement(dep_dte);
                   chute   : deplacement(dep_bas);
                   fin_jeu : begin
                              arret:=true;
                              perdu:=true;
                             end;
              end;
          end;
      end;
     deplacement(dep_bas);
   until arret;

   arret:=false;
   marque_tableau;
   affiche_tableau;
   inc(score,score_piece);
   controle_ligne;
   affiche_score;

  until perdu;

  affiche_perdu;
  delay(1000);

  repeat
  until keypressed;
  affiche(p_suiv,false);

 until sortir=true;

END.
