#include <alloc.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
/*    #include <mem.h>    */
#define  vram	0xA0000000

unsigned char far *page = 0xA0000000;		/* Virtual Video RAM */
unsigned char far *back[3];		/* Back Ground image */

struct	pcx_header
{	char maker;	char ver;	char code;	char bit;
	int x1,y1,x2,y2, mx,my;		char palette[48];	mode,	plane;
	int nubi, info, hres, vres;	char extra[54];
} header;
unsigned char	palette[768];

void	set_mode(int mode)	/* Assembly Routine .... */
{   union	REGS	r;
	r.h.ah = 0x00;	r.h.al = mode;	int86(0x10, &r, &r);
}
void	pset(int x, int y, int c)
{	y = y << 6;	y += y << 2;	/*  y*64 + y*256 = y*320     */
	y += x;				/*  y*320 + x   */
	page[y] = c;			/*  Set point   */
}
void	set_palette(unsigned char *data)
{   int i;
	outportb(0x3C8, 0);
	for(i=0; i<768; i+=3)
	{	outportb(0x3C9, data[i]);	outportb(0x3C9, data[i+1]);
		outportb(0x3C9, data[i+2]);
	}
}
void	copy_page(unsigned char far *dest, unsigned char far *sour)
{	memcpy(dest, sour, 64000L);
}
/* void	copy_block(unsigned char far *dest, unsigned char far *sour, int length)
{	memcpy(dest, sour, length);
}				/* Copying part	*/
void	copy_back(int y)
{   unsigned char far *p1, far *p2;	int l1, l2;
	if (y<200)
	{	p1 = back[0];	p2 = back[1];	}
	else
	{	p1 = back[1];	p2 = back[2];	y-=200;	}
	l2 = (200-y)*320; l1 = y*320;
	memcpy(page, p1+l1, l2);
	memcpy(page+l2, p2, l1);
}
void	read_pcx(char *name, char far *p)
{   FILE *fp;	int i, x=0, y=0, mx, my;
    unsigned char ch, data, palette[768];
	fp = fopen(name, "rb");		fread(&header, 128, 1, fp);
	fseek(fp, -768, SEEK_END);	fread(palette, 768, 1,fp);
	for (i=0; i<768; i++)	palette[i]>>=2;
	set_palette(palette);		fseek(fp,128,SEEK_SET);
	mx = header.x2;			if(mx>319) mx = 320;
	my = header.y2;			if(my>199) my = 200;
	while(1)
	{	ch = fgetc(fp);
		if ( (ch & 0xC0)==0xC0 )
		{	data = getc(fp);
			for (i=0; i< (ch&0x3f); i++)	p[y*320 + x++] = data;
		} else	p[y*320 + x++] = ch;
		if (x>mx)	{ x=0; y+=1; }
		if (y>my)	break;
	}
	fclose(fp);
}
