//@----T---T---T---T---T---T---T---T---T---T---T---T---T---T---T---T---T---T---T---T---T---T---T
// ***********************************************************************************************
// *
// *	Level 1 - main
// *
// ***********************************************************************************************

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

#include "defs.h"
#include "types.h"
#include "svga.h"
#include "debugger.h"
#include "keyboard.h"
#include "memory.h"
#include "scroll.h"
#include "digits.h"
#include "sprite.h"
#include "hugostyr.h"
#include "visuals.h"
#include "primitiv.h"
#include "joystick.h"
#include "hit.h"
#include "random.h"
#include "ail.h"
#include "dll.h"
#include "myail.h"
#include "debug.h"
#include "event.h"
#include "anmplay.h"
#include "eat.h"
#include "joystick.h"

#include "snake.h"
#include "zigzag.h"
#include "objects.h"

#include "..\anims\objects\level1\objanms.h"                // flex
#include "..\anims\objects\level1\fallobj\fallanms.h"       // flex
#include "..\anims\objects\level1\snake\snakeptr.h"         // brian

extern signed char 	SoundFXVolume;//~;
//~0
// ***********************************************************************************************
// *
// * Extern vars
// *
// ***********************************************************************************************


extern ActiveListType 	ActiveList;
extern int							ObjectRemoved;

extern AnimStruct 			*HugoBasicAnim;
extern byte 						*HugoBasicFrames;
extern byte 						*Blocks;													// Block grafik
extern struct BlockInfo *MapInfo; 												// Map til banen

extern MIDIFile *LevelMIDI;

extern byte NoScrollX,NoScrollY;
extern int	CameraY;
extern byte ScrollMustBeUpdated;

extern int	HugoDead,EndOfLevel;
extern int	CurrentLevel;
extern byte HugoBlockedRight,HugoBlockedLeft;
extern int HugoLianFallBlocked,HugoArmgangBlockedLeft,HugoArmgangBlockedRight;

extern int	HugoX,HugoY;																	// Hugos absolutte position
extern int	OldHugoX,OldHugoY;														// Forrige frames absolutte position
extern int	HugoEnergi,HugoPoint;

extern word MaxPosY,MinPosY;
extern word MaxPosX,MinPosX;
extern int	fixposx,fixposy;
extern int	posx,posy;
extern int	testback;
extern byte CameraShakeOn,CameraShakeCnt;
extern int	CameraShake[18];

extern AnimReplayStruct CurrentHugoAnimation;
extern AnimReplayStruct CurrentRitaAnimation;

extern int	CrrentLevel;
extern int	LevelWidth; 																	// Bane's x-stoerrelse
extern int	LevelHeight;																	// Bane's y-stoerrelse
extern int	HugoHasEaten,HugoHasEatenFrom,HugoHasBeenHit;

extern int	GameBlanks,GameSekunder,GameMinutter,OldGameBlanks;

extern signed char	*BlackPalette;

extern int	Test1,Test2,Test3;
extern byte CheatMode;
extern int	CheatModeCnt;

extern int	SplashOn;

extern	int  oldposx,oldposy;

extern int SubGoal;

extern short GameMode;
extern short HugoLives;
extern volatile int FrameCount,OldFrameCount,FallInterval1,FallInterval2,FallInterval3,FallInterval4,FallInterval5;

extern byte Fading;
extern int	RitaOn;
extern int	QuitGame;
extern short MainBladeFunctionPresent;

// ***********************************************************************************************
// *
// * Extern functions
// *
// ***********************************************************************************************

extern void CalcScrollPos(void);
extern void FadeUpPlaying(void);
extern void FadeDownPlaying(void);
extern void CallEventsOnScreen(void);
extern void DisplayCheatStatus(void);
extern void CheckHugoOutScreen(void);

extern int GameMode_Procent(int,int);

extern void ClearAllEat_Ptrs(void);

// ***********************************************************************************************
// *
// * Vars
// *
// ***********************************************************************************************

AnimStruct *ObjectAnimLevel;
byte *ObjectFramesLevel;

AnimStruct *ZigZagAnim;
byte *ZigZagFrames;

AnimStruct *SnakeAnim;
byte *SnakeFrames;

AnimStruct *FallAnimLevel;
byte *FallFramesLevel;

extern AnimStruct *FruitEatAnim;
extern byte *FruitEatFrames;


//-----------------------------------------------------------------------------------------------
//- Record & replay
//-----------------------------------------------------------------------------------------------

typedef struct RecordKeyT_ {
	byte Up,Down,Left,Right, Alt, Ctrl, Stop;
} RecordKeyT;

RecordKeyT	*RecordKeys=NULL;
byte				*ReplayKeys;
int 				KeyCnt,AccKeyCnt;
byte				RecordOn=0;
byte				ReplayOn;
int 				MaxKeys;
int 				r_HugoX,r_HugoY,r_posx,r_posy;


void Replay(void) {

	if (OldFrameCount>6)
		OldFrameCount=6;

	if	( (HugoStyr==&HugoEatStyr) || (HugoStyr==&HugoHeadHitStyr) || (HugoStyr==&HugoBitStyr) ) {
		_keys[UpKey]		= 0;
		_keys[DownKey]	= 0;
		_keys[LeftKey]	= 0;
		_keys[RightKey] = 0;
		_keys[JumpKey]	= 0;
		_keys[RunKey] 	= 0;
		return;
	}

	AccKeyCnt+=OldFrameCount;

	KeyCnt=AccKeyCnt / 6;

	_keys[UpKey]		= ReplayKeys[KeyCnt]	& 64;
	_keys[DownKey]	= ReplayKeys[KeyCnt]	& 32;
	_keys[LeftKey]	= ReplayKeys[KeyCnt]	& 16;
	_keys[RightKey] = ReplayKeys[KeyCnt]	&  8;
	_keys[JumpKey]	= ReplayKeys[KeyCnt]	&  4;
	_keys[RunKey] 	= ReplayKeys[KeyCnt]	&  2;

	if ( (ReplayKeys[KeyCnt] & 1) || (KeyCnt>=MaxKeys) ) {
		HugoDead=1;
	}

	KeyCnt+=OldFrameCount;
}


void Record(void) {
	int i;

	WaitFrames(6);
	OldFrameCount=6;
	FrameCount=0;

	if	( (HugoStyr==&HugoEatStyr) || (HugoStyr==&HugoHeadHitStyr) || (HugoStyr==&HugoBitStyr) )
		return;

	if (_keys[UpKey]) 	 RecordKeys[KeyCnt].Up		= 1; else RecordKeys[KeyCnt].Up 	=0;
	if (_keys[DownKey])  RecordKeys[KeyCnt].Down	= 1; else RecordKeys[KeyCnt].Down =0;
	if (_keys[LeftKey])  RecordKeys[KeyCnt].Left	= 1; else RecordKeys[KeyCnt].Left =0;
	if (_keys[RightKey]) RecordKeys[KeyCnt].Right = 1; else RecordKeys[KeyCnt].Right=0;
	if (_keys[JumpKey])  RecordKeys[KeyCnt].Alt 	= 1; else RecordKeys[KeyCnt].Alt	=0;
	if (_keys[RunKey])	 RecordKeys[KeyCnt].Ctrl	= 1; else RecordKeys[KeyCnt].Ctrl =0;
	if (_keys[kESC])		 RecordKeys[KeyCnt].Stop	= 1; else RecordKeys[KeyCnt].Stop =0;

	KeyCnt++;
}


void SaveRecording(void) {
	FILE *f;
	int  i;
	byte tmp;

	f=fopen("\\replay2.bin","wb");

	fwrite(&r_HugoX,sizeof(int),1,f);
	fwrite(&r_HugoY,sizeof(int),1,f);
	fwrite(&r_posx ,sizeof(int),1,f);
	fwrite(&r_posy ,sizeof(int),1,f);

	for(i=0;i<KeyCnt-1;i++) {
		tmp=0;
		tmp=tmp | (RecordKeys[i].Up 	 <<6);
		tmp=tmp | (RecordKeys[i].Down  <<5);
		tmp=tmp | (RecordKeys[i].Left  <<4);
		tmp=tmp | (RecordKeys[i].Right <<3);
		tmp=tmp | (RecordKeys[i].Alt	 <<2);
		tmp=tmp | (RecordKeys[i].Ctrl  <<1);
		tmp=tmp | (RecordKeys[i].Stop  <<0);

		fwrite(&tmp,1,1,f);

	}
	fclose(f);
}



// ***********************************************************************************************
// *
// *	Level 1
// *
// ***********************************************************************************************

void Main_Start_Level1(void) {
	int i;

	CurrentLevel = 0;
	RitaOn = 0;

	HugoHasEaten = -1;

	SplashOn = FALSE;
	ZigOn = FALSE;
	HugoDoNotEat = FALSE;
	HugoSkalFaldeUd = FALSE;

	NoScrollY=0;
	NoScrollX=0;
	CameraY=140;

	ScreenPtr1 = 0;
	ScreenPtr2 = 250;
	ScreenPtr3 = 500;

	IGNORE_STOP_SCROLL = TRUE;
	IGNORE_EVENTS = TRUE;

	MainBladeFunctionPresent = FALSE;

	switch(SubGoal)
	{
		case 0 : oldposx = 0; oldposy = 0;
			 posx=128;posy=240;
			 HugoX=283;HugoY=402;
			 break;

		case 1 : oldposx = 1070+320; oldposy = 417-240;
			 posx=1070;posy=417;
			 HugoX=1230;HugoY=557;
			 break;

		case 2 : oldposx = 1864+320; oldposy = 266-240;
			 posx=1864;posy=266;
			 HugoX=2014;HugoY=403;
			 break;

	}

	if (ReplayOn) {
		posx	= r_posx;  posy  = r_posy;
		HugoX = r_HugoX; HugoY = r_HugoY;
		oldposx = posx+320; oldposy = posy-240;
	}

	OldHugoX=HugoX;OldHugoY=HugoY;
	fixposx=posx<<8; fixposy=posy<<8;

	testback = TRUE;
	OverLayNr = OverLayTabel_Jungle_Offset;

	Fading=1;

	CalculateScreenPos();
	UpdateBackMostLayer();
	CalculateScreenPos();
	UpdateBackMostLayer();

	ClearActiveList();

	IGNORE_STOP_SCROLL = FALSE;
	IGNORE_EVENTS = FALSE;
	CallEventsOnScreen();

	if ( (SubGoal==0) && (HugoLives==START_HUGO_LIVES) && (!ReplayOn) )
		HugoStyr=&HugoWakeUpAStyr;
	else
		HugoStyr=&HugoStenerStyr;

	OldHugoStyr=HugoStyr;

	CurrentHugoAnimation.Direction = 0;

	if(SubGoal == 2) CurrentHugoAnimation.Direction = 1;

	if (HugoStyr->InitFunc != NULL) HugoStyr->InitFunc(); 		// Lad frste styrefunc init

	GameBlanks=0;
	GameSekunder=0;
	GameMinutter=0;

	HugoHasEaten=-1;
	HugoHasBeenHit = 0;


	HugoDead = FALSE;
	CurrentHugoAnimation.DisplayOn=1;

	ScrollMustBeUpdated=0;
	CurrentHugoAnimation.DisplayOn = 1;

	for(i=0;i<768;i++)
		MainPalette[i]=MainPalette1[i];

	if(MidiOn == TRUE)
	{
		Stop_MIDI(LevelMIDI);
		Play_MIDI(LevelMIDI,0);
	}
/*
*/
	FrameCount = 0;
	FadeUpPlaying();

	FallInterval1 = 0;
	FallInterval2 = 0;
	FallInterval3 = 0;
	FallInterval4 = 0;
	FallInterval5 = 0;
}


void Main_Init_Level1(void) {
	FILE	*f;

	SetDebugMessage("InitLevel1");

	ClearAllEat_Ptrs();

	CurrentLevel = 0;

	LevelWidth=2720;
	LevelHeight=728;

	BGLevelWidth=640;
	BGLevelHeight=360;

	ActiveList.First=NULL;
	ActiveList.Last=NULL;

	SetDebugMessage("Init1.1");

	LoadAnimation(&HugoBasicAnim,"..\\anims\\anims.bin",&HugoBasicFrames,"..\\anims\\frames.bin");
	LoadAnimation(&FruitEatAnim,"..\\anims\\objects\\eat\\eatanim.bin",&FruitEatFrames,"..\\anims\\objects\\eat\\eatframe.bin");
	LoadAnimation(&ZigZagAnim,"..\\anims\\objects\\level1\\zigzag\\ziganim.bin",&ZigZagFrames,"..\\anims\\objects\\level1\\zigzag\\zigframe.bin");
	LoadAnimation(&SnakeAnim,"..\\anims\\objects\\level1\\snake\\snakeanm.bin",&SnakeFrames,"..\\anims\\objects\\level1\\snake\\snakefrm.bin");
	LoadAnimation(&fxanim,"..\\anims\\objects\\level1\\fx\\fxanm.bin",&fxframes,"..\\anims\\objects\\level1\\fx\\fxfrm.bin");
	LoadAnimation(&ObjectAnimLevel,"..\\anims\\objects\\level1\\objanms.bin",&ObjectFramesLevel,"..\\anims\\objects\\level1\\objfrms.bin");
	LoadAnimation(&FallAnimLevel,"..\\anims\\objects\\level1\\fallobj\\fallanms.bin",&FallFramesLevel,"..\\anims\\objects\\level1\\fallobj\\fallfrms.bin");

	LoadEvents("..\\data\\jungle\\eventtab.bin");

	MainPalette=(byte *)LoadAndAlloc("..\\data\\jungle\\pal1a1.pal");
	MainPalette1=(byte *)LoadAndAlloc("..\\data\\jungle\\pal1a1.pal");

	SetDebugMessage("Init1.2");
	Init_Restore();
	Clear_Restore();
	SetDebugMessage("Init1.3");

	Blocks=LoadAndAlloc("..\\data\\jungle\\new\\blk1.bin");    //grafikken til klodserne
	MapInfo=(struct BlockInfo*) LoadAndAlloc("..\\data\\jungle\\new\\map1.bin");
	YPointers=LoadAndAlloc("..\\data\\jungle\\new\\pointer1.bin");
	PackInfo=LoadAndAlloc("..\\data\\jungle\\new\\pack1.bin");
	BitMap=LoadAndAlloc("..\\data\\jungle\\back1.bin");

	SetDebugMessage("Init1.4");

	BGFxTweakSize_X = 640/4;
	X_Plan_Pointers=alloc_mem(LevelHeight*4*8+8); 	//allocate memory for the y line pointers and their current xposition (0)
	Init_BG_Pointers_Level1();

	SetDebugMessage("Init1.5");

	if (ReplayOn) {
		KeyCnt=0;
		AccKeyCnt=0;

		switch(ReplayOn) {
			case 1	: f=fopen("\\replay.bin","rb");break;
			case 2	: f=fopen("\\replay2.bin","rb");break;
			default : ErrorHandler("Kan ikke finde replay?.bin\n");break;
		}

		fread(&r_HugoX,sizeof(int),1,f);
		fread(&r_HugoY,sizeof(int),1,f);
		fread(&r_posx ,sizeof(int),1,f);
		fread(&r_posy ,sizeof(int),1,f);

		MaxKeys=fread(ReplayKeys,1,6000,f);
		fclose(f);
	}

	SetDebugMessage("Init1.6");

	if(Midi == TRUE) Open_MIDIFile(LevelMIDI,"xmi\\bane1.xmi");

//	if(Digi == TRUE)
//	{
//		DigiOn = LoadSamples_Level1();
//	}

	SetDebugMessage("SetTweak");
	SetTweak320x200();
	ClearEntireVRAM();

	SetDebugMessage("LoadAndSetPalette");
	LoadAndResetPalette();

	Digits_Loaded=0;

	memset(BlackPalette,0,768);
	PalVGA(BlackPalette,768);

	Main_Start_Level1();
}




void Main_Run_Level1(void) {
	ObjectType *ObjectPtr,*ObjectNextPtr,*ObjectThisPtr;
	byte	*Frames;
	WORD	width,height;
	int 	Game_Procent;

	while ( (!HugoDead) && (EndOfLevel!=3) && (!QuitGame) ) {

		OldFrameCount = FrameCount;

		if (OldFrameCount==0)
			OldFrameCount=1;
		FrameCount = 0;

/*
		//
		// Demoplay recording
		//
		if ( (RecordOn) && (RecordKeys==NULL) ) {
			RecordKeys=malloc(sizeof(RecordKeyT)*6000);
			KeyCnt=0;
		}

		if ( (_keys[kTAB]) && (!RecordOn) ) {
			RecordOn=1;
			r_posx = posx;
			r_posy = posy;
			r_HugoX = HugoX;
			r_HugoY = HugoY;

			if (RecordKeys==NULL) {
				RecordKeys=malloc(sizeof(RecordKeyT)*6000);
				KeyCnt=0;
			}
		}
*/

		GameBlanks+=OldFrameCount;
		SetDebugMessage("Scroll");
		CalculateScreenPos();

		SetDebugMessage("Restore-business");
		RestoreGFX();

		SetDebugMessage("Backmost layer-business");
		UpdateBackMostLayer();

		if (!ReplayOn) {
			if(_keys[kESC]) {
				EndOfLevel=3;
				HugoDead=1;
			}

			if(_keys[kF11]) {
				while(_keys[kF11]);
				Typer();
			}

			if(_keys[kF10]) {
				CheatMode^=1;
				while(_keys[kF10]);
				CheatModeCnt=400;
			}
		}
/*		else {
			if (_keynumpress>0)
				_keynumpress=0;
				memset(_keys,0,256);
				break;
		}
*/
		if (ScrollMustBeUpdated)
			goto UpdatePosXY;

		if (EndOfLevel == 1) {

			HugoHasBeenHit = FALSE;
			HugoHasEaten = FALSE;

			if(MidiOn == TRUE)
			{
				Stop_MIDI(LevelMIDI);
				Play_MIDI(LevelMIDI,1);
			}

			HugoHasBeenHit = FALSE;
			HugoHasEaten = -1;

			NoScrollY = 0;
			HugoY += 30;
			OldHugoY = HugoY;

			Insert_Net();

			EndOfLevel = 2;
		}

//		if(_keys[kL])
//		{
//			EndOfLevel = 1;
//		}


		//
		// Check special keys
		//

		if (_keys[kRIGHTALT])
			WaitFrames(60);

		CheckHugoOutScreen();

		if(ZigOn == 0)
		{
			switch(GameMode)
			{

				case EASY : Game_Procent = FRUGT_FALL_EASY;
									break;

				case MEDIUM : Game_Procent = 0;
									break;

				case HARD 	: Game_Procent = FRUGT_FALL_HARD;
									break;
			}

			if( FallInterval1 > (480+GameMode_Procent(480,Game_Procent)) ){
				Insert_Fall_Object(posx+((33+posx+FallInterval1)&0xff),posy,OBJECT_MELONROT,OBJECT_MELONSPLAT,OBJECT_REMOVE);
				FallInterval1 = 0;
			}

			if( FallInterval2 > (600+GameMode_Procent(600,Game_Procent)) ){
				Insert_Fall_Object(posx+((55+posx+FallInterval2)&0xff),posy,OBJECT_AEBLEROT,OBJECT_AEBLESPLAT,OBJECT_BOUNCE);
				FallInterval2 = 0;
			}

			if( FallInterval3 > (960+GameMode_Procent(960,Game_Procent)) ){
				Insert_Fall_Object(posx+((40+posx+FallInterval3)&0xff),posy,OBJECT_BANANROT,OBJECT_BANANSPLAT,OBJECT_BOUNCE);
				FallInterval3 = 0;
			}

			if( FallInterval4 > (1200+GameMode_Procent(1200,Game_Procent)) ) {
				Insert_Fall_Object(posx+((99+posx+FallInterval4)&0xff),posy,OBJECT_PAEREROT,OBJECT_PAERESPLAT,OBJECT_BOUNCE);
				FallInterval4 = 0;
			}
		}

		switch(GameMode)
		{

			case EASY : Game_Procent = KOKUS_FALL_EASY;
								break;

			case MEDIUM : Game_Procent = 0;
								break;

			case HARD 	: Game_Procent = KOKUS_FALL_HARD;
								break;
		}
		if( FallInterval5 > (900+GameMode_Procent(900,Game_Procent)) && EndOfLevel == 0)
		{
			Insert_Fall_Object(HugoX+5,posy,OBJECT_KOKROT,OBJECT_KOKSPLAT,OBJECT_HIT);
			FallInterval5 = 0;
		}

		if(_keys[kL])
		{
			Insert_Fall_Object(HugoX+5,posy,OBJECT_KOKROT,OBJECT_KOKSPLAT,OBJECT_HIT);
			while(_keys[kL]);
		}

		if (RecordOn)
			gprintf(0,230,1,"Recording");

		//
		// Replaying
		//

		if (ReplayOn)
			Replay();

		//
		// Recording
		//

		if (RecordOn)
			Record();

		JoystickControl();

		//
		// Kald Hugo styrerutine
		//

		SetDebugMessage("Animation playing");

		if (!HugoDead)
			AnimationReplay();

		//
		// Events
		//

		OldHugoStyr=HugoStyr;

		if(HugoDead == FALSE) {

			HugoBlockedRight=HugoBlockedLeft=0;
			HugoArmgangBlockedLeft = 0;HugoArmgangBlockedRight = 0;

			SetDebugMessage("Event-check");
			CallEvents(OldHugoX,OldHugoY,HugoX,HugoY,CurrentHugoAnimation.Frames+CurrentHugoAnimation.DisplayFrame, CurrentHugoAnimation.Direction,TRUE);
			SetDebugMessage("Event-check done");
			CheckNewHugoStyr();
		}
		OldHugoStyr=HugoStyr;

		//
		// Objects move
		//

//		HiScore(0);

		SetDebugMessage("Aktiv-liste move");

		ObjectPtr=ActiveList.First;
		while (ObjectPtr!=NULL) {
			ObjectNextPtr = ObjectPtr->Next;
			ObjectThisPtr = ObjectPtr;
			ObjectRemoved = FALSE;

			if(ObjectThisPtr->ObjectAnim.Grafik != NULL) {
				if (ObjectAnimationReplay(&ObjectThisPtr->ObjectAnim))				// if frame changed
					if(ObjectThisPtr->MoveFunction != NULL) 						// && MoveFunction!=NULL
					{
						ObjectThisPtr->MoveFunction(ObjectThisPtr); 				// call MoveFunction
					}
			}

			SetDebugMessage("Move Done");

			if( (ObjectThisPtr->RealTimeFunction != NULL) && (ObjectRemoved == FALSE) )
			{
				SetDebugMessage("RealFunction");
				ObjectThisPtr->RealTimeFunction(ObjectPtr);
			}

			SetDebugMessage("RealFunction Done");
			ObjectPtr= ObjectNextPtr;
		}

		SetDebugMessage("Aktiv-liste move done");

		if( HugoDead == FALSE)
			CheckNewHugoStyr();

UpdatePosXY:

		if(SplashOn == TRUE)
			CurrentHugoAnimation.DisplayOn = 0;

		//
		// St alle bobs pa
		//

		SetDebugMessage("Set all BOBS");
		SetAllBobs();
		SetDebugMessage("Set all Done");



		gprintf(0,100,0,"%d",SoundFXVolume);
		Master_DIGIVolume(SoundFXVolume);

		Life_O_Meter(HugoEnergi);

//		DumpYLevels();

		if (GameBlanks>=60) {
			GameBlanks-=60;
			GameSekunder++;
		}

		if (GameSekunder>=60) {
			GameSekunder-=60;
			GameMinutter++;
		}

		//
		// Cheat-mode
		//

		if (CheatModeCnt) {
			DisplayCheatStatus();
			CheatModeCnt-=OldFrameCount;
			if(CheatModeCnt<0)
				CheatModeCnt=0;
		}

		//
		// Scroll-pos
		//

		SetDebugMessage("Udregner nye posx & posy");
		CalcScrollPos();
		SetDebugMessage("********************************************************");
	}

	if ( (RecordOn) && (KeyCnt!=0) )
		SaveRecording();

}







//$0:0:0:216:14:166:0:0:0:0:0:0:0:0:0:0:0:0:0:0
