
;routines graphiques assembleur de Liquid War

;**utilise :***********************************************************;
;*                         V 3 2 2 0 C A . A S M                      *;
;*--------------------------------------------------------------------*;
;*    Fonction       : contient diverses routines pour travailler dans*;
;*                     le mode graphique 320*200 en 256 couleurs      *;
;*                     de la carte VGA                                *;
;*--------------------------------------------------------------------*;
;*    Auteur         : MICHAEL TISCHER                                *;
;*    Dvelopp le   :  5.09.1990                                     *;
;*    Dernire MAJ   : 14.02.1992                                     *;
;*--------------------------------------------------------------------*;
;*    Modle mmoire : SMALL  (modifi LARGE)                         *;
;*--------------------------------------------------------------------*;
;*    Assemblage     : MASM /mx V3220CA;    ou     TASM -mx V3220CA   *;
;*                     ...puis lier  V3220C.C                        *;
;**********************************************************************;

.286

DOSSEG

.MODEL LARGE


;== constantes =========================================================

SC_INDEX       = 3c4h      ;Registre d'index du contrleur du squenceur
SC_MAP_MASK    = 2                          ;Numro du registre Map Mask
SC_MEM_MODE    = 4                   ;Numro dy registre de mode mmoire

GC_INDEX       = 3ceh          ;Registre d'index du contrleur graphique
GC_READ_MAP    = 4                          ;Numro du registre Read Map
GC_GRAPH_MODE  = 5                 ;Numro du registre de mode graphique
GC_MISCELL     = 6                            ;Numro du registre divers

CRTC_INDEX     = 3d4h            ;Registre d'index du contrleur d'cran
CC_MAX_SCAN    = 9     ;Numro du registre du maximum de lignes balayes
CC_START_HI    = 0Ch                        ;Numro du registre Hi_Start
CC_UNDERLINE   = 14h                 ;Numro du registre de soulignement
CC_MODE_CTRL   = 17h             ;Numro du registre de contrle de mode

DAC_WRITE_ADR  = 3C8h                                 ;Adresse DAC Write
DAC_READ_ADR   = 3C7h                                  ;Adresse DAC Read
DAC_DATA       = 3C9h                           ;Registre de donnes DAC

VERT_RETRACE   = 3DAh                       ;registre d'tat d'entre #1

PIXX           = 320                             ;Rsolution horizontale

;== Donnes ============================================================

.DATA

vio_seg    dw 0a000h           ;Segment mmoire cran avec page courante


;== Programme ==========================================================

.CODE

;-- Dclarations publiques ---------------------------------------------

public    _init320200                        ;Initialise le mode 320*200
public    _setpix                                      ;Dessine un pixel
public    _getpix                       ;Dtermine la couleur d'un pixel
public    _showpage                              ;Affiche la page 0 ou 1
public    _setpage                   ;Fixe la page pour setpix ou getpix
public    _getfontptr               ;Retourne un pointeur sur le jeu 8*8
public	  _setbigpix               ;affiche un gros pixel
public	  _oksetdac
public    _erasepage                 ;efface une page cran
public    _copypage                ;copie une page sur l'autre
public	  _dispevery		;affiche tout...


;-- INIT320200: initialise le mode graphique 320*200us -----------------
;-- Dclaration : void init320200( void );

_init320200 proc far

       ;-- On commence par dclencher le mode 13h pour que le BIOS -----
       ;-- effectue la plus grande partie de l'initialisation ----------
       ;-- Puis on modifie les registres qui n'ont pas encore le -------
       ;-- contenu souhait. -------------------------------------------

       mov   ax,0013h                               ;Appelle le mode 13h
       int   10h

       mov   dx,GC_INDEX                  ;Dsactive par le bit numro 4
       mov   al,GC_GRAPH_MODE        ;la sparation des adresses mmoire
       out   dx,al                      ;dans le registre mode graphique
       inc   dx                                 ;du contrleur graphique
       in    al,dx
       and   al,11101111b
       out   dx,al
       dec   dx

       mov   al,GC_MISCELL                 ;idem dans le registre divers
       out   dx,al                                  ;par le bit numro 1
       inc   dx                                                        ;
       in    al,dx
       and   al,11111101b
       out   dx,al

       mov   dx,SC_INDEX            ;Modifie le registre de mode mmoire
       mov   al,SC_MEM_MODE                   ;du contrleur de squence
       out   dx,al               ;de faon  mettre fin  la rpartition
       inc   dx                ;des adresses mmoire sur plusieurs plans
       in    al,dx                   ;de bits et  fixer le plan courant
       and   al,11110111b           ;par le registre de masquage binaire
       or    al,4                                                      ;
       out   dx,al

       mov   es,vio_seg                  ;avec le code couleur 00h et efface
       xor   di,di                                              ;l'cran
       mov   ax,di
       mov   cx,8000h
       rep   stosw

       mov   dx,CRTC_INDEX                  ;Met fin au mode double -mot
       mov   al,CC_UNDERLINE         ; par le moyen du bit 6 du registre
       out   dx,al               ; de soulignement du contrleur d'cran
       inc   dx
       in    al,dx
       and   al,10111111b
       out   dx,al
       dec   dx

       mov   al,CC_MODE_CTRL        ;Passe du mode mot au mode octet par
       out   dx,al            ;le moyen du bit 6 du registre de contrle
       inc   dx                           ;de mode du contrleur d'cran
       in    al,dx
       or    al,01000000b
       out   dx,al

       retf                                        ;retourne  l'appelant

_init320200 endp                                    ;Fin de la procdure

;-- SETPIX: Dessine un pixel dans une couleur donne  ------------------
;-- Dclaration : void setpix( int x, int y, unsigned char couleur );

_setpix    proc far

sframe     struc                            ;Structure d'accs  la pile
bp0         dw ?                                            ;Mmorise BP
ret_adr0    dd ?                         ;Adresse de retour  l'appelant
x0          dw ?                                             ;Abscisse X
y0          dw ?                                             ;Ordonne Y
couleur     dw ?                                                ;Couleur
sframe     ends                                     ;Fin de la structure

frame  equ [ bp - bp0 ]            ;adresse les lments de la structure

       push  bp                      ;Prpare l'adressage des paramtres
       mov   bp,sp                                  ; par le registre BP

       push  di                               ;Sauvegarde DI sur la pile

       mov   ax,PIXX / 4       ;Calcule l'offset dans la mmoire d'cran
       mul   frame.y0                                ;et le charge en DI
       mov   cx,frame.x0
       mov   bx,cx
       shr   bx,1
       shr   bx,1
       add   ax,bx
       mov   di,ax

       and   cl,3                  ;Calcule en AH le masque binaire pour
       mov   ah,1                                     ; adresser le plan
       shl   ah,cl
       mov   al,SC_MAP_MASK                    ;Numro du registre en AL
       mov   dx,SC_INDEX         ;Charge l'adresse d'index du squenceur
       out   dx,ax               ;Charge le registre de masquage binaire

       mov   es,vio_seg                ;ES pointe sur la mmoire d'cran
       mov   al,byte ptr frame.couleur       ;Charge la couleur du pixel
       stosb                          ; et la place dans le plan de bits

       pop   di                         ;Reprend le registre sur la pile
       pop   bp

       retf                                        ;Retourne  l'appelant

_setpix    endp                                     ;Fin de la procdure

;-- GETPIX: Dtermine la couleur d'un pixel   --------------------------
;-- Dclaration : unsigned char getpix( int x, int y );

_getpix    proc far

sframe1   struc                             ;Structure d'accs  la pile
bp1        dw ?                                             ;Mmorise BP
ret_adr1   dd ?                          ;Adresse de retour  l'appelant
x1         dw ?                                              ;Abscisse X
y1         dw ?                                              ;Ordonne Y
sframe1   ends                                      ;Fin de la structure

frame  equ [ bp - bp1 ]            ;adresse les lments de la structure

       push  bp                      ;Prpare l'adressage des paramtres
       mov   bp,sp                                   ;par le registre BP

       push  si                               ;Sauvegarde SI sur la pile

       mov   ax,PIXX / 4            ;calcule l'offset en mmoire d'cran
       mul   frame.y1                               ; et le charge en SI
       mov   si,frame.x1
       mov   cx,si
       shr   si,1
       shr   si,1
       add   si,ax

       and   cl,3                  ;calcule en AH le masque binaire pour
       mov   ah,cl                                     ;adresser le plan
       mov   al,GC_READ_MAP                    ;Numro du registre en AL
       mov   dx,GC_INDEX      ;Charge adresse index contrleur graphique
       out   dx,ax                          ;Charge le registre Read Map

       mov   es,vio_seg                ;ES pointe sur la mmoire d'cran
       mov   al,es:[si]                      ;Charge la couleur du pixel

       pop   si                         ;reprend le registre sur la pile
       pop   bp

       retf                                        ;retourne  l'appelant

_getpix    endp                                     ;Fin de la procdure




;-- SETPAGE: Slectionne la page concerne par les appels aux       ----
;--          fonctions setpix et getpix
;-- Dclaration : void setpage( unsigend char page );

_setpage   proc far

       pop   bx                              ;Dpile l'adresse de retour
       pop   ax
       pop   cx                                          ; et l'argument

       push  cx                             ; puis les remet sur la pile
       push  ax
       push  bx

       push  es

       mov   es,vio_seg

       mov   al,4                ;Octet fort du segment = page * 4 + A0h
       mul   cl
       or    al,0A0h

       mov   (byte ptr vio_seg)+1,al  ;Mmorise nouvelle adresse segment


       pop   es

       retf                                        ;retourne  l'appelant

_setpage   endp                                     ;Fin de la procdure

;-- SHOWPAGE: Affiche l'une des deux pages d'cran------
;-- Dclaration : void showpage( unsigend char page );

_showpage  proc far

       pop   bx                              ;Dpile l'adresse de retour
       pop   ax
       pop   cx                                          ; et l'argument

       push  cx
       push  ax                              ;puis les remet sur la pile
       push  bx

       mov   al,64                   ;Octet fort de l'offset = page * 64
       mul   cl
       mov   ah,al                         ;Octet fort de l'offset en AH

       ;-- Charge la nouvelle adresse de dbut--------------------------

       mov   dx,CRTC_INDEX                ;Adresse du contrleur d'cran
       mov   al,CC_START_HI                    ;Numro du registre en AL
       out   dx,ax                                   ;Effectue la sortie

       ;-- Attend un dbut de rafrachissement d'cran -----------------
       mov   dx,VERT_RETRACE                  ;Attend la fin du balayage
sp3:   in    al,dx                                             ;vertical
       test  al,8
       jne   sp3

sp4:   in    al,dx                  ;puis le dbut du retour du faisceau
       test  al,8
       je    sp4

       retf                                        ;Retourne  l'appelant

_showpage  endp                                     ;Fin de la procdure

;-- GETFONTPTR: Renvoie un pointeur FAR sur le jeu de caractres 8*8
;-- Dclaration : void far * getfontptr( void )

_getfontptr proc far

       push  bp                                           ;Sauvegarde BP

       mov   ax,1130h                              ;Charge les registres
       mov   bh,3
       int   10h                   ; puis dclenche l'interruption vido

       mov   dx,es                             ;Transfre ES:BP en DX:AX
       mov   ax,bp

       pop   bp                                  ;reprend BP sur la pile
       retf                                        ;Retourne  l'appelant

_getfontptr endp                                    ;Fin de la procdure


;my procedures qui tuent   (ou presque)

;affiche un gros pixel (2x2)


_setbigpix proc far

sframe     struc                            ;Structure d'accs  la pile
bp20        dw ?                                            ;Mmorise BP
ret_adr20   dd ?                         ;Adresse de retour  l'appelant
x20         dw ?                                             ;Abscisse X
y20         dw ?                                             ;Ordonne Y
couleur     dw ?                                                ;Couleur
sframe     ends                                     ;Fin de la structure

frame  equ [ bp - bp20 ]            ;adresse les lments de la structure

       push  bp                      ;Prpare l'adressage des paramtres
       mov   bp,sp                                  ; par le registre BP

       push  di                               ;Sauvegarde DI sur la pile

       mov   ax,PIXX / 2       ;Calcule l'offset dans la mmoire d'cran
       mul   frame.y20                                ;et le charge en DI
       mov   cx,frame.x20
       mov   bx,cx
       shr   bx,1
       add   ax,bx
       mov   di,ax

       and   cl,1                  ;Calcule en AH le masque binaire pour
       shl   cl,1
       mov   ah,11b                                     ; adresser le plan
       shl   ah,cl
       mov   al,SC_MAP_MASK                    ;Numro du registre en AL
       mov   dx,SC_INDEX         ;Charge l'adresse d'index du squenceur
       out   dx,ax               ;Charge le registre de masquage binaire

       mov   es,vio_seg                ;ES pointe sur la mmoire d'cran
       mov   al,byte ptr frame.couleur       ;Charge la couleur du pixel
       stosb                          ; et la place dans le plan de bits
       add   di,79
       stosb

       pop   di                         ;Reprend le registre sur la pile
       pop   bp

       retf                                        ;Retourne  l'appelant

_setbigpix    endp                                     ;Fin de la procdure






;modifie la palette de couleurs, comme dans la bible...

_oksetdac	proc	far

sframe		struc

bp0		dw 	?
re_adr0		dd	?
debut		dw	?
nombre		dw	?
offs		dw	?
segm		dw	?

sframe		ends

frame		equ	[bp-bp0]

		push	bp
		mov	bp,sp

		push	es

		mov	ax,frame.segm
		mov	es,ax

		mov	ax,1012h
		mov	bx,frame.debut
		mov	cx,frame.nombre
		mov	dx,frame.offs

		nop
		nop
		nop
		nop
		nop


		int	10h

		pop	es

		pop	bp
		retf


_oksetdac	endp


;***************** efface une page, bourrin, peut toujours servir******

_erasepage proc far

sframe        struc
bp0            dw ?
ret_adr0       dd ?

pg             db ?

sframe        ends

frame    equ    [bp-bp0]

	 push   bp
	 mov    bp,sp

	 push	es
	 push	di

	 mov    al,frame.pg
	 shl    ax,10
	 add    ah,0A0h
	 mov    es,ax

	 cld

	 mov	dx,SC_INDEX
	 mov	al,SC_MAP_MASK
	 mov	ah,1111b
	 out	dx,ax

	 mov    di,0
	 xor    al,al
	 mov    cx,80*200

	 rep    stosb

	 pop	es
	 pop	di

	 pop    bp
	 retf


_erasepage endp


;***************** copie une page sur l'autre                 ******

_copypage proc far

sframe        struc
bp0            dw ?
ret_adr0       dd ?

src           db ?
dst           db ?

sframe        ends

frame    equ    [bp-bp0]

	 push   bp
	 mov    bp,sp

	 mov    ax,0A000h
	 mov    es,ax

	 cld

	 mov    cx,4

bccop1:  push   cx
	 mov    ax,0080h
	 shl    ax,cl
	 mov    al,SC_MAP_MASK                    ;Numro du registre en AL
	 mov    dx,SC_INDEX         ;Charge l'adresse d'index du squenceur
	 out    dx,ax               ;Charge le registre de masquage binaire

	 mov    ah,cl
	 dec    ah
	 mov    al,GC_READ_MAP                    ;Numro du registre en AL
	 mov    dx,GC_INDEX      ;Charge adresse index contrleur graphique
	 out    dx,ax

	 mov    al,frame.dst
	 shl    ax,14
	 mov    di,ax

	 mov    al,frame.src
	 shl    ax,14
	 mov    si,ax

	 mov    cx,80*200/2

	 rep    movsw

	 pop    cx
	 loop   bccop1


	 pop    bp
	 retf


_copypage endp


;******* affichage           ************************************

_dispevery	proc	far

sframe		struc

bp0		dw	?
ret_adr0        dd	?
Xmin		dw	?
Ymin		dw	?
sizex		dw	?
sizey		dw	?
resol		dw	?
pagemem		dw	?
		dw	?
&tab		dw	?

sframe		ends

frame		equ	[bp-bp0]

		push	bp
		mov	bp,sp

		push	ds
		push	es
		push	di
		push	si

		mov     es,vio_seg    ;ES pointe sur la mmoire cran


		mov	ax,frame.Ymin
		mov	bx,80
		mov	cx,frame.resol
		inc	cx
		shl	cx,1
		mul	cx
		mul	bx

		mov	bx,frame.Xmin

		neg	cx
		add	cx,4
		shr	cl,1
		shr	bx,cl

		add	ax,bx
		mov     di,ax     ;di pointe sur le pt en haut  gauche

		mov	ax,frame.&tab
		mov	ds,ax     ;ds=dbut du tableau

		mov	si,frame.pagemem ;on pointe sur une page par si...

		mov	dx,SC_INDEX   ;on prpare dx pour les "out"
		mov	al,SC_MAP_MASK ;idem pour al

		mov	cx,frame.resol
		or	cx,cx
		je	stdspev1
		call	dispeverylow
		jmp	stdspev2
stdspev1:	call    dispeveryhigh
stdspev2:


		pop	si
		pop	di
		pop	es
		pop	ds

		pop 	bp

		retf


_dispevery	endp


;cas haute rsolution

dispeveryhigh	proc	near

		mov	cx,frame.sizey
bcdspevh1:      push	cx

		mov	cx,frame.sizex
		shr	cx,1          ;on divise par 2
bcdspevh2:
		mov	ah,00000011b
		out     dx,ax

		mov	bl,ds:[si]
		mov     es:[di],bl
		add	di,80
		mov	es:[di],bl
		sub	di,80

		mov	bx,ds
		inc	bx
		mov	ds,bx

		mov	ah,00001100b
		out	dx,ax

		mov	bl,ds:[si]
		mov	es:[di],bl
		add	di,80
		mov	es:[di],bl
		sub	di,79

		mov	bx,ds
		inc	bx
		mov	ds,bx

		loop	bcdspevh2

		add     di,160
		mov	bx,frame.sizex
		shr	bx,1
		sub	di,bx

		pop	cx
		loop	bcdspevh1

		ret

dispeveryhigh	endp


;cas basse rsolution

dispeverylow	proc	near

		mov	ah,00001111b
		out	dx,ax

		mov	bx,ds

		mov	cx,frame.sizey
bcdspevl1:      push	cx

		mov	cx,frame.sizex
		mov	dx,cx


bcdspevl2:

		mov	al,ds:[si]
		mov     es:[di],al
		add	di,80
		mov	es:[di],al
		add	di,80
		mov	es:[di],al
		add	di,80
		mov	es:[di],al
		sub	di,239

		inc	bx
		mov	ds,bx

		loop	bcdspevl2

		add     di,320
		sub	di,dx

		pop	cx
		loop	bcdspevl1

		ret

dispeverylow	endp




end