
;routines clavier et assembleur de Liquid War


.286

DOSSEG

.MODEL LARGE

;*****utilise un programme de la bible..........


KB_STATUS_P   equ 64h                            ;Port d'tat du clavier
KB_DATA_P     equ 60h                        ;Port de donnes du clavier

OB_FULL       equ 1                ;Bit 0 dans le port d'tat du clavier
				  ;un caractre dans le buffer de sortie
IB_FULL       equ 2                ;Bit 1 dans le port d'tat du clavier
				   ;un caractre dans le buffer d'entre

ACK_SIGNAL    equ 0fah            ;Signal accus de rception du clavier
SET_TYPEM     equ 0f3h                               ;Code Set Typematic

MAX_TRY       equ 3                       ;Nombre de tentatives permises


KB_PORT		=60h
SEG_BUF_KEY	=40h
NEXT_CHAR	=1Ah
LAST_CHAR	=1Ch



.FARDATA


tabis		dd 32 dup (0)          ;tableau tmoin
tabhasbeen	dd 32 dup (0)          ;mme genre, pas tout  fait pareil
vecteur9	dd ?            ;pour stocker le vecteur int09h normal


.CODE


;********************  dclarations  ************************************



public _runscanmode          ;lance la gestion du clavier par scan-codes
public _leavescanmode	      ;revient au mode habituel utilisant int 16h
public _iskey               ;teste si une touche est enfonce ou pas
public _hasbeenkey          ;teste si une touche a t enfonce
public _resetkeys            ;remet les touches a 0 (pour hasbeenkey)
public _paramkeybd		;envoie des infos au clavier (repet etc...)



;-----------------------------------------------------------------------
;-- SET_TYPM: Transmet la vitesse Typematic au contrleur du clavier ---
;
;-- Appel depuis C: bool set_typem( byte trate );
;-- Renvoie : TRUE, si la vitesse Typematic a pu tre fixe
;--               FALSE si une erreur est survenue

;******************** corps du programme ***********************************





;******lance la gestion du clavier par scan-codes (adapt aux jeux...)**
;******l'ancienne int09h a ici completly disparue a-pu BIOS...**********

_runscanmode	proc	far



		push	ds
		push	es
		push	di

		cld                         ;traitement croissant

		mov	ax,@FARDATA
		mov	ds,ax
		mov	es,ax

		xor	ax,ax

		mov	di,offset tabis
		mov	cx,64
		rep	stosw                ;tabis mis a zro

		mov	di,offset tabhasbeen
		mov	cx,64
		rep	stosw                 ;idem pour tabhasbeen


		mov	ax,3509h	      ;lit le vecteur normal % es,bx
		int	21h
		mov	cx,bx
		mov	bx,offset vecteur9
		mov     [bx+2],es
		mov	[bx],cx             ;on le sauve


				;! ici ds vaut n'importe quoi



		mov	dx,offset depoteint09h
		mov	ax,cs
		mov	ds,ax
		mov     ax,2509h
		int	21h			;nouveau vecteur

		call	emptybuff

				;! ici ds vaut n'importe quoi

		pop	di
		pop	es
		pop	ds







		retf

depoteint09h:

		pushf
		pusha
		push	ds



		mov	ax,@FARDATA
		mov	ds,ax

		in	al,KB_PORT

		cmp	al,128       ;make code ou break code
		jb	stnew9h4

		 ;c'est un break code

		xor 	ah,ah
		sub	al,128
		mov	bx,offset tabis
		add	bx,ax            ;bx pointe sur la case de tabis
		xor	al,al
		mov	[bx],al

		jmp	stnew9h5

stnew9h4:        ;c'est un make code

		mov	cl,01h
		xor	ah,ah

		mov	bx,offset tabis
		add	bx,ax
		mov	[bx],cl          ;on met a 1 la case de tabis

		mov	bx,offset tabhasbeen
		add	bx,ax
		mov	[bx],cl          ;et celle de tabhasbeen


stnew9h5:

		in	al,61h
		mov	ah,al
		or	al,80h
		out	61h,al
		mov	al,ah

		nop
		nop
		nop
		nop
		nop


		out	61h,al
		mov	al,20h
		out	20h,al

		pop	ds
		popa
		popf


		iret



_runscanmode	endp






;********vide le buffer de int16h**************************************

emptybuff	proc	near

		mov	ax,SEG_BUF_KEY
		mov	ds,ax
		mov	bx,LAST_CHAR
		cli
		mov  	ax,[bx]
		mov     bx,NEXT_CHAR
		mov	[bx],ax
		sti

		ret

emptybuff       endp


;**********revient  une gestion normale du clavier*********************

_leavescanmode	proc	far

		push	ds

		mov	ax,@FARDATA
		mov	ds,ax

		mov	bx,offset vecteur9
		mov     cx,[bx+2]
		mov	dx,[bx]
		mov	ds,cx
		mov	ax,2509h
		int	21h		;poke nouveau vecteur % ds,dx

				;! ici ds vaut n'importe quoi



		pop	ds

		retf

_leavescanmode	endp



;******teste si une touche est enfonce********************************

_iskey		proc	far



		pop	ax		;dpile l'adresse retour
		pop	bx
		pop	cx		;on rcupre le scan-code
		push	cx
		push	bx
		push	ax

		push	ds

		mov	ax,@FARDATA
		mov	ds,ax

		mov	bx,offset tabis
		add	bx,cx
		mov	al,[bx]

		pop	ds

		retf

_iskey		endp


;*****teste si une touche a t enfonce depuis le dernier resetkeys*****


_hasbeenkey	proc	far

		pop	ax              ;dpile l'adresse retour
		pop	bx
		pop	cx                   ;on prend le scancode
		push	cx
		push	bx
		push	ax

		push	ds

		mov	ax,@FARDATA
		mov	ds,ax

		mov	bx,offset tabhasbeen
		add	bx,cx
		mov	al,[bx]

		pop	ds

		retf

_hasbeenkey	endp



;*******remet le tableau tabhasbeen  zro****************************

_resetkeys	proc	far

		push	ds
		push	es
		push	di
		push	si

		mov     ax,@FARDATA
		mov	es,ax
		mov	ds,ax

		mov	di,offset tabhasbeen
		mov     si,offset tabis

		mov	cx,64
		rep	movsw

		pop	si
		pop	di
		pop	es
		pop	ds

		retf

_resetkeys	endp


;**** la routine qui suit s'inspire plus que largement de la routine
;**** set_tymp de la bible!...


_paramkeybd  proc far


       pop  	ax
       pop	bx
       pop  	cx
       push 	cx
       push	bx
       push	ax

       xor  dx,dx                     ;Transmission a priori dfectueuse
       mov  ah,SET_TYPEM          ;Commande de fixation vitesse Typmatic
       cli                                     ;Inhibe les interruptions
       call send_kb                                  ;Vers le contrleur
       jne  error                                ;Erreur ? Oui --> Error

       mov  ah,cl                              ;cl=param venant du C

       call send_kb                                  ;Vers le contrleur
       jne  error                                  ;Erreur Oui --> Error

       inc  dl                               ;tout va bien ,renvoie TRUE

error: sti                                   ;Rtablit les interruptions
       mov  ax,dx                      ;Charge la valeur de retour en AX

       retf                              ;Rend la main au programme en C

_paramkeybd  endp

;-----------------------------------------------------------------------
;-- SEND_KB: envoie un octet au contrleur du clavier ------------------
;-- Entre   : AH = octet  evoyer
;-- Sortie : Indicateur de zro : 0=Erreur , 1=o.k.
;-- Registres : AX et le registres des indicateurs
;     sont modifis
;-- Info     : Routine  usage interne, ne peut tre appele
;--            qu' partir du prsent module

send_kb   proc near

      push cx                                 ;Empile tous les registres
      push bx                                   ;modifis par la routine

      mov  bl,MAX_TRY                     ;Nombre de tentatives tolres

                ;-- Attend que le contrleur puisse recevoir des donnes

skb_1:    xor  cx,cx                        ;65536 itrations au maximum
skb_2: in   al,KB_STATUS_P                ;Lit le contenu du port d'tat
       test al,IB_FULL        ; Reste-t-il un caractre dans le buffer ?
       loopne skb_2                                       ;Oui --> SKB_2

                                   ;-- Envoie un caractre au contrleur

        mov  al,ah                         ;Transfre le caractre en AL
        out  KB_DATA_P,al                  ;puis dans le port de donnes
skb_3:    in   al,KB_STATUS_P             ;Lit le contenu du port d'tat
        test al,OB_FULL              ;Rponse dans le buffer de sortie ?
        loope skb_3                                      ;Non  --> SKB_3

                 ;-- Lit et exploite la rponse du contrleur ----------

        in   al,KB_DATA_P                        ;Lit le port de donnes
        cmp  al,ACK_SIGNAL                          ;Caractre accept ?
        je   skb_end                                ;Oui--> tout va bien

          ;-- Le caractre n'a pas t accept   -----------------------

        dec  bl                        ;Dcrmente le compteur d'erreurs
        jne  skb_2                               ;Peut-on recommencer  ?
                                                           ;Oui--> SKB_2

        or   bl,1                 ;Non , Mettre  0 l'indicateur de zro
						 ;pour signaler l'erreur

skb_end: pop  bx                       ;Dpile les registres sauvegards
	 pop  cx                                                       ;
	 ret                                      ;Retourne  l'appelant

send_kb   endp



end