/*routines graphiques de Liquid War*/



#include "lwhd09.h"

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>


/*-- Constantes ------------------------------------------------------*/

#define MAXX 319                             /* Coordonnes maximales */
#define MAXY 199





/*  IsVga: Teste la prsence d'une carte VGA                            */

BYTE IsVga( void )
{
 union REGS   Regs;            /* Registres pour grer l'interruption */

 Regs.x.ax = 0x1a00;            /* La fonction 1Ah n'existe qu'en VGA */
 int86( 0x10, &Regs, &Regs );
 return ( Regs.h.al == 0x1a );               /* Est-elle disponible ? */
}


/*  OutVga: retour au mode texte                                        */

void OutVga( void )
{
   union REGS regs;

   regs.x.ax=0x0003;
   int86(0x10,&regs,&regs);
}



/*  GetDac: Dtermine les contenus d'un certain nombre de registres DAC */

void GetDac( int First, int Nbr, void far *BufP )
{
 union REGS    Regs;       /* Registres proc. pour grer interruption */
 struct SREGS  SRegs;                         /* Registres de segment */

 Regs.x.ax = 0x1017;          /* Numro de la fonction et de l'option */
 Regs.x.bx = First;                 /* Numro du premier registre DAC */
 Regs.x.cx = Nbr;                    /* Nombre de registres  charger */
 Regs.x.dx = FP_OFF( BufP );
 SRegs.es  = FP_SEG( BufP );                /* Pointeur sur le buffer */
 int86x( 0x10, &Regs, &Regs, &SRegs );         /* Dclenche int. BIOS */
}

/*  SetDac: Charge un certain nombre de registres DAC                   */

void SetDac( int First, int Nbr, void far *BufP )
{
 union REGS    Regs;               /* Registres proc. pour grer int. */
 struct SREGS  SRegs;                         /* Registres de segment */

 Regs.x.ax = 0x1012;          /* Numro de la fonction et de l'option */
 Regs.x.bx = First;                 /* Numro du premier registre DAC */
 Regs.x.cx = Nbr;                    /* Nombre de registres  charger */
 Regs.x.dx = FP_OFF( BufP );
 SRegs.es  = FP_SEG( BufP );                 /* Pointeur sur le buffer*/
 int86x( 0x10, &Regs, &Regs, &SRegs );         /* Dclenche int. BIOS */
}


/*  ChangeDacReg: Modifie le contenu d'un registre DAC en mmoire       */

void ChangeDacReg( DACREG *DRegP, BYTE Num, BYTE Comp, BYTE Val )
{
 if(( DRegP->RGB[ Comp ] = Val) > 63 )  /* Incrmente la composante */
   DRegP->RGB[ Comp ] = 0;                    /* Sup  53: ramne  0 */
 SetDac( Num, 1, DRegP );                   /* Charge le registre DAC */
}






/*recopie 1 page sur l'autre, utilis car assembleur bugg (shame on me)*/

void copiepage(BYTE src,BYTE dst)

{
  int i,j;
  BYTE buffer[320];

  for (i=0;i<200;++i)
     {
      setpage(src);
      for (j=0;j<320;++j)
	 buffer[j]=getpix(j,i);
      setpage(dst);
      for (j=0;j<320;++j)
	 setpix(j,i,buffer[j]);
     }
}



/*--------montre la palette de couleurs--------------------------------*/

void showpal(void)

{
   int i,j,k;

   for (i=0;i<4;++i)
      {
       setpage(i);
       for (j=180;j<200;++j)
	  for (k=0;k<256;++k)
	     setpix(k,j,(BYTE) k);
      };

}


/*--Charge les couleurs d'un fichier PCX----------------------*/

void initcolors(NOM fichier,int first,int last)
{
   int i,j;
   FILE *f;
   DACARRAY dakar;


   f=fopen(fichier,"r+b");
   fseek(f,(first-256)*3,SEEK_END);

   for (i=0;i<=(last-first);++i)
	 for (j=0;j<3;++j)
		dakar[i].RGB[j]=getc(f)>>2;
   SetDac(first,last-first+1,(FPT) &dakar);

   fclose(f);

};


/*---Charge 1 fichier PCX sur l'ecran actif, merci ThomThom---------------*/

void chargepcx(NOM fichier)
{
	BYTE	l=1;
	BYTE	c;
	FILE	*f;
	int	X=0;
	int	Y=0;

	f=fopen(fichier,"r+b");
	fseek(f,128,0);
	for(Y=0;Y<200;Y++)
	  for(X=0;X<320;X++)
		{
		if (--l==0)
			{	c=getc(f);
				if (c>192)
					{ l=c-192; c=getc(f); }
				else
					l=1;
			}
		setpix(X,Y,c);
		}
	fclose(f);
}



/*--Charge un tableau ---------------------------------------------------*/

void chargetab(NOM fichier)
{

	int i,j,g,h;
	unsigned int l=0,m=63999;
	int k=0;
	int a,b;
	FILE *f;



	chargepcx(fichier);

	f=fopen(fichier,"r+b");

	fseek(f,-224*3,SEEK_END);

	for (i=32;i<64;++i)
		for (j=0;j<3;++j)
			colortab[i].RGB[j]=getc(f)>>2;

	fclose(f);

	while (getpix(l%320,l/320)==255) l++;
	while (getpix(m%320,m/320)==255) m--;

	sizex=mini((m-l)%320+1,160);
	sizey=mini((m-l)/320+1,100);

	resolution=((sizex>80)||(sizey>50)) ? 0 : 1;

	Xmin=(160-resolution*80-sizex)/2;
	Ymin=(100-resolution*50-sizey)/2;

	a=m%320+1;
	b=m/320+1;

	for (j=l/320;j<b;++j)
	    for (i=l%320;i<a;++i)
		  pokeall(getpix(i,j),k++,bigtab);



}

/*--Charge la palette du pic-------------------*/

void setpalpic(void)

{
	oksetdac(0,256,(FPT) &colorpic);
}

/*---Charge la palette du tableau--------------*/

void setpaltab(void)

{
	oksetdac(0,256,(FPT) &colortab);
}




/*--Rempli la palette des couleurs des gradients et celle des curseurs--*/

void calculpal(DACREG color[6])

{
	int i,j,k;

	for (i=0;i<6;++i)
	   for (j=0;j<32;++j)
	       for (k=0;k<3;++k)
		   colortab[64+i*32+j].RGB[k]
		   =(((int) color[i].RGB[k])*(j+9))/40;



	for (i=0;i<6;++i)
	   for (k=0;k<3;++k)
	       {
	       colortab[20+i*2].RGB[k]=16+color[i].RGB[k]/4;
	       colortab[20+i*2+1].RGB[k]=48+color[i].RGB[k]/4;
	       }

}

/*----initialisation palette primaire------------*/

void initpal(void)

{
	int	i;

	DACREG	color[]={  63, 0, 0,
			   0, 63, 0,
			   0, 0, 63,
			   63, 63, 0,
			   63, 0, 63,
			   0, 63, 63 };

	DACREG  colorbis[]={ 1,1,3,
			     63,32,32,
			     32,16,16,
			     8,56,8,
			     2,2,8,
			     3,3,12,
			     4,4,16,
			     0,0,0};

	calculpal(color);


	for (i=0;i<8;++i)
		colortab[i]=colorbis[i];



}




/*affiche le terrain de jeu (utilisation conventionnelle de dispevery)*/

void dispallsquare(void)

{
	dispevery (Xmin,Ymin,sizex,sizey,resolution,1,bigtab);
}


/*--affiche un gradient */

void dispallgradient(int num)

{
       dispevery (Xmin,Ymin,sizex,sizey,resolution,4+2*num,bigtab);
}

/*--- charge le fichier pcx dcor ------------------------------------*/

void loaddecor(void)

{
	FILE *f;
	int i,j;

	f=fopen(INTROFILE,"r+b");
	fseek(f,-256*3,SEEK_END);

	for (i=0;i<256;++i)
		for (j=0;j<3;++j)
			colorpic[i].RGB[j]=getc(f)>>2;


	fclose(f);

	chargepcx(INTROFILE);
}




/*-- affiche un curseur     */

void disponecursor(int n,int parity)

{

	int posx,posy,px,py;
	int c,cbase;
	int i,j;
	int xm,ym,xM,yM;
	int teta;
	int coef;



	static BYTE tampon[12][12];

	coef=1+resolution;
	posx=(Xmin+cursor[n].x)*2-6;
	posy=(Ymin+cursor[n].y)*2-6;
	cbase=20+cursor[n].color*2;

	teta=(cursor[n].rot+=4000);

	for (i=0;i<3;++i)
		{
		px=6+(signed long) (cosinus(teta)/17000);
		py=6+(signed long) (sinus(teta)/17000);

		tampon[px][py-1]=
		tampon[px+1][py-1]=
		tampon[px+2][py]=
		tampon[px+2][py+1]=
		tampon[px+1][py+2]=
		tampon[px][py+2]=
		tampon[px-1][py+1]=
		tampon[px-1][py]=cbase;

		tampon[px][py]=
		tampon[px+1][py]=
		tampon[px+1][py+1]=
		tampon[px][py+1]=cbase+1;

		teta+=21845;
		}


	xm=maxi(0,6-2*cursor[n].x);
	xM=mini(12,6+2*(sizex-cursor[n].x));
	ym=maxi(0,6-2*cursor[n].y);
	yM=mini(12,6+2*(sizey-cursor[n].y));

	if (resolution)
		for (j=ym;j<yM;++j)
			for (i=xm;i<xM;++i)
				if (c=tampon[i][j])
					setbigpix(posx+i,posy+j,c);


	if (!resolution)
		for (j=ym;j<yM;++j)
			for (i=xm;i<xM;++i)
				if (c=tampon[i][j])
					setpix(posx+i,posy+j,c);

	for (j=0;j<12;++j)
		for (i=0;i<12;++i)
			tampon[i][j]=0;
}

void dispallcursor(int parity)

{
	int i;


	for (i=0;i<MAXCURSOR;++i)
		{
		if (cursor[i].visible=cursor[i].visible
				     &&(stillhowmany(cursor[i].color)!=0))
			disponecursor(i,parity);
		}

}

void dispchoose(void)

{
	int x,y;
	BYTE c;
	int a,b;



	if (resolution)
		{
		for (y=0;y<sizey;++y)
		for (x=0;x<sizex;++x)
			{
			c=(int) (peekwhatis(x,y,sizex,bigtab)>>8);
			a=(x+Xmin)*2+159;
			b=(y+Ymin)*2+99;
			setpix(a,b,c);
			setpix(a,++b,c);
			setpix(++a,b,c);
			setpix(a,--b,c);
			}
		}
	else
		{
		for (y=0;y<sizey;++y)
		for (x=0;x<sizex;++x)
			setpix(x+159+Xmin,y+99+Ymin,
			       (int) (peekwhatis(x,y,sizex,bigtab)>>8));
		}

}

void fullbox(int x1,int y1,int x2,int y2,BYTE coul)

{
	int x,y;

	for (y=y1;y<=y2;++y)
		for (x=x1;x<=x2;++x)
			setpix(x,y,coul);
}

void cleardispchoose(void)

{
	fullbox(159,99,318,198,0);
}

void box(int x1,int y1,int x2,int y2,BYTE coul)

{
	int i;

	if (x1>x2)
		{
		i=x1;
		x1=x2;
		x2=i;
		}

	if (y1>y2)
		{
		i=y1;
		y1=y2;
		y2=i;
		}

	for (i=x1;i<=x2;++i)
		{
		setpix(i,y1,coul);
		setpix(i,y2,coul);
		}

	for (i=y1;i<=y2;++i)
		{
		setpix(x1,i,coul);
		setpix(x2,i,coul);
		}

}

void displetter(int x,int y,int letter)

{
	static BYTE graphletter[]={

			0,0,0,
			0,0,0,
			0,0,0,
			0,0,0,
			0,0,0,
			0,0,0,

			0,1,0,
			1,0,1,
			1,0,1,
			1,1,1,
			1,0,1,
			1,0,1,

			1,1,0,
			1,0,1,
			1,1,0,
			1,0,1,
			1,0,1,
			1,1,0,

			0,1,0,
			1,0,1,
			1,0,0,
			1,0,0,
			1,0,1,
			0,1,0,

			1,1,0,
			1,0,1,
			1,0,1,
			1,0,1,
			1,0,1,
			1,1,0,

			1,1,1,
			1,0,0,
			1,1,0,
			1,0,0,
			1,0,0,
			1,1,1,

			1,1,1,
			1,0,0,
			1,1,0,
			1,0,0,
			1,0,0,
			1,0,0,

			0,1,1,
			1,0,0,
			1,0,0,
			1,0,1,
			1,0,1,
			0,1,0,

			1,0,1,
			1,0,1,
			1,1,1,
			1,0,1,
			1,0,1,
			1,0,1,

			1,1,1,
			0,1,0,
			0,1,0,
			0,1,0,
			0,1,0,
			1,1,1,

			0,0,1,
			0,0,1,
			0,0,1,
			0,0,1,
			1,0,1,
			0,1,0,

			1,0,1,
			1,0,1,
			1,1,0,
			1,0,1,
			1,0,1,
			1,0,1,

			1,0,0,
			1,0,0,
			1,0,0,
			1,0,0,
			1,0,0,
			1,1,1,

			1,0,1,
			1,1,1,
			1,0,1,
			1,0,1,
			1,0,1,
			1,0,1,

			1,0,1,
			1,0,1,
			1,1,1,
			1,1,1,
			1,0,1,
			1,0,1,

			0,1,0,
			1,0,1,
			1,0,1,
			1,0,1,
			1,0,1,
			0,1,0,

			1,1,0,
			1,0,1,
			1,0,1,
			1,1,0,
			1,0,0,
			1,0,0,

			0,1,0,
			1,0,1,
			1,0,1,
			1,0,1,
			1,1,1,
			0,1,1,

			1,1,0,
			1,0,1,
			1,0,1,
			1,1,0,
			1,0,1,
			1,0,1,

			0,1,1,
			1,0,0,
			0,1,0,
			0,0,1,
			0,0,1,
			1,1,0,

			1,1,1,
			0,1,0,
			0,1,0,
			0,1,0,
			0,1,0,
			0,1,0,

			1,0,1,
			1,0,1,
			1,0,1,
			1,0,1,
			1,0,1,
			1,1,1,

			1,0,1,
			1,0,1,
			1,0,1,
			1,0,1,
			1,0,1,
			0,1,0,

			1,0,1,
			1,0,1,
			1,0,1,
			1,0,1,
			1,1,1,
			1,0,1,

			1,0,1,
			1,0,1,
			0,1,0,
			1,0,1,
			1,0,1,
			1,0,1,

			1,0,1,
			1,0,1,
			0,1,0,
			0,1,0,
			0,1,0,
			0,1,0,

			1,1,1,
			0,0,1,
			0,1,0,
			0,1,0,
			1,0,0,
			1,1,1,


			};

	int i,j;

	for (j=0;j<10;++j)
		for (i=0;i<5;++i)
			setpix(x+i,y+j,COULBACK+random(3));

	for (j=0;j<6;++j)
		for (i=0;i<3;++i)
			if (graphletter[letter*18+j*3+i])
				setpix(x+1+i,y+2+j,COULWRITE);



}