/* dclarations externes etc... de Liquid War */



/*-- Constantes -----------------------------------------------------*/

#define MAXCURSOR 26

#define INTROFILE "lwpic.pcx"
#define SETFILE "lwset.dat"
#define TABFILE "lwtab???.pcx"


#define COULEMPTY 0
#define COULBOX 1
#define COULNOBOX 2
#define COULWRITE 3
#define COULBACK 4

/*-- Dclarations de types -------------------------------------------*/

typedef char *NOM;
typedef unsigned char BYTE;
typedef union {                             /* Dcrit un registre DAC */
	       struct { BYTE Rouge, Vert, Bleu; } b;
	       BYTE RGB[3];
	      } DACREG;
typedef DACREG DACARRAY[256];                   /* Table DAC complte */
struct ALLIN16 { BYTE screendata[4];int gradient[6]; };
typedef ALLIN16 far *ALLIN16PTR;
typedef void far *FPT;
struct CURSOR { int x,y;
		int val,rot;
		BYTE select,actif,visible;
		BYTE shifted;
		BYTE team,color;
		BYTE up,right,down,left,shift; };
typedef BYTE TABWHERECURSOR[6][6][4];
struct KEYSET { BYTE up,down,left,right,shift; };
typedef KEYSET TABKEYCURSOR[MAXCURSOR];

/*---- Variables globales ------------------*/

extern long far *tabcos;
extern long far *tabsin;
extern ALLIN16 far *bigtab;
extern BYTE resolution;
extern int Xmin,Ymin,sizex,sizey;
extern CURSOR cursor[MAXCURSOR];
extern TABKEYCURSOR tabkeycursor;
extern TABWHERECURSOR tabwherecursor;
extern int chosentab;

extern DACARRAY colortab;
extern DACARRAY colorpic;

/*---- rfrences  l'assembleur -----------*/


extern "C" void init320200( void );
extern "C" void setpix( int x, int y, unsigned char couleur);
extern "C" void setbigpix( int x,int y, unsigned char couleur);
extern "C" BYTE getpix( int x, int y );
extern "C" void setpage( BYTE page );
extern "C" void showpage( BYTE page );
extern "C" void far * getfontptr( void );
extern "C" void oksetdac(int first,int size,FPT adr);
extern "C" void erasepage(BYTE page);
extern "C" void copypage(BYTE source,BYTE destination);
extern "C" void dispevery(int Xmin,int Ymin,int sizex,int sizey,
		     int resol,
		     int pagemem,
		     ALLIN16PTR bigtab);

extern "C" void pokebyte(int offs,int segm,BYTE vale);
extern "C" BYTE peekbyte(int offs,int segm);
extern "C" void far *alsegoff(void far *ptr);

extern "C" void runscanmode(void);
extern "C" void leavescanmode(void);
extern "C" BYTE iskey(int scancode);
extern "C" BYTE hasbeenkey(int scancode);
extern "C" void resetkeys(void);
extern "C" BYTE paramkeybd(int param);

extern "C" int stillhowmany(int n);
extern "C" void fillgoto(void);
extern "C" void boostgradient(int sizex,int sizey,
			      int numgrad,int dir,
			      ALLIN16PTR bigtab);
extern "C" unsigned int peekgradient(int item,int numgrad,
				     ALLIN16PTR bigtab);
extern "C" void pokegradient(int val,int item,int numgrad,
			     ALLIN16PTR bigtab);
extern "C" void pokeall(int val,int item,ALLIN16PTR bigtab);
extern "C" unsigned int peekwhatis(int x,int y,int sizex,
				   ALLIN16PTR bigtab);
extern "C" void clearmen(int x,int y,ALLIN16PTR bigtab);
extern "C" void putman(int x,int y,int sizex,int team,int health,
		       ALLIN16PTR bigtab);
extern "C" void boostsquare(int sizex,int sizey,int updown,
			    int recharge,int semidecharge,int decharge,
			    ALLIN16PTR bigtab);

/* rfrences aux autres fc externes */


extern int mini(int a,int b);
extern int maxi(int a,int b);
extern long cosinus(int angle);
extern long sinus(int angle);
extern void far *coolfarmalloc(unsigned long n);
extern void allocseg(void);
extern void filltabval(void);
extern void seeseg(void);
extern void truc(void);
extern void disphowmany();
extern int cangoto(int x,int y);
extern int vasymimile(void);
extern void theprog(void);


extern BYTE IsVga( void );
extern void OutVga( void );
extern void GetDac( int First, int Nbr, void far *BufP );
extern void SetDac( int First, int Nbr, void far *BufP );
extern void ChangeDacReg( DACREG *DRegP, BYTE Num, BYTE Comp, BYTE Val );
extern void copiepage(BYTE src,BYTE dst);
extern void showpal(void);
extern void loaddecor(void);
extern void setpalpic(void);
extern void setpaltab(void);
extern void initcolors(NOM fichier,int first,int last);
extern void chargepcx(NOM fichier);
extern void chargetab(NOM fichier);
extern void calculpal(DACREG couleur[6]);
extern void initpal(void);
extern void dispallsquare(void);
extern void dispallgradient(int num);
extern void disponecursor(int n,int parity);
extern void dispallcursor(int patity);
extern void dispchoose(void);
extern void fullbox(int x1,int y1,int x2,int y2,BYTE coul);
extern void cleardispchoose(void);
extern void box(int x1,int y1,int x2,int y2,BYTE coul);
extern void displetter(int x,int y,int letter);

extern void outesc(void);
extern void tempo(long temps);
extern void wait(void);
extern void scanwait(void);
extern int nokey(int k);
extern int noesc(void);
extern int noenter(void);
extern void waitnokey(void);
extern BYTE givekey(void);
extern BYTE firstkey(void);
extern void defkeycursor(void);
extern void movecursor(void);

extern void refreshgradient(int numgrad,int dir);
extern void refreshallgradient(void);
extern void putmen(int team,int health,int number);
extern void randommen(int team,int health,int number);
extern void putsomemen(void);
extern int getfreeroom(void);
extern void putmenenhanced(int pourcent);
extern void randomcursor(void);
extern void pokeallcursor(void);
extern void movesquare(void);

extern void createset(void);
extern void loadset(void);
extern void setcadre(void);
extern int choixduroi(void);
extern int choixcurseur();
extern int choixpeople(void);
extern int choixclavier();
extern int choseindir(void);
extern int choixtableau(void);