'LANDER.BAS
'A Lunar Lander program
'Started 12/4/95 by Chris Sequeira
'press SHIFT + F5 to run...
'to exit QBASIC, select Exit from the file menu.

'*****************************************
'Menus data type
TYPE Menus
        MenuName AS STRING * 10
        StartCoord AS INTEGER
        EndCoord AS INTEGER
END TYPE

'define the data type for color hues
TYPE Hues
      Red AS INTEGER
      Green AS INTEGER
      Blue AS INTEGER
END TYPE


DEFINT A-Z        'set default data type to INTEGER

'game stuff
DECLARE SUB SetColors (pal() AS Hues, fc, lc)   'sub to set colors
DECLARE SUB MilliDelay (msecs)                  'sub to create delays
DECLARE SUB DrawTerrain (level)           'sub to draw terrain
DECLARE SUB DoLander ()                   'sub to run main part of game
DECLARE FUNCTION GetFileSize& (file$)     'function to get size of files

DECLARE SUB About ()                      'sub to show program info
DECLARE SUB ShowHaHa (ship$)              'sub to show 'em they crashed

DECLARE SUB NextLevel (level)             'sub to welcome 'em to the next level
DECLARE FUNCTION NewGame ()               'function to start new game
DECLARE FUNCTION MoveUp (level)           'function to move up a level
DECLARE FUNCTION GoThere (Curlevel)       'function to take 'em to any level          
DECLARE FUNCTION Password (level)         'function to get passwords

'menu stuff
DECLARE SUB InitMenus (menuChoice)              'sub to initialize menus
DECLARE FUNCTION RunMenu (menu)                 'sub to run menus
DECLARE FUNCTION MenuClick$ ()                  'function to check for menu click

'window stuff
DECLARE SUB Windw (winbuff(), x, y, w, h, mode, border, bufflag)            'sub for basic window
DECLARE SUB CapWindw (winbuff(), x, y, w, h, border, text$)                 'sub for captioned window
DECLARE SUB CapTWindw (winbuff(), x, y, w, h, border, Cap$, text1$, text2$, text3$) 'sub for captioned text window
DECLARE FUNCTION InputWindw$ (winbuff(), x, y, w, h, border, Cap$, text1$, text2$, text3$, encrypt) 'function to get input

DECLARE FUNCTION Array2String$ (array$(), lowbound, highbound, encrypt)   'function to convert array to string

'mouse stuff
DECLARE SUB MouseDriver (ax%, bx%, cx%, dx%)
DECLARE SUB MouseHide ()
DECLARE FUNCTION MouseInit% ()
DECLARE SUB MousePut (x%, y%)
DECLARE SUB MouseRange (x1%, y1%, x2%, y2%)
DECLARE SUB MouseShow ()
DECLARE SUB MouseStatus (lb%, rb%, XMouse%, YMouse%)
DECLARE SUB WaitRelease ()


'*****************************************
'global constants
CONST True = -1
CONST False = NOT True

COMMON SHARED MaxX, MaxY
COMMON SHARED TextX, TextY, TextXOfs, TextYOfs

COMMON SHARED lander()
COMMON SHARED ShipEPI

COMMON SHARED col

COMMON SHARED buff1()
COMMON SHARED buff2()
COMMON SHARED buff3()
COMMON SHARED buff4()
COMMON SHARED buff5()

COMMON SHARED mode
COMMON SHARED DivFactor

COMMON SHARED NotHere

REDIM SHARED Names(10) AS Menus
REDIM SHARED Passwords$(200)

'*****************************************
'load mouse code
DIM SHARED mouse$
mouse$ = SPACE$(57)
RESTORE mouse
FOR i% = 1 TO 57
  READ A$
  h$ = CHR$(VAL("&H" + A$))
  MID$(mouse$, i%, 1) = h$
NEXT i%

'init mouse
CLS
ms% = MouseInit%
IF NOT ms% THEN
  PRINT "Mouse not found"
  END
ELSE
  MouseHide
END IF


SCREEN 13         '320 X 200 w/256 colors

'initialize buffers
DIM buff1(0)
DIM buff2(0)
DIM buff3(0)
DIM buff4(0)
DIM buff5(0)

'************************************************************
'main code
DIM SHARED pal(255) AS Hues
DEF SEG = VARSEG(pal(0))
BLOAD "DEFAULT.PAL", 0
SetColors pal(), 0, 255

'******************************************************************
'read in screen data
RESTORE Mode13
READ TextX, TextY, MaxX, MaxY, TextXOfs, DivFactor, Maxcolors


'*****************************************************************
FileName$ = "LANDER.SPR"                         'ship sprite file
FileSize& = GetFileSize&(FileName$)              'get file size
ldelm = (FileSize& - 7) \ 2                      'calc array size
REDIM lander(ldelm)                              'array for ship
DEF SEG = VARSEG(lander(0))                      'point to it
BLOAD FileName$, 0                               'load from file
ShipEPI = ((lander(0) \ 8) * lander(1)) \ 2 + 2  'elements per image


'*************************************************************
'read in passwords (or make them)
RANDOMIZE TIMER
ON ERROR GOTO FileNotFound                'error checking ON
OPEN "pass" FOR INPUT AS #1               'look for file
      IF NOT NotHere THEN                 'file exists?
            FOR k = 1 TO 200
                  INPUT #1, Passwords$(k) 'read in passwords
            NEXT k

            CLOSE #1
      ELSE
            DIM chars$(5)
            FOR k = 1 TO 200
Assign:
                  FOR l = 1 TO 5
                        dachar$ = CHR$(INT(RND * 93) + 33)
                        IF dachar$ = CHR$(34) THEN EXIT FOR: GOTO Assign      'can't be a quote
                        chars$(l) = dachar$
                  NEXT l

                  'make sure it's not the same
                  FOR check = 1 TO k
                        IF chars$ = Passwords$(check) THEN EXIT FOR: GOTO Assign
                  NEXT check

                  Passwords$(k) = Array2String$(chars$(), 1, 5, False)
                  
            NEXT k

            OPEN "pass" FOR OUTPUT AS #1              'create password file
                  FOR writeit = 1 TO 200
                        WRITE #1, Passwords$(writeit) 'write in data
                  NEXT
            CLOSE #1
      END IF
ON ERROR GOTO 0               'error checking OFF



'***************************************************************
DoLander          'do the game!!!
END





'*******************************************************
'errors
FileNotFound:
      NotHere = True
      RESUME NEXT

'*******************************************************
'screen data
Mode13: DATA 8, 8, 320, 200, 8, 1, 256

'Mouse data
mouse:
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

SUB About
      CapTWindw buff5(), 40, 57, 220, 60, False, "About", "Luner Lander V1.0", "1995 by Chris Sequeira", "Press any key to continue."
      WHILE INKEY$ <> "": WEND
      MilliDelay 500
      SLEEP
      MouseHide
      PUT (40, 57), buff5, PSET
      MouseShow
END SUB

FUNCTION Array2String$ (array$(), lowbound, highbound, encrypt)
      IF lowbound > highbound THEN        'wrong order?
            'swap variables
            temp = highbound
            highbound = lowbound
            lowbound = temp
      END IF

      FOR convert = lowbound TO highbound
            IF encrypt THEN         'need encryption?
                  newString$ = newString$ + "*"
            ELSE
                  newString$ = newString$ + array$(convert)
            END IF
      NEXT convert

      Array2String$ = newString$
END FUNCTION

SUB CapTWindw (winbuff(), x, y, w, h, border, Cap$, text1$, text2$, text3$)
      ERASE winbuff      'remove old window buffer

      'draw captioned window (OOP kicks!)
      CapWindw winbuff(), x, y, w, h, border, Cap$

      row = INT(y / TextY) + 4
      column = INT(x / 8) + 2

      MouseHide

      LOCATE row, column: PRINT text1$
      LOCATE row + 1, column: PRINT text2$
      LOCATE row + 2, column: PRINT text3$

      MouseShow
END SUB

SUB CapWindw (winbuff(), x, y, w, h, border, text$)
      ERASE winbuff      'remove old window buffer

      'draw basic black window (doesn't OOP rule??!??!)
      Windw winbuff(), x, y, w, h, True, border, True

      'draw caption holder
      MouseHide

      LINE (x + (w - 5), y + 5)-(x + 5, y + 5), 15
      LINE -(x + 5, y + 8 + TextY), 15
      LINE -(x + (w - 5), y + 8 + TextY), 8
      LINE -(x + (w - 5), y + 5), 8

      'print text
      row = INT(y / TextY) + 2
      column = INT(x / 8) + 2
      LOCATE row, column: PRINT text$

      MouseShow
END SUB

SUB DoLander
      level = 1
      ships = 5

      FirstTime = True

      MouseShow
start:
      MouseHide         'hide mouse pointer

      CLS               'clear screen
      DrawTerrain level 'draw world

      InitMenus 1       'initialize pulldown menus

      Windw buff1(), 0, 172, 319, 14, True, False, False
      LOCATE 23, 2: PRINT "Level"; level

      IF FirstTime THEN       'just started program?
            About             'show info About...
            FirstTime = False 'not first time anymore!
      END IF

      MouseShow         'show mouse pointer

      Restart = False

      'image stuff
      REDIM back(200)
      ShipPic = ShipEPI
      MaskPic = 2 * ShipEPI

      'sound stuff
      freq = 1000
      bottom = 200
      sndStep = -5

      'define starting values
      VPos = 12
      HPos = 160

      'define moving values
      RANDOMIZE TIMER
      DIM fallval AS SINGLE
      DIM speed AS SINGLE
      DIM moveVal AS SINGLE
      DO
            moveVal = RND * level - INT(level / 2)
            levelVal = level / 10
            IF levelVal = 0 THEN levelVal = 1
      LOOP UNTIL moveVal MOD levelVal = 0

      fallval = .05 + (level / 100)
      speed = 1
      value = INT(level / 10)
      IF value = 0 THEN value = 1

      pause = 0

      'fuel!
      fuel = 300

      'main game loop
      DO
            WHILE INKEY$ <> "": WEND      'clear keyboard buffer
            MouseStatus lb%, rb%, XMouse%, YMouse%
            XMouse% = XMouse% \ (TextX + TextXOfs)
            YMouse% = YMouse% \ TextY

            MenuLabel = 0: Choice = 0
            IF lb% AND YMouse% = 0 THEN            'left button clicked?
                  FOR check = 1 TO UBOUND(Names)   'see where it's at
                              IF XMouse% > Names(check).StartCoord - 2 AND XMouse% < Names(check).EndCoord + 1 THEN
                                    Choice = RunMenu(check)
                                    MenuLabel = check
                              END IF

                  NEXT check
            END IF


            'New Game selected?
            IF MenuLabel = 1 AND Choice = 1 THEN
                  IF NewGame = True THEN                    'want to restart?
                        level = 1                           'take 'em to first level
                        Restart = True: EXIT DO
                  END IF
            END IF

            'About selected?
            IF MenuLabel = 1 AND Choice = 2 THEN About      'show About

            'Next Level selected?
            IF MenuLabel = 2 AND Choice = 1 THEN
                  UAccess = MoveUp(level + 1)
                  IF UAccess THEN                           'did they get password?
                        level = level + 1                   'they did!
                        Restart = True: EXIT DO             'take 'em to next level
                  END IF
            END IF

            'Last Level selected?                      
            IF MenuLabel = 2 AND Choice = 2 THEN
                  level = level - 1                         'take 'em back a level
                  Restart = True: EXIT DO
            END IF

            'Go To selected?
            IF MenuLabel = 2 AND Choice = 3 THEN
                  UAccess = GoThere(level)
                  IF UAccess THEN                           'did they get password?
                        level = UAccess                     'they did!
                        Restart = True: EXIT DO             'take 'em to the level
                  END IF
            END IF

            y$ = INKEY$             'get any keypresses

            IF NOT pause THEN             'game not paused?
                  'draw the ship
                  MouseHide               'hide mouse pointer

                  LOCATE 23, 15: PRINT "Fuel:"; INT(fuel); "gallons   "      'print fuel status

                  HPos = INT(HPos)                                      'truncate horizontal position to integer
                  VPos = INT(VPos)                                      'truncate vertical position to integer
                  GET (HPos, VPos)-(HPos + 14, VPos + 14), back         'save background
                  PUT (HPos, VPos), lander(MaskPic), AND                'put down image mask
                  PUT (HPos, VPos), lander(ShipPic), XOR                'put down image
                  MouseShow               'show mouse pointer

                  'check for planet
                  FOR k = VPos TO (VPos + 12)   'check for walls
                        FOR l = HPos TO (HPos + 13)
                              IF POINT(l, k) = col THEN     'they crashed!!
                                    PLAY "mbo0l32efgefdc"
                                    ships = ships - 1       'now user has one less ship
                                    ship$ = "You have" + STR$(ships) + " ships left."
                                    ShowHaHa ship$

                                    IF ships = 0 THEN                   'got no ships?
                                          GameOver = True               'gameover!!
                                          EXIT DO
                                    ELSE              'still have ships?
                                          Restart = True: EXIT DO       'restart
                                    END IF
                              END IF
                        NEXT l
                  NEXT k
                  FOR k = (HPos + 6) TO (HPos + 8) 'check for ground
                        IF POINT(k, VPos + 13) = col THEN
                              IF speed < 1 AND ABS(moveVal) < 1 THEN    'safe landing?
                                    level = level + 1                   'go to next level!
                                    NextLevel level
                              ELSE                          'they crashed!
                                    PLAY "mbo0l32efgefdc"
                                    ships = ships - 1       'now user has one less ship!
                                    ship$ = "You have" + STR$(ships) + " ships left."
                                    ShowHaHa ship$

                                    IF ships = 0 THEN             'got no ships?
                                          GameOver = True         'gameover!
                                          EXIT DO
                                    END IF
                              END IF
                              Restart = True          'restart
                              EXIT DO
                        END IF
                  NEXT k


                  MilliDelay 30     'short delay


                  MouseHide         'hide mouse pointer
                  PUT (HPos, VPos), back, PSET  'erase ship
                  MouseShow         'show mouse pointer

                  HPos = HPos + moveVal         'move ship sideways
                  speed = speed + fallval       'increase falling speed
                  VPos = VPos + speed           'move ship vertically

                  'check for boundaries
                  IF HPos > 304 OR HPos < 0 OR VPos < 10 OR VPos > 173 THEN   'out of bounds?
                        PLAY "o1L10DP16<L4B"
                        ships = ships - 1             'now user has one less shi[
                        ship$ = "You have" + STR$(ships) + " ships left."
                        ShowHaHa ship$

                        IF ships = 0 THEN             'got no ships?
                              GameOver = True         'gameover!
                              EXIT DO
                        ELSE              'still have ships?
                              Restart = True: EXIT DO 'restart level
                        END IF
                  END IF
            END IF

            'check keys
            x$ = INKEY$

            IF NOT pause THEN       'game not paused?
                  IF fuel THEN            'make sure there's fuel
                        IF x$ = CHR$(0) + "H" THEN speed = speed - value            'UP pressed
                        IF x$ = CHR$(0) + "P" THEN speed = speed + value            'DOWN pressed
                        IF x$ = CHR$(0) + "K" THEN moveVal = moveVal - value        'LEFT pressed
                        IF x$ = CHR$(0) + "M" THEN moveVal = moveVal + value        'RIGHT pressed
                  END IF

                  IF UCASE$(x$) = "P" THEN            'wants to pause?
                        pause = NOT pause             'toggle pause variable
                        IF pause THEN                 'pause on?
                              CapTWindw buff1(), 80, 64, 160, 50, True, "Paused", "Paused...", "Press p to go on.", ""
                        ELSE        'pause off
                              MouseHide         'hide pointer
                              PUT (80, 64), buff1, PSET           'close window
                              MouseShow         'show pointer
                        END IF
                  END IF
            ELSE
                  IF UCASE$(x$) = "P" OR UCASE$(y$) = "P" THEN
                        pause = NOT pause
                        IF pause THEN
                              CapTWindw buff1(), 80, 64, 160, 50, True, "Paused", "Paused...", "Press p to go on.", ""
                        ELSE
                              MouseHide
                              PUT (80, 64), buff1, PSET
                              MouseShow
                        END IF
                  END IF
            END IF

            IF fuel > 0 AND NOT pause THEN            'still got fuel?    
                  fuel = fuel - (1 + (fallval * 6))        'subtract amount of fuel
            ELSE              'out of fuel
                  IF freq >= bottom THEN
                        PLAY "MB"
                        SOUND freq, 1.2         'play sound
                        freq = freq + sndStep
                  END IF
            END IF
      LOOP UNTIL Choice = 3 AND MenuLabel = 1 OR GameOver

      IF Restart = True THEN GOTO start        'need to restart?

END SUB

SUB DrawTerrain (level)
      RANDOMIZE TIMER     'use timer to "seed" random number generator

      'draw sky
      value = INT(RND * 3) + 5            'pick from 3 colors
      col = value * 16                    'start with brightest shade
      FOR y = 200 TO 1 STEP -1            'draw from bottom to top
            LINE (0, y)-(319, y), col
            IF y MOD 20 = 0 AND col < ((value * 16) + 15) THEN
                  col = col + 1           'increase value
            END IF
      NEXT


      'draw ground
      shade = INT(RND * 15) + 1       'pick a shade
      col = (13 * 16) + shade         'set shade of brown
      FOR x = 0 TO 319                'draw from left to right
            RANDOMIZE TIMER
            mover = (30 - level) + (INT(RND * 2) - 6)
            IF mover <= 0 THEN mover = 1
            IF x MOD mover = 0 THEN 'need new coord?
                  IF LastY = 0 THEN           'don't have a LastY?
                        y = INT(RND * 60) + 110     'pick a y coord
                        LastY = y               'put first y into LastY
                  ELSE    'have a LastY
                        DO
                              y = INT(RND * 60) + 110     'pick a y coord
                        LOOP UNTIL ABS(LastY - y) < 60 AND y <> LastY   'make them similar
                  END IF
            END IF

            'draw line
            LINE (x, y)-(x, 199), col
            LastY = y       'save y
      NEXT
END SUB

FUNCTION GetFileSize& (file$)
        OPEN file$ FOR BINARY AS #1
                fileLength& = LOF(1)
        CLOSE #1

        GetFileSize& = fileLength&
END FUNCTION

FUNCTION GoThere (Curlevel)
      'get the desired level
      dalevel$ = InputWindw(buff4(), 50, 64, 190, 70, False, "Go To...", "Enter a level.", "Press ENTER when done.", "", False)
      PUT (50, 64), buff4, PSET

      'convert string to numeral
      desLevel = VAL(dalevel$)

      'need to go up?
      IF desLevel > Curlevel THEN
            UAccess = MoveUp(desLevel)
        
            IF UAccess THEN
                  GoThere = desLevel
            ELSE
                  GoThere = 0
            END IF
      ELSE
            IF desLevel > 0 THEN
                  GoThere = desLevel
            ELSE
                  BEEP
            END IF
      END IF
END FUNCTION

SUB InitMenus (menuChoice)
        ERASE Names     'erase old menu array
        SELECT CASE menuChoice
                CASE 1
                        REDIM Names(2) AS Menus
                        '**** first menu
                        Names(1).MenuName = "File"
                        Names(1).StartCoord = 2
                        Names(1).EndCoord = 6

                        '**** second menu
                        Names(2).MenuName = "Level"
                        Names(2).StartCoord = 9
                        Names(2).EndCoord = 14
        END SELECT

        'draw border line
        LINE (0, TextY)-(MaxX, TextY), 9
        'clear text line first
        FOR clearIt = 1 TO 40
            LOCATE 1, clearIt: PRINT " "
        NEXT clearIt
        'print names
        FOR i = 1 TO UBOUND(Names)
                LOCATE 1, Names(i).StartCoord: PRINT Names(i).MenuName
        NEXT i

END SUB

FUNCTION InputWindw$ (winbuff(), x, y, w, h, border, Cap$, text1$, text2$, text3$, encrypt)
      CapTWindw winbuff(), x, y, w, h, border, Cap$, text1$, text2$, text3$

      LINE (x + 8, (CSRLIN + 1) * TextY)-((x + w) - 8, (CSRLIN + 1) * TextY), 7

      TRow = CSRLIN + 1
      TCol = (x + 10) \ 8 + 1
      TEnd = ((x + w) - 10) \ 8 - 1
      TLen = TEnd - TCol

      DIM user$(80)
      count = 1

      WHILE INKEY$ <> "": WEND
      DO
            DO
                  key$ = INKEY$           'look for keypress
            LOOP UNTIL key$ <> ""         'loop till you got one

            'printable character?
            IF (ASC(key$) > 31) AND (ASC(key$) < 127) AND (count < 80) THEN
                  'add it to array
                  user$(count + 1) = CHR$(0): user$(count) = key$

                  'print portion that will fit in window
                  IF count <= TLen THEN       'whole thing fits?
                        LOCATE TRow, TCol: PRINT Array2String$(user$(), 1, count, encrypt)
                  ELSE        'all don't fit
                        LOCATE TRow, TCol: PRINT Array2String$(user$(), count - TLen, count, encrypt)
                  END IF

                  count = count + 1
            ELSEIF (ASC(key$) = 8) AND (count > 1) THEN     'backspace hit?
                  IF encrypt THEN
                        BEEP        'can't delete encryption
                  ELSE
                        'delete last character
                        count = count - 1
                        user$(count) = CHR$(0)

                        'print portion that will fit in window
                        IF count <= TLen THEN       'whole thing fits?
                              LOCATE TRow, TCol: PRINT Array2String$(user$(), 1, count, encrypt)
                        ELSE        'all don't fit
                              LOCATE TRow, TCol: PRINT Array2String$(user$(), count - TLen, count, encrypt)
                        END IF
                  END IF
            END IF
      LOOP UNTIL key$ = CHR$(13)          'loop till ENTER

      InputWindw$ = Array2String$(user$(), 1, count - 1, False)
END FUNCTION

SUB MilliDelay (msecs) STATIC

    IF sysfact& THEN                             'calc- system speed yet?
        IF msecs THEN                            'have to want a delay
            count& = (sysfact& * msecs) \ -54    'calc- # of loops needed
            DO
                count& = count& + 1              'negative - add to get to 0
                IF count& = z THEN EXIT DO       'when its 0 we're done
            LOOP UNTIL t2 = PEEK(&H6C)           'make it the same as below
        END IF
    ELSE                                         'calc- system speed
        DEF SEG = &H40                           'point to low memory
        t1 = PEEK(&H6C)                          'get tick count
        DO
            t2 = PEEK(&H6C)                      'get tick count
        LOOP UNTIL t2 <> t1                      'wait 'til its a new tick
        DO
            sysfact& = sysfact& + 1              'count number of loops
            IF sysfact& = z THEN EXIT DO         'make it the same as above
        LOOP UNTIL t2 <> PEEK(&H6C)              'wait 'til its a new tick
        t2 = 256                                 'prevent the above UNTIL
    END IF
END SUB

SUB MouseDriver (ax%, bx%, cx%, dx%)
  DEF SEG = VARSEG(mouse$)
  mouse% = SADD(mouse$)
  CALL Absolute(ax%, bx%, cx%, dx%, mouse%)
END SUB

SUB MouseHide
 ax% = 2
 MouseDriver ax%, 0, 0, 0
END SUB

FUNCTION MouseInit%
  ax% = 0
  MouseDriver ax%, 0, 0, 0
  MouseInit% = ax%
END FUNCTION

SUB MousePut (x%, y%)
  ax% = 4
  cx% = x%
  dx% = y%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseRange (x1%, y1%, x2%, y2%)
  ax% = 7
  cx% = x1%
  dx% = x2%
  MouseDriver ax%, 0, cx%, dx%
  ax% = 8
  cx% = y1%
  dx% = y2%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseShow
  ax% = 1
  MouseDriver ax%, 0, 0, 0
END SUB

SUB MouseStatus (lb%, rb%, XMouse%, YMouse%)
  ax% = 3
  MouseDriver ax%, bx%, cx%, dx%
  lb% = ((bx% AND 1) <> 0)
  rb% = ((bx% AND 2) <> 0)
  XMouse% = cx%
  YMouse% = dx%
END SUB

FUNCTION MoveUp (level)
      'get password value
      UAccess = Password(level)

      'did they pass?
      IF UAccess = True THEN
            MoveUp = True
      ELSE
            MoveUp = 0
      END IF
END FUNCTION

FUNCTION NewGame
      DO
            Answer$ = InputWindw(buff3(), 80, 80, 120, 70, False, "New Game", "Are you sure?", "Type Y or N.", "", False)
            PUT (80, 80), buff3, PSET
      LOOP UNTIL UCASE$(Answer$) = "Y" OR UCASE$(Answer$) = "N"

      IF UCASE$(Answer$) = "Y" THEN
            NewGame = True
      ELSE
            NewGame = False
      END IF
END FUNCTION

SUB NextLevel (level)
      Curlevel$ = "You left level" + STR$(level - 1) + "."
      newlevel$ = "You're going to" + STR$(level) + "!"
      passwrd$ = "Your password is " + Passwords$(level - 1)

      CapTWindw buff1(), 40, 40, 210, 60, False, "Onward!", Curlevel$, newlevel$, passwrd$
      WHILE INKEY$ <> "": WEND
      MilliDelay 500
      SLEEP

      MouseHide
      PUT (40, 40), buff1, PSET
      MouseShow
END SUB

FUNCTION Password (level)
      'get password
      Cap$ = "Level " + STR$(level) + " access"
      dapass$ = InputWindw(buff3(), 50, 64, 190, 70, False, Cap$, "Enter your password.", "There's no BACKSPACE.", "Press ENTER when done.", True)
      PUT (50, 64), buff3, PSET

      'check if it's OK
      PRINT dapass$
      IF dapass$ = Passwords$(level) THEN
            'they got it!
            Password = True
      ELSE
            'they missed it!
            CapTWindw buff3(), 80, 64, 160, 50, False, "Wrong!", "Incorrect password!", "", ""
            MilliDelay 200
            SLEEP

            PUT (80, 64), buff3, PSET
            Password = False
      END IF
END FUNCTION

FUNCTION RunMenu (menu)
      ON ERROR GOTO 0   'turn off error check
      SELECT CASE menu
                CASE 1
                        DIM MenuText$(3)
                        MaxWidth = 8
                        MenuText$(1) = "New Game"
                        MenuText$(2) = "About..."
                        MenuText$(3) = "Exit"
                CASE 2
                        DIM MenuText$(3)
                        MaxWidth = 13
                        MenuText$(1) = "Next Level..."
                        MenuText$(2) = "Last Level"
                        MenuText$(3) = "Go To..."
        END SELECT

        'calc coords
        ux = (Names(menu).StartCoord - 1) * TextX - 2   'upper X coord
        uy = TextY                                      'upper Y coord
        lx = MaxWidth * TextX + ux + 2                  'lower X coord
        ly = UBOUND(MenuText$) * TextY + TextY          'lower Y coord

        MouseHide               'hide mouse pointer
        'calc buffer size
        DIM buffer(10000)                        'screen buffer variable
        GET (ux, uy)-(lx, ly), buffer           'buffer screen

        LINE (ux, uy)-(lx, ly), 0, BF           'erase whats underneath
        LINE (ux, uy)-(lx, ly), 9, B            'draw menu box (change 9 for a different color)

        'draw menu bar
        LINE (ux + 1, uy)-(lx - 1, TextY * 2 - 1), 7, BF
        DIM bar(1000)
        GET (ux + 1, uy)-(lx - 1, TextY * 2 - 1), bar
        PUT (ux + 1, uy), bar

        'print text
        FOR k = 1 TO UBOUND(MenuText$)
                LOCATE k + 1, Names(menu).StartCoord
                PRINT MenuText$(k)
        NEXT

        WaitRelease     'wait for release of left button

        'get the choice
        row = 1: LastRow = 1
        PUT (ux + 1, row * TextY), bar   'draw bar
        DO
                MouseStatus lb%, rb%, XMouse%, YMouse%
                row = YMouse% \ TextY

                'get keypresses
                x$ = INKEY$
                IF x$ = CHR$(0) + "H" THEN row = row - 1
                IF x$ = CHR$(0) + "P" THEN row = row + 1
                IF x$ = CHR$(27) THEN row = 0: EXIT DO

                'is Row valid?
                IF row < 1 THEN row = 1
                IF row > UBOUND(MenuText$) THEN row = UBOUND(MenuText$)

                'did Row change?
                IF row <> LastRow THEN
                        PUT (ux + 1, LastRow * TextY), bar   'erase bar
                        PUT (ux + 1, row * TextY), bar       'draw in new location
                        LastRow = row           'update LastRow
                END IF
        LOOP UNTIL lb% = -1 OR x$ = CHR$(13)
        WaitRelease     'wait for user to release mouse button

        PUT (ux, uy), buffer, PSET
        ERASE buffer    'remove images...
        ERASE bar       'to save memory
        MouseShow               'show mouse pointer

        RunMenu = row          'return row
END FUNCTION

'sub to change palette
SUB SetColors (pal() AS Hues, fc, lc)
   OUT &H3C8, fc                                 'tell controller to get ready
   FOR t = fc TO lc                              'from first to last
      OUT &H3C9, pal(t).Red                      'send red component
      OUT &H3C9, pal(t).Green                    'send green component
      OUT &H3C9, pal(t).Blue                     'send blue component
   NEXT
END SUB

SUB ShowHaHa (ship$)
      CapTWindw buff1(), 40, 57, 220, 60, False, "Ha Ha!", "Your ship crashed!", ship$, "Press any key to go on..."
      WHILE INKEY$ <> "": WEND
      MilliDelay 200
      SLEEP
      MouseHide
      PUT (40, 57), buff1, PSET
      MouseShow
END SUB

SUB WaitRelease
        MouseStatus lb%, rb%, x%, y%
        WHILE lb% = -1 OR rb% = -1                     'loop until button is released
                MouseStatus lb%, rb%, x%, y%
        WEND
END SUB

SUB Windw (winbuff(), x, y, w, h, mode, border, bufflag)
      MouseHide         'turn off mouse cursor
      DIM size AS LONG

      x2 = w + x
      y2 = h + y

      IF x2 < 320 AND y2 < 200 THEN
            IF bufflag THEN                     'want a buffer?
                  ERASE winbuff     'remove old window buffer

                  size = w * h \ DivFactor + 8  'calc size

                  'too big?
                  IF size > 64000 THEN CLS : PRINT "Window Error: Window too big!": END
           
                  REDIM winbuff(size)
                  GET (x, y)-(x2, y2), winbuff   'get the screen
            END IF

            'draw window
            LINE (x + w, y)-(x, y), 15
            LINE -(x, y + h), 15
            LINE -(x + w, y + h), 8
            LINE -(x + w, y), 8

            IF mode = False THEN
                  'make window gray
                  LINE (x + 1, y + 1)-(x + (w - 1), y + (h - 1)), 7, BF

                  IF border THEN          'want a border
                        LINE (x + (w - 5), y + 5)-(x + 5, y + 5), 8
                        LINE -(x + 5, y + (h - 5)), 8
                        LINE -(x + (w - 5), y + (h - 5)), 15
                        LINE -(x + (w - 5), y + 5), 15
                  END IF
            ELSE
                  'make window black
                  LINE (x + 1, y + 1)-(x + (w - 1), y + (h - 1)), 0, BF

                  IF border THEN          'want a border
                        LINE (x + (w - 5), y + 5)-(x + 5, y + 5), 8
                        LINE -(x + 5, y + (h - 5)), 8
                        LINE -(x + (w - 5), y + (h - 5)), 15
                        LINE -(x + (w - 5), y + 5), 15
                  END IF
            END IF
      END IF

      MouseShow   'turn on mouse cursor
END SUB

