Program Convert;

Const

{ Room_Flags: Room types }
      Temple_Room          = $0001;
      Haven_Room           = $0002;
      Shop_Room            = $0004;

{ Attr_Flags }
      Link_Ok_Flag         = $0001;
      Sticky_Flag          = $0002;
      Teleport_Ok_Flag     = $0004;
      Invisible_Flag       = $0008;
      For_Sale_Flag        = $0010;
      ChOwn_Ok_Flag        = $0020;

{ System Flags }
      Macro_Flag           = $0001;



Const Gender_Mask        = $0007;      { The low 3 bits of }
      No_Gender          = $0000;
      Neuter_Gender      = $0001;
      Female_Gender      = $0002;
      Male_Gender        = $0003;

      O_Temple_Room        = $0010;      { For donations                }
      O_Haven_Room         = $0020;      { No fighting allowed          }
      O_Shop_Room          = $0040;      { To sell and buy old objs.    }
      O_Macro_Flag         = $0080;      { This object can be USED      }
      O_Link_Ok_Flag       = $0100;      { Define an object as LINKABLE }
      O_Stiky_Flag         = $0200;      { Define an object as STIKY    }
{**}  O_Teleport_Ok_Flag   = $0400;      { Everybody can tele to here   }
      O_Invisible_Flag     = $0800;      { To hide long lists of objs.  }
      O_For_Sale_Flag      = $1000;      { Object has no current owner  }
      O_CHOWN_OK_flag      = $2000;      { Can be owned by someone      }
      { Undefined          = $8000; }



Type LongRec    = Record  { filepointer and length of a longtekst }
                    Start   : LongInt;
                    Length  : Word;
                  End;

Type  OldRecord  = Record
                    Name     : String;      { Object name              }
                    Password : String[40];  { Password for players     }
                    Key      : String[40];  { Boolean key              }

                    Location : Integer;     { Current location         }
                    Contents : Integer;     { Start of contents list   }
                    Exits    : Integer;     { Start of exits list      }
                    Next     : Integer;     { continue list            }
                    Owner    : Integer;     { Recordnumber of owner    }
                    Pennies  : Integer;     { Value/amound of pennies  }

                    ObjType  : Byte;     { Thing, room, exit, player, Drone}
                    ObjLevel : Byte;     { Toad,player,builder,wizard,god  }
                    GenFlags : LongInt;

                    Desc     : LongRec;  { Pointer to long description }

                    Fail     : LongRec;  { Pointer to fail string      }
                    Success  : LongRec;  { Pointer to Success string   }
                    OFail    : LongRec;  { Pointer to fail for others  }
                    OSuccess : LongRec;  { Pointer to succes for others}

                  End;

     NEWRecord  = Record
                    Name     : String;      { Object name              }
                    Password : String[40];  { Password for players     }
                    Key      : String[40];  { Boolean key              }

                    Location : Integer;     { Current location         }
                    Contents : Integer;     { Start of contents list   }
                    Exits    : Integer;     { Start of exits list      }
                    Next     : Integer;     { continue list            }
                    Owner    : Integer;     { Recordnumber of owner    }
                    Pennies  : Integer;     { Value/amound of pennies  }

                    ObjType  : Byte;     { Thing, room, exit, player, Drone}
                    ObjLevel : Byte;     { Toad,player,builder,wizard,god  }
                    GenFlags : LongInt;

                    Desc     : LongRec;  { Pointer to long description }

                    Fail     : LongRec;  { Pointer to fail string      }
                    Success  : LongRec;  { Pointer to Success string   }
                    OFail    : LongRec;  { Pointer to fail for others  }
                    OSuccess : LongRec;  { Pointer to succes for others}

                    Macro    : LongRec;  { Pointer to macro            }

                    Sex        : Byte;
                    Room_Flags : LongInt;
                    Attr_Flags : LongInt;

                    Storage    : Array[0..9] of Integer;

                    Filler     : Array[1..83] of Byte;
                  End;


Function BitSet(L,Flag : LongInt):Boolean;
Begin
BitSet:=(L And Flag)=Flag;
End;

Procedure SetBit(Var L : LongInt; Flag : LongInt);
Begin
L:=L Or Flag;
End;


Procedure CheckRecord(Var Rec : NewRecord);
Var Temp : LongInt;
Begin
With Rec Do
 Begin
 Room_Flags:=0;
 If BitSet(GenFlags,O_Temple_Room) then SetBit(Room_Flags,Temple_Room);
 If BitSet(GenFlags,O_Haven_Room) then SetBit(Room_Flags,Haven_Room);
 If BitSet(GenFlags,O_Shop_Room) then SetBit(Room_Flags,Shop_Room);

 Attr_Flags:=0;
 If BitSet(GenFlags,O_Link_Ok_Flag) then SetBit(Attr_Flags,Link_Ok_Flag);
 If BitSet(GenFlags,O_Stiky_Flag) then SetBit(Attr_Flags,Sticky_FLag);
 If BitSet(GenFlags,Teleport_Ok_Flag) then SetBit(Attr_Flags,Teleport_Ok_Flag);
 If BitSet(GenFlags,O_Invisible_Flag) then SetBit(Attr_Flags,Invisible_Flag);
 If BitSet(GenFlags,O_For_Sale_Flag) then SetBit(Attr_Flags,For_Sale_Flag);
 If BitSet(GenFlags,O_Chown_ok_Flag) then SetBit(Attr_Flags,Chown_Ok_Flag);

 Sex:=GenFlags And Gender_Mask;

 Temp:=0;
 If BitSet(GenFlags,O_Macro_Flag) then SetBit(Temp,Macro_Flag);
 GenFlags:=Temp;
 End;

End;


Var Inp : File of OldRecord;
    Out : File of NewRecord;

    IRec: OldRecord;
    ORec: NewRecord;

Begin
Assign(Inp,ParamStr(1)+'.IDX');
Rename(Inp,ParamStr(1)+'.OLD');
Reset(Inp);

Assign(Out,ParamStr(1)+'.IDX');
Rewrite(Out);

While Not Eof(Inp) Do
 Begin
 Read(Inp,IRec);
 FillChar(ORec,SizeOf(ORec),#00);
 ORec.Name       := IRec.Name;
 ORec.Password   := IRec.Password;
 ORec.Key        := IRec.Key;
 ORec.Location   := IRec.Location;
 ORec.Contents   := IRec.Contents;
 ORec.Exits      := IRec.Exits;
 ORec.Next       := IRec.Next;
 ORec.Owner      := IRec.Owner;
 ORec.Pennies    := IRec.Pennies;
 ORec.ObjType    := IRec.ObjType;
 ORec.ObjLevel   := IRec.ObjLevel;
 ORec.GenFlags   := IRec.GenFlags;
 ORec.Desc       := IRec.Desc;
 ORec.Fail       := IRec.Fail;
 ORec.Success    := IRec.Success;
 ORec.OFail      := IRec.OFail;
 ORec.OSuccess   := IRec.OSuccess;

 CheckRecord(ORec);
 Write(Out,ORec);
 End;
Close(Inp);
Close(Out);
End.
