{$I COPYRGHT.INC}

(*----------------------------------------------------------------------------*

   I/O interface to simplify implementation of modem/network code

 *---------------------------------------------------------------------------*)


Unit MyIO;
Interface
Uses CRT;

Procedure My_ReadLn(Var S : String);
Function  My_KeyPressed:Boolean;
Function  My_ReadKey:Char;
Procedure My_Write(S : String);
Procedure My_WriteLn(S : String);
Procedure My_ClrEol;
Procedure My_Delay(D : LongInt);
Procedure My_ClrScr;
Procedure My_gotoXy(X,Y : Byte);
Function  My_WhereX:Byte;
Function  My_WhereY:Byte;
Procedure My_Window(x1,y1,x2,y2 : Byte);

Function My_YesNo(Txt : String;Default : Char):Char;
Procedure My_WaitForKey(Txt : String);
Procedure My_Beep;

Implementation

Procedure My_ReadLn(Var S : String);
Begin
ReadLn(S);
End;

Function My_KeyPressed:Boolean;
Begin
My_KeyPressed:=CRT.KeyPressed;
End;

Function My_ReadKey:Char;
Begin
My_ReadKey:=CRT.ReadKey;
End;

Procedure My_Write(S : String);
Begin
Write(S);
End;

Procedure My_WriteLn(S : String);
Begin
WriteLn(S);
End;

Procedure My_ClrEol;
Begin
CRT.ClrEol;
End;

Procedure My_ClrScr;
Begin
CRT.ClrScr;
End;

Procedure My_gotoXy(X,Y : Byte);
Begin
CRT.GotoXy(X,Y);
End;

Function  My_WhereX:Byte;
Begin
My_WhereX:=CRT.WhereX;
End;

Function  My_WhereY:Byte;
Begin
My_WhereY:=CRT.WhereY;
End;

Procedure My_Delay(D : LongInt);
Begin
CRT.Delay(D);
End;

Procedure My_Window(x1,y1,x2,y2 : Byte);
Begin
CRT.Window(X1,Y1,X2,Y2);
End;



Function My_YesNo(Txt : String;Default : Char):Char;
Var Key : Char;
Begin
If Upcase(Default)='Y'
   Then My_write(Txt+' [Yn]: ')
   Else My_Write(Txt+' [yN]: ');
Repeat
 Key:=Upcase(My_ReadKey);
Until Key in['Y','N',#13];
Case Key Of
 #13 : My_YesNo:=Default;
 Else  My_YesNo:=Key;
End; {Case}
End;

Procedure My_WaitForKey(Txt : String);
Var Dum : Char;
Begin
My_WriteLn('');
My_Write(Txt);
Dum:=My_ReadKey;
If Dum=#00
   Then Dum:=My_ReadKey;
End;

Procedure My_Beep;
Begin
CRT.NoSound;
CRT.Sound(1000);
CRT.Delay(100);
CRT.NoSound;
End;



Begin
Assign(Output,'');
Rewrite(Output);
End.
