{$I COPYRGHT.INC}

(*---------------------------------------------------------------------------*
  This unit contains the outputprocessing routines
 *---------------------------------------------------------------------------*)

Unit Out_Proc;
Interface
Uses MyIO,
     Header;

(*---------------------------------------------------------------------------*
   Write a description text to the screen. Wrap the text at position 80.
 *---------------------------------------------------------------------------*)

Procedure WriteText(T : TextRecord);

Procedure TranslateTextMacros(     Name   : String;
                                   Gender : GenderType;
                               Var T      : TextRecord);


Implementation
(*---------------------------------------------------------------------------*
   Write a description text to the screen. Wrap the text at position 80.
 *---------------------------------------------------------------------------*)

Procedure WriteText(T : TextRecord);
Var Cnt : Word;
    Len : Word;
    Lines : Byte;
Begin
Cnt:=0;
Len:=0;
Lines:=0;
While T[Cnt]<>#00 Do
 Begin
 Case T[Cnt] of
   #10,
   #13      : Begin
              My_WriteLn('');
              Len:=0;
              If ((T[Cnt]=#13) And (T[Cnt+1]=#10)) Or
                 ((T[Cnt]=#10) And (T[Cnt+1]=#13))
                 Then Inc(Cnt);
              Inc(Lines);
              End;
   '\'      : Begin
              Inc(Cnt);
              Case Upcase(T[Cnt]) Of
               'N' : Begin
                     My_WriteLn('');
                     Len:=0;
                     End;
               'T' : My_Write(#9);
               'R' : My_Write(#13);
               'B' : My_Write(#8);
               'F' : My_Write(#10);
               'P' : My_Write(#27);
               'G' : My_Write(#7);
              End; {case}
              End;
  Else My_Write(T[Cnt]);
 End; {Case}
 Inc(Cnt);
 Inc(Len);
 If Len=79
    Then Begin
         If T[Cnt]<>' '
            Then Begin
                 While T[Cnt]<>' ' Do
                  Begin
                  Dec(Cnt);
                  My_Write(#8' '#8);
                  End;
                 Inc(Cnt);
                 End
            Else Inc(Cnt);
         My_WriteLn('');
         Inc(Lines);
         Len:=0;
         End;
 If Lines=20
    Then Begin
         Lines:=0;
         My_waitForKey('--- More ---');
         End;
 End;
My_WriteLn('');
End;

(*---------------------------------------------------------------------------*)
Procedure TranslateTextMacros(     Name   : String;
                                   Gender : GenderType;
                               Var T      : TextRecord);
Var NewT : TextRecord;
    Tcnt : Word;
    NCnt : Word;
    Tmp  : String[10];

Procedure Add(Var Where : Word; S: String);
Var Cnt : Word;
Begin
Move(S[1],NewT[Where],Length(S));
Where:=Where+Length(S)-1;
End;

Begin
TCnt:=0;
NCnt:=0;
FillChar(NewT,SizeOf(NewT),#00);
While T[TCnt]<>#00 Do
 Begin
 If T[TCnt]<>MACRO_ESC
    Then NewT[NCnt]:=T[TCnt]
    Else Begin
         Case T[TCnt+1] Of
          'm','M' : Add(NCnt,MemMatch);
          'n','N' : Add(NCnt,Name);
          's','S' : Begin
                    Case Gender Of
                      None,Male : Tmp:='he';
                      Female    : Tmp:='she';
                      Neuter    : Tmp:='it';
                    End;{case}
                    If T[TCnt+1]='S'
                       Then Tmp[1]:=Upcase(Tmp[1]);
                    Add(NCnt,Tmp);
                    End;
          'o','O' : Begin
                    Case Gender Of
                      None,Male : Tmp:='him';
                      Female    : Tmp:='her';
                      Neuter    : Tmp:='it';
                    End;{case}
                    If T[TCnt+1]='O'
                       Then Tmp[1]:=Upcase(Tmp[1]);
                    Add(NCnt,Tmp);
                    End;
          'p','P' : Begin
                    Case Gender Of
                      None,Male : Tmp:='his';
                      Female    : Tmp:='her';
                      Neuter    : Tmp:='its';
                    End;{case}
                    If T[TCnt+1]='P'
                       Then Tmp[1]:=Upcase(Tmp[1]);
                    Add(NCnt,Tmp);
                    End;

         End; {Case}
         Inc(TCnt);
         End;
 Inc(TCnt);
 Inc(NCnt);
 End;
T:=NewT;
End;

End.