HELP    [G+]
  HELP [command|subject]
  Shows information on the given command/subject.
  For a list of commands use the ? command.
  If you don't know what's going on here, HELP MUD would probably be
  a good start.
.
  Extra subjects are:
.
  BOOLEAN   FLAGS   MACROS   MUD   HOWTO  LANGUAGE

?       [G+]
  ?
  Give a list of available commands

SAY     [G+]  (aka: " )
  SAY <text>
  Say something to the other players in the same room.

POSE    [G+]  (aka: : )
  : <action>
  Do an action. F.e. POSE burbs will be shown to the other users as
  "Juser burbs"

SCORE   [G+]
  SCORE
  Show how many pennies you have

NEWS    [G+]
  NEWS
  Shows the newsfile

WNEWS   [W+]
  WNEWS
  Shows special news for wizards and higher

GOTO    [G+]  (aka GO)
  GOTO <direction> or GO <direction>
  Moves player in a direction. You can also just type the exit or direction.

HOME    [P+]
  HOME
  Send the player to his/her/its home.

ROB     [P+]
  ROB <PlayerName>
  Try to rob a penny from PlayerName

GIVE    [P+]
  GIVE <Player>=<Pennies>
  Give pennies to player. Wizards can give pennies without losing money
  themself.

LOOK    [G+]
  LOOK [AT] <Object> or READ <Object>
  Give the description of an object.

EXA     [G+]
  EXA <Object> or EXAMINE <Object>
  Tells you the number and owner of an object.

INV     [G+]
  INV or INVENTORY or I
  Shows the contents of a player.

GET     [P+]
  GET <Object>  or TAKE <Object>
  move an object to the player's possesion.

DROP    [P+]
  DROP <Object> or THROW <Object> or SACRIFICE <Object>
  Drops an object in the current room. If the room is a temple, the player
  can be rewarded with money.

QUIT    [G+]
  QUIT
  Stops the game

WHO     [G+]
  WHO
  Shows a list of current players.

VERSION [G+]
  VERSION
  Shows the version of the current MyMUD

WHISPER [P+]
  WHISPER <Player>=<Msg> or  > <Player>=<Msg>
  Whisper a personal message to a player. Wizards can whisper to players in
  other rooms. The other users in the room get a note that the player is
  whispering.

KILL    [P+]
  KILL <Player>[=<Pennies>]
  Try to kill an other player. The more pennies, the better the chance that
  the other player is realy killed. There are places where you are not allowed
  to kill people. A killed player goes home. Nobody is realy killed but the
  killed player looses all his objects..

TIME    [G+]
  TIME or DATE
  Shows the current time at the server.

PAGE    [P+]
  Page <Player>
  Sends a message to Player with information about your location.

USE     [P+]
  USE <item> or /<item>
  Use the magic abilities of an item.

@CREATE     [B+]
  @CREATE  <Name>[=<Pennies>]
  Creates a new object with a certain name. Every object costs minimal 10
  pennies. If you give more pennies the value of the object becomes higher.

@WALL       [W+]
  @WALL <msg>
  Send a message to all the current players.

@PASSWORD   [P+]
  @PASSWORD <OldPassword>=<NewPassword>
  Changes the old password into a new password.

@LOCK       [P+]
  @LOCK <Object>=<Lock>|<*>
  Puts a boolean expression in the lockfield of an object. You have to own
  an object to lock it. For the boolean expressions see the subject BOOLEAN
  Using a * as expression translates into ME&(!ME)
.
  See also BOOLEAN

@UNLOCK     [P+]
  @UNLOCK <Object>
  Removes the lock of an object. You have to own the object to remove the lock.

@SET        [B+]
  @SET <Object>=[!]<FLAG>
  Sets or resets a flag of an object. Using the ! in front of the flag
  negates the flag. See the subject FLAGS for the current supported flags.
  You have to own the object to set flags.

@NAME       [B+]
  @NAME <OldName>=<NewName>[;<aka>]
  Changes the namefield of an object. You can give more than one newname.
  Use this to give objects more than one name or yourself aliasses.
  You have to own an object to change it's name.

@SETHOME    [B+]
  @SETHOME <Object>
  Make the current room the HOME of an object. You have to own the location
  as well as the object.

@DESC       [P+]
  @DESC <Object>
  Offers you the possiblity to give an object a new long description.
  The descriptions may contain MACRO symbols (See subject MACRO)
  You have to own an object to give it an description.

@FAIL       [P+]
  @FAIL <Object>
  Offers you the possiblity to give an object a new long fail description.
  The descriptions may contain MACRO symbols (See subject MACRO)
  You have to own an object to give it an description.

@SUCCESS    [P+]
  @SUCCESS <Object>
  Offers you the possiblity to give an object a new long success description.
  The descriptions may contain MACRO symbols (See subject MACRO)
  You have to own an object to give it an description.

@OFAIL      [P+]
  @OFAIL <Object>
  Offers you the possiblity to give an object a new long ofail description.
  The descriptions may contain MACRO symbols (See subject MACRO)
  You have to own an object to give it an description.

@OSUCCESS   [P+]
  @OSUCCESS <Object>
  Offers you the possiblity to give an object a new long osuccess description.
  The descriptions may contain MACRO symbols (See subject MACRO)
  You have to own an object to give it an description.

@MAGIC      [W+]
  @MAGIC <Object>
  Give the object a macro. See also MACRO for more information.

@INFO       [P+]
  @INFO  <Object>
  Fill the info field of an object. This info can be seen by everybody
  using the @FINGER command.

@FINGER     [P+]
  @FINGER <Object>
  See the info field of an object.

@PROMOTE    [P+]
  @PROMOTE <Player>
  Increases the players level with one level. You cannot increase your own
  level or players of the same level as you.

@DEGRADE    [W+]
  @DEGRADE <Player>
  Lowers the players level with one level.

@HOME       [B+]
  @HOME <Item>
  Set the homelocation for an item. If the item is sticky it will return to
  this location when dropped.

@SHUTDOWN   [GOD only]
  @SHUTDOWN
  Send everybody a message that the game goes down and shutdown the game.

@NOTE       [P+]
  @NOTE <Msg>
  Puts a message in the players notefield. This field is shown in the WHO
  userlist.

@DESTROY    [W+]
  @DESTROY <Object>
  Destroys an object and removes every trace of it. The object still takes
  space in the database though!

@DIG        [B+]
  @DIG <Name>[=<Direction>]
  Digs a new room. Optional you can also link it to the current room by
  specifying a direction. New rooms cost 10 pennnies.

@OPEN       [B+]
  @OPEN <Direction>[;<Direction>]=#<TargetRoomNr.>
  Opens a link between the current room and a targetroom in a certain
  direction.

@CHOWN      [B+]
  @CHOWN <Item>=<User>
  Change the ownership of an item to a user. The receiving player should
  have his CHOWN flag set.

@FIND       [B+]
  @FIND [<User>]
  Find all the objects owned by yourself or by an other user.

@EDITFILE <FileName>  [W+]
  Edit a named file. Together with the &SHOWFILE macro command this means
  that whizards can have their own newspapers, tips, etc. etc.


@TELEPORT   [W+]
  @TELEPORT <Location/item/player>
  Teleport to a location or to the same location as an item or player.
  This is normaly a wizard commando but it can also be used in a magic
  macro (See MACRO) and then it works for everybody..

@ACTION     [B+]
  @ACTION <Name>
  Creates an fake exit sending the user back to the current room. Use this
  for fake commands.

#REC        [W+]
  #REC <Object>
  Show the lowlevel information of an object.

BOOLEAN
  <not avaliable>
  In boolean expressions the following symbols can be used:
.
  &  And             @P  playerlevel or higher
  |  Or              @B  Builderlevel or higher
  !  not             @W  Wizardlevel or higher
  () for grouping    @G  God only
.
  An object can be locked to you with @LOCK ME=ME
  For testing @LOCK ME=ME&(1ME) is often handy since it is always false.
  You can shorten this to @LOCK ME=*


FLAGS
  <not avaliable>
  The flags which are currently implemented and used:
.
   T TEMPLE         This room is a temple (for donations)
   H HAVEN          This room is haven (no fighting and killing)
   $ SHOP           Everything dropped here (and owned by you) is sold
                    to the shopkeeper. Items with a (..p) value have to
                    bought. (use the TAKE command)
   O LOUD           Users can overhear whispers. Kind of..
.
   L LINK_OK        Allowes to link other rooms to thisone
   S STIKY          An object goes back to its home when dropped
   P TELEPORT       (not implemented yet)
   I INVISIBLE      The object is invisible.
.
   D DRONE          Makes the object a DRONE. When dropped, it will follow the
                    player all through the game.
   C CHOWN          Any player is allowed to change the ownership of the object.


MACROS
  <not avaliable>
  MyMUD implements the following text-macros at this moment:
.
  %n    Name                            \n    Newline          \f    FormFeed
  %s    he,she,it     %S  He,She,It     \t    Tab              \g    Bell
  %o    him,her,it    %O  Him,Her,It    \r    Carriage Return  \p    Esc
  %p    his,hers,its  %P  His,Hers,Its  \b    BackSpace
.
 Further you can use the variables in your commandlines by refering to
 &1..&9. See VARIABLES for more info.

VARIABLES
  <Not available>
  Every object has 9 variables. These var's can be used from withing MAGIC
  MACRO's by using the &SET and &RANDOM commands. The variables can be
  refered to as &0 to &9. Variable 0 can not be set but is used for special
  actions.  Variables can be refered from everywhere.

&SET     [MACRO]
  &SET <var>=<ObjectNr>
  Fill a variable slot with an object number.

&RANDOM  [MACRO]
  &RANDOM <Limit>[=<Breakpoint>]
  When you use the RANDOM function without a breakpoint the resulting
  value is stored in variable 0.
  If you use the RANDOM function with a limit and a breakpoint the
  macro continues only when the generated number, which is between 0
  and <Limit>, is greater than the breakpoint.

&SAY <Text>   [MACRO]
  Say the text to the user

&SAYALL <Text>  [MACRO]
  Say the text to all the user except the player

&PENNIES <Integer>   [MACRO]
  Add or subtract amount from score.

&SHOWFILE <FileName>   [MACRO]
  Show the named file.

MUD
  <not avaliable>
  Welcome to MyMUD.
.
  MyMUD is an adventure in which many players can play at the same time.
  The fun is not in killing robbing etc. but in the social interaction
  between the players. Of course there are puzzles to solve and objects
  to toy with (and if your good, a wizard can even give you the power
  to create your own object and places!) but this is not the main point.
.
  In an adventure you can be whoever you want to be. You choose your own
  name, give yourself a description and there you are! A whole new you..
  How other users react towards you depends only on your behaviour in the
  game..
.
  For more information use HELP with one of the following keywords:
.
   MOVING  WIZARDS

MOVING
  <not avaliable>
  Moving around in MyMUD is simple. Every location has exits. These exits
  have names. Just type the name and there you go. Most location have at
  least the N,S,E,W (north,south,east,west) directions but OUT or
  LEAVE work too often. There can also be other exits which you only discover
  by carefull reading and looking.


GUEST
  <not avaliable>
  A Guest is the lowest level of player in the game. They can not do much
  more than wandering around and talking..

PLAYER
  <not avaliable>
  Players are the normal type inhabitants in this game. They can interact,
  wander, talk, change descriptions etc. of the things they own, rob each
  other etc.

BUILDERS
  <not avaliable>
  Builders are players who have creational abilities. They can create new
  objects and locations.

WIZARDS
  <not avaliable>
  Wizards are players with devine powers. They can do things mortals can only
  dream of. They are also the players who keep an eye on what is going on in
  the game and on your behaviour. Remember: It's only a game..

GOD
  <not avaliable>
  God is the owner of the game. (s)he has the absolute power and is the only
  one who can promote players to wizards. (s)he can do everything a wizard
  can do.


HOWTO
  <not available>
  Select one of the following:
.
  OBJECT         How to make a new object.
  ROOM           Create a new room
  MAGIC MACRO    How to create a magic item.

ROOM
  <Not available>
  Creating a location is a two step process:
  First dig a room. F.e. A wine cellar which we want to reach with Goto
  cellar:
.
     @DIG A wine cellar=Goto cellar
.
  Then you enter the cellar and you have to create an exit to somewhere
  else. Let's say the wineceller was created in a bar and you want to be
  normal and return there again when leaving the cellar:
.
     @OPEN Leave;Leave cellar=Bar
.
  Ready.  Now you can start by describing the celler, the exits and maybe
  fill it with a few items and or actions.

MAGIC MACRO
  <Not available>
  MyMud has the ability to create macro's which I liked to call magic's.
  Once an item has a magic it can be used. (See the USE command) To create
  the magic you fire up the editor with @MAGIC <itemname>. Let's create a
  magic beer bottle which teleports you straigt to the bar.
.
      @CREATE A magic beer bottle;bottle
      @MAGIC bottle
.
  In the editor you now type:
.
      @TELEPORT #12
.
  Where #12 is the number of the bar. Save and USE BOTTLE and poef! you're in
  the bar. Let's now make a stick which takes you whereever you want! You now
  want to give a parameter. Let's also store the current location in a
  variable so we can easily go back. Don't type the part behind the ;
.
     =1               ; Require at least 1 parameter!
     &SET 1=HERE      ; Fill variable 1 with the current location
     @TELEPORT %1     ; Jump to the location defined in parameter 1
     LOOK             ; Look where we ended up
     "Hai there!      ; greet everybody
.
  You can no use this macro as USE STICK=BAR. If you want to go back to
  the previouse location use USE STICK=#&1  If you use USE STICK or
  USE STICK=  MyMud will give you the items description. If no description
  is available, it will tell you that at least 1 parameter is needed.

OBJECT
  <not available>
  To make an object you start with using the @CREATE command. (Let's make a
  giant goldfish which follows you through the game!) Start with
  @CREATE Goldy=500
.
  This creates an object named Goldy in your inventory. Goldies value
  (selling or sacrfising) will be (500/100)-1=99
  After creation, Goldy needs descriptions. Use @DESC Goldy to describe her
  and @FAIL @OFAIL @SUCCESS and @OSUCCESS for the other description fields.
  If you want to keep Goldy for yourself you should also use the @LOCK
  command to set Goldy's lock to ME. (@LOCK GOLDY=ME)
.
  As a last, to make Goldy a drone, you should set the drone flag.
  @SET GOLDY=D Does that trick. Now you can drop Goldy and she will
  follow you wherever you go!

LANGUAGE
  <not available>
  One of the special features of MyMUD is the language support. If installed
  by the god, this means that you can press the ScrollLock key and start
  using a translated keyboard. This can be simple, accents on characters
  and such, or complicated, a compleet greek or russian keyboard. in the
  last case it is also possible to use the native characters one screen
  if you have an EGA or VGA compatible videocard. Ask your God or wizards
  for more info!
