                           Intrinsics 101
                          ================
                     From the Nethack Grimoires

                 by Steve Derby (sderby@netcom.com).


This file describes how to get the various intrinsics in Nethack and
why you want (or don't want) them. As always, I'm interested in hearing
clarifications and additions.

Note: Except where noted below, eating corpses has only a chance of
bestowing an intrinsic. This chance varies with the level of the
monster's corpse (Stormbringer does not effect corpse level). Also,
eating rings while polymorphed into a monster that can always has a 1
in 3 chance of conferring the ring's intrinsic, but you may also
consume food faster than usual. Not all rings can be eaten.

Intrinsics can be temporary (they automatically go away after a number
of moves), permanent (they never go away under normal circumstances),
or controlled (you control the intrinsics, usually by wearing or
removing magical items).  The "Message" referred to for each intrinsic
is what Nethack tells you when you've permanently gained the
intrinsic.  The message may differ if you are blind or hallucinating
and not all intrinsics have an associated message.  (Note that when
getting an intrinsic by eating a ring, the message is always "Magic
spreads through your body as you digest the ring.")

Note that polymorphing into various monsters gives you their
intrinsics, but only until you return to human/elven form, so I've
omitted polymorphing as a way of getting intrinsics.

Aggravate Monster
~~~~~~~~~~~~~~~~~
Message: varies
Effect: Causes all monsters on the level to come at you with a vengence.
  Generally a bad intrinsic to have.
Obtaining:
  - Cannibalism ("You will regret that!"; permanent)
  - Eat a domestic animal: kitten, housecat, large cat, little dog, dog,
    large dog ("You have a feeling eating that <animal> was a bad idea";
    permanent)
  - Quaff a cursed potion of invisiblilty ("You feel your presence is
    known."; temporary)
  - Wear a ring of aggravate monster (controlled; they tend to be cursed)
  - Eat a ring of aggravate monster (permanent)

Cause Conflict
~~~~~~~~~~~~~~
Message: none
Effect: Causes all monsters (hostile, peaceful, and tame) to attack whoever
  is nearby. Still does not allow you to safely kill peaceful monsters,
  though they will attack you.
Obtaining:
  - Wear a ring of conflict (controlled)
  - Eat a ring of conflict (permanent; probably a bad idea)
  - #Invoke the Sceptre of Might (controlled)

Clairvoyance
~~~~~~~~~~~~
Message: "I bestow on thee a blessing." (when donating)
Effect: The area around you occassionally maps itself. In the endgame,
  proximity to magic portals is sometimes revealed.
Obtaining:
  - Offer money to priests at temples (between 200 and 400 times your level;
    temporary)
  - Carry the Amulet of Yendor (controlled)

Cold resistance
~~~~~~~~~~~~~~~
Message: "You feel full of hot air."
Effect: Cold attacks (rays, defensive, covering with frost, etc.) do not
  affect you.
Obtaining:
  - Eat "cold" monsters, such as yetis, blue jellies, winter wolves, white
    dragons, etc. (permanent)
  - Wear a ring of cold resistance (controlled)
  - Wear white dragon scale mail (controlled)
  - Eat a ring of cold resistance (permanent)
  - Become the Hand of Elbereth/Envoy of Balance/Glory of Arioch (permanent)
  - Valkyries begin with cold resistance

Disintegration-resistance
~~~~~~~~~~~~~~~~~~~~~~~~~
Message: "You feel very firm."
Effect: Disintegration blasts from black dragons and angry deities do not
  harm you. Wands of death do not harm you.
Obtaining:
  - Eat a black dragon (permanent)
  - Wear black dragon scale mail (controlled)

ESP
~~~
Message: none
Effect: All monsters in the vicinity are revealed, whether they can actually
  be seen or not. Monsters posing as statues, mimics, and hiding monsters
  (e.g. rock piercers and trappers) are revealed.
Obtaining:
  - Wear an amulet of ESP (including the Eye of Aethiopica; controlled)
  - Wear a helm of telepathy (controled)
  - Carry the Orb of Detection, the Palantir of Westernesse, the Magic
    Mirror of Merlin, or the Platinum Yendorian Express Card (controlled)

Fire resistance
~~~~~~~~~~~~~~~
Message: "You feel a slight chill."
Effect: Heat attacks (rays, defensive, burning, etc.) and fire traps do not
  affect you.
Obtaining:
  - Eat "hot" monsters such as hell hounds, red dragons, fire giants, etc.
    (permanent)
  - Wear a ring of fire resistance (controlled)
  - Eat a ring of fire resistance (permanent)
  - Wear red dragon scale mail (controlled)
  - Become the Hand of Elbereth/Envoy of Balance/Glory of Arioch (permanent)
  - Carry the Mitre of Holiness (controlled)
  - Priests gain fire resistance with time

Invisibility
~~~~~~~~~~~~
Message: "You feel hidden."
Effect: You are invisible to other monsters, reducing their attack
  efficiency. Also, you cannot enter shops (at least not by way of the front
  door).
Obtaining:
  - Wear a ring of invisibility (controlled)
  - Wear a cloak of invisiblity (controlled)
  - Eat a ring of invisibility (permanent)
  - Eat a stalker corpse while not already invisible (temporary; always
    works)
  - Eat a stalker corpse while already invisible (permanent; always works)
  - Quaff a cursed or uncursed potion of invisibility (temporary; if cursed,
    it also gives you aggravate monster)
  - Quaff a blessed potion of invisibility (temporary or permanent: your
    choice)
  - Zap yourself with a wand of invisibility (permanent)
  - Quaff from a sink (temporary; infintesmally small chance)
  - #Invoke the Orb of Detection (controlled)

Jumping
~~~~~~~
Message: none
Effect: You can jump at will (using #jump).
Obtaining:
  - Wear boots of jumping (controlled)
  - Knights begin with jumping (appropriately enough, only in an L-shape)

Levitation
~~~~~~~~~~
Message: "You float into the air."
Effect: You float above the ground, avoiding any pressure-sensitive traps
  below. You cannot go down stairs or interact in any way with items on the
  ground below.
Obtaining:
  - Wear boots of levitation (controlled; they tend to be cursed)
  - Wear a ring of levitation (controlled)
  - Eat a ring of levitation (permanent; WARNING: This is a bad thing)
  - Quaff a potion of levitation (temporary)
  - #Invoke the Heart of Ahriman (controlled)
Note that the related intrisic "You can fly" is not included in this file
because there is no way to obtain it, other than polymorphing into a flying
monster. Flight gives all the benefits of levitation with none of the
drawbacks.

Luck
~~~~
Note: Luck is a variable, not an intrinsic. For information on how to raise
  your luck, see the Nethack Grimoires file "raising"

Good/bad luck does not time out for you: Normally, any luck you get (good
  or bad) will gradually return to 0 (-1 during the new moon, +1 during the
  full moon). Carrying a luckstone can halt this automatic regression: a
  blessed luckstone makes good luck stick, but bad luck times out; an
  uncursed luckstone makes both stick; a cursed luck stone makes bad luck
  stick, but good luck times out.
You have extra/reduced luck: Carrying a luckstone also changes your base
  luck. A cursed luckstone reduces it while a blessed or uncursed luckstone
  increases it.

Lycanthropy
~~~~~~~~~~~
Message: "You feel feverish."
Effect: Occassionally, you will turn into a werecreature of the same type
  that bit you (wererat, werejackal, or werewolf). Definately a bad thing,
  except that you can create pets with the #monster meta-command. See the
  file "trouble" for a description of how to cure lycanthropy.
Obtaining:
  - Get bitten by a wererat, werejackal, or werewolf (permanent)
  - Eat a wererat, werejackal, or werewolf (permanent)

Magic Resistance
~~~~~~~~~~~~~~~~
Message: none
Effect: Causes magic missiles to bounce harmlessly away. Anti-magic fields,
  teleportation traps, and polymorph traps have no effect.
Obtaining:
  - Wear a cloak of magic protection (controlled)
  - Wear gray dragon scale mail (controlled)
  - Carry the Orb of Detection, the Sceptre of Might, the Magic Mirror of
    Merlin, the Platinum Yendorian Express Card, or the Eye of Aethiopica
    (controlled)

Poison Resistance
~~~~~~~~~~~~~~~~~
Message: "You feel healthy!"
Effect: Eating poisonous corpses is safe. Poison attacks (e.g. killer bee
  stings) do not do extra damage or kill you outright. Poisoned darts and
  arrows do not do extra damage or kill you outright. Potions of sickness do
  not poison you. Poison resistance DOES NOT protect you from become deathly
  sick.
Obtaining:
  - Eat a poisonous corpse (permanent; includes a vast array of monsters
    including most insects, all kobolds, and many others.)
  - Eat unicorn corpses, cave spiders, garter snakes, gelatinous cubes, or
    a few others which are NOT poisonous, but will confer poison resistance
    (permanent)
  - Wear a ring of poison resistance (controlled)
  - Eat a ring of poison resistance (permanent)
  - Wear an amulet of versus poison (controlled)
  - Wear green dragon scale mail (controlled)
  - Become the Hand of Elbereth/Envoy of Balance/Glory of Arioch (permanent)
  - Healers and barbarians begin with poison resistance
  - Tourists gain poison resistance with time

Polymorph
~~~~~~~~~
Message: none
Effect: You will occassionally polymorph into something else. If you have
  polymorph control, you get to choose what. Polymorphing is always
  temporary.
Obtaining:
  - Wear a ring of polymorph (controlled)
  - Eat a ring of polymorph (permanent)
Note that you can also polymorph (without gaining the intrinsic) by zapping
  yourself with a wand of polymorph, quaffing from a sink (sometimes),
  stepping on a polymorph trap, or eating a chameleon corpse. Eating a mimic
  corpse will polymorph you temporarily into a pile of gold.

Polymorph Control
~~~~~~~~~~~~~~~~~
Message: none
Effect: You get to choose what monster to become when polymorphed
Obtaining:
  - Wear a ring of polymorph control (controlled)
  - Eat a ring of polymorph control (permanent)

Protection
~~~~~~~~~~
Message: "Thy devotion has been rewarded." (when donating)
Effect: Lowers your armor class by the amount of protection (0-20).
Obtaining:
  - Wear a ring of protection (controlled)
  - Eat a ring of protection (permanent)
  - Wear a cloak of protection (controlled)
  - Pray (sometimes; permanent)
  - Donate to priests in temples (between 400 and 600 times your level;
    permanent)

Reflection
~~~~~~~~~~
Message: none
Effect: "Beamed" attacks and lightning will bounce harmlessly back the way
  they came.
Obtaining:
  - Wear a shield of reflection (controlled)
  - Wear an amulet of reflection (controlled)

Regeneration
~~~~~~~~~~~~
Message: none
Effect: Your hit points regenerate at a very fast rate.
Obtaining:
  - Wear a ring of regeneration (controlled)
  - Eat a ring of regeneration (permanent; a bad idea due to the increased
    food consumption)
  - Carry The Palantir of Westernesse or the Staff of Aesculapius (controlled)

Searching
~~~~~~~~~
Message: "You feel perceptive!"
Effect: Your character will automatically search for secret doors, passages,
  traps, monsters posing as statues, etc. every turn.
Obtaining:
  - Wear a ring of searching (controlled)
  - Eat a ring of searching (permanent)
  - Wield Excalibur (controlled)
  - Elves begin with searching
  - Archeologists, Barbarians, Rogues, and Tourists gain searching with time

See invisible
~~~~~~~~~~~~~
Message: varies
Effect: Invisible monsters are no longer invisible to you.
Obtaining:
  - Quaff a potion of see invisible (temporary)
  - Quaff a blessed potion of see invisible (permanent)
  - Quaff from a fountain (sometimes; permanent; "You see an image of
    someone stalking you.")
  - Quaff from a sink (temporary; infintessmally small chance)
  - Sit on a throne (sometimes; permament; "Your vision clears.")
  - Eat a ring of see invisible (permament)
  - Eat a stalker corpse while invisible (permanent; always works)
  - Become the Hand of Elbereth/Envoy of Balance/Glory of Arioch (permanent)
  - Elves begin with see invisible

Shock resistance
~~~~~~~~~~~~~~~~
Message: "You health currently feels amplified!"
Effect: Lighting and electrical attacks do not harm you.
Obtaining:
  - Eat monsters which attack with electricity, such as blue dragons
    (permanent)
  - Eat gelatinous cubes or black puddings (permanent)
  - Wear a ring of shock resistance (controlled)
  - Eat a ring of shock resistance (permanent)
  - Wear blue dragon scale mail (controlled)

Sleep resistance
~~~~~~~~~~~~~~~~
Message: "You feel wide awake."
Effect: Sleep attacks (e.g. from homunculi or wands of sleep) and sleeping
  gas traps do not affect you.
Obtaining:
  - Eat elves (permanent)
  - Eat some acidic monsters such as acid blobs and gelatinous cubes
    (permanent)
  - Eat orange dragons (permanent)
  - Eat homunculi (permanent)
  - Wear orange dragon scale mail (controlled)
  - Elves begin with sleep resistance

Speed
~~~~~
Note that speed can be stolen by shades and can be removed by quantum
mechanics.

Message: "You feel yourself speed up [a bit more]."
Effect: You become faster in movement and attacks. There are two levels of
  speed: fast and very fast. Very fast can be obtained only when wearing
  speed boots.
Obtaining:
  - Wear speed boots (controlled)
  - Zap yourself with a wand of speed monster (permanent)
  - Quaff a potion of speed (temporary)
  - Quaff from a sink (temporary; infintessmally small chance)
  - Get hit by a Quantum Mechanic while not yet fast (sometimes; permanent;
    "Your velocity seems very uncertain.")
  - Eat a Quantum Mechanic while not yet fast (always; permanent; "Your
    velocity seems very uncertain.")
  - Archeologists, Elves, and Samauris begin with speed
  - Barbarians, Cavemen, Healers, Knights, Priests, and Valkyries gain speed
    with time

Stealth
~~~~~~~
Message: "You walk very quietly."
Effect: Other monsters (including your pet) may not notice you.
Obtaining:
  - Wear elven boots (controlled)
  - Wear a ring of stealth (controlled)
  - Eat a ring of stealth (permanent)
  - Carry the Heart of Ahriman (Barbarian quest artifact; controlled)
  - Archeologists, rogues, and valkyries begin with stealth
  - Samauris gain stealth with time

Telepathy
~~~~~~~~~
Note that telepathy will be lost if you kill a peaceful monster of your same
race (elves for elves, humans otherwise).

Message: "You feel a strange mental acuity."
Effect: When blind, the location of all monsters on the level with brains are
  revealed.
Obtaining:
   - Eat a floating eye corpse (permanent; always works)
   - Eat a mind flayer corpse (permanent)
   - Become the Hand of Elbereth/Envoy of Balance/Arioch's Glory (always;
     permanent)
   - Pray (sometimes; permanent)

Teleport
~~~~~~~~
Message: "You feel jumpy."
Effect: If you don't also have teleport control, you will occassionally
  teleport to a random location on the level. If you have teleport control,
  you get to choose where.
Obtaining:
  - Wear a ring of teleportation (controlled)
  - Eat a ring of teleportation (permanent)
  - Eat most (but not all) teleporting monster: leprechauns, all nymphs,
    tengus, the Wizard of Yendor (permanent)

Teleport Control
~~~~~~~~~~~~~~~~
Message: "You feel in control of yourself."
Effect: If you also have teleport or know the teleport away spell, you can
  choose where to teleport to.
Obtaining:
  - Wear a ring of teleport control (controlled)
  - Eat a ring of teleport control (permanent)
  - Eat tengus or the Wizard of Yendor (permanent; in the latter case it's
    cannibalism if you're not an elf)
  - Carry the Master Key of Thievery (controlled)
  - Wizards gain teleport control with time

Turning to stone
~~~~~~~~~~~~~~~~
Message: "You are slowing down.", "Your limbs are stiffening."
Effect: Obvious. You turn to stone and die in 2 moves. Definately a bad
  thing. (See the file "trouble" for info on how to cure this.)
Obtaining:
  - Tangle with a cockatrice (sometimes; permanent until death)
  - Eat a cockatrice egg (permanent until death)
Note: eating a cockatrice corpse, Medusa's corpse, gazing on Medusa, and
  touching a cockatrice with ungloved hands cause immediate stoning.

Warning
~~~~~~~
Message: "You feel sensitive."
Effect: Your character will occassionally feel aprehensive as he/she senses
  a flash of colored light. The darker the color, the more dangerous the
  monsters on the level are.
Obtaining:
  - Wear a ring of warning (controlled)
  - Eat a ring of warning (permanent)
  - Wield Sting (controlled)
  - Carry the Master Key of Thievery or the Orb of Fate (controlled)
  - Cavemen and Wizards gain warning with time

                                 * * *

Thanks to the following kind and knowledgeable individual for
contributing to this file: John Darrow, Brandi Derby, Ali Harlow, Carl
Muckenhoupt, Timothy Redden, Rene Stienen, Viljo Viitanen, Boudewijn
Wayers.
