
#ifndef _GAME_CPP
#define _GAME_CPP

#include "game.h"

/*******************/

s16 control[7];//player control keys
//
s16 level     ;//current wave
s16 levelDone ;//flag all landers killed
u32 score     ;
u32 highScore ;
u32 nextShield;
//
s16 bombCount ;//how many active player missles
s16 alienCount;//how many landers for new level
s16 expCount  ;//how many active explosions
s16 spikeTimer;

/*******************/
/*******************/
/*******************/
/*******************/

void clrThings()
{
u16 ind;
for (ind=0;ind<THINGTOTAL;ind++)
    {things[ind].flag1=OFF;
     }
}

/////////////////////

void setupPlanets()
{
u16 ind;
/////setup planets//////
for (ind=GRAVSTART;(ind< GRAVLAST );ind++)
    {randInd++;
     //
     things[ind].x=Cos(randLook256[randInd])*(ind*175);
     things[ind].x+=GLBX_HALF;//normalize 0->GLBX_MAX
     //
     things[ind].y=Sin(randLook256[randInd])*(ind*175);
     things[ind].y+=GLBY_HALF;//normalize 0->GLBY_MAX
     //
     things[ind].mass =30;
     things[ind].flag1=ON;
     /////add population/////
     if (randLook[randInd]==TRUE)
	things[ind].flag2=SPACEMAN;
     else
	things[ind].flag2=ALIENMAN;
     //
     things[ind].type=ind;
     }
/////sun /////
things[SUN ].x       =GLBX_HALF;//center
things[SUN ].y       =GLBY_HALF;//cenetr
things[SUN ].mass    =40       ;
things[SUN ].flag1   =ON       ;
things[SUN ].flag2   =EMPTY    ;
things[SUN ].type    =SUN      ;
//
things[GATE].flag2   =EMPTY    ;
things[GATE].type    =GATE     ;
}

/////////////////////

void setupPlayer()
{
/////
things[PLAYER].x      =things[GATE].x;//center of screen
things[PLAYER].y      =things[GATE].y;//center of screen
things[PLAYER].fx     =things[GATE].x;//start at gate
things[PLAYER].fy     =things[GATE].y;//start at gate
things[PLAYER].xvel   =15            ;
things[PLAYER].yvel   =15            ;
things[PLAYER].thpos  =0    	     ;
things[PLAYER].thvel  =0    	     ;
things[PLAYER].facing =0    	     ;
things[PLAYER].count  =0    	     ;
things[PLAYER].mass   =0    	     ;
things[PLAYER].flag1  =ON  	     ;
things[PLAYER].flag2  =EMPTY	     ;
things[PLAYER].type   =PLAYER	     ;
/////station
things[OTHERSTART].x      =things[SUN].x;//center of screen
things[OTHERSTART].y      =things[SUN].y;//center of screen
things[OTHERSTART].fx     =things[SUN].x;//start at gate
things[OTHERSTART].fy     =things[SUN].y;//start at gate
things[OTHERSTART].flag1  =ON  	        ;
things[OTHERSTART].flag2  =EMPTY	;
things[OTHERSTART].type   =STATION      ;
randInd++;
things[OTHERSTART].target=(randLook256[randInd]/36)+1;//target planet;
/////
}

/////////////////////

void setupLanders()
{
u16 ind;
//
for (ind=ALIENSTART;ind<(ALIENSTART+alienCount);ind++)
    {
    things[ind].flag1=ON   ;
    things[ind].type =LANDER;
    //
    randInd++;
    things[ind].target=(randLook256[randInd]/36)+1;//target planet;
    //
    randInd++;
    ////
    things[ind].x =Cos(randLook256[randInd])*(GLBX_HALF-50);
    things[ind].x+=GLBX_HALF;//normalize 0->GLBX_MAX
    //
    things[ind].y =Sin(randLook256[randInd])*(GLBX_HALF-50);
    things[ind].y+=GLBY_HALF;//normalize 0->GLBY_MAX
    ////
    }
}

/////////////////////

void setupStarMap()
{
u16 ind;
u16 gap;
u16 flag;
STARTYPE temp;
//
for (ind=0;ind<STAR_TOTAL;ind++)
    {starMap[ind].x=(rand()%GLBX_MAX);
     starMap[ind].y=(rand()%GLBY_MAX);
     }
//procedure CombSort(N:integer);
gap=11;
LOOP:
   {;
   flag=0;
   gap=(gap*10) / 13;
   if (gap==0) gap=1;
   else
      {if ( (gap==9) || (gap==10) )  gap=11;
       for (ind=1;ind<(11-gap);ind++)
	   {if (starMap[ind].x>starMap[ind+gap].x)
	       {temp=starMap[ind];
		starMap[ind]=starMap[ind+gap];
		starMap[ind+gap]=temp;
		flag=1;
		}
	    }
       }
    }//LOOP
if (!((flag==0) && (gap==1)) ) goto LOOP;
}

/*******************/
/*******************/
/*******************/
/*******************/

void drawStar(STARTYPE *star)
{
s16 tmpx ;
s16 tmpy ;
s16 tmpxs;
s16 tmpys;
//
s16 rskip;
s16 lskip;
s16 tskip;
s16 bskip;
//
u16 ind  ;
//
tmpx =(*star).x ;
tmpy =(*star).y ;
tmpxs=images[STAR].xs;
tmpys=images[STAR].ys;
//
tmpx+=(GLBX_MAX-things[PLAYER].x)+160;
if (tmpx<0)          tmpx+=GLBX_MAX  ;
if (tmpx>GLBX_MAX)   tmpx-=GLBX_MAX  ;
//
tmpy+=(GLBY_MAX-things[PLAYER].y)+100;
if (tmpy<0)          tmpy+=GLBY_MAX      ;
if (tmpy>GLBY_MAX)   tmpy-=GLBY_MAX;
//
tmpx-=(tmpxs>>1);
tmpy-=(tmpys>>1);
//is in screen
if ( (tmpx<0)           ||
     (tmpx>(319-tmpxs)) ||
     (tmpy<0)           ||
     (tmpy>(199-tmpys)) )
   {goto DONE;
    }
else
   {randInd++;
    drawSprite(tmpx,tmpy,tmpxs,tmpys,
    images[STAR].spr[(randLook[randInd])][0],Vaddr1);
    }
DONE:{;}
}

/////////////////////

void doStars()
{
u16 ind ;
u16 indstop;

u16 firstx;
u16 lastx;


//
for (ind=0;ind<STAR_TOTAL;ind++)
    {drawStar(&starMap[ind]);
     }
}

/*******************/
/*******************/
/*******************/
/*******************/

void doRadar()
{
u16 ind;
u16 addr;
u8  col ;
//clear
for (ind=0;ind<(MAPX_MAX*MAPY_MAX);ind++)
    {*(images[RADAR].spr[0][0]+(ind))=255;
     }
//make
//117blue 110white 163lgrn 85prup 5red 185yell 200brn
for (ind=1;ind<OTHERLAST;ind++)
    {if (things[ind].flag1==ON)
	{randInd++;
	 if (things[ind].flag2==EMPTY   ) col=117    ;
	 if (things[ind].flag2==SPACEMAN) col=5      ;
	 if (things[ind].flag2==ALIENMAN) col=87     ;
	 if (things[ind].type ==SUN     ) col=185    ;
	 if (things[ind].type ==GATE    ) col=randInd;
	 if (things[ind].type ==LANDER  ) col=161    ;
	 if (things[ind].type ==MUTANT  ) col=163    ;
	 if (things[ind].type ==STATION ) col=5      ;
	 if (things[ind].type ==SPIKE   ) col=163+randLook[randInd];
	 if (things[ind].type ==STORM   ) col=185;
	 if (things[ind].type ==JUNK    ) col=200;
	 //
	 addr=( (things[ind].x/64)+((things[ind].y/64)*64) );
	 *((images[RADAR].spr[0][0])+addr)=col;
	 }
     }
/////
col=110;//white
addr=( (things[PLAYER].x/64)+((things[PLAYER].y/64)*64) );
*((images[RADAR].spr[0][0])+addr)=col;
//draw radar
drawSprite (10,10,MAPX_MAX,MAPY_MAX,images[RADAR].spr[0][0],Vaddr1);
Hline(9 ,76,9 ,254,Vaddr1);
Hline(9 ,76,74,254,Vaddr1);
Vline(9 ,9 ,74,254,Vaddr1);
Vline(76,9 ,74,254,Vaddr1);

//draw shield
if (things[PLAYER].shield>0)
   {Hline(10,(10+things[PLAYER].shield),5,5,Vaddr1);
    }
}

/////////////////////

void doScore()
{
s16 ind;
s16 xpos;
u32 mod;
u32 rmd;
//
xpos=308;
rmd=score;
//
for (ind=0;ind<6;ind++)
    {mod =rmd%10;
     rmd/=10;
     //
     if (mod<5)
	{drawSprite(xpos,5,images[DIGIT1].xs,images[DIGIT1].ys,
	 images[DIGIT1].spr[mod][0],Vaddr1);
	 }
     else
	{mod-=5;
	 drawSprite(xpos,5,images[DIGIT2].xs,images[DIGIT2].ys,
	 images[DIGIT2].spr[mod][0],Vaddr1);
	 }
     //
     if (rmd==0) goto DONE;
     xpos=xpos-12;
     }
DONE:{;}
//deal with scores
while (nextShield<score)
      {nextShield+=5000;
       if (things[PLAYER].shield<150) things[PLAYER].shield+=20;
       }
//rolled over
if (score>1000000)
   {score     %=1000000;
    nextShield%=1000000;
    }
}

/*******************/
/*******************/
/*******************/
/*******************/

void drawPlayer()
{
/////draw rider/////
randInd++;
if (things[PLAYER].flag2==ALIENMAN)
   {drawSprite (296,20,images[ALIENMAN].xs,images[ALIENMAN].ys,
     images[ALIENMAN].spr[(randLook[randInd])][0],Vaddr1);
    }
if (things[PLAYER].flag2==SPACEMAN)
   {drawSprite (296,20,images[SPACEMAN].xs,images[SPACEMAN].ys,
     images[SPACEMAN].spr[(randLook[randInd])][0],Vaddr1);
    }
////////////////////
if ( control[NONE]==ON )
   {drawSprite (144,84,images[PLAYER].xs,images[PLAYER].ys,
     images[PLAYER].spr[0][things[PLAYER].facing],Vaddr1);
    goto DONE;
    }
//
if ( control[UP]==ON )
   {drawSprite (144,84,images[PLAYER].xs,images[PLAYER].ys,
     images[PLAYER].spr[1][things[PLAYER].facing],Vaddr1);
    }
//
if ( control[DOWN]==ON )
   {drawSprite (144,84,images[PLAYER].xs,images[PLAYER].ys,
     images[PLAYER].spr[2][things[PLAYER].facing],Vaddr1);
    }
//
if ( control[RIGHT]==ON )
   {drawSprite (144,84,images[PLAYER].xs,images[PLAYER].ys,
     images[PLAYER].spr[3][things[PLAYER].facing],Vaddr1);
    }
//
if ( control[LEFT]==ON )
   {drawSprite (144,84,images[PLAYER].xs,images[PLAYER].ys,
     images[PLAYER].spr[4][things[PLAYER].facing],Vaddr1);
    }
/////
DONE:{;}
}

/////////////////////
/////////////////////
/////////////////////
/////////////////////

void gravity(THINGTYPE *thing)
{
u16     ind;
float   xdist;
float   ydist;
float   txd;
float   tyd;
float   dist;
float   sqrd;
float   ux;
float   uy;
float   acc;
float   sqac;
//
xdist=(*thing).fx;
ydist=(*thing).fy;
//
for (ind=GRAVSTART;ind<=GRAVLAST;ind++)
    {if (things[ind].mass!=0)
	{txd=(xdist-things[ind].x);
	 tyd=(ydist-things[ind].y);
	 //
	 dist = (txd*txd)+(tyd*tyd);
	 if (dist!=0)
	    {sqrd      = sqrt(dist)               ;
	     ux        = (txd/sqrd)               ;
	     uy        = (tyd/sqrd)               ;
	     acc       = (things[ind].mass/dist) ;
	     sqac      = sqrt(acc)                ;
	     (*thing).xvel=(*thing).xvel+(ux*sqac);
	     (*thing).yvel=(*thing).yvel+(uy*sqac);
	     }
	 }
     }
}

/////////////////////
/////////////////////
/////////////////////
/////////////////////

void drawThings(THINGTYPE *thing)
{
s16 tmpx;
s16 tmpy;
s16 tmpxs;
s16 tmpys;
u16 ind ;
//////
tmpx =(*thing).x;
tmpy =(*thing).y;
tmpxs=images[((*thing).type)].xs;
tmpys=images[((*thing).type)].ys;
//
tmpx+=(GLBX_MAX-things[PLAYER].x)+160;
if (tmpx<0)          tmpx+=GLBX_MAX  ;
if (tmpx>GLBX_MAX)   tmpx-=GLBX_MAX  ;
//
tmpy+=(GLBY_MAX-things[PLAYER].y)+100;
if (tmpy<0)          tmpy+=GLBY_MAX      ;
if (tmpy>GLBY_MAX)   tmpy-=GLBY_MAX;
//
tmpx-=(tmpxs>>1);
tmpy-=(tmpys>>1);
//is in screen
if ( (tmpx<0)           ||
     (tmpx>(319-tmpxs)) ||
     (tmpy<0)           ||
     (tmpy>(199-tmpys)) )
   {goto DONE;
    }
else
   {///draw explosions////
    if ( ((*thing).type)==EXPLOS )
       {drawSprite(tmpx,tmpy,tmpxs,tmpys,
	images[((*thing).type)].spr[((*thing).count)][0],Vaddr1);
	goto DONE;
	}
    ///draw bombs and storm///
    if (images[((*thing).type)].rot==32)
       {if (images[((*thing).type)].var==1)
	   {drawSprite(tmpx,tmpy,tmpxs,tmpys,
	    images[((*thing).type)].spr[0]
	    [((*thing).facing)],Vaddr1);
	    goto DONE;
	    }
	else
	   {randInd++;
	    drawSprite(tmpx,tmpy,tmpxs,tmpys,
	    images[((*thing).type)].spr[(randLook[randInd])]
	    [((*thing).facing)],Vaddr1);
	    goto DONE;
	    }
	}
    ///draw planet or thing and junk///
    if (images[((*thing).type)].var==1)  //one images
       {drawSprite(tmpx,tmpy,tmpxs,tmpys,
	images[((*thing).type)].spr[0][0],Vaddr1);
	}
    else  				   //two images
       {if ((*thing).type==JUNK)
	   {drawSprite(tmpx,tmpy,tmpxs,tmpys,
	    images[((*thing).type)].spr[(*thing).facing][0],Vaddr1);
	    goto DONE;
	    }
	else
	   {randInd++;
	    drawSprite(tmpx,tmpy,tmpxs,tmpys,
	    images[((*thing).type)].spr[(randLook[randInd])][0],Vaddr1);
	    }
	}
    /////draw  population/////
    if ((*thing).flag2==ALIENMAN)
       {randInd++;
	drawSprite(tmpx+4,tmpy+4,images[ALIENMAN].xs,images[ALIENMAN].ys,
	images[ALIENMAN].spr[(randLook[randInd])][0],Vaddr1);
	goto DONE;
	}
    if ((*thing).flag2==SPACEMAN)
       {randInd++;
	drawSprite(tmpx+4,tmpy+4,images[ALIENMAN].xs,images[ALIENMAN].ys,
	images[SPACEMAN].spr[(randLook[randInd])][0],Vaddr1);
	}
    //////////////////////////
    }
DONE:{;}
}

/////////////////////
/////////////////////
/////////////////////
/////////////////////

void makeExplosion(THINGTYPE *thing,s16 size)
{///size 4 or less
s16 ind;
if (expCount>EXPMAX) goto DONE;
//

ind=EXPSTART;
while (things[ind].flag1==ON) ind++;
//
things[ind].flag1 =ON;
things[ind].x     =(*thing).x;
things[ind].y     =(*thing).y;
things[ind].count =size;
things[ind].type  =EXPLOS;
expCount++;
//
DONE:{;}
}

/////////////////////

void crash(THINGTYPE *thing)
{
s16 tmpx;
s16 tmpy;
//
tmpx=(*thing).x-things[PLAYER].x;
tmpy=(*thing).y-things[PLAYER].y;
//
if ( (tmpx<16) && (tmpx>-16) && (tmpy<16) && (tmpy>-16) )
   {/////is a crash/////
    things[PLAYER].shield-=25;
    (*thing).flag1=OFF;
    ////score
    makeExplosion(thing,4);
    score+=50;
    }
}

/////////////////////

void grabNdrop(THINGTYPE *thing)
{
s16 tmpx;
s16 tmpy;
//
tmpx=(*thing).x-things[PLAYER].x;
tmpy=(*thing).y-things[PLAYER].y;
//
if ( (tmpx<16) && (tmpx>-16) && (tmpy<16) && (tmpy>-16) )
   {/////is a grab/////
    if (things[PLAYER].flag2==EMPTY)
       {if ((*thing).flag2!=EMPTY)
	   {/////pick up from planet/////
	    things[PLAYER].flag2=(*thing).flag2;
	    (*thing).flag2=EMPTY;
	    }
	}
    else
       {if ((*thing).flag2==EMPTY)
	   {if ( (*thing).type==GATE )
	       {/////drop at gate//////
		makeExplosion(thing,4);
		if (things[PLAYER].flag2==SPACEMAN)
		   {//score
		    if (things[PLAYER].shield<150) things[PLAYER].shield+=10;
		    score+=1000;
		    }
		things[PLAYER].flag2=EMPTY;
		}
	    else
	       if ( (*thing).type==SUN )
		  {/////drop at sun //////
		   makeExplosion(thing,4);
		   if (things[PLAYER].flag2==ALIENMAN)
		      {//score
		       score+=1000;
		       }
		   things[PLAYER].flag2=EMPTY;
		   }
	       else
		  {/////drop on planet//////
		   (*thing).flag2=things[PLAYER].flag2;
		   things[PLAYER].flag2=EMPTY;
		   }
	    }
	}
    }
}

/////////////////////
/////////////////////
/////////////////////
/////////////////////

void mutantBrain(THINGTYPE *thing)
{
s16 tmpx;
s16 tmpy;
//
tmpx=((*thing).x)-(things[PLAYER].x);
tmpy=((*thing).y)-(things[PLAYER].y);
//
if ( tmpx>0 )
   {if ( tmpx> GLBX_HALF ) (*thing).x++;else (*thing).x--;
    }
else
   {if ( tmpx<-GLBX_HALF ) (*thing).x--;else (*thing).x++;
    }
//
if ( tmpy>0 )
   {if ( tmpy> GLBY_HALF ) (*thing).y++;else (*thing).y--;
    }
else
   {if ( tmpy<-GLBY_HALF ) (*thing).y--;else (*thing).y++;
    }
//
if ((*thing).x<0)         {(*thing).x+=GLBX_MAX;}
if ((*thing).x>GLBX_MAX)  {(*thing).x-=GLBX_MAX;}
if ((*thing).y<0)         {(*thing).y+=GLBY_MAX;}
if ((*thing).y>GLBY_MAX)  {(*thing).y-=GLBY_MAX;}
//

}

/////////////////////

void landerBrain(THINGTYPE *thing)
{
/////
if (( ((*thing).x) == (things[((*thing).target)].x) ) &&
    ( ((*thing).y) == (things[((*thing).target)].y) ) )
    {/////at target/////
     if ( (things[((*thing).target)].flag2)==EMPTY )
	{/////colony/////
	 (*thing).flag1=OFF;
	 things[((*thing).target)].flag2=ALIENMAN;
	 }
     //
     if ( (things[((*thing).target)].flag2)==SPACEMAN )
	{/////abduct/////
	 (*thing).type=MUTANT;
	 things[((*thing).target)].flag2=EMPTY;
	 }
     //
     if ( (things[((*thing).target)].flag2)==ALIENMAN )
	{///new target///
	 randInd++;
	 (*thing).target=(randLook256[randInd]/36)+1;//target planet;
	 }
     /////
     }
else
   {/////keep moving/////
    if ( ((*thing).x) > (things[((*thing).target)].x) )
       {(*thing).x--;}
    else
       if ( ((*thing).x) < (things[((*thing).target)].x) )
	  {(*thing).x++;}
    //
    if ( ((*thing).y) > (things[((*thing).target)].y) )
       {(*thing).y--;}
    else
       if ( ((*thing).y) < (things[((*thing).target)].y) )
	  {(*thing).y++;}
    /////
    }
}

/////////////////////

void stationBrain(THINGTYPE *thing)
{
/////
if (( ((*thing).x) == (things[((*thing).target)].x) ) &&
    ( ((*thing).y) == (things[((*thing).target)].y) ) )
    {/////at target/////
     if ( (things[((*thing).target)].flag2)==EMPTY )
	{/////colony/////
	 things[((*thing).target)].flag2=SPACEMAN;
	 randInd++;
	 (*thing).target=(randLook256[randInd]/36)+1;//target planet;
	 }
     //
     if ( ( things[(*thing).target].flag2==SPACEMAN ) ||
	  ( things[(*thing).target].flag2==ALIENMAN ) )
	{/////new planet/////
	 randInd++;
	 (*thing).target=(randLook256[randInd]/36)+1;//target planet;
	 }
     /////
     }
else
   {/////keep moving/////
    if ( ((*thing).x) > (things[((*thing).target)].x) )
       {(*thing).x--;}
    else
       if ( ((*thing).x) < (things[((*thing).target)].x) )
	  {(*thing).x++;}
    //
    if ( ((*thing).y) > (things[((*thing).target)].y) )
       {(*thing).y--;}
    else
       if ( ((*thing).y) < (things[((*thing).target)].y) )
	  {(*thing).y++;}
    /////
    }
}

/////////////////////

void bombBrains(THINGTYPE *thing)
{
s16 ind;
s16 tmpx;
s16 tmpy;
//move
(*thing).fx-=(*thing).xvel;
(*thing).fy-=(*thing).yvel;
//bound
if ((*thing).fx<0)         {(*thing).fx+=GLBX_MAX;}
if ((*thing).fx>GLBX_MAX)  {(*thing).fx-=GLBX_MAX;}
if ((*thing).fy<0)         {(*thing).fy+=GLBY_MAX;}
if ((*thing).fy>GLBY_MAX)  {(*thing).fy-=GLBY_MAX;}
//
(*thing).x=(*thing).fx;
(*thing).y=(*thing).fy;
///////is it a hit///////
for (ind=ALIENSTART;ind<ALIENLAST;ind++)
    {//
     if (things[ind].flag1==ON)
	{tmpx=(*thing).x-things[ind].x;
	 tmpy=(*thing).y-things[ind].y;
	 //
	 if ( (tmpx<10) && (tmpx>-10) && (tmpy<10) && (tmpy>-10) )
	    {/////it's a hit
	     bombCount--;
	     things[ind].flag1=OFF;
	     (*thing).flag1   =OFF;
	     makeExplosion(thing,4);
	     //score
	     score+=250;
	     }
	 }
    }
//////otherstuff//////
for (ind=OTHERSTART;ind<OTHERLAST;ind++)
    {//
     if (things[ind].flag1==ON)
	{tmpx=(*thing).x-things[ind].x;
	 tmpy=(*thing).y-things[ind].y;
	 //
	 if ( (tmpx<10) && (tmpx>-10) && (tmpy<10) && (tmpy>-10) )
	    {/////it's a hit
	     bombCount--;
	     if (things[ind].type!=STORM) //storms don't die
		{things[ind].flag1=OFF;
		 makeExplosion(thing,4);
		 //score
		 score+=250;
		 }
	     //bomb off
	     (*thing).flag1   =OFF;
	     }
	 }
    }


////time out bomb/////
(*thing).count--;
if ((*thing).count==0)
   {bombCount--;
    (*thing).flag1=OFF;
     makeExplosion(thing,1);
    }
/////
}

/////////////////////

void explosionBrains(THINGTYPE *thing)
{////explosions aren't that smart
(*thing).count --;
//
if ( (*thing).count==0)
   {///timed out
    (*thing).flag1=OFF;
    expCount--;
    }
/////
}

/////////////////////
/////////////////////
/////////////////////
/////////////////////


void spikeBrain(THINGTYPE *thing)
{
float   txd;
float   tyd;
float   dist;
float   sqrd;
float   ux;
float   uy;
//
s16 tmpx;
s16 tmpy;
//
txd=((*thing).x)-(things[PLAYER].x);
tyd=((*thing).y)-(things[PLAYER].y);
//
dist = (txd*txd)+(tyd*tyd);
if (dist!=0)
   {sqrd      = sqrt(dist)               ;
    ux        = (txd/sqrd)               ;
    uy        = (tyd/sqrd)               ;
    (*thing).x-=(ux*2.5);
    (*thing).y-=(uy*2.5);
    }
//
if ((*thing).x<0)         {(*thing).x+=GLBX_MAX;}
if ((*thing).x>GLBX_MAX)  {(*thing).x-=GLBX_MAX;}
if ((*thing).y<0)         {(*thing).y+=GLBY_MAX;}
if ((*thing).y>GLBY_MAX)  {(*thing).y-=GLBY_MAX;}
//

}

/////////////////////

void launchSpike(THINGTYPE *thing)
{

(*thing).flag1 =ON;
(*thing).type  =SPIKE;
//
/////
randInd++;
(*thing).x=things[PLAYER].x;
(*thing).x+=Cos(randLook256[randInd])*1000;
//
(*thing).y=things[PLAYER].y;
(*thing).y+=Sin(randLook256[randInd])*1000;
/////
if ((*thing).x<0)         {(*thing).x+=GLBX_MAX;}
if ((*thing).x>GLBX_MAX)  {(*thing).x-=GLBX_MAX;}
if ((*thing).y<0)         {(*thing).y+=GLBY_MAX;}
if ((*thing).y>GLBY_MAX)  {(*thing).y-=GLBY_MAX;}
//
(*thing).fx=(*thing).x;
(*thing).fy=(*thing).y;
//
}

/////////////////////
/////////////////////

void stormBrain(THINGTYPE *thing)
{
s16 ind;
s16 tmpx;
s16 tmpy;
//facing
(*thing).facing++;
if ((*thing).facing==32) (*thing).facing=0;
//move
(*thing).fx-=(*thing).xvel;
(*thing).fy-=(*thing).yvel;
//bound
if ((*thing).fx<0)         {(*thing).fx+=GLBX_MAX;}
if ((*thing).fx>GLBX_MAX)  {(*thing).fx-=GLBX_MAX;}
if ((*thing).fy<0)         {(*thing).fy+=GLBY_MAX;}
if ((*thing).fy>GLBY_MAX)  {(*thing).fy-=GLBY_MAX;}
//
(*thing).x=(*thing).fx;
(*thing).y=(*thing).fy;
/////is it a hit/////
for (ind=GRAVSTART;ind<GRAVLAST;ind++)
    {//storm kill planet populations
     if (things[ind].flag2!=EMPTY)
	{tmpx=(*thing).x-things[ind].x;
	 tmpy=(*thing).y-things[ind].y;
	 //
	 if ( (tmpx<10) && (tmpx>-10) && (tmpy<10) && (tmpy>-10) )
	    {/////it's a hit
	     things[ind].flag2=EMPTY;
	     makeExplosion(thing,4);
	     }
	 }
     }
/////
}

/////////////////////

void launchStorm(THINGTYPE *thing)
{
(*thing).flag1 =ON;
(*thing).type  =STORM;
(*thing).facing=1;
/////
randInd++;
(*thing).x=things[PLAYER].x;
(*thing).x+=Cos(randLook256[randInd])*GLBX_HALF;
//
(*thing).y=things[PLAYER].y;
(*thing).y+=Sin(randLook256[randInd])*GLBY_HALF;
/////
randInd++;
(*thing).xvel=Cos(randLook256[randInd]);
(*thing).yvel=Sin(randLook256[randInd]);
/////
if ((*thing).x<0)         {(*thing).x+=GLBX_MAX;}
if ((*thing).x>GLBX_MAX)  {(*thing).x-=GLBX_MAX;}
if ((*thing).y<0)         {(*thing).y+=GLBY_MAX;}
if ((*thing).y>GLBY_MAX)  {(*thing).y-=GLBY_MAX;}
//
(*thing).fx=(*thing).x;
(*thing).fy=(*thing).y;
//
}

/////////////////////
/////////////////////

void junkBrain(THINGTYPE *thing)
{
s16 ind;
s16 tmpx;
s16 tmpy;
//move
gravity(thing);
//DELT       0.1
(*thing).fx-=((*thing).xvel)*DELT;
(*thing).fy-=((*thing).yvel)*DELT;
(*thing).xvel-=(DRAG*(*thing).xvel*DELT);
(*thing).yvel-=(DRAG*(*thing).yvel*DELT);
//bound
if ((*thing).fx<0)         {(*thing).fx+=GLBX_MAX;}
if ((*thing).fx>GLBX_MAX)  {(*thing).fx-=GLBX_MAX;}
if ((*thing).fy<0)         {(*thing).fy+=GLBY_MAX;}
if ((*thing).fy>GLBY_MAX)  {(*thing).fy-=GLBY_MAX;}
//
(*thing).x=(*thing).fx;
(*thing).y=(*thing).fy;
/////is it a hit/////
for (ind=GRAVSTART;ind<=GRAVLAST;ind++)
    {//JUNK killS planet populations
     tmpx=(*thing).x-things[ind].x;
     tmpy=(*thing).y-things[ind].y;
     //
     if ( (tmpx<16) && (tmpx>-16) && (tmpy<16) && (tmpy>-16) )
	{/////it's a hit
	 (*thing).flag1=OFF;
	 things[ind].flag2=EMPTY;
	 makeExplosion(thing,4);
	 }
     }
/////
}

/////////////////////

void launchJunk(THINGTYPE *thing)
{
(*thing).flag1 =ON;
(*thing).type  =JUNK;
(*thing).facing=randLook[randInd];
/////
randInd++;
(*thing).x=things[PLAYER].x;
(*thing).x+=Cos(randLook256[randInd])*GLBX_HALF;
//
(*thing).y=things[PLAYER].y;
(*thing).y+=Sin(randLook256[randInd])*GLBY_HALF;
/////
(*thing).xvel=0;
(*thing).yvel=0;
/////
(*thing).fx=(*thing).x;
(*thing).fy=(*thing).y;
//

}


/////////////////////
/////////////////////

void doThings()
{
u16 ind ;
u16 indstop;
u16 spikeLaunch;
//completed
spikeLaunch=TRUE;
levelDone=TRUE;
//
for (ind=GRAVSTART;(ind<THINGTOTAL);ind++)
    {if (things[ind].flag1==ON)
	{/////planets
	 if (things[ind].type<=GRAVLAST)
	    {if (control[GRAB]==ON)
		grabNdrop(&things[ind]);
	     goto DRAW;
	     }
	 /////mutants
	 if (things[ind].type==MUTANT)
	    {mutantBrain(&things[ind]);
	     crash(&things[ind]);
	     levelDone=FALSE;
	     goto DRAW;
	     }
	 /////landers
	 if (things[ind].type==LANDER)
	    {landerBrain(&things[ind]);
	     crash(&things[ind]);
	     levelDone=FALSE;
	     spikeLaunch=FALSE;
	     goto DRAW;
	     }
	 /////bombs
	 if (things[ind].type==BOMB)
	    {bombBrains(&things[ind]);
	     goto DRAW;
	     }
	 /////explosions
	 if (things[ind].type==EXPLOS)
	    {explosionBrains(&things[ind]);
	     goto DRAW;
	     }
	 /////STATION
	 if (things[ind].type==STATION)
	    {stationBrain(&things[ind]);
	     goto DRAW;
	     }
	 /////storm
	 if (things[ind].type==STORM)
	    {stormBrain(&things[ind]);
	     crash(&things[ind]);
	     goto DRAW;
	     }
	 /////junk
	 if (things[ind].type==JUNK)
	    {junkBrain(&things[ind]);
	     crash(&things[ind]);
	     goto DRAW;
	     }
	 /////spike
	 if (things[ind].type==SPIKE)
	    {spikeBrain(&things[ind]);
	     crash(&things[ind]);
	     goto DRAW;
	     }

	 /////draw the thing
	 DRAW:
	     {;
	      drawThings(&things[ind]);
	      }
	 }
     }

////launchothers////////
//spike
if (spikeLaunch==TRUE)
   {if (spikeTimer>0) spikeTimer--;
    if ( (things[OTHERSTART+1].flag1==OFF) &&
	 (spikeTimer==0) )
       {spikeTimer=750;
	launchSpike(&things[OTHERSTART+1]);
	}
    }
//storm
if (things[OTHERSTART+2].flag1==OFF)
   {launchStorm(&things[OTHERSTART+2]);
    }
//junk
if ( (things[OTHERSTART+3].flag1==OFF) )
   {launchJunk(&things[OTHERSTART+3]);
    }
//////
}

/*******************/
/*******************/
/*******************/
/*******************/

void playerMovement()
{
//////
if ( control[DOWN] )
   {things[PLAYER].xvel=things[PLAYER].xvel-(ACC/4)*Cos(things[PLAYER].thpos);
    things[PLAYER].yvel=things[PLAYER].yvel-(ACC/4)*Sin(things[PLAYER].thpos);
    }
if ( control[UP] )
   {things[PLAYER].xvel=things[PLAYER].xvel+ACC*Cos(things[PLAYER].thpos);
    things[PLAYER].yvel=things[PLAYER].yvel+ACC*Sin(things[PLAYER].thpos);
    }
if ( control[LEFT ] ) things[PLAYER].thvel-=THACC;
if ( control[RIGHT] ) things[PLAYER].thvel+=THACC;
//////
gravity(&things[PLAYER]);
//
things[PLAYER].fx-=(things[PLAYER].xvel*DELT);
things[PLAYER].fy-=(things[PLAYER].yvel*DELT);
//
things[PLAYER].xvel-=(DRAG*things[PLAYER].xvel*DELT);
things[PLAYER].yvel-=(DRAG*things[PLAYER].yvel*DELT);

//
things[PLAYER].thvel-=(THDRAG*things[PLAYER].thvel*DELT);
//
things[PLAYER].thpos+=things[PLAYER].thvel*DELT;
//
if (things[PLAYER].thpos>=TWOPI)  things[PLAYER].thpos-=TWOPI;
if (things[PLAYER].thpos<0)       things[PLAYER].thpos+=TWOPI;
//
things[PLAYER].facing=(things[PLAYER].thpos*5.09295817894);
//
if (things[PLAYER].fx<0)         {things[PLAYER].fx+=GLBX_MAX;}
if (things[PLAYER].fx>GLBX_MAX)  {things[PLAYER].fx-=GLBX_MAX;}
if (things[PLAYER].fy<0)         {things[PLAYER].fy+=GLBY_MAX;}
if (things[PLAYER].fy>GLBY_MAX)  {things[PLAYER].fy-=GLBY_MAX;}
//
things[PLAYER].x=things[PLAYER].fx;
things[PLAYER].y=things[PLAYER].fy;
//
}

//////////////////////

void launchBomb()
{
s16 ind;
//
ind=BOMBSTART;
while (things[ind].flag1==ON) ind++;
//
things[ind].flag1 =ON;
things[ind].fx    =things[PLAYER].fx;
things[ind].fy    =things[PLAYER].fy;
things[ind].facing=things[PLAYER].facing;
things[ind].xvel  =(things[PLAYER].xvel/10)+(Cos(things[PLAYER].thpos)*5);
things[ind].yvel  =(things[PLAYER].yvel/10)+(Sin(things[PLAYER].thpos)*5);
things[ind].count =25;
things[ind].type  =BOMB;
//
bombCount++;
}

//////////////////////

void playerControl()
{
static u16 grabflag;
static u16 fireflag;
//
if (fireflag) fireflag--;
if (grabflag) grabflag--;
control[NONE]=ON;
////
if (key[UP_KEY   ])
   {control[UP   ]=ON ;
    control[NONE ]=OFF;
    }
else control[UP  ]=OFF;
//
if (key[DOWN_KEY ])
   {control[DOWN ]=ON ;
    control[NONE ]=OFF;
    }
else control[DOWN]=OFF;
//
if (key[LEFT_KEY ])
   {control[LEFT ]=ON ;
    control[NONE ]=OFF;
    }
else control[LEFT]=OFF;
//
if (key[RIGHT_KEY])
   {control[RIGHT]=ON ;
    control[NONE ]=OFF;
    }
else control[RIGHT]=OFF;
////
if ( (key[SPACE_KEY]) && (grabflag==0) )
   {control[GRAB]=ON ;
    grabflag  =20;
    }
else control[GRAB]=OFF;
//
if ( (key[F_KEY]) && (fireflag==0) )
   {control[FIRE]=ON ;
    fireflag  =10 ;
    }
else control[FIRE]=OFF;
////
if ( (control[FIRE]==ON) && (bombCount<BOMBMAX) ) launchBomb();
////
playerMovement();
}

/*******************/
/*******************/
/*******************/
/*******************/

void clrScreens()
{
fadeDown()     ;
//
Cls (0,VGA)    ;
Cls (0,Vaddr1) ;
Cls (0,Vaddr2) ;
//
fastDac(DAC[1]);
//
}

/////////////////////

void countPoints()
{
u16 ind;
u16 atot;
u16 stot;
u16 xpos;
u32 mod;
u32 rmd;
//
atot=0;
stot=0;
/////count'em
for (ind=0;ind<GRAVLAST;ind++)
    {////count populations
     if (things[ind].flag2==SPACEMAN) {stot++;}
     if (things[ind].flag2==ALIENMAN) {atot++;}
     /////
     }
/////draw'em
xpos=144-((atot+stot)*(images[ALIENMAN].xs>>1));
for (ind=0;ind<GRAVLAST;ind++)
    {////draw populations
     if (things[ind].flag2==SPACEMAN)
	{xpos+=20;
	 drawSprite(xpos,80,images[SPACEMAN].xs,images[SPACEMAN].ys,
	  images[SPACEMAN].spr[0][0],VGA);
	 }
     if (things[ind].flag2==ALIENMAN)
	{xpos+=20;
	 drawSprite(xpos,80,images[ALIENMAN].xs,images[ALIENMAN].ys,
	  images[ALIENMAN].spr[0][0],VGA);
	 }
     /////
     }
/////
drawSprite(160-images[BONUS].xs,125,images[BONUS].xs,images[BONUS].ys,
	  images[BONUS].spr[0][0],VGA);
/////calc/draw bonus
xpos=196;
stot=stot*((level/5)+1);
if (stot>12) stot=12;
if (atot<stot) rmd=((stot-atot)*500);else rmd=0;
if ( rmd>10000) rmd=10000;
//score
score+=rmd;
////
for (ind=0;ind<4;ind++)
    {mod =rmd%10;
     rmd/=10;
     //
     if (mod<5)
	{drawSprite(xpos,125,images[DIGIT1].xs,images[DIGIT1].ys,
	  images[DIGIT1].spr[mod][0],VGA);
	 }
     else
	{mod-=5;
	 drawSprite(xpos,125,images[DIGIT2].xs,images[DIGIT2].ys,
	  images[DIGIT2].spr[mod][0],VGA);
	 }
     //
     if (rmd==0) goto DONE;
     xpos=xpos-12;
     }
/////
DONE:{;}
delay(2500);
}

/////////////////////

void drawWave()
{
u16 ind;
u16 xpos;
s32 mod;
s32 rmd;
//
////
if (level<100) xpos=172;else xpos=178;
////
drawSprite(156-images[WAVE].xs,80,images[WAVE].xs,images[WAVE].ys,
	  images[WAVE].spr[0][0],VGA);
////
rmd=level;
for (ind=0;ind<3;ind++)
    {mod =rmd%10;
     rmd/=10;
     //
     if (mod<5)
	{drawSprite(xpos,80,images[DIGIT1].xs,images[DIGIT1].ys,
	  images[DIGIT1].spr[mod][0],VGA);
	 }
     else
	{mod-=5;
	 drawSprite(xpos,80,images[DIGIT2].xs,images[DIGIT2].ys,
	  images[DIGIT2].spr[mod][0],VGA);
	 }
     //
     if (rmd==0) goto DONE;
     xpos=xpos-12;
     }
/////
DONE:{;}
delay(1500);
fadeDown()     ;
Cls (0,VGA)    ;
fastDac(DAC[1]);
}

/////////////////////

void writeHighScore()
{
u8* name;
FILE* fptr;
/////
name="high.dat";
/////
fptr=fopen(name,"w+b");
fwrite(&highScore,sizeof(s32),1,fptr);
/////
fclose(fptr);
}


/////////////////////

void gameOver()
{
u16 ind;
u16 xpos;
s32 mod;
s32 rmd;
/////
drawSprite(160-(images[GAMEOVER].xs>>1),60,images[GAMEOVER].xs,images[GAMEOVER].ys,
	  images[GAMEOVER].spr[0][0],VGA);
/////is high score
if (score>highScore)
   {highScore=score;
    writeHighScore();
    }
//hiscore
drawSprite(160-(images[GAMEOVER].xs>>1),130,images[GAMEOVER].xs,
	   images[GAMEOVER].ys,images[GAMEOVER].spr[1][0],VGA);
/////
if (highScore>99999) xpos=184;else xpos=178;
rmd=highScore;
for (ind=0;ind<6;ind++)
    {mod =rmd%10;
     rmd/=10;
     //
     if (mod<5)
	{drawSprite(xpos,155,images[DIGIT1].xs,images[DIGIT1].ys,
	  images[DIGIT1].spr[mod][0],VGA);
	 }
     else
	{mod-=5;
	 drawSprite(xpos,155,images[DIGIT2].xs,images[DIGIT2].ys,
	  images[DIGIT2].spr[mod][0],VGA);
	 }
     //
     if (rmd==0) goto DONE;
     xpos=xpos-12;
     }
/////
DONE:{;}
delay(3000);
/////
}

/////////////////////

void pause()
{
//draw pause
drawSprite(160-(images[GAMEOVER].xs>>1),60,images[GAMEOVER].xs,
	   images[GAMEOVER].ys,images[GAMEOVER].spr[2][0],VGA);
//
PAUSE:
    {;
     delay(250);
     if (! key[P_KEY] ) goto PAUSE;
     }
//
delay(250);
}

/////////////////////
/////////////////////

void nextLevel()
{
//shield
if (things[PLAYER].shield<150) things[PLAYER].shield+=10;
//
if (alienCount<ALIENMAX)       alienCount++;
//
level++			 ;
expCount  =0             ;
bombCount =0             ;
levelDone =FALSE         ;
spikeTimer=1500          ;
clrThings()      	 ;
setupPlanets()   	 ;
setupLanders()   	 ;
setupPlayer()    	 ;
clrScreens()             ;
drawWave()		 ;
}

/////////////////////

void setupNewGame()
{
things[PLAYER].shield=50 ;
nextShield=5000          ;
score     =0     	 ;
level     =1     	 ;
expCount  =0             ;
bombCount =0             ;
levelDone =FALSE         ;
spikeTimer=1500          ;
alienCount=1     	 ;
clrThings()      	 ;
setupPlanets()   	 ;
setupStarMap()   	 ;
setupLanders()   	 ;
setupPlayer()    	 ;
clrScreens()     	 ;
drawWave()       	 ;
}

/*******************/
/*******************/
/*******************/
/*******************/

int game()
{
//////first time//////
setupNewGame()   ;
//////////////////////
GAME:
    {;
     while ( (!(key[ESC_KEY])) )
	   {
	   //pause
	   if ( key[P_KEY] ) pause();
	   Cls (0,Vaddr1);
	   playerControl();
	   //
	   doStars();
	   doThings();
	   drawPlayer();
	   doRadar();
	   doScore();
	   //
	   waitRetrace();
	   flip(Vaddr1,VGA);
	   //
	   if (things[PLAYER].shield<0) goto DEAD;
	   if (levelDone)
	      {countPoints();
	       nextLevel();
	       }
	   }
     }
//////////////////////
DEAD:{;}
gameOver();
}


/*******************/

#endif _GAME_CPP


