#ifndef _INTRO_CPP
#define _INTRO_CPP

#include "intro.h"

/*****************/

u8 jind;
u8 jmap[128*32];
u8 jsav[128*32];
/*****************/
/*****************/
/*****************/
/*****************/


void drawJason()
{
/////by jason
drawNoMask (6,166,images[JASON].xs,images[JASON].ys,jsav,Vaddr1);
rotScaleSpr(images[JASON].spr[0][0],jmap,jind,
	    images[JASON].xs,images[JASON].ys,
	    images[JASON].xs,images[JASON].ys,1);

evolve1    (6,166,images[JASON].xs,images[JASON].ys,1,Vaddr1,Vaddr1);
drawSprite (6,166,images[JASON].xs,images[JASON].ys,jmap,Vaddr1);
saveSprite (6,166,images[JASON].xs,images[JASON].ys,jsav,Vaddr1);
/////
}

///////////////////

void introScreen()
{
char *name;
fadeDown();
name="intro01.pcx";
loadPcx (name,Vsarr1,320,200);
drawJason();
fastDac(DAC[1]);
flip (Vaddr1,VGA);
//
}

///////////////////

void meltScreen()
{
fadeUp();
/////
MLOOP:
    {;
     evolve1(1,1,318,198,1,Vaddr1,Vaddr2);
     flip(Vaddr2,VGA);
     evolve1(1,1,318,198,1,Vaddr2,Vaddr1);
     flip(Vaddr1,VGA);
     //flow control
     if ((key[ESC_KEY])||(key[SPACE_KEY])||(key[Q_KEY])||(key[ENTER_KEY]))
	{fadeUp();
	 goto DONE;
	 }
     ///
     if (key[F1_KEY]) fastDac(DAC[0]);
     if (key[F2_KEY]) fastDac(DAC[1]);
     if (key[F3_KEY]) fastDac(DAC[2]);
     if (key[F4_KEY]) fastDac(DAC[3]);
     if (key[F5_KEY]) fastDac(DAC[4]);
     if (key[F6_KEY]) fastDac(DAC[5]);
     ///
     goto MLOOP;
     }
/////
DONE:{;}
fadeUp();
}

///////////////////

void setupInfo()
{
things[0].x   =8;
things[0].y   =7;
things[0].type=LANDER;
//
things[1].x   =24;
things[1].y   =30;
things[1].type=MUTANT;
//
things[2].x   =8;
things[2].y   =56;
things[2].type=SPIKE;
//
things[3].x   =24;
things[3].y   =82;
things[3].type=STATION;
//
things[4].x   =11;
things[4].y   =110;
things[4].type=ALIENMAN;
//
things[5].x   =30;
things[5].y   =132;
things[5].type=SPACEMAN;
//
}

///////////////////

void drawInfoStuff()
{
s16 ind;
s16 tmpx;
s16 tmpy;
/////
flip (Vaddr2,Vaddr1);
for (ind=0;ind<6;ind++)
    {tmpx =things[ind].x;
     tmpy =things[ind].y;
     randInd++;
     drawSprite(tmpx,tmpy,images[(things[ind].type)].xs,
     images[(things[ind].type)].ys,
     images[(things[ind].type)].spr[(randLook[randInd])][0],Vaddr1);
     }
/////
}

///////////////////

void infoScreen()
{
char *name;
fadeUp();
//
name="info01.pcx";
loadPcx (name,Vsarr1,320,200);
drawJason();
fastDac(DAC[1]);
flip (Vaddr1,VGA);
flip (Vaddr1,Vaddr2);

/////
INFOLOOP:
       {;
	jind+=3;
	drawInfoStuff();
	drawJason();
	flip(Vaddr1,VGA);
	//flow control
	if ((key[ESC_KEY])||(key[SPACE_KEY])||
	    (key[Q_KEY])||(key[ENTER_KEY]))
	   {fadeUp();
	    goto DONE;
	    }
	//
	if (key[M_KEY])
	   {meltScreen();
	    goto DONE;
	    }
	//
	goto INFOLOOP;
	}
/////
DONE:{;}
}

///////////////////

void gameScreen()
{
char *name;
//
randInd++ ;
//
if (randLook[randInd])
   {name="gstart01.pcx";
    loadPcx (name,Vsarr1,320,200);
    fadeDown()       ;
    fastDac(DAC[4])  ;
    flip (Vaddr1,VGA);
    }
else
   {name="gstart02.pcx";
    loadPcx (name,Vsarr1,320,200);
    fadeDown()       ;
    fastDac(DAC[5])  ;
    flip (Vaddr1,VGA);
    }
//
delay(1000);
}

///////////////////

s16 quitToDos()
{
drawSprite(96,76,images[QUIT].xs,images[QUIT].ys+1,
	   images[QUIT].spr[0][0],VGA);
LOOP:
    {;
     if ((key[N_KEY])||(key[ESC_KEY])||(key[SPACE_KEY]))
	{flip (Vaddr1,VGA);
	 return(FALSE);
	 }
     if (key[Y_KEY]) return(TRUE);
     goto LOOP;
     }
}

///////////////////
///////////////////

s16 intro()
{
//
jind=0;
setupInfo();
introScreen();
INTROLOOP:
	{;
	 jind+=3;
	 drawJason();
	 flip(Vaddr1,VGA);
	 //
	 if (key[P_KEY])
	    {gameScreen();
	     return(TRUE);
	     }
	 if (key[Q_KEY])
	    {if (quitToDos()) return(FALSE);
	     }
	 if (key[M_KEY])
	    {meltScreen();
	     introScreen();
	     }
	 if (key[I_KEY])
	    {infoScreen();
	     introScreen();
	     }
	 goto INTROLOOP;
	 }
}

/*****************/
#endif _INTRO_CPP

