
#ifndef _JMATH_CPP
#define _JMATH_CPP

#include "jmath.h"

/*******************/

s32 SinFix[256]     ;
s32 CosFix[256]     ;
u16 randLook   [256];
u16 randLook256[256];
u8  randInd         ;

/******************/

double Sin (double x)
{
asm{.387
    fld     [qword ptr x]
    fwait
    fsin
    }
}

double Cos (double x)
{
asm{.387
    fld     [qword ptr x]
    fwait
    fcos
    }
}

/*******************/

void makeFixedTrig()               //Creates sin/cos tables
{
s16   dir;
float angle;

for (dir=0;dir<256;dir++)          //use 256 degrees in circle
    {
    angle=dir;
    angle=angle*3.14159265/128;
    SinFix[dir]=(Sin(angle)*65536);
    CosFix[dir]=(Cos(angle)*65536);
    }
}

/*******************/

void makeRandLook()
{
u16 ind;

time_t t;
srand((unsigned) time(&t));

for (ind=0;ind<255;ind++)
    {
    randLook   [ind]=(rand()%2  );
    randLook256[ind]=(rand()%256);
    }
randInd=0;
}

/******************/

#endif _JMATH_CPP