
#ifndef _PT_CPP
#define _PT_CPP

#include "pt.h"

/*******************/

dactype DAC[6];

/*******************/

STARTYPE far starMap[STAR_TOTAL];
//
THINGTYPE things[THINGTOTAL];
IMAGETYPE images[IMAGETOTAL];

/*******************/
/*******************/
/*******************/
/*******************/

void ImageRotation()
{
u16 ind;
u16 var;
u16 rot;
//
for (ind=0;ind<IMAGETOTAL;ind++)
    {if (images[ind].rot>1)
	{for (var=0;var<images[ind].var;var++)
	     {for (rot=1;rot<images[ind].rot;rot++)
		  {rotScaleSpr(images[ind].spr[var][0],
		   images[ind].spr[var][rot],
		   (rot*8),
		   images[ind].xs,images[ind].ys,
		   images[ind].xs,images[ind].ys,1);
		   }
	      }
	 }
     }
}


/////////////////////

void loadImages()
{
u16 ind;
u16 var;
//
//extern void loadPcx   (char* FileName,u8 *where,u32 width, u32 depth);
for (ind=0;ind<IMAGETOTAL;ind++)
    {for (var=0;var<images[ind].var;var++)
	 {loadPcx (images[ind].name[var],
		   images[ind].spr [var][0],
		   images[ind].xs,
		   images[ind].ys);
	  }
     }
}

/////////////////////

void setupImages()
{
/////
images[SPACEMAN].xs      =24            ;
images[SPACEMAN].ys      =24            ;
images[SPACEMAN].var     =2             ;
images[SPACEMAN].rot     =1             ;
images[SPACEMAN].name[0] ="spacem01.pcx";
images[SPACEMAN].name[1] ="spacem02.pcx";
//////
images[ALIENMAN].xs      =24            ;
images[ALIENMAN].ys      =24            ;
images[ALIENMAN].var     =2             ;
images[ALIENMAN].rot     =1             ;
images[ALIENMAN].name[0] ="alienm01.pcx";
images[ALIENMAN].name[1] ="alienm02.pcx";
//////
images[PLAYER  ].xs      =32            ;
images[PLAYER  ].ys      =32            ;
images[PLAYER  ].var     =5             ;
images[PLAYER  ].rot     =32            ;
images[PLAYER  ].name[0] ="ship01.pcx"  ;
images[PLAYER  ].name[1] ="ship02.pcx"  ;
images[PLAYER  ].name[2] ="ship03.pcx"  ;
images[PLAYER  ].name[3] ="ship04.pcx"  ;
images[PLAYER  ].name[4] ="ship05.pcx"  ;
//////
//////
images[STATION ].xs      =32            ;
images[STATION ].ys      =32            ;
images[STATION ].var     =2             ;
images[STATION ].rot     =1             ;
images[STATION ].name[0] ="stat01.pcx"  ;
images[STATION ].name[1] ="stat02.pcx"  ;
//////
images[LANDER  ].xs      =32            ;
images[LANDER  ].ys      =32            ;
images[LANDER  ].var     =2             ;
images[LANDER  ].rot     =1             ;
images[LANDER  ].name[0] ="aliens01.pcx";
images[LANDER  ].name[1] ="aliens02.pcx";
//////
images[MUTANT  ].xs      =32            ;
images[MUTANT  ].ys      =32            ;
images[MUTANT  ].var     =2             ;
images[MUTANT  ].rot     =1             ;
images[MUTANT  ].name[0] ="mutant01.pcx";
images[MUTANT  ].name[1] ="mutant02.pcx";
//////
images[BOMB    ].xs      =12            ;
images[BOMB    ].ys      =12            ;
images[BOMB    ].var     =2             ;
images[BOMB    ].rot     =32            ;
images[BOMB    ].name[0] ="bomb01.pcx"  ;
images[BOMB    ].name[1] ="bomb02.pcx"  ;
//////
images[STAR    ].xs      =12            ;
images[STAR    ].ys      =12            ;
images[STAR    ].var     =2             ;
images[STAR    ].rot     =1             ;
images[STAR    ].name[0] ="star01.pcx"  ;
images[STAR    ].name[1] ="star02.pcx"  ;
//////
images[GATE    ].xs      =32            ;
images[GATE    ].ys      =32            ;
images[GATE    ].var     =2             ;
images[GATE    ].rot     =1             ;
images[GATE    ].name[0] ="gate01.pcx" ;
images[GATE    ].name[1] ="gate02.pcx" ;
//////
images[SUN     ].xs      =32            ;
images[SUN     ].ys      =32            ;
images[SUN     ].var     =2             ;
images[SUN     ].rot     =1             ;
images[SUN     ].name[0] ="sun01.pcx"   ;
images[SUN     ].name[1] ="sun02.pcx"   ;
//////
images[PLANET1 ].xs      =32            ;
images[PLANET1 ].ys      =32            ;
images[PLANET1 ].var     =1             ;
images[PLANET1 ].rot     =1             ;
images[PLANET1 ].name[0] ="planet01.pcx";
//////
images[PLANET2 ].xs      =32            ;
images[PLANET2 ].ys      =32            ;
images[PLANET2 ].var     =1             ;
images[PLANET2 ].rot     =1             ;
images[PLANET2 ].name[0] ="planet02.pcx";
//////
images[PLANET3 ].xs      =32            ;
images[PLANET3 ].ys      =32            ;
images[PLANET3 ].var     =1             ;
images[PLANET3 ].rot     =1             ;
images[PLANET3 ].name[0] ="planet03.pcx";
//////
images[PLANET4 ].xs      =32            ;
images[PLANET4 ].ys      =32            ;
images[PLANET4 ].var     =1             ;
images[PLANET4 ].rot     =1             ;
images[PLANET4 ].name[0] ="planet04.pcx";
//////
images[PLANET5 ].xs      =32            ;
images[PLANET5 ].ys      =32            ;
images[PLANET5 ].var     =1             ;
images[PLANET5 ].rot     =1             ;
images[PLANET5 ].name[0] ="planet05.pcx";
//////
images[PLANET6 ].xs      =32            ;
images[PLANET6 ].ys      =32            ;
images[PLANET6 ].var     =1             ;
images[PLANET6 ].rot     =1             ;
images[PLANET6 ].name[0] ="planet06.pcx";
//////
images[PLANET7 ].xs      =32            ;
images[PLANET7 ].ys      =32            ;
images[PLANET7 ].var     =1             ;
images[PLANET7 ].rot     =1             ;
images[PLANET7 ].name[0] ="planet07.pcx";
//////
images[PLANET8 ].xs      =32            ;
images[PLANET8 ].ys      =32            ;
images[PLANET8 ].var     =1             ;
images[PLANET8 ].rot     =1             ;
images[PLANET8 ].name[0] ="planet08.pcx";
//////
images[RADAR   ].xs      =MAPX_MAX      ;
images[RADAR   ].ys      =MAPY_MAX      ;
images[RADAR   ].var     =1             ;
images[RADAR   ].rot     =1             ;
images[RADAR   ].name[0] ="radar01.pcx" ;
//////
images[DIGIT1  ].xs      =12            ;
images[DIGIT1  ].ys      =12            ;
images[DIGIT1  ].var     =5             ;
images[DIGIT1  ].rot     =1             ;
images[DIGIT1  ].name[0] ="num00.pcx"   ;
images[DIGIT1  ].name[1] ="num01.pcx"   ;
images[DIGIT1  ].name[2] ="num02.pcx"   ;
images[DIGIT1  ].name[3] ="num03.pcx"   ;
images[DIGIT1  ].name[4] ="num04.pcx"   ;
//////
images[DIGIT2  ].xs      =12            ;
images[DIGIT2  ].ys      =12            ;
images[DIGIT2  ].var     =5             ;
images[DIGIT2  ].rot     =1             ;
images[DIGIT2  ].name[0] ="num05.pcx"   ;
images[DIGIT2  ].name[1] ="num06.pcx"   ;
images[DIGIT2  ].name[2] ="num07.pcx"   ;
images[DIGIT2  ].name[3] ="num08.pcx"   ;
images[DIGIT2  ].name[4] ="num09.pcx"   ;
//////
images[EXPLOS  ].xs      =32            ;
images[EXPLOS  ].ys      =32            ;
images[EXPLOS  ].var     =5             ;
images[EXPLOS  ].rot     =1             ;
images[EXPLOS  ].name[0] ="exp01.pcx"   ;
images[EXPLOS  ].name[1] ="exp02.pcx"   ;
images[EXPLOS  ].name[2] ="exp03.pcx"   ;
images[EXPLOS  ].name[3] ="exp04.pcx"   ;
images[EXPLOS  ].name[4] ="exp05.pcx"   ;
//////
images[SPIKE   ].xs      =32            ;
images[SPIKE   ].ys      =32            ;
images[SPIKE   ].var     =2             ;
images[SPIKE   ].rot     =1             ;
images[SPIKE   ].name[0] ="spike01.pcx" ;
images[SPIKE   ].name[1] ="spike02.pcx" ;
//////
images[STORM   ].xs      =32            ;
images[STORM   ].ys      =32            ;
images[STORM   ].var     =1             ;
images[STORM   ].rot     =32            ;
images[STORM   ].name[0] ="fire01.pcx"  ;
//////
images[QUIT    ].xs      =128           ;
images[QUIT    ].ys      =48            ;
images[QUIT    ].var     =1             ;
images[QUIT    ].rot     =1             ;
images[QUIT    ].name[0] ="quit.pcx" ;
//////
images[BONUS   ].xs      =60            ;
images[BONUS   ].ys      =12            ;
images[BONUS   ].var     =1             ;
images[BONUS   ].rot     =1             ;
images[BONUS   ].name[0] ="bonus01.pcx" ;
//////
images[WAVE    ].xs      =48            ;
images[WAVE    ].ys      =12            ;
images[WAVE    ].var     =1             ;
images[WAVE    ].rot     =1             ;
images[WAVE    ].name[0] ="wave01.pcx"  ;
//////
images[JASON   ].xs      =128           ;
images[JASON   ].ys      =32            ;
images[JASON   ].var     =1             ;
images[JASON   ].rot     =1             ;
images[JASON   ].name[0] ="jason01.pcx" ;
//////
images[JUNK    ].xs      =32            ;
images[JUNK    ].ys      =32            ;
images[JUNK    ].var     =2             ;
images[JUNK    ].rot     =1             ;
images[JUNK    ].name[0] ="junk01.pcx"  ;
images[JUNK    ].name[1] ="junk02.pcx"  ;
//////
images[GAMEOVER].xs      =84            ;
images[GAMEOVER].ys      =12            ;
images[GAMEOVER].var     =3             ;
images[GAMEOVER].rot     =1             ;
images[GAMEOVER].name[0] ="gameov01.pcx";
images[GAMEOVER].name[1] ="highsc01.pcx";
images[GAMEOVER].name[2] ="paused01.pcx";
//////
}

/////////////////////

void getMem()
{
u16 ind;
u16 var;
u16 rot;
//
for (ind=0;ind<IMAGETOTAL;ind++)
    {for (var=0;var<images[ind].var;var++)
	 {for (rot=0;rot<images[ind].rot;rot++)
	      {images[ind].spr[var][rot]=
	       (u8*) malloc((images[ind].xs*images[ind].ys));
	       }
	  }
     }
}

/////////////////////

void loseMem()
{
u16 ind;
u16 var;
u16 rot;
//
for (ind=0;ind<IMAGETOTAL;ind++)
    {for (var=0;var<images[ind].var;var++)
	 {for (rot=0;rot<images[ind].rot;rot++)
	      {free(images[ind].spr[var][rot]);
	       }
	  }
     }
}

/////////////////////

void getImages()
{
setupImages();
getMem()         ;
loadImages() ;
ImageRotation();
}

/////////////////////

void loadPals()
{
char *name;
//get screen up first
name="paint01.pcx";
loadPcx (name,Vsarr2,320,200);
loadPcxPal(name,DAC[0]);
fastDac(DAC[0]);
flip (Vaddr2,VGA);
//
name="intro01.pcx";
loadPcxPal(name,DAC[1]);
//
name="palrgb.pcx";
loadPcxPal(name,DAC[2]);
//
name="graypal.pcx";
loadPcxPal(name,DAC[3]);
//
name="gstart01.pcx";
loadPcxPal(name,DAC[4]);
//
name="gstart02.pcx";
loadPcxPal(name,DAC[5]);
}


//////////////////////

void loadHighScore()
{
u8* name;
FILE* fptr;
/////
name="high.dat";
/////
if ((fptr=fopen(name,"rb"))==NULL)
   {fptr=fopen(name,"w+b");
    highScore=10000;
    fwrite(&highScore,sizeof(s32),1,fptr);
    }
else
   {fread(&highScore,sizeof(s32),1,fptr);
    }
/////
fclose(fptr);
}


/*******************/
/*******************/
/*******************/
/*******************/

int main(s16 argc,u8 *argv)
{
/////
setupGfx() ;
if ((--argc)==0) setSquare();//THIS IS SWITCH FOR 1 TO 1 SCREEN RATIO
loadPals() ;
loadHighScore();
/////
makeRandLook()     ;
makeFixedTrig()    ;
InstallKeyHandler();
getImages()        ;
////////
LOOP:
    {;
     if (intro()==TRUE)
	{game();
	 goto LOOP;
	 }
     }
////////
RestoreKeyHandler();
shutDownGfx();
loseMem();
////////
}

/*******************/

#endif _PT_CPP