
#ifndef _PT_H
#define _PT_H

/**********************/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>

#include "game.h"
#include "vgagfx.h"
#include "intro.h"
#include "jmath.h"
#include "ukeyb.h"

/**********************/

#ifndef TRUE
#  define TRUE	   1
#endif TRUE

#ifndef FALSE
#  define FALSE    0
#endif FALSE

/////
#define EMPTY      0
//
#define OFF        0
#define ON         1
/////
/**********************/

#define u8  unsigned char
#define u16 unsigned short
#define u32 unsigned long
#define s8  signed char
#define s16 signed short
#define s32 signed long

/**********************/
/////
#define GLBX_MAX   4096
#define GLBY_MAX   4096
//
#define GLBX_HALF  2048
#define GLBY_HALF  2048
//
#define MAPX_MAX   64
#define MAPY_MAX   65
/////
/*******************/
/////dynamic controls
#define THACC      0.02
#define ACC        0.6
#define DELT       0.1
#define DRAG       0.09
#define THDRAG     0.2
//
#define TWOPI      6.28318530718
/////
/*******************/
/////player controls
#define GRAB       0
#define FIRE       1
#define UP         2
#define DOWN       3
#define RIGHT      4
#define LEFT       5
#define NONE       6
/*******************/

#define PLAYER     0
//
#define PLANET1    1
#define PLANET2    2
#define PLANET3    3
#define PLANET4    4
#define PLANET5    5
#define PLANET6    6
#define PLANET7    7
#define PLANET8    8
#define GATE       9
#define SUN        10
//
#define LANDER     11
#define MUTANT     12
#define SPACEMAN   13
#define ALIENMAN   14
#define BOMB       15
#define STAR       16
#define RADAR      17
#define STATION    18
#define DIGIT1     19
#define DIGIT2     20
#define EXPLOS     21
#define SPIKE      22
#define STORM      23
#define JASON      24
#define QUIT       25
#define BONUS      26
#define WAVE       27
#define JUNK       28
#define GAMEOVER   29
//
#define IMAGETOTAL 30
/*******************/
//planets
#define GRAVSTART     1
#define GRAVLAST     10
//landers/mutants
#define ALIENSTART   11
#define ALIENLAST    30
#define ALIENMAX     20
//station
#define OTHERSTART   31
#define OTHERLAST    35
#define OTHERMAX      5
//player missle
#define BOMBSTART    36
#define BOMBLAST     40
#define BOMBMAX       5
//explosion
#define EXPSTART     41
#define EXPLAST      45
#define EXPMAX        5
//total things
#define THINGTOTAL   46
/////
#define STAR_TOTAL   2500
/*******************/

typedef struct THINGTYPE
      {s16  x,y;
      float fx,fy,
	    xvel,yvel,
	    thvel,thpos;
       s16  facing,count,
	    shield,
	    mass,target,
	    flag1,flag2,
	    type;};
//
typedef struct IMAGETYPE
      {u16  xs,ys,
	    var,rot;
       char *name[6];
       u8   *spr [6][32];};

//
typedef struct
       {s16 x,y;} STARTYPE;

/*******************/

extern STARTYPE far starMap[STAR_TOTAL];
//
extern THINGTYPE things[THINGTOTAL];
extern IMAGETYPE images[IMAGETOTAL];
//
extern s16 control[7];//player control keys
//
extern s16 level     ;//current wave
extern s16 levelDone ;//flag all landers killed
extern u32 score     ;
extern u32 highScore ;
extern u32 nextShield;
//
extern s16 bombCount ;//how many active player missles
extern s16 alienCount;//how many landers for new level
extern s16 expCount  ;//how many active explosions
//
/**********************/

extern dactype DAC[6];

/**********************/


#endif _PT_H