
#ifndef _UKEYB_CPP
#define _UKEYB_CPP

#include "ukeyb.h"

/*********************/
u8  key[255];
void interrupt (*SaveInt09)(...);
/*********************/

void interrupt keyHandler(...)
{
asm{xor ax, ax
    in  al, 0x60
    mov di, ax
    and di, 0xFF7F
    mov bx, 7
    bt  ax, bx       //test bit 7 set carry flag
    jc  BRK
    lea bx, key
    mov [bx+di],1    //make
    mov al, 0x20
    out 0x20, al
    jmp END
    }
BRK:
asm{lea bx, key
    mov [bx+di],0    //break
    mov al, 0x20
    out 0x20, al
   }
END:
}

/*********************/

void InstallKeyHandler()
{
u8 ind;
for (ind=0;ind<255;ind++)  //zero out buffer
    {key[ind]=0;}

SaveInt09 = getvect(0x9);
setvect(0x9, keyHandler);
}

void RestoreKeyHandler()
{
setvect(0x9, SaveInt09);

asm{mov ax,0x0C00          //flush keybuffer
    int 0x21
   }
}

/*********************/

#endif _UKEYB_CPP