#ifndef _VGAGFX_CPP
#define _VGAGFX_CPP

#include "vgagfx.h"

/*******************/

u8 far Vsarr1[65535];
u8 far Vsarr2[65535];
u16 Vaddr1;
u16 Vaddr2;

u16 VGA;

/********************/

void setVga()        //dos vga 0x10  320*200-256 color
{
asm{mov ax, 0x0013
    int 0x10
    }
}

void setText()
{
asm{mov ax, 0x0003   //dos vga 0x10  TEXT
    int 0x10
    }
}

void setSquare()     //"one to one aspect 320*200"
{
asm{mov	dx,0x3c2
    mov	ax,0xe3
    out	dx,ax
    }
}

/********************/

void Pal(u8 col,u8 r,u8 g,u8 b)
{
asm{mov    dx,3c8h
    mov    al,[col]
    out    dx,al
    inc    dx
    mov    al,[r]
    out    dx,al
    mov    al,[g]
    out    dx,al
    mov    al,[b]
    out    dx,al
   }
}

void getPal(s8 Col,u8* R,u8* G,u8* B)  //get pallet from VGA-DAC
{
   outportb(0x3c7,Col);
   *R=inp  (0x3c9);
   *G=inp  (0x3c9);
   *B=inp  (0x3c9);
}

void fadeDown()
{
u16 ind1;
u16 ind2;
u8  tmp[3];

for(ind1=0;ind1<64;ind1++)
   {waitRetrace();
    for(ind2=0;ind2<256;ind2++)
	{getPal((u8)ind2,&tmp[0],&tmp[1],&tmp[2]);
	if (tmp[0]>0) tmp[0]--;
	if (tmp[1]>0) tmp[1]--;
	if (tmp[2]>0) tmp[2]--;
	Pal((u8)ind2,tmp[0],tmp[1],tmp[2]);
	}
   }
}

void fadeUp()
{
u16 ind1;
u16 ind2;
u8 tmp[3];

for(ind1=0;ind1<64;ind1++)
   {waitRetrace();
   for(ind2=0;ind2<256;ind2++)
      {getPal((u8)ind2,&tmp[0],&tmp[1],&tmp[2]);
       if (tmp[0]<255) tmp[0]++;
       if (tmp[1]<255) tmp[1]++;
       if (tmp[2]<255) tmp[2]++;
       Pal((u8)ind2,tmp[0],tmp[1],tmp[2]);
      }
   }
}

void fastDac(dactype DAC)
{
u16 ind;
waitRetrace();
for(ind=255;ind>0;ind--)
    {Pal ((char)ind,(DAC[ind][0]),(DAC[ind][1]),(DAC[ind][2]));
    }
}


/*******************/

void Vline(u16 x1,u16 y1,u16 y2,u8 col,u16 where)
{
asm{mov ax,x1
    mov bx,y1
    mov dx,y2
    cmp bx,dx
    jl LOOP1
    xchg bx,dx
    }
LOOP1:
asm{mov di,bx
    shl di,1
    shl di,1
    add di,bx
    mov cl,6
    shl di,cl
    add di,ax
    mov cx,where
    mov es,cx
    mov cx,dx
    sub cx,bx
    inc cx
    mov al,col
    mov bx,0x13f
    }
LOOP2:
asm{stosb
    add di,bx
    loop LOOP2
    }
}

void Hline(u16 x1,u16 x2,u16 y,u8 col,u16 where)
{
 asm{mov   ax,where
     mov   es,ax
     mov   ax,y
     mov   di,ax
     shl   ax,8
     shl   di,6
     add   di,ax
     add   di,x1

     mov   al,col
     mov   ah,al
     mov   cx,x2
     sub   cx,x1
     shr   cx,1
     jnc   LINE
     stosb
     }
LINE:
 asm{rep   stosw
     }
}


void putPixel (u16 x,u16 y,u8 Col)           //put to VGA ie:0xA000
  {
  asm{
     mov     ax,0xa000
     mov     es,ax
     mov     bx,[x]
     mov     dx,[y]
     mov     di,bx
     mov     bx,dx
     shl     dx,8
     shl     bx,6
     add     dx,bx
     add     di,dx
     mov     al,[Col]
     stosb
     }
  }

void putPixel2(u16 x,u16 y,u8 col,u16 where)//put to address
{
  asm {
    mov     ax, where
    mov     es, ax
    mov     bx, x
    mov     dx, y
    mov     di, bx
    mov     bx, dx
    shl     dx, 8
    shl     bx, 6
    add     dx, bx
    add     di, dx
    mov     al, col
    stosb
  }
}

/*************************/

void loadPcx (char* FileName,u8* where,u32 width, u32 depth)
{
FILE *fil;
u8  run;
u8  c;
u8  *cptr;
u32 index;
u32 n;
u32 bytes;
u32 w;

cptr= &c;
fil=fopen (FileName, "rb");
fseek(fil,(long)128,SEEK_SET);
for (index=0;index<(depth);index++)
    {n=0;
     while (n<width)
	   {fread(cptr,sizeof(char), 1, fil);
	    if ((c & 192)==192)
	       {run=(c & 63);
		fread (cptr,sizeof(char), 1, fil);
		n=n+run;
		for (w=(n-run);w<n;w++)
		    {
		    where[((index*width)+w)]=c;
		    }
	       }
	    else
	       {
	       where[((index*width)+n)]=c;
	       n++;
	       }
	   }
     }
fclose (fil);
}


void loadPcxPal(char* filename)
{
long fsize;
int  ind;
dactype DAC;
FILE* fptr;

if ((fptr=fopen(filename,"rb"))==NULL)
   {setText();
    printf("Error opening file pal\n");
    exit(1);
    }

fseek(fptr,0,SEEK_END);
fsize=(ftell(fptr))-768;
fseek(fptr,fsize,SEEK_SET);
fread(DAC,sizeof(char),768,fptr);

for(ind=255;ind>0;ind--)
    {Pal ((char)ind,(DAC[ind][0])>>2,(DAC[ind][1])>>2,(DAC[ind][2])>>2);
    }
fclose(fptr);
}

void loadPcxPal(char* filename,dactype ddac)
{
long fsize;
int  ind;
dactype DAC;
FILE* fptr;

if ((fptr=fopen(filename,"rb"))==NULL)
   {setText();
    printf("Error opening file %s\n",filename);
    exit(1);
    }

fseek(fptr,0,SEEK_END);
fsize=(ftell(fptr))-768;
fseek(fptr,fsize,SEEK_SET);
fread(DAC,sizeof(char),768,fptr);

for(ind=255;ind>0;ind--)
    {ddac[ind][0]=(DAC[ind][0])>>2;
     ddac[ind][1]=(DAC[ind][1])>>2;
     ddac[ind][2]=(DAC[ind][2])>>2;
    }
fclose(fptr);
}

/*******************/

void Cls(u8 Color,u16 Where)
{
asm {push    ds
     push    es
     mov     ax, Where
     mov     es, ax
     mov     al, Color
     mov     ah, al
     xor     di, di
     mov     cx, 32000
     rep     stosw
     pop     es
     pop     ds
    }
}


void flip(u16 Source,u16 Dest)
{
asm {push    ds
     push    es
     mov     ax, Dest
     mov     es, ax
     mov     ax, Source
     mov     ds, ax
     xor     si, si
     xor     di, di
     mov     cx, 32000
     rep     movsw
     pop     es
     pop     ds
    }
}


void waitRetrace()
{
asm{mov dx,3DAh}
l1:
asm{in al,dx
    and al,08h
    jnz l1}
l2:
asm{in al,dx
    and al,08h
    jz  l2
   }
}

/*********************/

void drawSprite (u16 x,u16 y,u16 xs,u16 ys,u8 *spr,u16 where)
{
asm{push  ds
    push  es

    mov   ax, y
    mov   dx, y
    shl   ax, 8
    shl   dx, 6
    add   ax, dx
    mov   di, ax
    add   di, x

    lds   si, spr
    mov   ax, where
    mov   es, ax
    mov   dx, ys
    dec   dl
    mov   cx, xs
    cld}
START:
asm{push  di
    push  cx}
LINE:
asm{mov   bl, byte ptr [si]
    cmp   bl, 255
    jz    SKIP
    movsb
    loop  LINE
    jmp   NEXT}
SKIP:
asm{inc   si
    inc   di
    loop  LINE}
NEXT:
asm{pop   cx
    pop   di
    add   di,320
    dec   dx
    jnz   START
    pop   es
    pop   ds}
}


void drawNoMask (u16 x,u16 y,u16 xs,u16 ys,u8 *spr,u16 where)
{
asm{push  ds
    push  es

    mov   ax, y
    mov   dx, y
    shl   ax, 8
    shl   dx, 6
    add   ax, dx
    mov   di, ax
    add   di, x

    mov   ax, where
    mov   es, ax
    lds   si, spr
    mov   dx, ys
    dec   dx
    mov   cx, xs
    cld}
LOOP:
asm{push  di
    push  cx
    rep movsb
    pop   cx
    pop   di
    add   di,320
    dec   dx
    jnz   LOOP
    pop   es
    pop   ds}
}

void saveSprite (u16 x,u16 y,u16 xs,u16 ys,u8 *spr,u16 where)
{

asm{push  ds
    push  es
    les   di, spr
    mov   ax, where
    mov   ds, ax
    mov   ax, y
    mov   dx, y
    shl   ax, 8
    shl   dx, 6
    add   ax, dx
    mov   si, ax
    add   si, x
    mov   dx,ys
    dec   dx
    mov   cx,xs
    cld}
LOOP:
asm{push  si
    push  cx
    rep   movsb
    pop   cx
    pop   si
    add   si,320
    dec   dl
    jnz   LOOP
    pop   es
    pop   ds}
}

/*******************/

void rotScaleSpr(u8 *source,u8 *target,u16 degree
	   ,u16 xsize,u16 ysize,u16 xmsize,u16 ymsize,u16 scale)
{
s16 xind;
s16 yind;
s32 xsour;
s32 ysour;
s16 sourind;
s16 targind;
s16 xhalf;
s16 yhalf;
s16 xmhalf;
s16 ymhalf;

xmhalf=xmsize>>1;
ymhalf=ymsize>>1;
xhalf=xsize>>1;
yhalf=ysize>>1;

for (yind=0;yind<ymsize;yind++)
    {
    for (xind=0;xind<xmsize;xind++)
	{
	 xsour=((xind-xmhalf) * ((CosFix[degree])*scale)>>16)
	      +((yind-ymhalf) * ((SinFix[degree])*scale)>>16);
	 ysour=-((xind-xmhalf)* ((SinFix[degree])*scale)>>16)
	       +((yind-ymhalf)* ((CosFix[degree])*scale)>>16);
	 targind=((yind*xmsize)+xind);
	 if ((((ysour+yhalf)>0) && ((xsour+xhalf)>0)) &&
	    (((ysour+yhalf)<ysize) && ((xsour+xhalf)<xsize)))
	    {
	    sourind=(((ysour+yhalf)*xsize)+(xsour+xhalf));
	    target[targind]=source[sourind];
	    }
	 else
	    {
	    target[targind]=255;
	    }
	}
    }
}

void rotSpr(u8 *source,u8 *target,u16 degree)
{
s16 xind;
s16 yind;

s32 xsour;
s32 ysour;

s16 sourind;
s16 targind;


for (yind=0;yind<32;yind++)
    {
    for (xind=0;xind<32;xind++)
	{
	 xsour=((xind-16) * (CosFix[degree])>>16)
	      +((yind-16) * (SinFix[degree])>>16);
	 ysour=-((xind-16)* (SinFix[degree])>>16)
	       +((yind-16)* (CosFix[degree])>>16);

	 targind=((yind*32)+xind);
	 if ((((ysour+16)>0) && ((xsour+16)>0)) &&
	    (((ysour+16)<32) && ((xsour+16)<32)))
	    {
	    sourind=(((ysour+16)*32)+(xsour+16));
	    target[targind]=source[sourind];
	    }
	 else
	    {
	    target[targind]=255;
	    }
	}
    }
}

/*****************/

void evolve1(u16 x,u16 y,u16 xs, u16 ys,s16 shift,u16 Source,u16 Dest)
{
asm{push  ds
    push  es
    mov   ax, Source
    mov   ds, ax
    mov   ax, Dest
    mov   es, ax
    mov   ax, y
    mov   dx, y
    shl   ax, 8
    shl   dx, 6
    add   ax, dx
    mov   si, ax
    add   si, x
    mov   di, si
    mov   dx, ys
    mov   cx, xs
    cld}
Start:
asm{push  si
    push  cx
    push  dx}
Loop:
asm{sub   si, 320
    mov   ax, 0
    lodsb
    mov   dx, ax
    add   si, 318
    lodsb
    add   dx, ax
    lodsb
    add   dx, ax
    lodsb
    add   dx, ax
    add   si, 318
    lodsb
    add   ax, dx
    mov   dx, 0
    mov   bx, 5
    div   bx
    add   ax, shift
    stosb
    sub   si, 320
    loopnz  Loop}
Next:
asm{pop   dx
    pop   cx
    pop   si
    add   si, 320
    mov   di, si
    sub   dx, 1
    jnz   Start
    pop   es
    pop   ds}
}

/*******************/

void setGlobals()
{
VGA=0xA000;

Vaddr1 = FP_SEG(Vsarr1);
Vaddr2 = FP_SEG(Vsarr2);
}

void setupGfx()
{
setGlobals();
setVga();
}

void shutDownGfx()
{
fadeDown();
asm{mov	dx,0x3c2
    mov	ax,0x63
    out	dx,ax
    }
delay(100);
setText();
}

/*******************/

#endif _VGAGFX_CPP