
#ifndef _VGAGFX_H
#define _VGAGFX_H

#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <dos.h>
#include <conio.h>
#include <io.h>

#include "jmath.h"

/********************/

#define u8  unsigned char
#define u16 unsigned short
#define u32 unsigned long
#define s8  signed char
#define s16 signed short
#define s32 signed long

/********************/

typedef u8 dactype[255][3];

/********************/

extern void setupGfx();
extern void shutDownGfx();
extern void setVga();
extern void setText();
extern void setSquare();
//
extern void Pal(u8 col,u8 r,u8 g,u8 b);
extern void getPal(s8 Col,u8* R,u8* G,u8* B);
extern void fadeDown();
extern void fadeUp();
extern void fastDac(dactype dac);
//
extern void Vline(u16 x1,u16 y1,u16 y2,u8 col,u16 where);
extern void Hline(u16 x1,u16 x2,u16 y,u8 col,u16 where);
extern void putPixel    (u16 x,u16 y,u8 col);
extern void putPixel2   (u16 x,u16 y,u8 col,u16 where);
//
extern void loadPcx   (char* FileName,u8 *where,u32 width, u32 depth);
extern void loadPcxPal(char* filename);//overload c++
extern void loadPcxPal(char* filename,dactype ddac);//overload c++
//
extern void drawSprite (u16 x,u16 y,u16 xs,u16 ys,u8 *spr,u16 where);
extern void saveSprite (u16 x,u16 y,u16 xs,u16 ys,u8 *spr,u16 where);
extern void drawNoMask (u16 x,u16 y,u16 xs,u16 ys,u8 *spr,u16 where);
//
extern void rotScaleSpr(u8 *source,u8 *target,u16 degree
	    ,u16 xsize,u16 ysize,u16 xmsize,u16 ymsize,u16 scale);
extern void rotSpr(u8 *source,u8 *target,u16 degree);
//
extern void evolve1(u16 x,u16 y,u16 xs, u16 ys,s16 shift,u16 Source,u16 Dest);
//
extern void Cls(u8 Color,u16 Where);
extern void flip(u16 Source,u16 Dest);
extern void waitRetrace();

/********************/

extern u8 far Vsarr1[65535];
extern u8 far Vsarr2[65535];
extern u16 Vaddr1;
extern u16 Vaddr2;

extern u16 VGA;

/********************/

#endif _VGAGFX_H