IDEAL						;assembler command
;SYSTEMFLAG	    = 1
ENGLISH = 1
;-------------------
;ASSEMBLER SPECIFICS
;-------------------

TRUE	=	1
FALSE	=	0
NULL	=	FALSE

;-------------------------
;SPECIAL FKEYS
;-------------------------

;THE CHARACTER IS SHIFETD IN AH AND AL = 0
;SO SEARCH IS FOR FNO+00 IN HEX!

ESCAPE	=	27
F1	=	3B00H
F2	=	3C00H
F3	=	3D00H
F4	=	3E00H
F5	=	3F00H
F6	=	4000H
F7	=	4100H
F8	=	4200H
F9	=	4300H
F10	=	4400H
;__________________
;SCREEN	SPECIFICS
;------------------
Cgascreen	=	1			;640*200 mono cga
Cgascreen1	=	2			;cga colour 320 * 200
EgaScreen	=	3			;ega 320 *200
EgaScreen1	=	4			;ega/vga 640 * 380
VgaScreen 	= 	5			;mcga mode 256
MCGA		= 	0A000H
VID_EGA	=	0A000H
VIDVGA		=	VID_EGA
sequencer	=	3c4h			;sequencer port addr
mask_reg	=	02h			;sequencer plane mask reg
graph_cntrl	=	3ceh			;graphic controller port
graph_dat	=	3cfh
bitmask_reg	=	08h			;bitmap register
mode_reg	=	05h			;mode register
map_sel	=	04h			;map select register
func_sel      =      03h         		;function select register

SEQUENCER	=	3C4H			;SEQUENCER
GRAPHCNTRL	=	3CEH			;Graphics controller
GRAPHDAT	=	3CFH			;graphics data
CRTC		=	3D4H			;controller
MASKREG	=	02H			;MAP MASK REGISTER
FUNCTIONSELECT =	03H			;
MAPSELECT	=	04H			;read map select index
MEMORYMODE	=	04H			;see mapselect
MODEREG	=	05H			;graphic mode index
MISCREG	=	06H			;miscellaneous ->graphcntrl
BITMASKREG	=	08h			;
SCANLINEMAX	=	09H			;max scanline ->crtc
UNDERLINE	=	14H			;underline ->crtc
MODECNTRL	=	17H			;modecontrol ->crtc

MSCREENWIDTH	=	320			;mcga mode screen width in
						;pixels
MSCREENDEPTH	=	200			;mcga mode screen depth in
						;pels
SCREENSTARTHIGH =	0CH			;screen high register
BACKPLANE	=	0AC00H			;BACKGROUND REPLACE SCREEN
GRAPHSTORE	=	BACKPLANE		;BUFFER FOR OBJS/POINTERS
MPAGE1		=	0A000H
MPAGE2		=	0A400h
MPAGE3		=	0A800H
MPAGE4		=	BACKPLANE
TEMPPAGE	=	0B800H
SCROLLPAGE1	=	6D60H
SCROLLDEPTH	=	350
SCROLLWIDTH	=	640
EGAPAGE0	=	0A000H
EGAPAGE1	=	0A800H
;------------------
;USED FOR SWAPPING
;SCREENS IN HI-RES
;MODE
;------------------

FAST	=	6
MED	=	4
SLOW	=	2
VSLOW	=	1

;----------------------
;MOUSE SPECIFICS
;----------------------
POSMOVE 	=	1
NEGMOVE 	=	-1
UARROW		=	72
DARROW		=	80
LARROW		=	75
RARROW		=	77
RBUTTON	=	71
LBUTTON	=	13
_ENTER		=	LBUTTON
;----------------------
;NEW SIGNOS DEFINITIONS
;FOR SKILL RATINGS
;----------------------

PROFICIENT	=	35
EXPERT		=	75

;-------------------
;SIGNOS SYSTEM EQU'S
;-------------------
SCRPTCR 	=	14H    ;
SCRPT$	 	=     '^'
SCRPTCOM 	=     '#'
TXTSTART 	=     '{'
TXTFIN	 	=     '}'
ZDELIM	 	=     '$'
TDELIM	 	=     '\'
HYPERTEXT 	=    '~'
HYPERMARK 	=    '|'
CR	 	=	0dh
CRLF	 	=	0D0AH
LF	 	=	0AH
BACKSPC 	=	4BH
LETFIN		=	'%'
PAGEBREAK 	=	'@'
SCRPTAN	=	'\'
;--------------------------------
;CHARACTER RECORD OFFSET EQUATES
;--------------------------------

c_flags		=	0	;(Dup20)  	10 flags
c_initflags		=	20     ;(Dup20)       10 flags initial
c_description		=	40     ;              YOU
c_title		=	42     ;              Title as a number
c_forname		=	44     ;W.PTR         ;Forname
c_surname		=	46     ;W.PTR         ;Surname
c_age			=	48     ;
c_birthday		=	50     ;W.PTR         ;Birthday
c_sex			=	52     ;              ;sex as a number
c_occupation		=	54     ;              ;as a number
c_nationality		=	56     ;              ;as a number
c_skills		=	58     ;(Dup 66)      ;32 skills+1 start@1
c_totals		=	124    ;(Dup 14)      ;6 Totals+1
c_abilities		=	138    ;(dup 14)      ;6 abilities + 1
c_timedate		=	152    ;(dup 6)       ;yr:mnth:day:hr:min
c_factsno		=	164    ;              ;number facts learned
c_factslearned 	=	166    ;(Dup 100)     ;50 facts max
c_adventures		=	266    ;W.Ptr         to adv record

;----------------------------
;OBJECT RECORD EQUATES
;----------------------------

objno		=	0                          	;no this object
o_loc		=	2                          	;current location
o_docs		=	4   				;0 = not readable
							;else <n> = no pages to
							;read <-n> = read
o_evttrigger	=	6                          	;Vase/book etc
o_seen		=	8                          	;seen/not seen
o_seenflag	=	o_seen        		;for compatibility
o_anim		=	10				;now = number of animations
o_docno	=	o_anim				;document number if doc
o_comverb	=	12                         	;GET/LOOK etc Communication
o_manverb	=	14                         	;Same manipulation Window
o_doctype	=	o_bubx				;document type if document
o_initx	=	16                         	;initial x pos
o_inity	=	18                         	;initial y pos
o_bubx		=	20				;bubble print x position
o_buby		=	22				;  "     "    y    "
o_invent	=	24				;0 or number of inventory table
o_givepos	=	26				;packed word for offset from
							;top of sprite to give zone
							;e.g msb = xpos
							;    lsb = ypos
							; = 0311 = 3x/11y

o_graphptr	=	28				;dword ptr
o_curgraph	=	32                         	;current graphic no
o_curx		=	34                         	;current xpos
o_cury		=	36                         	;current ypos
o_active	=	38                         	;0 = not/1 = active
o_bkgrnd	=	40                         	;ptr to background replace
o_width	=	42                         	;width of graphic
o_depth	=	44                         	;depth of graphic
o_bwidth	=	46                         	;width of large object
o_bdepth	=	48                         	;ditto depth
o_bsize       =      50                         	;width*depth = bytes
o_bgraphptr	=	52				;dd offset in disk file
o_sgraphoff	=	56				;offset into file for graph
o_bgraphoff	=	60				;ditto
o_quality	=	64				;Packed DWORD
;============================
smlobjsize	=	16*24				;bytes

;---------------------------
;LOCATION RECORD EQUATES
;---------------------------

locno		=	0                          	;nmber this location
l_regions	=	2                          	;packed 16 regions
l_connections	=	4                          	;no of CONDATS max 6
l_condat	=	6                          	;6 connection records
;-----------------------------
;BELOW FILLED IN A RUNTIME

l_seen		=	66       			;structured as:-
	    						;Target Location
							;x1/y1/x2/y2 hotspot

l_lastvisit	=	68				;last time visited this loc
							;in minutes eg 1hr 30mins = 90
l_eventbase	=	70				;dword ptr to events
l_noobjs	=	74	 			;no of objects in loaction
l_objlist1	=	76				;this is 50 bytes long
							;and holds 25 ptrs to
							;object records

;_______________________
;condat rec equates
;-----------------------

l_targetloc	=	0
condatx1	=	2
condaty1	=	4
condatx2	=	6
condaty2	=	8

condatrec_offset  =	10

;_________________________
;ADVENTURE RECORD OFFSETS
;-------------------------

a_number	=	0				;adventure number
a_name		=	2			      	;10 bytes for adventure name
a_lastplayed	=	12                        	;year:month:day:hour:minute

lastplayed_offset =	12
a_recoffset	=	266
c_recoffset	=	268
o_recoffset	=	68
l_recoffset	=	126


;---------------------------------
;    System Flag Definitions
;---------------------------------
FNULL		=	0			;A MUST FOR DICK
FCHARACTER	=	1
FLOCATION	=	2
FTURNS		=	3
FCARRIED	=	4
FSTAMINA	=	5
FMAXWT		=	6
FSKILL		=	7
FINITLOC	=	8
FHEARTS 	=	9
FHOWLONG	=	10
FREGIONS	=	11
FSPEED		=	27
FTIMSET 	=	28
FCLOCK		=	29
FQUIT		=	30
FWIN		=	31
FSCORE		=	32
FOCCUPATION	=	33
FAGE		=	34
FNATIONALITY	=	35
FHYPER		=	36
FSEX		=	37
FMARINER	=	38
FTITLE		=	39
FWINDOW	=	40
FALARM		=	41
LASTWIND	=	42

FPROPS		=	43				;IF = 43 THEN NIGHT
FPOSTBOX	=	44
;PLOT1		=	45
;PLOT2		=	46
;PLOT3		=	47
;PLOT4		=	48
;PLOT5		=	49
;PLOT6		=	50
;-----------------------------------------
MON		=	0
TUE		=	1
WED		=	2
THUR		=	3
FRI		=	4
SAT		=	5
SUN		=	6

MAXFLAGS      =      150
NUMBERSKILLS  =      88


MALE          =	0
FEMALE		=      1
BRITISH	=      0
AMERICAN      =      1
INITIALSPEED	=	255

;-----------------------
;WORDLIST EQUATES
;-----------------------

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
GET 		=	1
DROP		=	2
LOOK 		=	3
TAKE 		=	4
GIVE 		=	5
MOVE 		=	6
ERROR 		=	255
_GOTO		=	MOVE
EGAANQ		=	256
EXIT		=	257				;added for map windows etc
ECOMMUNICATION   =	261
EINVENTORY	=	EXIT
PAGEBACK	=	260
PAGEON		=	259
USER		=	666				;USER INTERFACE
;WAS WRD TAB 2 FOLLOWING

YOU 		=	1
;-------------------------------
;SIGNOS MISCELLANEOUS DEFINITIONS
;-------------------------------

ANYWORD	=	254
CARRIED	=	-2
WORN		=	CARRIED			;same thing in signos
GLOBL		=	254
ANY_CHARACTER	=	255
EOF		=	-1
LIMBO		=	0
DEAD		=	LIMBO


NOTEWIDTH	=	40		  		;WIDTH OF NOTE
NOTEX		=	24
NOTEY		=	14

;-----------------------
;BUBBLE  EQUATES
;-----------------------

BWIDTH		=	0				;offsets into bubble data
BDEPTH		=	2
BTEXTX		=	4
BTEXTY		=	6
BDATA		=	8
FREE		=	NULL				;no bubble
ACTIVE		=	-1                     	;bubble currently active
BTEXTDEPTH	=	8				;depth of text
FNTWID		=	4
BUBBAK		=	0707H
BUBBUFLEN	=	36*4*8*10
SCRPTFLEN	=	1024*8
ASKSCRPTFLEN	=	512*4
;------------------------
;  WINDOW  EQUATES
;------------------------

COMWINDOW	=	-11
INVENTWINDOW	=	-12
MANWINDOW	=	-13
GUIDEWINDOW	=	-14
NOTEWINDOW	=	-15
MAPWINDOW	=	-16
USERI		=	-17
;-------------------------

;-------------------------
;LOOKUPXY CONSTANTS
;-------------------------

;TABLE IS CONSTRUCTED XPOS,XPOS1,YPOS,DEPTH,COMVERB,EVENT TRIGGER,ETC...
;WIDTH = XPOS+XPOS1
;


LOOKUPXY_OFF	=	14 			;LOOKUP TABLE =
OBJECTGOT	=	12			;offset into xy tables for
XYOBJNO	=	OBJECTGOT  		;object
LOOKUPCOMVERB	=	08			;COMVERB LOOK/GIVE ETC
LOOKUPXPOS	=	0			;CURRENT SCREEN X POS
LOOKUPYPOS	=	4			;CURRENT SCREEN Y POS


POINTEROFF	=	16*16			;offset to each micon
EGAHIPOINTEROFF =	32/8*32*4		;bytes
EGALOPOINTEROFF =	16/8*16*4		;bytes
POINTERCONST	=	8			;nmbr pointers in animation
BUBOFF		=	160*64			;BUBBLE OFFSET
EGAREPBUF0	=	6d60h                ;spare bit buffers
EGAREPBUF1	=	6d68h			;spare bit buffers
;-----------------------------
;  LARGE OBJECT EQUATES
;-----------------------------

OBJVASE	=	80*152			;sizes in bytes
OBJJAR		=	64*88
OBJBLOWER	=	80*56

;---------------------------------
;VFONT HEADER OFFSETS
;----------------------------------

F_WIDTH	=	0
F_HEIGHT	=	1
F_BASE		=	2
F_PIXWIDTH	=	3
F_FIRSTCHAR	=	4
F_START	=	6
;=================================

SBLKY		=	0
SBLKX  	=	2
SBLKWIDTH	=	4
SBLKDEPTH	=	6
SANIMNO	=	8
SBLKGRAPHPTR	=	10
SBLKANIMPTR	=	14
SBLKOFFSET	=	16
SCURANIM	=	18

ANIMOFF	=	12
NXTPROP	=	16
PROPTABOFF	=	64

_RET		=	0C3H			;RET OP CODE
_NOP		=	90H			;NOP OP CODE
MCGAPTRWIDTH	=	16/2
MCGAPTRDEPTH	=	16/2
EGAPTRWIDTH	=	(2*8)/2
EGAPTRDEPTH	=	16/2
EGAHIPTRWIDTH	=	(4*8)/2
EGAHIPTRDEPTH	=	32/2

AVACANT	=	-2
ASTOPPED	=	-1
CAPTSIZE	=	41344			;SIZE OF CAPTIONS
CREDITSIZE	=	43520			;SIZE OF CREDITS
LOCSIZE	=	64768
ROLAND		=	4
;===========================EQUATES FILE ENDS===================================
%NEWPAGE
