
/*
 *  SQUIDGY.H
 *
 *  Simon Hern     (Wolfson College, Cambridge, CB3 9BB, England)
 *  Summer 1995    (Email: sdh20@cam.ac.uk)
 *
 *  Header file for "Squidgy Wars" game
 *
 */


#ifndef SQUIDGY_H
#define SQUIDGY_H



/* INCLUDES */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <conio.h>
#include <alloc.h>
#include <string.h>
#include <dos.h>

/* XLib v06 */
#include <xlib.h>
#include <xvsync.h>
#include <xpal.h>
#include <xcbitmap.h>
#include <xline.h>
#include <xrect.h>



/* CONSTANT DEFINITIONS */

#define VERSION_DATE "19/11/95"

/* Dimensions of screen (special Mode X screen mode) */
#define SCR_WIDTH 320
#define SCR_HEIGHT 240

/* Dimensions of map array (in tiles) */
#define MAP_HEIGHT 20
#define MAP_WIDTH 20

/* Size of a tile (in pixels) */
#define TILE_WIDTH 16L
#define TILE_SIZE TILE_WIDTH*TILE_WIDTH

/* Width of the viewing window onto the main play area */
#define VIEW_WIDTH 9L*TILE_WIDTH
/* Size of the buffer in which the contents of the viewing window */
/* are initially generated */
#define VIEW_BUFF_WIDTH (VIEW_WIDTH+TILE_WIDTH)
#define VIEW_BUFF_SIZE VIEW_BUFF_WIDTH*VIEW_BUFF_WIDTH

/* Mode X screen memory addresses at which the viewing windows are drawn */
#define SCR_ADDR_VIEW_1 (48L*SCR_WIDTH/4 + 2L)
#define SCR_ADDR_VIEW_2 (48L*SCR_WIDTH/4 + 2L + SCR_WIDTH/8)

/* Positions of the tile-size sprites within the TileSprites array */
/* (These are the 'expanded' sprites rather than the 'raw' sprites */
/*                                                                 */
/* Floor tiles - 7 different shadow effects */
#define FLOOR_TILES 0
#define NUM_FLOOR_TILES 7
/* Bits of wall - 16 different sections */
#define WALL_TILES 7
#define NUM_WALL_TILES 16
/* Fire ball: missile, explosion, 3 frames of spinning balls */
#define ZAP_TILE 23
#define BLAST_TILE 24
#define GUN_TOKEN_TILES 25
/* Plasma ball: missile, explosion, 3 frames of spinning balls */
#define ZAP2_TILE 28
#define BLAST2_TILE 29
#define GUN2_TOKEN_TILES 30
#define NUM_GUN_TOKEN_TILES 3
/* Pentagram symbols - magenta, cyan, yellow, green */
#define FAST_TOKEN_TILE 33
#define SLOW_TOKEN_TILE 34
#define VANISH_TOKEN_TILE 35
#define HEALTH_TOKEN_TILE 36
/* 'Hits remaining' icon */
#define HEART_TILE 37
/* Squidgy sprites used as life counters */
#define CLEAN_BLUE_TILE 38
#define CLEAN_RED_TILE 39
/* Laser: 8 directions, explosion, 3 frames of spinning token */
#define LASER_TILE 40
#define LASER_BLAST_TILE 48
#define LASER_TOKEN_TILES 49
/* Shield */
#define SHIELD_TILE 52
#define SHIELD_TOKEN_TILE 53
/* 16 poses for each of the two squidgies                          */
/* (In order: up frame 1, up frame 2, up-right 1, up-right 2, etc) */
#define BLUE_CRITTER_TILES 54
#define RED_CRITTER_TILES 70
/* More squidgy poses, this time with fire in their eyes */
#define EVIL_CRITTER_TILES 86
/* Dead squidgies - facing each of 8 directions (up, up-right, right, etc) */
#define SKELEBONE_TILES 118
#define TOTAL_TILES 126

/* Maximum number of fire/plasma balls in flight at one time */
#define TOTAL_ZAPS 16
/* Distance moved by a fire ball each frame */
#define ZAP_SPEED 8
/* Distance moved by a laser bolt each frame */
#define ZAP2_SPEED 10
/* Delay between fire ball launches */
#define ZAP_DELAY 9
/* Delay between laser bolt launches */
#define ZAP2_DELAY 5
/* Width of fire ball sprite (top-left corner of ZAP_TILE) */
#define ZAP_WIDTH 6
/* Maximum range at which plasma balls become active */
#define HEATSEEK_RANGE TILE_WIDTH*4
/* Maximum number of fire/plasma ball explosions on screen */
#define TOTAL_BLASTS TOTAL_ZAPS
/* Maximum number of shield units per player */
#define SHIELDS_PER_PLAYER 4
/* Colour of bars showing time remaining for fire/plasma balls/laser */
#define BAR_COLOUR 208
#define BAR2_COLOUR 72
#define BAR3_COLOUR 157

/* Number of special power tokens available (pentagrams and gun) */
#define TOTAL_TOKENS 6
/* Delay before new gun/healing/other token appears after collection */
#define GUN_REAPPEAR 100
#define HEALTH_REAPPEAR 800
#define TOKEN_REAPPEAR 30
/* Length of time gun/other token stays in one place */
#define GUN_MOVE 300
#define TOKEN_MOVE 300
/* Amount of time gun/lasergun/shield/other token acts for */
#define GUN_HELDFOR 350
#define LASER_HELDFOR 250
#define SHIELD_HELDFOR 150
#define TOKEN_HELDFOR 100
/* Amount of time healing token needs to do its stuff */
#define HEALING_TIME 80
/* Points at which plasma balls appear instead of fire balls */
/* (First time, Subsequent time, Random additional time)     */
#define HEATSEEK_REAPPEAR0 6
#define HEATSEEK_REAPPEAR1 3
#define HEATSEEK_REAPPEAR2 4

/* Initial health of squidgies */
#define SQUIDGY_HITS 4
#define SQUIDGY_LIVES 3

/* Delays between death of squidgy and end of round, and between */
/* end of round and start of next round                          */
#define DEATH_DELAY 20
#define DEATH_HOLD 120

/* Number of different sound effects */
#define TOTAL_SOUNDS 6

/* Joystick sensitivity, 0.0=hyperactive 1.0=indifferent */
#define JOYSTICK_FIDGE_FACTOR 0.2

/* Size of 'Squidgy Wars' logo sprite */
#define LOGO_WIDTH 175
#define LOGO_HEIGHT 20
/* Reposition logo colours within palette */
#define LOGO_PALETTE_WRONG 0xE8
#define LOGO_PALETTE_RIGHT 0x40
/* Colour of logo */
#define LOGO_COL_RED 63
#define LOGO_COL_GREEN 63
#define LOGO_COL_BLUE 0

/* Colour of border around viewing windows */
#define OUTLINE_COLOUR 10

/* Size of characters in font */
#define CHAR_WIDTH 5
#define CHAR_HEIGHT 7
#define CHAR_SIZE (CHAR_WIDTH+1)*CHAR_HEIGHT

/* Colours to draw font characters in */
#define BLUE_TEXT 0x15
#define RED_TEXT 0xC4
#define MAGENTA_TEXT 0xA4
#define GREEN_TEXT 0x28
#define CYAN_TEXT 0x2C
#define YELLOW_TEXT 0xB8
#define WHITE_TEXT 0x01
#define GREY_TEXT 0x06

/* Sine table - number of entries (0 -> 2*PI) and size of entries (0 -> 1) */
#define TOTAL_ANGLES 1024
#define SINE_AMPLITUDE 32768L

/* Key codes */
#define KEY_ABORT_A1 1      /* ESCAPE */
#define KEY_ABORT_B1 29     /* CONTROL */
#define KEY_ABORT_B2 46     /* - C     */
#define KEY_ABORT_C1 29     /* CONTROL  */
#define KEY_ABORT_C2 56     /* - ALT    */
#define KEY_ABORT_C3 83     /* - DELETE */



/* MACROS */

/* Restrict values to within range 0 to (MAP_WIDTH-1) */
#define ModWidth(x) ( (x)>=0 ? ( (x) % MAP_WIDTH ) : ( (x) + MAP_WIDTH ) )
/* Restrict values to within range 0 to (MAP_HEIGHT-1) */
#define ModHeight(x) ( (x)>=0 ? ( (x) % MAP_HEIGHT ) : ( (x) + MAP_HEIGHT ) )



/* STRUCTURE DECLARATIONS */

/* Information stored about each player */
typedef struct {
    char far * ViewBuffer;  /* Start of viewing window buffer memory */
                            /* (Always a multiple of 16)             */
    char far * alloc_ViewBuffer;  /* First byte allocated for ViewBuffer */

    int XPos, YPos;  /* Player's position */
    int Speed;  /* Player's speed - affected by collecting tokens */
    int Direc;  /* Direction player's facing - 0=up, 1=up-right, etc */
    int Tile;  /* Sprite (tile number) showing player this round */
    int XMove, YMove;  /* Amount player moves this round */
    int Frame;  /* Frame (0,1,2) of animation of scurrying squidgy */

    int Gun;  /* 0=no gun, otherwise amount of time player has gun for */
    int GunWait;  /* Delay before gun can be fired next */
    int GunType;  /* See GunTypes enum below */

    int FastPower, SlowPower, VanishPower;  /* Token times remaining */
    int Healing;  /* Time spent on top of healing token */
    int Shields;  /* Number of shields possessed */
    int ShieldPower;  /* Time remaining on next shield unit */
    int ShieldFrame;  /* Progress of shield units around squidgy (0-12) */

    int Hits;  /* Hits remaining */
    int Dead;  /* 0=Healthy happy squidgy, otherwise=Skeleton */
    int Lives;  /* Lives remaining */

    int Up, Down, Left, Right, Fire;  /* Flags for controls operated */
    int ControlDevice;  /* see ControlTypes enum */
    int KeyUp, KeyDown, KeyLeft, KeyRight, KeyFire;  /* Defined keys */
    int JoyXUpper, JoyXLower, JoyYUpper, JoyYLower;  /* Joystick levels */
} PlayerStruct;



/* Information stored about each active fire/plasma balls */
typedef struct {
    int Active;  /* 1=valid missile, 0=unused data */
    int Type; /* See GunTypes enum below */
    int XPos, YPos;  /* Position of missile */
    int Direc;  /* Direction of flight - 0=up, 2=up-right, 4=right, etc */
    int Owner;  /* Player who fired missile */
    int DontKillOwner;  /* Rounds for which owner is immune to this missile */
} ZapStruct;



/* Information stored about each explosion */
typedef struct {
    int Active;  /* 1=valid explosion, 0=unused data */
    int XPos, YPos;  /* Position of explosion */
    int Type;  /* Kind of missile causing explosion, see GunTypes enum */
} BlastStruct;



/* Information stored about each shield unit */
typedef struct {
    int Active;  /* 1=valid explosion, 0=unused data */
    int XPos, YPos;  /* Position of explosion */
    int Owner;  /* Player protected by shield */
} ShieldStruct;



/* Information stored about each token - see TokenTypes enum */
typedef struct {
    int Type;  /* See TokenTypes enum */
    int Active;  /* 1=token in play, 0=token pending reappearance */
    int Delay;  /* Time till token moves, or reappears */
    int XTile, YTile;  /* Position of token (specific tile) */
    int Tile;  /* Sprite (tile number) showing this token */
    int Frame;  /* Animation frame of token (gun only) */
} TokenStruct;



/* Text buffered for printing to screen */
typedef struct {
    int Times;  /* Number of frames text is printed for                 */
                /* (remember we're using a triple buffered screen mode) */
    unsigned * Data;  /* List of screen addresses of pixels to plot for text */
                      /* Four lists (each ending -1), one for each plane     */
    char Colour;  /* Colour byte in which to draw text */
} PrintStruct;



/* ENUMERATIONS */

/* The choice of control device for each player */

enum ControlTypes { KEYBOARD, JOYSTICK1, JOYSTICK2 };


/* The different kinds of tokens in the 'Tokens' array */

enum TokenTypes { UNUSED_TOKEN, GUN_TOKEN, FAST_TOKEN, SLOW_TOKEN,
                  VANISH_TOKEN, HEALTH_TOKEN, SHIELD_TOKEN };


/* The different types of guns (and missiles)               */
/* (PLASMA_LOCKED is a plasma ball that has found a target) */

enum GunTypes { PLASMA=0, FIRE=1, LASER=-1, PLASMA_LOCKED=2 };


/* Classes of tiles                                               */
/* CRITTER means squidgy without gun, EVIL means squidgy with gun */

enum TileTypes { FLOOR, WALL, CRITTER, TOKEN, EVIL, SKELEBONE, OTHER };


/* Five sound effects                                                       */
/* THUMP is the sound of the gun, CHIME is the sound of a token collected,  */
/* BIG_CHIME is the sound of a gun token collected,                         */
/* SQUEAK is the sound of a squidgy in pain, FIZZ is the sound of the laser */
/* WHIRR is the sound of the healing symbol in operation,                   */
/* and NO_WHIRR is the sound of the healing symbols stopping working        */

enum SoundTypes { THUMP=0, CHIME=1, BIG_CHIME=2, WHIRR=3, SQUEAK=4, FIZZ=5,
                  NO_WHIRR=-1 };


/* Values returned to show status of program */

enum ReturnTypes { RET_CONTINUE, RET_RENEW, RET_ESCAPE,
                   RET_GAME, RET_GAMEOVER };


#endif

