'*************************************************************************
'
' Strategy -- A Solitare Game
'
'  (c) Copyright 1989-95 by Randy Rasa
'                           18215 Troost
'                           Olathe, KS 66062
'
'  Notice: This source code is provided for reference and educational
'          purposes only, and is protected under United States Copyright
'          Law.  In other words, you may look this over, learn from it,
'          and play with it, but not steal it.
'
'   Command Line Syntax:  STRATEGY [/Q][/M]
'           /Q = quiet mode -- most noises will be stifled
'           /M = mono mode -- black and white video
'
'*************************************************************************
'
'   Revision History
'
' Revision   Date   Description
' -------- -------- ---------------------------------------
'   0.00   11-11-89 program started
'   1.00   11-14-89 program completed
'   1.01   09-02-91 Force program into 25 x 80 text mode.
'   1.02   02-04-95 Updated for freeware release.
'
'*************************************************************************
'
' Strategy was written with QuickBASIC 4.5, compiled to
' a stand-alone EXE file, and linked with NOCOM.OBJ and
' SMALLERR.OBJ (included with QB) to reduce the file size.
'
' This program makes use of routines provided in the
' QuickPak Professional library published by
'       Crescent Software, Inc.
'       11 Grandview Avenue
'       Stamford, CT 06905
'       (203) 846-2500
' The library is excellent and definitely recommended.
'
' Since this program calls routines in an external library,
' and I cannot distribute that library, I have included a
' "Quick Library" (STRATEGY.QLB), which contains the external
' routines in a form usable within the QuickBASIC environment.
' Use the command line:
'       QB STRATEGY /L STRATEGY.QLB
' to load the program and quick library into QuickBASIC.
' You will be able to run the program, make changes, and
' fool around with the program all you want, but you will
' not be able to compile to an EXE file.  If you really want
' to do this you will either need to buy QuickPak Professional,
' or substitute your own routines.
'
'*************************************************************************

    DEFINT A-Z
    CONST FALSE = 0
    CONST TRUE = NOT FALSE
'
' QuickPak Professional routines
'
    DECLARE SUB Box0 (ULRow%, ULCol%, LRRow%, LRCol%, Char%, Colr%)
    DECLARE SUB GetCursor (x%, y%, button%)
    DECLARE SUB HideCursor ()
    DECLARE SUB InitMouse (There%)
    DECLARE SUB MouseTrap (ULRow%, ULCol%, LRRow%, LRCol%)
    DECLARE SUB SetCursor (x%, y%)
    DECLARE SUB ShowCursor ()
    DECLARE SUB TextCursor (fg%, bg%)
    DECLARE SUB QPrint0 (x$, Colr%)
    DECLARE SUB ScrnSave0 (ULRow%, ULCol%, LRRow%, LRCol%, SEG Element%)
    DECLARE SUB ScrnRest0 (ULRow%, ULCol%, LRRow%, LRCol%, SEG Element%)
    DECLARE FUNCTION OneColor% (fg%, bg%)
    DECLARE SUB ClearScr0 (ULRow%, ULCol%, LRRow%, LRCol%, Colr%)
'
' RAR's routines
'
    DECLARE SUB CardMove (FanNum%, CardValue%, Action%)
    DECLARE SUB DspFoundation (FoundNum%)
    DECLARE SUB GetCard (value%, Crd$, card.color%, Suit%)
    DECLARE SUB MorK (key$, x%, y%)
    DECLARE SUB DspCard (CardNumber%, ULRow%, ULCol%)
    DECLARE SUB DspPile (PileNum%)
   
    REDIM scrn1(2000)                     'arrays to save screens
    REDIM Scrn2(2000)

    RANDOMIZE TIMER
    cmnd$ = UCASE$(COMMAND$)
    IF INSTR(cmnd$, "/Q") <> 0 THEN Quiet = TRUE ELSE Quiet = FALSE   'check for quiet mode
    IF INSTR(cmnd$, "/M") <> 0 THEN
        video = &HB4
    ELSE
        DEF SEG = 0
        video = PEEK(&H463)                 'check for color card
    END IF

    IF video = &HB4 THEN
        foreground = 7          'mono
        background = 0
        red = 0: black = 0
        CardFG = 0: CardBG = 7
        norm = 7: inv = 112
        TitleFG = 0: TitleBG = 7: TitleColor = 112
    ELSE                        'color
        foreground = 15         ' bright white foreground
        background = 1          ' blue background
        red = 4: black = 0
        CardFG = 0: CardBG = 7
        norm = 31: inv = 113
        TitleFG = 0: TitleBG = 2: TitleColor = 32
    END IF
    'norm = OneColor(foreground, background)                'Note: these lines are commented out
    'inv = OneColor(background, foreground)                 ' to save a few bytes.
    'TitleColor = OneColor(TitleFG, TitleBG)

    CALL InitMouse(mouse%)          'check for mouse (returns 0=no mouse, 1=mouse present)
    IF NOT mouse THEN
        PRINT "A mouse is required."
        END
    END IF
    CALL TextCursor(-2, -2)         'set text cursor to be inverse
    FirstGame = TRUE
    WIDTH 80, 25
    SCREEN 0: COLOR foreground, background: CLS
    GOTO start
    '
    ' Instructions
    '
help:
    COLOR foreground, background: CLS
    PRINT
    COLOR background, foreground: PRINT " Strategy "
    COLOR foreground, background
    PRINT
    PRINT " Strategy is a one-deck solitaire in which the object is to build the"
    PRINT " foundations up in suit from ace to king.  The entire deck is dealt one card"
    PRINT " at a time.  The aces, as they become available, are immediately transferred"
    PRINT " to the foundation row.  The other forty-eight cards are put into eight"
    PRINT " wastepiles, with each card placed into any pile you wish.  After the deal,"
    PRINT " the top of each pile is available for play onto the foundations.  Therefore"
    PRINT " the 'strategy' is to arrange the cards in the wastepiles so that the"
    PRINT " foundations can be built up in suit."
    PRINT
    PRINT " When you have finished dealing the deck, your work is essentially finished."
    PRINT " The computer will attempt to build up the foundations, and will keep going"
    PRINT " until the game is won or an impasse is reached"
    PRINT
    PRINT " During the deal, you may ask for help, start a new game, or quit.  The Esc"
    PRINT " key is the 'boss switch' -- pressing it will shell you to DOS.  Type 'exit'"
    PRINT " to return to the game."
    RETURN
    '
    ' Start the game
    '
start:
    COLOR foreground, background: CLS
    '
    ' Card Number Table:
    '
    '           |       Suit
    '     Value |H(3) D(4) C(5) S(6)
    '     ------|---- ---- ---- ----
    '         A |  1   14   27   40
    '         2 |  2   15   28   41
    '         3 |  3   16   29   42
    '         4 |  4   17   30   43
    '         5 |  5   18   31   44
    '         6 |  6   19   32   45
    '         7 |  7   20   33   46
    '         8 |  8   21   34   47
    '         9 |  9   22   35   48
    '        10 | 10   23   36   49
    '         J | 11   24   37   50
    '         Q | 12   25   38   51
    '         K | 13   26   39   52
    '
    REDIM card(53)
    FOR n = 1 TO 52
        card(n) = n         'initialize the deck
    NEXT
    '
    ' SHUFFLE the deck
    '
    FOR i = 1 TO (3 * 52)         ' go thru the deck 3 times
        x = INT(RND * 52) + 1
        y = INT(RND * 52) + 1
        SWAP card(x), card(y)
    NEXT i
    '
    ' Set up game screen
    '
    CALL Box0(3, 20, 15, 61, 2, norm)
    LOCATE 3, 22: PRINT "Piles"
    CALL Box0(16, 20, 22, 61, 2, norm)
    LOCATE 16, 22: PRINT "Foundations"
    CALL Box0(3, 2, 9, 18, 2, norm)
    LOCATE 3, 4: PRINT "The Deck"
    CALL Box0(14, 63, 22, 79, 2, norm)
    row = 1: Colr = inv: txt$ = " S T R A T E G Y ": GOSUB dspc
    COLOR background, foreground
    FOR n = 4 TO 10 STEP 3                  'draw option boxes
        LOCATE n, 67: PRINT ""
        LOCATE n + 2, 67: PRINT ""
    NEXT
    LOCATE 5, 67: PRINT "  Help  "
    LOCATE 8, 67: PRINT "   New  "
    LOCATE 11, 67: PRINT "  Quit  "
    REDIM Pile(8, 48)
    FOR n = 1 TO 8
        CALL DspPile(n)
    NEXT
    REDIM Foundation(4)
    FOR n = 1 TO 4
        CALL DspFoundation(n + 100)         'display foundations
    NEXT
    '
    ' display titles
    '
    IF FirstGame THEN
        CALL ScrnSave0(1, 1, 25, 80, SEG Scrn2(0))
        CALL Box0(5, 15, 18, 65, 2, TitleColor)
        CALL ClearScr0(6, 16, 17, 64, TitleColor)
        Colr = TitleColor
        row = 7: txt$ = "S T R A T E G Y": GOSUB dspc
        row = row + 1
        txt$ = "A game of skill, luck, and concentration.": GOSUB dspc1
        row = row + 1
        txt$ = "Version 1.02": GOSUB dspc1
        row = row + 1
        txt$ = "By Randy Rasa": GOSUB dspc1
        txt$ = "18215 Troost": GOSUB dspc1
        txt$ = "Olathe, KS 66062-9208": GOSUB dspc1
        txt$ = "(C) Copyright 1989-95 by Randy Rasa": GOSUB dspc1
        Colr = norm
        GOSUB PressAnyKey
        CALL ScrnRest0(1, 1, 25, 80, SEG Scrn2(0))
        HiScore = 0: LoScore = 0: AvgScore = 0
        TotalScores = 0: NumGames = 0: GamesWon = 0
        FirstGame = FALSE
    END IF
    '
    ' Deal the deck
    '
    Remaining = 52: CardNum = 1
    ResetCursor = TRUE
    Score = 0
    GOSUB DspScore
    DO
        Colr = norm: txt$ = "Deal the card to a pile ...": GOSUB dspc25
        CALL DspCard(card(CardNum), 4, 8)
        COLOR foreground, background
        LOCATE 10, 4: PRINT "Remaining:"; Remaining
        value = (card(CardNum) - 1) MOD 13 + 1
        Suit = (card(CardNum) - 1) \ 13 + 3
        IF value = 1 THEN           'if an ace, place it automatically
            Foundation(Suit - 2) = card(CardNum)
            CALL DspFoundation(Suit - 2 + 100)
            GOSUB MakeSound
            Remaining = Remaining - 1
            CardNum = CardNum + 1
        ELSE
            GOSUB GetPlace
            IF ans$ = "" THEN
                IF xy <> 0 THEN
                    CALL CardMove(xy, card(CardNum), 1)
                    CALL DspPile(xy)
                    GOSUB MakeSound
                    Remaining = Remaining - 1
                    CardNum = CardNum + 1
                END IF
            ELSE
                SELECT CASE ans$
                    CASE "H"
                        CALL ScrnSave0(1, 1, 25, 80, SEG Scrn2(0))
                        GOSUB help
                        GOSUB PressAnyKey
                        CALL ScrnRest0(1, 1, 25, 80, SEG Scrn2(0))
                        ResetCursor = TRUE
                    CASE "N"
                        txt$ = "New Game (Y/N)?": GOSUB dspc25
                        CALL MouseTrap(25, 43, 25, 45)
                        CALL SetCursor(43, 25)
                        CALL MorK(ans$, x, y)
                        IF x = 43 OR ans$ = "Y" THEN
                            GOSUB CalcFinalScore
                            GOTO start
                        END IF
                        ResetCursor = TRUE
                    CASE "Q"
                        txt$ = "Are you sure you want to quit (Y/N)?": GOSUB dspc25
                        CALL MouseTrap(25, 53, 25, 55)
                        CALL SetCursor(53, 25)
                        CALL MorK(ans$, x, y)
                        IF x = 53 OR ans$ = "Y" THEN GOTO TheEnd
                        ResetCursor = TRUE
                    CASE CHR$(27)   'Esc
                       CALL ScrnSave0(1, 1, 25, 80, SEG Scrn2(0))
                       COLOR 7, 0
                       CLS
                       PRINT "Type 'Exit' to return ..."
                       SHELL
                       CALL ScrnRest0(1, 1, 25, 80, SEG Scrn2(0))
                END SELECT
            END IF
        END IF
    LOOP UNTIL Remaining = 0

    CALL ClearScr0(3, 1, 10, 18, norm)      'clear the deck
    '
    ' Attempt to build foundations (automatically)
    '
    txt$ = "Building foundations ...": GOSUB dspc25
    DO
        Match = FALSE
        FOR f = 1 TO 4
            FOR p = 1 TO 8
                CALL CardMove(p, CardValue, 0)
                IF CardValue = Foundation(f) + 1 THEN
                    CALL DspPile(p)
                    Foundation(f) = CardValue
                    CALL DspFoundation(f + 100)
                    GOSUB MakeSound
                    CALL Pause(3)
                    Score = Score + 1
                    GOSUB DspScore
                    Match = TRUE
                ELSE
                    CALL CardMove(p, CardValue, 1)
                END IF
            NEXT
        NEXT
    LOOP UNTIL Match = FALSE OR Score = 48
    IF Score = 48 THEN GamesWon = GamesWon + 1
    GOSUB CalcFinalScore
    IF Score < 48 THEN
        IF NOT Quiet THEN SOUND 100, 5
        row = 24: txt$ = "You Lose!": GOSUB dspc
    ELSE
        IF NOT Quiet THEN CALL chime(9)
        row = 24: txt$ = "You Win!": GOSUB dspc
    END IF
    txt$ = "Play Again (Y/N)?": GOSUB dspc25
    CALL MouseTrap(25, 44, 25, 46)
    CALL SetCursor(44, 25)
    CALL MorK(ans$, x, y)
    IF x = 44 OR ans$ = "Y" THEN GOTO start
TheEnd:
    COLOR 7, 0
'    LOCATE OrigRow, 1
'    CALL ScrnRest0(1, 1, 25, 80, SEG scrn1(0))
    END
'
'************** End Of Main Program ******************
'-------------- Start Of Subroutines -----------------
'
' Wait for mouse or key input
'
GetPlace:
    xy = 0: ans$ = ""
    IF ResetCursor THEN
        CALL MouseTrap(4, 21, 14, 75)
        CALL SetCursor(35 * 8 - 8, 9 * 8 - 8)
        ResetCursor = FALSE
    END IF
    CALL MorK(Place$, mx, my)
    IF my < 15 AND mx < 60 THEN
        SELECT CASE my
            CASE 4 TO 8: y = 1
            CASE 10 TO 14: y = 2
            CASE ELSE: y = 0
        END SELECT
        SELECT CASE mx
            CASE 25 TO 29: x = 1
            CASE 34 TO 38: x = 2
            CASE 43 TO 47: x = 3
            CASE 52 TO 56: x = 4
            CASE ELSE: x = 0: y = 0
        END SELECT
        IF y = 0 THEN xy = 0 ELSE xy = x + (y - 1) * 4
    END IF
    IF my > 16 AND mx < 60 THEN
        SELECT CASE mx
            CASE 25 TO 29: xy = 101
            CASE 34 TO 38: xy = 102
            CASE 43 TO 47: xy = 103
            CASE 52 TO 56: xy = 104
            CASE ELSE: xy = 0
        END SELECT
    END IF
    IF mx > 60 THEN
        SELECT CASE my
            CASE 4 TO 6: ans$ = "H"
            CASE 7 TO 9: ans$ = "N"
            CASE 10 TO 12: ans$ = "Q"
            CASE ELSE: ans$ = "Z"
        END SELECT
    END IF
    IF mx = 0 THEN ans$ = Place$
    RETURN
'
'   Display a string
'
dsp1:
    row = row + 1   'automatically increment row
dsp:
    LOCATE row, col, 0
    CALL QPrint0(txt$, Colr)
    RETURN
'
'   display a string (centered)
'
dspc25:
    GOSUB ClrLin25
    row = 24
dspc1:
    row = row + 1
dspc:
    col = 40 - LEN(txt$) \ 2
    GOTO dsp
'
' clear line 25 (status line)
'
ClrLin25:
    LOCATE 25, 1
    CALL QPrint0(SPACE$(80), norm)
    RETURN
'
' Display "Press any key ..." and wait for key or mouse
'
PressAnyKey:
    txt$ = "Press any key ...": GOSUB dspc25
    CALL MouseTrap(25, 32, 25, 48)
    CALL SetCursor(25, 48)
    CALL MorK(ans$, x, y)
    GOTO ClrLin25
    'RETURN
'
' Calculate the final score
'
CalcFinalScore:
    TotalScores = TotalScores + Score
    IF Score > HiScore THEN HiScore = Score
    IF Score < LoScore OR LoScore = 0 THEN LoScore = Score
    AvgScore = TotalScores \ (NumGames + 1)
    GOSUB DspScore
    NumGames = NumGames + 1
    RETURN
'
' Display Scores
'
DspScore:
    COLOR foreground, background
    LOCATE 15, 65: PRINT "Score:"; Score
    LOCATE 16, 65: PRINT "Game #"; NumGames + 1
    LOCATE 17, 63: PRINT "Ķ"
    LOCATE 18, 65: PRINT "Games Won:"; GamesWon
    LOCATE 19, 65: PRINT "High:"; HiScore
    LOCATE 20, 65: PRINT "Low:"; LoScore
    LOCATE 21, 65: PRINT "Average:"; AvgScore
    RETURN
'
' create strange sound to signify a card being played
'
MakeSound:
    IF NOT Quiet THEN
        FOR s = 100 TO 1000 STEP 200
            SOUND s, .1
        NEXT
    END IF
    RETURN

SUB CardMove (PileNum, CardValue, Action)
'
' Add or remove a card from a pile
'  Action -- 0 = remove a card from pile number PileNum,
'                returning the value in CardValue
'            1 = add CardValue to pile number PileNum
'
SHARED Pile()

    CardNum = 1
    DO
        CardVal = Pile(PileNum, CardNum)
        CardNum = CardNum + 1
    LOOP UNTIL CardVal = 0
    IF Action = 0 THEN
        CardNum = CardNum - 2
        CardValue = Pile(PileNum, CardNum)    'remove card
        Pile(PileNum, CardNum) = 0
    ELSE
        CardNum = CardNum - 1
        Pile(PileNum, CardNum) = CardValue    'add card
    END IF

END SUB

SUB DspCard (CardNumber, ULRow, ULCol)

SHARED CardFG, CardBG

    value = (CardNumber - 1) MOD 13 + 1
    Suit = (CardNumber - 1) \ 13 + 3
    CALL GetCard(value, Crd$, CardColor, Suit)
    IF LEFT$(Crd$, 1) = " " THEN
        CrdH$ = RIGHT$(Crd$, 1): CrdL$ = " "
    ELSE
        CrdH$ = LEFT$(Crd$, 1): CrdL$ = RIGHT$(Crd$, 1)
    END IF
    COLOR CardFG, CardBG
    LOCATE ULRow + 0, ULCol: PRINT "Ŀ"
    LOCATE ULRow + 1, ULCol
    PRINT ""; : COLOR CardColor, CardBG: PRINT CrdH$; CrdL$; CHR$(Suit); : COLOR CardFG, CardBG: PRINT ""
    LOCATE ULRow + 2, ULCol: PRINT "   "
    LOCATE ULRow + 3, ULCol
    PRINT ""; : COLOR CardColor, CardBG: PRINT CHR$(Suit);
    IF CrdL$ = " " THEN
        PRINT CrdL$; CrdH$;
    ELSE
        PRINT CrdH$; CrdL$;
    END IF
    COLOR CardFG, CardBG: PRINT ""
    LOCATE ULRow + 4, ULCol: PRINT ""

END SUB

SUB DspFoundation (FoundNum)
'
' Display a Foundation
'  FoundNum = Foundation number (101-104)
'
SHARED foreground, background, red, black, Foundation()

    COLOR foreground, background
    row = 17: col = (FoundNum - 101) * 9 + 25
    IF Foundation(FoundNum - 100) = 0 THEN
        LOCATE row + 0, col: PRINT "  "
        LOCATE row + 1, col: PRINT "     "
        LOCATE row + 2, col: PRINT "   "
        LOCATE row + 3, col: PRINT "     "
        LOCATE row + 4, col: PRINT "  "
        IF FoundNum < 103 THEN CardColor = red ELSE CardColor = black
        'COLOR CardColor, background
        COLOR foreground, background
        LOCATE row + 2, col + 2: PRINT CHR$(FoundNum - 98)
    ELSE
        CALL DspCard(Foundation(FoundNum - 100), row, col)
    END IF

END SUB

SUB DspPile (PileNum)
'
' Display A Pile
'  PileNum: pile number (1 to 8)
'
SHARED foreground, background, Pile()

    r = ((PileNum - 1) \ 4) * 6 + 4
    c = ((PileNum - 1) MOD 4) * 9 + 25
    CrdCnt = 1
    DO UNTIL Pile(PileNum, CrdCnt) = 0: CrdCnt = CrdCnt + 1: LOOP
    CrdCnt = CrdCnt - 1
    IF CrdCnt = 0 THEN
        COLOR foreground, background
        LOCATE r + 0, c: PRINT "  "
        LOCATE r + 1, c: PRINT "     "
        LOCATE r + 2, c: PRINT "   "
        LOCATE r + 3, c: PRINT "     "
        LOCATE r + 4, c: PRINT "  "
    ELSE
        CALL DspCard(Pile(PileNum, CrdCnt), r, c)
    END IF

END SUB

SUB GetCard (value, Crd$, card.color, Suit)
'
' convert card number to label and color
'
SHARED red, black

    SELECT CASE value
        CASE 1: Crd$ = " A"
        CASE 2 TO 9: Crd$ = STR$(value)
        CASE 10: Crd$ = "10"
        CASE 11: Crd$ = " J"
        CASE 12: Crd$ = " Q"
        CASE 13: Crd$ = " K"
    END SELECT
    IF Suit < 5 THEN
        card.color = red      'red for hearts or diamonds
    ELSE
        card.color = black    'black for clubs or spades
    END IF

END SUB

SUB MorK (ky$, x, y)
'
'   get mouse or keyboard input
'
'   Inputs: none
'   Outputs: key$ -- key pressed ("" if no key pressed)
'            x,y -- mouse position when button was pressed
'                   x = text col, y = text row
'                   0,0 if mouse button not pressed
'
    CALL ShowCursor
    button = 1
    DO UNTIL button = 0
        CALL GetCursor(x, y, button)      'wait until all mouse buttons are released
    LOOP
    ky$ = ""
    DO UNTIL button <> 0 OR ky$ <> ""
        ky$ = UCASE$(INKEY$)
        CALL GetCursor(x, y, button)      'wait for mouse button to be pressed
    LOOP
    IF button THEN
        x = x \ 8 + 1
        y = y \ 8 + 1
    ELSE
        x = 0: y = x
    END IF
    CALL HideCursor

END SUB

