@echo off
REM RESET installer label for Floppy Disk
REM This is DOS specific; do not use LFNs
REM
REM Gets the current mounted directory of
REM DosBox drives and attempts to set the
REM label according to the protected game
REM installer requirement.
REM
REM 2020-06 DB 74.3 Mount syntax adoption
REM
IF NOT EXIST ASET.EXE GOTO FAIL1
:PARM1
REM initial label variable, more to come
SET GLABEL=%3
REM the directory of the game to install
SET GAMENAME=%1
REM only one installation program to run
SET INSTALLR=%2
REM is it really there?
IF EXIST %GAMENAME%\%INSTALLR% GOTO PARM2
ECHO The referenced directory and install
ECHO are not available. Please try again.
ECHO.
ECHO %0 GAME_INST_DIR INSTALLER DISKLABEL
ECHO.
GOTO EXIT
:PARM2
REM If there are spaces in the label then
REM use all the values at the end for var
SHIFT
IF "%3"=="" GOTO PARM3
SET GLABEL=%GLABEL% %3
GOTO PARM2
:PARM3
ASET DSKLABEL := UPCASE('%GLABEL%')
REM
REM START
REM
CLS
ASET CDIR=DIR
ASET CPTH := COPY('%CDIR%',4,30)
ASET CDRV := COPY('%CDIR%',1,2)
ASET CLBL := LABEL
IF NOT EXIST Z:\COMMAND.COM GOTO REALDOS
MOUNT -u A:
MOUNT -u B:
MOUNT > MOUNT.TXT
REM 74.0
REM ASET CDRIVE := DELETE(LINE(2,'MOUNT.TXT'),1,38)
REM 74.3+
ASET MDRIVE := DELETE(LINE(3,'MOUNT.TXT'),1,80)
ASET CDRIVE := NTH(4,'%MDRIVE%')
MOUNT A %CDRIVE%\%CPTH%\%GAMENAME% -t floppy -label "%DSKLABEL%"
DEL MOUNT.TXT
IF NOT EXIST A:\%INSTALLR% GOTO FAIL2
CYCLES 3000
GOTO INSTALL
:REALDOS
LABEL %DSKLABEL%
REM Check label change; LFNs can break this
ASET NLBL := LABEL
REM cannot use compare due to DOS bug for
REM spaces in string comparisons!  argh!!
ASET NLBL1 := SUBALL(' ','','%NLBL%')
ASET NLBL2 := SUBALL(' ','','%DSKLABEL%')
IF NOT "%NLBL1%"=="%NLBL2%" GOTO FAIL3
SUBST A: %GAMENAME%
:INSTALL
A:
%INSTALLR%
GOTO END
:FAIL1
ECHO !!!!          WARNING           !!!!
ECHO We need another program to run this!
ECHO ASET lets  us  set  some environment
ECHO variables to  uniquely label a DRIVE 
ECHO for the Installer to work.
GOTO END
:FAIL2
ECHO !!!!          WARNING           !!!!
ECHO The PATH for DOSBox may have long or
ECHO special character names. Please only
ECHO use short 8.3 as this is DOS anyway!
GOTO END
:FAIL3
ECHO !!!!          WARNING           !!!!
ECHO Unable to change the drive label for
ECHO the disk to what the installer needs
ECHO to work. Change label to %DSKLABEL%
ECHO and run installer manually.
:END
%CDRV%
IF EXIST Z:\COMMAND.COM GOTO EXIT
REM Clean up DOS changes
SUBST A: /D >NUL
IF NOT "%CLBL%"=="" LABEL %CLBL%
SET CDIR=
SET CPTH=
SET CDRV=
SET CLBL=
SET NLBL=
SET CDRIVE=
SET MDRIVE=
SET GLABEL=
SET GAMENAME=
SET INSTALLR=
SET DSKLABEL=
:EXIT
